<?php
/**
 * Controller to handling updating ebook process
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_Ajax_Update_ebook' ))
{
	class IPEbo_Ajax_Update_ebook
	{
		/**
		 * Execution save options process
		 *
		 * @return void
		 */
		public function exec()
		{
			$redirect = false;
			$is_add   = false;
			$error    = true;
			if ( ! empty( $_POST['isadd'] )) {
				$is_add = true;
			}
			if ( ! empty( $_POST['object_id'] ))
			{
				$ebookId = absint( $_POST['object_id'] );
				if ( $ebook = get_post( $ebookId ) ) {
					$this->_updateEbook( $ebook );
				} else {
					$ebookId = 0;
				}
			} else {
				$ebookId = $this->_addEbook();
			}
			if ( $ebookId )
			{
				$error = false;
				$model = new IPEbo_Model_Ebook();
				$model->saveSetting( $ebookId );
			}
			if ( $error ) {
				$status   = 0;
				$ebookId  = 0;
				if ( $is_add ) {
						$message = __( 'Failed create ebook.', IPEBO_SLUG );
				} else {
						$message = __( 'Failed save ebook.', IPEBO_SLUG );
				}
			}
			else
			{
				$status = 1;
				if ( $is_add )
				{
					$message  = __( 'Successfully created ebook.', IPEBO_SLUG );
					if ( isset( $_POST['ebook_resource'] ) && $_POST['ebook_resource'] == 'post' )
					{
						$redirect = admin_url() . 'admin.php?page=' . IPEBO_PAGENAME . '&action=import&id=' . $ebookId . '&create=1';
					}
					else
					{
						$redirect = admin_url() . 'admin.php?page=' . IPEBO_PAGENAME . '&action=edit&id=' . $ebookId . '&create=1';
					}
				}
				else
				{
					$message = __( 'Successfully saved ebook.', IPEBO_SLUG );
					$redirect = admin_url() . 'admin.php?page=' . IPEBO_PAGENAME . '&action=edit&id=' . $ebookId . '&edited=1';
				}
			}

			$result = array(
					'status'    	=> $status,
					'message'   	=> $message,
					'ebookid'  		=> $ebookId
			);
			if ( $redirect ) {
					$result['redirect'] = $redirect;
			}
			echo json_encode( $result );
			die();
		}

		/**
		 * Add new ebook
		 *
		 * @return int
		 */
		protected function _addEbook()
		{
			global $user_ID;

			if ( empty( $_POST['ebook_title'] )) {
				$title = 'Unknown';
			} else {
				$title = apply_filters( 'single_post_title', $_POST['ebook_title'] );
			}

			$info = '';
			if ( empty( $_POST['ebook_info'] )) {
				$info = apply_filters( 'wp_filter_kses', $_POST['ebook_info'] );
			}

			$dataPost = array(
				'post_status'  => 'publish',
				'post_type'    => 'ipebo_ebook',
				'post_author'  => $user_ID,
				'post_title'   => $title,
				'post_content' => $info
			);
			$result = wp_insert_post( $dataPost );
			return $result;
		}

		/**
		 * Update ebook
		 *
		 * @param  object $ebook
		 * @return boolean
		 */
		protected function _updateEbook( $ebook )
		{
			$result   = 0;
			$dataPost = array();
			if ( ! empty( $_POST['ebook_title'] ) && $_POST['ebook_title'] != $ebook->post_title ) {
				$dataPost['post_title'] = apply_filters( 'single_post_title', $_POST['ebook_title'] );
			}
			if ( ! empty( $_POST['ebook_info'] ) && $_POST['ebook_info'] != $ebook->post_content ) {
				$dataPost['post_content'] = apply_filters( 'wp_filter_kses', $_POST['ebook_info'] );
			}
			if ( ! empty( $dataPost )) {
				$dataPost['ID'] = $ebook->ID;
				$result = wp_update_post( $dataPost );
			}
			return $result;
		}

	}
}
