<?php
/**
 * Controller to handling sorting pages process
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_Ajax_Sort_pages' ))
{
  class IPEbo_Ajax_Sort_pages
  {
    /**
     * Execution save options process
     *
     * @return void
     */
    public function exec()
    {
      $ids   = array();
      $ebook = false;
      if ( ! empty( $_POST['ids'] ))
      {
        $_ids = apply_filters( 'single_post_title', $_POST['ids'] );
        $_ids = trim( $_ids, '|' );
        $ids  = explode( '|', $_ids );
      }
      if ( ! empty( $_POST['ebookid'] )) {
        $ebookId = absint( $_POST['ebookid'] );
        $ebook   = get_post( $ebookId );
      }
      if ( empty( $ids ) || ! $ebook ) {
        echo json_encode( array(
          'status'        => 0,
          'messageTitle'  => __( 'System Error', IPEBO_SLUG ),
          'message'       => __( 'System Error', IPEBO_SLUG )
        ) );
        die();
      }
      //
      //Sorting
      //
      $settings = new IPEbo_Setting( $ebook->ID, '__ipebo_ebook_setting' );
      $saveIds  = implode( $ids, '|' );
      $data = array(
        'ebook_posts' => $saveIds
      );
      $settings->setSettings( $data );

      //Send result
      echo json_encode( array(
        'status'        => 1,
        'messageTitle'  => __( 'Successfully', IPEBO_SLUG ),
        'message'       => __( 'Successfully sorting pages in your ebook', IPEBO_SLUG )
      ) );
      die();
    }
  }
}
