<?php
/**
 * Controller to handling saving page process
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_Ajax_Save_page' ))
{
  class IPEbo_Ajax_Save_page
  {
    /**
     * Execution save options process
     *
     * @return void
     */
    public function exec()
    {
      global $user_ID;

      $page  = false;
      $ebook = false;
      if ( ! empty( $_POST['page_id'] )) {
        $pageId = absint( $_POST['page_id'] );
        $page   = get_post( $pageId );
      }
      if ( ! empty( $_POST['object_id'] )) {
        $ebookId = absint( $_POST['object_id'] );
        $ebook   = get_post( $ebookId );
      }
      if ( ! $page || ! $ebook ) {
        echo json_encode( array(
          'status'        => 0,
          'messageTitle'  => __( 'System Error', IPEBO_SLUG ),
          'message'       => __( 'System Error', IPEBO_SLUG )
        ) );
        die();
      }

      //Save data
      $type = 'page';
      if ( ! empty( $_POST['object_type'] )) {
        $type = $_POST['object_type'];
      }
      // If cover
      if ( $type == 'cover' )
      {
        $this->_saveContentCover( $ebook );
        //Save setting
        $model = new IPEbo_Model_Ebook();
        $model->saveSetting( $ebook->ID );
      }
      //If page
      else
      {
        $pageType = 'article';
        if ( ! empty( $_POST['page_type'] )) {
          $pageType = $_POST['page_type'];
        }
        if ( $pageType == 'article' ) {
          $this->_saveContentArticle( $page );
        }
        else if ( $pageType == 'table' ) {
          $this->_saveContentTable( $page );
        }
        else if ( $pageType == 'action' ) {
          $this->_saveContentAction( $page );
        }
        //Save setting
        $model = new IPEbo_Model_Ebook_Page();
        $model->saveSetting( $page->ID );
      }
      $result = true;

      //Send result
      if ( $result )
      {
        echo json_encode( array(
          'status'        => 1,
          'messageTitle'  => __( 'Success', IPEBO_SLUG ),
          'message'       => __( 'Successfully updated ebook page.', IPEBO_SLUG )
        ) );
      }
      else
      {
        echo json_encode( array(
          'status'        => 0,
          'messageTitle'  => __( 'Failed', IPEBO_SLUG ),
          'message'       => __( 'Failed to update ebook page', IPEBO_SLUG )
        ) );
      }
      die();
    }

    /**
     * Save content cover
     *
     * @param  object $ebook
     * @return void
     */
    protected function _saveContentCover( $ebook )
    {
      $result   = 0;
			$dataPost = array();
			if ( ! empty( $_POST['cover_title'] ) && $_POST['cover_title'] != $ebook->post_title ) {
				$dataPost['post_title'] = apply_filters( 'single_post_title', $_POST['cover_title'] );
			}
			if ( ! empty( $_POST['cover_summary'] ) && $_POST['cover_summary'] != $ebook->post_content ) {
				$dataPost['post_content'] = apply_filters( 'wp_filter_kses', $_POST['cover_summary'] );
			}
			if ( ! empty( $dataPost )) {
				$dataPost['ID'] = $ebook->ID;
				$result = wp_update_post( $dataPost );
			}
			return $result;
    }

    /**
     * Save content article
     *
     * @param  object $page
     * @return void
     */
    protected function _saveContentArticle( $page )
    {
      $result   = 0;
			$dataPost = array();
			if ( ! empty( $_POST['article_title'] ) && $_POST['article_title'] != $ebook->post_title ) {
				$dataPost['post_title'] = apply_filters( 'single_post_title', $_POST['article_title'] );
			}
			if ( ! empty( $_POST['article_content'] ) && $_POST['article_content'] != $ebook->post_content ) {
				$dataPost['post_content'] = apply_filters( 'wp_filter_kses', $_POST['article_content'] );
			}
			if ( ! empty( $_POST['article_summary'] ) && $_POST['article_summary'] != $ebook->post_excerpt ) {
				$dataPost['post_excerpt'] = apply_filters( 'wp_filter_kses', $_POST['article_summary'] );
			}
			if ( ! empty( $dataPost )) {
				$dataPost['ID'] = $page->ID;
				$result = wp_update_post( $dataPost );
			}
			return $result;
    }

    /**
     * Save content table
     *
     * @param  object $page
     * @return void
     */
    protected function _saveContentTable( $page )
    {
      $result   = 0;
			$dataPost = array();
			if ( ! empty( $_POST['table_title'] ) && $_POST['table_title'] != $ebook->post_title ) {
				$dataPost['post_title'] = apply_filters( 'single_post_title', $_POST['table_title'] );
			}
			if ( ! empty( $_POST['table_content'] ) && $_POST['table_content'] != $ebook->post_content ) {
				$dataPost['post_content'] = apply_filters( 'wp_filter_kses', $_POST['table_content'] );
			}
			if ( ! empty( $dataPost )) {
				$dataPost['ID'] = $page->ID;
				$result = wp_update_post( $dataPost );
			}
			return $result;
    }

    /**
     * Save content action
     *
     * @param  object $page
     * @return void
     */
    protected function _saveContentAction( $page )
    {
      $result   = 0;
			$dataPost = array();
			if ( ! empty( $_POST['action_title'] ) && $_POST['action_title'] != $ebook->post_title ) {
				$dataPost['post_title'] = apply_filters( 'single_post_title', $_POST['action_title'] );
			}
			if ( ! empty( $_POST['action_content'] ) && $_POST['action_content'] != $ebook->post_content ) {
				$dataPost['post_content'] = apply_filters( 'wp_filter_kses', $_POST['action_content'] );
			}
			if ( ! empty( $dataPost )) {
				$dataPost['ID'] = $page->ID;
				$result = wp_update_post( $dataPost );
			}
			return $result;
    }
  }
}
