<?php
/**
 * Controller to handling deleting page process
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_Ajax_Delete_page' ))
{
  class IPEbo_Ajax_Delete_page
  {
    /**
     * Execution save options process
     *
     * @return void
     */
    public function exec()
    {
      $page  = false;
      $ebook = false;
      if ( ! empty( $_POST['pageid'] )) {
        $pageId = absint( $_POST['pageid'] );
        $page   = get_post( $pageId );
      }
      if ( ! empty( $_POST['ebookid'] )) {
        $ebookId = absint( $_POST['ebookid'] );
        $ebook   = get_post( $ebookId );
      }
      if ( ! $page || ! $ebook ) {
        echo json_encode( array(
          'status'        => 0,
          'messageTitle'  => __( 'System Error', IPEBO_SLUG ),
          'message'       => __( 'System Error', IPEBO_SLUG )
        ) );
        die();
      }
      //
      //Deleting
      //
      $result    = false;
      $settings  = new IPEbo_Setting( $ebook->ID, '__ipebo_ebook_setting' );
      if ( $_ids = $settings->getSetting( 'ebook_posts' ) )
      {
        $ids = explode( '|', $_ids );
        foreach( $ids as $idx => $id )
        {
          $id = absint( $id );
          if ( $pageId == $id ) {
            unset( $ids[$idx] );
            break;
          }
        }
        //
        //Save
        $saveIds = implode( $ids, '|' );
        $data = array(
          'ebook_posts' => $saveIds
        );
        $settings->setSettings( $data );
        $result = true;
      }

      //Send result
      if ( $result )
      {
        echo json_encode( array(
          'status'        => 1,
          'messageTitle'  => __( 'Success', IPEBO_SLUG ),
          'message'       => __( 'Successfully deleted page from your ebook', IPEBO_SLUG )
        ) );
      }
      else
      {
        echo json_encode( array(
          'status'        => 0,
          'messageTitle'  => __( 'Failed', IPEBO_SLUG ),
          'message'       => __( 'Failed to remove the page from your ebook', IPEBO_SLUG )
        ) );
      }
      die();
    }
  }
}
