<?php
/**
 * Controller to handling adding page process
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPEbo_Ajax_Add_page' ))
{
  class IPEbo_Ajax_Add_page
  {
    /**
     * Execution save options process
     *
     * @return void
     */
    public function exec()
    {
      global $user_ID;

      $ebook = false;
      if ( ! empty( $_POST['ebookid'] )) {
        $ebookId = absint( $_POST['ebookid'] );
        $ebook   = get_post( $ebookId );
      }

      if ( ! $ebook ) {
        echo json_encode( array(
          'status'        => 0,
          'messageTitle'  => __( 'System Error', IPEBO_SLUG ),
          'message'       => __( 'System Error', IPEBO_SLUG )
        ) );
        die();
      }

      if ( ! empty( $_POST['title'] )){
        $title = apply_filters( 'single_post_title', $_POST['title'] );
      } else {
        $title = 'page-ebook-' . time();
      }
      if ( ! empty( $_POST['template'] )){
        $template = apply_filters( 'pre_term_name', $_POST['template'] );
      } else {
        $template = 'article';
      }

      //Insert page
      $data = array(
				'post_status'  => 'publish',
				'post_type'    => 'ipebo_ebook_page',
				'post_author'  => $user_ID,
				'post_title'   => $title
      );
			$result = wp_insert_post( $data );
      $resultData = array();
      $preview = '';

      if ( $result )
      {
        //Save setting
				$model = new IPEbo_Model_Ebook_Page();
				$model->saveSetting( $result );

        //Connect to ebook
        $settings = new IPEbo_Setting( $ebook->ID, '__ipebo_ebook_setting' );
        $postIds  = $settings->getSetting( 'ebook_posts' );
        $postIds .= '|' . $result;
        //Save settings
        $data = array(
          'ebook_posts' => $postIds
        );
        $settings->setSettings( $data );

        //Set response data
        $page = get_post( $result );
        $resultData = array(
          'type'      => 'page',
          'id'        => $result,
          'ebook'     => $ebook,
          'page'      => $page
        );

        //Page type
        $settings = new IPEbo_Setting( $page->ID, '__ipebo_ebook_page_setting' );
        $pageType = $settings->getSetting( 'page_type', 'article' );
        $resultData['page_type'] = $pageType;

        if ( $pageType == 'article' ) {
          $resultData['article_title'] = stripslashes( $page->post_title );
        }
        else if ( $pageType == 'table' ) {
          $resultData['table_title'] = stripslashes( $page->post_title );
        }
        else if ( $pageType == 'action' ) {
          $resultData['action_title'] = stripslashes( $page->post_title );
        }

        //Get preview
        $preview = $this->_getPreview( $page, $settings );
      }

      //Send result
      if ( $result )
      {
        echo json_encode( array(
          'status'        => 1,
          'messageTitle'  => __( 'Success', IPEBO_SLUG ),
          'message'       => __( 'Successfully add page into your ebook', IPEBO_SLUG ),
          'pageId'        => $result,
          'pageTitle'     => $title,
          'data'          => $resultData,
          'preview'       => $preview
        ) );
      }
      else
      {
        echo json_encode( array(
          'status'        => 0,
          'messageTitle'  => __( 'Failed', IPEBO_SLUG ),
          'message'       => __( 'Failed to added page into your ebook', IPEBO_SLUG ),
          'data'          => $resultData
        ) );
      }
      die();
    }

    /**
     * Get preview
     *
     * @param  object $page
     * @param  object $settings
     * @return void
     */
    protected function _getPreview( $page, $settings )
    {
      $creator  = new IPEbo_Creator_Content( $page, $settings, false, true );
      $content  = $creator->getPageContent();
      return $content;
    }
  }
}
