<?php
/**
 * Main application class
 *
 * @package wp-ebook-creator
 * @author InstaProduct
 * @link http://insta-product.com/
 */

//
//Include all function files
require_once( IPEBO_LIB . '/config.php' );
require_once( IPEBO_LIB . '/setting.php' );
require_once( IPEBO_LIB . '/font.php' );
require_once( IPEBO_LIB . '/faicon.php' );
require_once( IPEBO_LIB . '/list.php' );
require_once( IPEBO_LIB . '/creator.php' );
require_once( IPEBO_LIB . '/creatorContent.php' );

//Model
require_once( IPEBO_LIB . '/model.php' );
require_once( IPEBO_LIB . '/model/ebook.php' );
require_once( IPEBO_LIB . '/model/ebookPage.php' );
require_once( IPEBO_APP . '/controller.php' );
require_once( IPEBO_APP . '/viewer.php' );

//Admin Libraries
require_once( IPEBO_LIB . '/html.php' );
require_once( IPEBO_LIB . '/form.php' );
require_once( IPEBO_LIB . '/admin.php' );
require_once( IPEBO_LIB . '/admin/main.php' );
require_once( IPEBO_LIB . '/admin/create.php' );

require_once( IPEBO_PATH . 'vendor/autoload.php' );

//Color library
if ( ! class_exists( 'phpColor' )) {
	require_once( IPEBO_LIB . '/Color.php' );
}

if ( ! class_exists( 'IPEbo_App' ))
{
	class IPEbo_App
	{
		//{{ run

		/**
		 * Run all functions
		 *
		 * @return void
		 */
		public static function run()
		{
			$hook = sanitize_title( IPEBO_TITLE );

			//Install Plugin
			register_activation_hook( __FILE__, array( __CLASS__, 'install' ) );

			//
			//Admin init
			add_action( 'admin_init', array( __CLASS__, 'adminInit' ) );

			//
			//Register admin menu
			add_action( 'admin_menu', array( __CLASS__, 'addAdminMenu' ) );

			//
			//Add css
			add_action(
				'admin_print_styles-toplevel_page_' . IPEBO_PAGENAME,
				array( __CLASS__, 'adminStyle' ),
				1100
			);
			add_action(
				'admin_print_styles-'.$hook.'_page_' . IPEBO_PAGENAME . '-create',
				array( __CLASS__, 'adminStyle' ),
				1100
			);
			add_action(
				'admin_print_styles-'.$hook.'_page_' . IPEBO_PAGENAME . '-manage',
				array( __CLASS__, 'adminStyle' ),
				1100
			);
			add_action(
				'admin_print_styles',
				array( __CLASS__, 'adminGlobalStyle' ),
				1000
			);

			//
			//Add javascript
			add_action(
				'admin_print_scripts-toplevel_page_' . IPEBO_PAGENAME,
				array( __CLASS__, 'adminScript' ),
				1100
			);
			add_action(
				'admin_print_scripts-'.$hook.'_page_'.IPEBO_PAGENAME. '-create',
				array( __CLASS__, 'adminScript' ),
				1100
			);
			add_action(
				'admin_print_scripts-'.$hook.'_page_'.IPEBO_PAGENAME. '-manage',
				array( __CLASS__, 'adminScript' ),
				1100
			);
			add_action(
				'admin_print_scripts',
				array( __CLASS__, 'adminGlobalScript' ),
				1000
			);
		}

		//}}
		//{{ adminInit

		/**
		 * Admin init
		 *
		 * @return void
		 */
		public static function adminInit()
		{
			//
			//Preview ebook
			$creator = new IPEbo_Creator();
			$creator->init();

			// $html = '
			// <div style="background-color:#eeeeee; font-family:dejavusansmono;">
			// <h1><a name="top"></a>mPDF</h1>
			// <h2 style="font-family:playball;">Basic HTML Example</h2>
			// This file demonstrates most of the HTML elements.
			// <h3>Heading 3</h3>
			// <h4>Heading 4</h4>
			// <h5>Heading 5</h5>
			// <h6>Heading 6</h6>
			// <p>P: Nulla felis erat, imperdiet eu, ullamcorper non, nonummy quis, elit. Suspendisse potenti. Ut a eros at ligula vehicula pretium. Maecenas feugiat pede vel risus. Nulla et lectus. Fusce eleifend neque sit amet erat. Integer consectetuer nulla non orci. Morbi feugiat pulvinar dolor. Cras odio. Donec mattis, nisi id euismod auctor, neque metus pellentesque risus, at eleifend lacus sapien et risus. Phasellus metus. Phasellus feugiat, lectus ac aliquam molestie, leo lacus tincidunt turpis, vel aliquam quam odio et sapien. Mauris ante pede, auctor ac, suscipit quis, malesuada sed, nulla. Integer sit amet odio sit amet lectus luctus euismod. Donec et nulla. Sed quis orci. </p>
			//
			// <hr />
			//
			// <div><img src="tiger.wmf" style="float:right;">DIV: Proin aliquet lorem id felis. Curabitur vel libero at mauris nonummy tincidunt. Donec imperdiet. Vestibulum sem sem, lacinia vel, molestie et, laoreet eget, urna. Curabitur viverra faucibus pede. Morbi lobortis. Donec dapibus. Donec tempus. Ut arcu enim, rhoncus ac, venenatis eu, porttitor mollis, dui. Sed vitae risus. In elementum sem placerat dui. Nam tristique eros in nisl. Nulla cursus sapien non quam porta porttitor. Quisque dictum ipsum ornare tortor. Fusce ornare tempus enim. </div>
			// <div><img src="klematis.jpg" style="opacity: 0.5; float: left;" />DIV: Proin aliquet lorem id felis. Curabitur vel libero at mauris nonummy tincidunt. Donec imperdiet. Vestibulum sem sem, lacinia vel, molestie et, laoreet eget, urna. Curabitur viverra faucibus pede. Morbi lobortis. Donec dapibus. Donec tempus. Ut arcu enim, rhoncus ac, venenatis eu, porttitor mollis, dui. Sed vitae risus. In elementum sem placerat dui. Nam tristique eros in nisl. Nulla cursus sapien non quam porta porttitor. Quisque dictum ipsum ornare tortor. Fusce ornare tempus enim. </div>
			// </div>
			//
			// ';
			// $mpdf = new mPDF();
			//
			// $mpdf->WriteHTML($html);
			//
			// $mpdf->AddPage();
			//
			// $mpdf->WriteHTML('Your Book text');
			// $mpdf->Output();

			/**
			 * Ajax handler
			 **/
			$controller = new IPEbo_Controller();
			$controller->ajax();
		}

		//}}
		//{{ addAdminMenu

		/**
		 * Add admin menu
		 *
		 * @return void
		 */
		public static function addAdminMenu()
		{
			add_menu_page(
				IPEBO_TITLE,
				IPEBO_TITLE,
				'edit_posts',
				IPEBO_PAGENAME,
				array( __CLASS__, 'main' ),
				'dashicons-book-alt'
			);
			add_submenu_page(
				IPEBO_PAGENAME,
				__( 'All Ebooks', IPEBO_SLUG ),
				__( 'All Ebooks', IPEBO_SLUG ),
				'edit_posts',
				IPEBO_PAGENAME,
				array( __CLASS__, 'main' )
			);
			add_submenu_page(
				IPEBO_PAGENAME,
				__( 'Add New', IPEBO_SLUG ),
				__( 'Add New', IPEBO_SLUG ),
				'edit_posts',
				IPEBO_PAGENAME . '-create',
				array( __CLASS__, 'create' )
			);
		}

		//}}
		//{{ main

		/**
		 * Manage all ebooks
		 *
		 * @return void
		 */
		public static function main()
		{
      $builder = new IPEbo_Admin_Main();
      $builder->render();
		}

		//}}
		//{{ create

		/**
		 * Chat Manager
		 *
		 * @return void
		 */
		public static function create()
		{
      $builder = new IPEbo_Admin_Create();
      $builder->render();
		}

		//}}
		//{{ adminStyle

		/**
		 * Add Css file
		 *
		 * @return void
		 */
		public static function adminStyle()
		{
			wp_deregister_style( 'remodal' );
			wp_register_style(
				'remodal',
				IPEBO_BASE_URL . 'assets/css/remodal.css',
				false,
				null
			);
			wp_enqueue_style('remodal');

			wp_deregister_style( 'remodal-theme' );
			wp_register_style(
				'remodal-theme',
				IPEBO_BASE_URL . 'assets/css/remodal-default-theme.css',
				false,
				null
			);
			wp_enqueue_style('remodal-theme');

			wp_deregister_style( 'ipebo-admin-style' );
			wp_register_style(
				'ipebo-admin-style',
				IPEBO_BASE_URL . 'assets/css/admin.min.css',
				false,
				null
			);
			wp_enqueue_style('ipebo-admin-style');
		}

		//}}
		//{{ adminGlobalStyle

		/**
		 * Add Css file to all pages
		 *
		 * @return void
		 */
		public static function adminGlobalStyle()
		{
			wp_deregister_style( 'ipebo-admin-global-style' );
			wp_register_style(
				'ipebo-admin-global-style',
				IPEBO_BASE_URL . 'assets/css/admin-global.min.css',
				false,
				null
			);
			wp_enqueue_style( 'ipebo-admin-global-style' );
		}

		//}}
		//{{ adminScript

		/**
		 * Add javascript file
		 *
		 * @return void
		 */
		public static function adminScript()
		{
		?>
			<script type="text/javascript">
				var ipebo_img_url = '<?php echo IPEBO_BASE_URL . 'assets/img/'; ?>',
					ui_base_image	  = '<?php echo IPEBO_BASE_URL . 'assets/img/'; ?>',
					ipebo_font_url	= '<?php echo IPEBO_BASE_URL . 'assets/img/font/'; ?>',
					ipebo_fontcss_url	= '<?php echo IPEBO_BASE_URL . 'assets/css/fonts/'; ?>',
					ui_message		 =
					{
						delete_confirm_title: '<?php _e( 'Delete Confirmation', IPEBO_SLUG ); ?>',
						delete_confirm_info: '<?php _e( 'Are you sure doing this action?', IPEBO_SLUG ); ?>'
					}
			</script>

			<?php
			wp_deregister_script('jquery-ui');
			wp_register_script(
				'jquery-ui',
				"http" . ($_SERVER['SERVER_PORT'] == 443 ? "s" : "") . "://ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/jquery-ui.min.js",
				false,
				null
			);
			wp_enqueue_script('jquery-ui');

			wp_deregister_script('ipebo-admin-script');
			wp_enqueue_script(
				'ipebo-admin-script',
				IPEBO_BASE_URL . 'assets/js/admin.js',
				array( 'jquery' ),
				1,
				true
			);
		}

		//}}
		//{{ adminGlobalScript

		/**
		 * Add javascript file to all pages
		 *
		 * @return void
		 */
		public static function adminGlobalScript()
		{
			wp_deregister_script('ipebo-admin-global-script');
			wp_enqueue_script(
				'ipebo-admin-global-script',
				IPEBO_BASE_URL . 'assets/js/admin-global.min.js',
				array( 'jquery' ),
				1,
				true
			);
		}

		//}}
	}
}
