# IfcOpenShell - IFC toolkit and geometry engine
# Copyright (C) 2021 Thomas Krijnen <thomas@aecgeeks.com>
#
# This file is part of IfcOpenShell.
#
# IfcOpenShell is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# IfcOpenShell is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with IfcOpenShell.  If not, see <http://www.gnu.org/licenses/>.

import ifcopenshell
from typing import Any, Union, Literal, Self

# `std::vector<xxx>` usually translated to `tuple[xxx, ...]`.

ON_SLABS_AND_WALLS: Any
ON_SLABS_AT_FLOORPLANS: Any
ALWAYS: Any

ATPATH: Any
ATSTART: Any
ATEND: Any
NOTDEFINED: Any

MATRIX4: Any
POINT3: Any
DIRECTION3: Any
LINE: Any
CIRCLE: Any
ELLIPSE: Any
BSPLINE_CURVE: Any
OFFSET_CURVE: Any
PLANE: Any
CYLINDER: Any
SPHERE: Any
TORUS: Any
BSPLINE_SURFACE: Any
EDGE: Any
LOOP: Any
FACE: Any
SHELL: Any
SOLID: Any
LOFT: Any
EXTRUSION: Any
REVOLVE: Any
SWEEP_ALONG_CURVE: Any
NODE: Any
COLLECTION: Any
BOOLEAN_RESULT: Any
FUNCTION_ITEM: Any
FUNCTOR_ITEM: Any
PIECEWISE_FUNCTION: Any
GRADIENT_FUNCTION: Any
CANT_FUNCTION: Any
OFFSET_FUNCTION: Any
COLOUR: Any
STYLE: Any

CARTESIAN_DOUBLE: Any
CARTESIAN_QUOTIENT: Any
FILTERED_CARTESIAN_QUOTIENT: Any
EXACT_PREDICATES: Any
EXACT_CONSTRUCTIONS: Any

CURVES: Any
SURFACES_AND_SOLIDS: Any
CURVES_SURFACES_AND_SOLIDS: Any
TRIANGULATED: Any
NATIVE: Any
SERIALIZED: Any

MAXSTEPSIZE: Any
MINSTEPS: Any

TRIANGLE_MESH: Any
POLYHEDRON_WITHOUT_HOLES: Any
POLYHEDRON_WITH_HOLES: Any

SHARED_PTR_DISOWN: Any

cvar: Any

class FileDescription(HeaderEntity):
    description: tuple[str, ...]
    implementation_level: str

class FileName(HeaderEntity):
    name: str
    time_stamp: str
    author: tuple[str, ...]
    organization: tuple[str, ...]
    preprocessor_version: str
    originating_system: str
    authorization: str

class IfcSpfHeader:
    def file(self, *args): ...
    @property
    def file_description(self) -> FileDescription: ...
    @property
    def file_name(self) -> FileName: ...
    @property
    def file_schema(self): ...
    def read(self): ...
    def tryRead(self): ...
    def write(self, out): ...

class BRep(Representation):
    def as_compound(self, force_meters): ...
    def begin(self): ...
    def calculate_projected_surface_area(self, ax, along_x, along_y, along_z): ...
    def calculate_surface_area(self, arg2): ...
    def calculate_volume(self, arg2): ...
    def end(self): ...
    def item(self, i): ...
    def item_id(self, i): ...
    def shapes(self): ...
    def size(self): ...

class BRepElement(Element):
    def calculate_projected_surface_area(self, along_x, along_y, along_z): ...
    @property
    def geometry(self) -> BRep: ...
    def geometry_pointer(self): ...
    @property
    def surface_area(self): ...
    @property
    def volume(self): ...

class CgalEmitOriginalEdges:
    name: Any
    description: Any
    defaultvalue: Any

class ColladaSerializer(WriteOnlyGeometrySerializer):
    def finalize(self): ...
    def isTesselated(self): ...
    def object_id(self, o): ...
    def ready(self): ...
    def setFile(self, arg2): ...
    def setUnitNameAndMagnitude(self, name, magnitude): ...
    def write(self, *args): ...
    def writeHeader(self): ...

class ComputeCurvature:
    name: Any
    description: Any
    defaultvalue: Any

class ConversionResult:
    def ItemId(self): ...
    def Placement(self): ...
    def Shape(self): ...
    def Style(self): ...
    def StylePtr(self): ...
    def append(self, trsf): ...
    def hasStyle(self): ...
    def prepend(self, trsf): ...
    def setStyle(self, newStyle): ...

class ConversionResultShape:
    def Serialize(self, place, arg3): ...
    def Triangulate(self, *args): ...
    def add(self, arg2): ...
    def area(self): ...
    def axis(self): ...
    def bounding_box(self, *args): ...
    def box(self): ...
    def convex_decomposition(self): ...
    def convex_tag(self, b): ...
    def edges(self): ...
    def facets(self): ...
    def halfspaces(self): ...
    def intersect(self, arg2): ...
    def is_manifold(self): ...
    def length(self): ...
    def map(self, *args): ...
    def moved(self, arg2): ...
    def num_edges(self): ...
    def num_faces(self): ...
    def num_vertices(self): ...
    def plane_equation(self): ...
    def position(self): ...
    def serialize(self): ...
    def serialize_obj(self): ...
    def set_box(self, b): ...
    def solid(self): ...
    def solid_mt(self): ...
    def subtract(self, arg2): ...
    def surface_genus(self): ...
    def vertices(self): ...
    def volume(self): ...

class DoubleArray3:
    def back(self): ...
    def begin(self): ...
    def empty(self): ...
    def end(self): ...
    def fill(self, u): ...
    def front(self): ...
    def iterator(self): ...
    def rbegin(self): ...
    def rend(self): ...
    def size(self): ...
    def swap(self, v): ...

class Element:
    # TODO: Remove from the wrapper?
    def SetParents(self, newparents): ...
    # TODO: could it be None?
    @property
    def context(self) -> str:
        """Element's geometry context.

        E.g 'Body':
        """
        ...

    @property
    def guid(self) -> str:
        """Mirroring IfcRoot.GlobalId."""
        ...

    @property
    def id(self) -> int:
        """Element's STEP ID."""
        ...
    # TODO: could it be None?
    @property
    def name(self) -> str:
        """Mirroring IfcRoot.Name."""
        ...

    @property
    def parent_id(self) -> int:
        """Parent object STEP id.

        E.g. IfcBuildingStorey that element's in.
        """
        ...
    # TODO: Returns SwigPyObject. Should we just remove it from the wrapper?
    def parents(self): ...
    @property
    def product(self) -> entity_instance: ...
    @property
    def transformation(self) -> Transformation: ...
    @property
    def transformation_buffer(self) -> bytes: ...
    @property
    def type(self) -> str:
        """Element's IFC Class.

        E.g. 'IfcWall'.
        """
        ...

    @property
    def unique_id(self) -> str:
        """Interal unique id for the element.

        E.g. 'product-186f8dc2-070c-46e1-a65b-a435a043ba3e-body'.
        """
        ...

class FileSchema(HeaderEntity):
    schema_identifiers: Any

class FunctionStepParam:
    name: Any
    description: Any
    defaultvalue: Any

class FunctionStepType:
    name: Any
    description: Any
    defaultvalue: Any

class GeometrySerializer:
    READ_BREP: Any
    READ_TRIANGULATION: Any
    def geometry_settings(self, *args): ...
    def isTesselated(self): ...
    def object_id(self, o): ...
    def read(self, *args): ...
    def setUnitNameAndMagnitude(self, name, magnitude): ...
    def settings(self, *args): ...
    def write(self, *args): ...

class GltfSerializer(WriteOnlyGeometrySerializer):
    def finalize(self): ...
    def isTesselated(self): ...
    def ready(self): ...
    def setFile(self, arg2): ...
    def setUnitNameAndMagnitude(self, arg2, arg3): ...
    def write(self, *args): ...
    def writeHeader(self): ...

class HdfSerializer(GeometrySerializer):
    def finalize(self): ...
    def isTesselated(self): ...
    def read(self, *args): ...
    def ready(self): ...
    def remove(self, guid): ...
    def setFile(self, arg2): ...
    def setUnitNameAndMagnitude(self, arg2, arg3): ...
    def write(self, *args): ...
    def writeHeader(self): ...

class HeaderEntity:
    def getArgument(self, index): ...
    def getArgumentCount(self): ...
    def toString(self, upper): ...

class IfcBaseEntity(entity_instance):
    def declaration(self): ...
    def get(self, name): ...
    def get_inverse(self, name): ...
    def populate_derived(self): ...
    def set_id(self, i): ...

class IfcBaseType(entity_instance):
    def declaration(self): ...

class IfcEntityInstanceData: ...

class IfcLateBoundEntity(IfcBaseEntity):
    def declaration(self): ...

class InstanceReference:
    file_offset: Any
    v: Any

class Iterator:
    initialization_outcome_: Any
    processed_: Any
    def bounds_max(self): ...
    def bounds_min(self): ...
    def compute_bounds(self, with_geometry): ...
    def create(self): ...
    def file(self): ...
    def filters(self, *args): ...
    def get(self) -> Element:
        """Get last processed element."""
        ...

    def getLog(self): ...
    def get_native(self): ...
    def get_object(self, id): ...
    def had_error_processing_elements(self): ...
    def initialize(self) -> bool:
        """Return true if the iterator is initialized with any elements, false otherwise."""
        ...

    def next(self) -> Union[entity_instance, None]:
        """Process next shape representation.

        :return: Processed ``entity_instance`` or ``None`` if nothing is left to process.

        """
        ...

    def process_concurrently(self): ...
    def process_finished_rep(self, rep): ...
    def progress(self) -> int:
        """Return current progress (0-100).

        Updated after processing each representation.
        """
        ...

    def set_cache(self, cache: GeometrySerializer): ...
    def unit_magnitude(self): ...
    def unit_name(self): ...

class OpaqueCoordinate_3:
    def get(self, i): ...
    def set(self, i, n): ...

class OpaqueCoordinate_4:
    def get(self, i): ...
    def set(self, i, n): ...

class OpaqueNumber:
    def clone(self): ...
    def to_double(self): ...
    def to_string(self): ...

class Representation:
    def entity(self): ...
    @property
    def id(self) -> str:
        """
        Example: `2432-openings-2468`, where
        - 2432 - mapped representation id
        - 2468 - IfcRelVoidsElement
        """

    def settings(self): ...

class Serialization(Representation):
    @property
    def brep_data(self): ...
    @property
    def surface_style_ids(self): ...
    @property
    def surface_styles(self): ...

class SerializedElement(Element):
    @property
    def geometry(self) -> Serialization: ...

class SerializerSettings:
    def get_(self, name): ...
    def get_type(self, name): ...
    def set_(self, *args): ...
    def setting_names(self): ...

class Settings:
    def get_(self, name): ...
    def get_type(self, name): ...
    def set_(self, *args): ...
    def setting_names(self): ...

class SvgSerializer(WriteOnlyGeometrySerializer):
    SH_NONE: Any
    SH_FULL: Any
    SH_LEFT: Any
    def addDrawing(self, pos, dir, ref, name, include_projection): ...
    def addSizeComponent(self, fi): ...
    def addTextAnnotations(self, k): ...
    def addXCoordinate(self, fi): ...
    def addYCoordinate(self, fi): ...
    def doWriteHeader(self): ...
    def finalize(self): ...
    def getMirrorX(self): ...
    def getMirrorY(self): ...
    def getOnlyValid(self, b): ...
    def getProfileThreshold(self): ...
    def getSegmentProjection(self): ...
    def getSubtractionSettings(self): ...
    def getUnifyInputs(self): ...
    def getUsePrefiltering(self): ...
    def growBoundingBox(self, x, y): ...
    def idElement(self, elem): ...
    def isTesselated(self): ...
    def nameElement(self, *args): ...
    def object_id(self, storey, o): ...
    def ready(self): ...
    def resetScale(self): ...
    def resize(self): ...
    def setAlwaysProject(self, b): ...
    def setAutoElevation(self, b): ...
    def setAutoSection(self, b): ...
    def setBoundingRectangle(self, width, height): ...
    def setDrawDoorArcs(self, b): ...
    def setDrawStoreyHeights(self, sh): ...
    def setDrawingCenter(self, x, y): ...
    def setElevationRef(self, s): ...
    def setElevationRefGuid(self, s): ...
    def setFile(self, f): ...
    def setMirrorX(self, b): ...
    def setMirrorY(self, b): ...
    def setNoCSS(self, b): ...
    def setOnlyValid(self, b): ...
    def setPolygonal(self, b): ...
    def setPrintSpaceAreas(self, b): ...
    def setPrintSpaceNames(self, b): ...
    def setProfileThreshold(self, i): ...
    def setScale(self, s): ...
    def setSectionHeight(self, h, storey): ...
    def setSectionHeightsFromStoreys(self, offset): ...
    def setSectionRef(self, s): ...
    def setSegmentProjection(self, b): ...
    def setSpaceNameTransform(self, v): ...
    def setStoreyHeightLineLength(self, d): ...
    def setSubtractionSettings(self, sbp): ...
    def setUnifyInputs(self, b): ...
    def setUnitNameAndMagnitude(self, arg2, arg3): ...
    def setUseHlrPoly(self, b): ...
    def setUseNamespace(self, b): ...
    def setUsePrefiltering(self, b): ...
    def setWithoutStoreys(self, b): ...
    def start_path(self, *args): ...
    def write(self, *args): ...
    def writeHeader(self): ...

class SwigPyIterator:
    def advance(self, n): ...
    def copy(self): ...
    def decr(self, n): ...
    def distance(self, x): ...
    def equal(self, x): ...
    def incr(self, n): ...
    def next(self): ...
    def previous(self): ...
    def value(self): ...

class Transformation:
    def data(self): ...
    @property
    def matrix(self): ...

class Triangulation(Representation):
    def addEdge(self, item_id, style, i0, i1): ...
    def addFace(self, *args): ...
    def addNormal(self, X, Y, Z): ...
    def addVertex(self, item_index, material_index, X, Y, Z): ...
    @staticmethod
    def box_project_uvs(vertices, normals): ...
    @property
    def colors_buffer(self): ...
    @property
    def edges(self) -> tuple[int, ...]: ...
    @property
    def edges_buffer(self) -> bytes: ...
    def edges_item_ids(self) -> tuple[int, ...]: ...
    @property
    def edges_item_ids_buffer(self) -> bytes: ...
    @staticmethod
    def empty(settings): ...
    @property
    def faces(self) -> tuple[int, ...]: ...
    @property
    def faces_buffer(self) -> bytes: ...
    @property
    def faces_tri(self) -> tuple[int, ...]: ...
    @property
    def item_ids(self) -> tuple[int, ...]: ...
    @property
    def item_ids_buffer(self) -> bytes: ...
    @property
    def material_ids(self) -> tuple[int, ...]: ...
    @property
    def material_ids_buffer(self) -> bytes: ...
    @property
    def materials(self) -> tuple[style, ...]: ...
    @property
    def normals(self): ...
    @property
    def normals_buffer(self) -> bytes: ...
    @property
    def polyhedral_faces_with_holes(self): ...
    @property
    def polyhedral_faces_without_holes(self): ...
    def registerEdge(self, item_id, i0, i1): ...
    def registerEdgeCount(self, n1, n2, edgecount): ...
    def resetWelds(self): ...
    @property
    def uvs(self): ...
    def uvs_ref(self): ...
    @property
    def verts(self) -> tuple[float, ...]: ...
    @property
    def verts_buffer(self) -> bytes: ...

class TriangulationElement(Element):
    @property
    def geometry(self) -> Triangulation: ...
    def geometry_pointer(self): ...

class TriangulationType:
    name: Any
    description: Any
    defaultvalue: Any

class TtlWktSerializer(WriteOnlyGeometrySerializer):
    def finalize(self): ...
    def isTesselated(self): ...
    def ready(self): ...
    def setFile(self, arg2): ...
    def setUnitNameAndMagnitude(self, arg2, arg3): ...
    def ttl_object_id(self, o, postfix): ...
    def write(self, *args): ...
    def writeHeader(self): ...

class WaveFrontOBJSerializer(WriteOnlyGeometrySerializer):
    def finalize(self): ...
    def isTesselated(self): ...
    def ready(self): ...
    def setFile(self, arg2): ...
    def setUnitNameAndMagnitude(self, arg2, arg3): ...
    def write(self, *args): ...
    def writeHeader(self): ...
    def writeMaterial(self, style): ...

class WriteOnlyGeometrySerializer(GeometrySerializer):
    def read(self, *args): ...

class XmlSerializer:
    def finalize(self): ...
    def ready(self): ...
    def setFile(self, arg2): ...
    def writeHeader(self): ...

class XmlSerializerFactory:
    @staticmethod
    def implementations(): ...

class _SwigNonDynamicMeta(type): ...

class abstract_arrangement:
    def get_face_pairs(self): ...
    def merge(self, edge_indices): ...
    def num_edges(self): ...
    def num_faces(self): ...
    def write(self, polygons, progress): ...

class aggregation_type(parameter_type):
    array_type: Any
    bag_type: Any
    list_type: Any
    set_type: Any
    def as_aggregation_type(self) -> aggregation_type: ...
    def bound1(self): ...
    def bound2(self): ...
    def type_of_aggregation(self): ...
    def type_of_aggregation_string(self): ...
    def type_of_element(self) -> parameter_type: ...

class attribute:
    def name(self) -> str: ...
    def optional(self) -> bool: ...
    def type_of_attribute(self) -> parameter_type: ...

class attribute_value_derived: ...

class boolean_result:
    INTERSECTION: Any
    SUBTRACTION: Any
    UNION: Any
    operation: Any
    def calc_hash(self): ...
    @property
    def children(self): ...
    def clone_(self): ...
    def kind(self): ...
    @staticmethod
    def operation_str(op): ...

class bspline_curve(curve):
    control_points: Any
    degree: Any
    knots: Any
    multiplicities: Any
    weights: Any
    def calc_hash(self): ...
    def clone_(self): ...
    def kind(self): ...

class bspline_surface(surface):
    control_points: Any
    degree: Any
    knots: Any
    multiplicities: Any
    weights: Any
    def calc_hash(self): ...
    def clone_(self): ...
    def kind(self): ...

class buffer:
    def filename(self): ...
    def get_value(self): ...
    def is_ready(self): ...

class cant_function(function_item):
    def calc_hash(self): ...
    def clone_(self): ...
    def end(self): ...
    def get_cant(self): ...
    def get_gradient(self): ...
    def kind(self): ...
    def start(self): ...

class circle(curve):
    radius: Any
    def calc_hash(self): ...
    def clone_(self): ...
    @staticmethod
    def from_3_points(p1, p2, p3): ...
    def kind(self): ...
    @property
    def matrix(self): ...

class clash:
    a: Any
    b: Any
    clash_type: Any
    distance: Any
    p1: Any
    p2: Any

class clashes:
    def append(self, x): ...
    def assign(self, n, x): ...
    def back(self): ...
    def begin(self): ...
    def capacity(self): ...
    def clear(self): ...
    def empty(self): ...
    def end(self): ...
    def erase(self, *args): ...
    def front(self): ...
    def get_allocator(self): ...
    def insert(self, *args): ...
    def iterator(self): ...
    def pop(self): ...
    def pop_back(self): ...
    def push_back(self, x): ...
    def rbegin(self): ...
    def rend(self): ...
    def reserve(self, n): ...
    def resize(self, *args): ...
    def size(self): ...
    def swap(self, v): ...

class collection:
    def calc_hash(self): ...
    @property
    def children(self): ...
    def clone_(self): ...
    def kind(self): ...
    @property
    def matrix(self): ...

class colour(item):
    def r(self) -> float: ...
    def g(self) -> float: ...
    def b(self) -> float: ...
    def calc_hash(self) -> int: ...
    def clone_(self) -> Self: ...
    @property
    def components(self) -> tuple[float, float, float]:
        """RGB tuple."""
        ...

    def kind(self) -> int: ...

class context:
    def add(self, segments): ...
    def build(self): ...
    def get_face_pairs(self): ...
    def merge(self, edge_indices): ...
    def num_edges(self): ...
    def num_faces(self): ...
    def write(self, arg2): ...

class curve(geom_item):
    def print_impl(self, o, classname, indent): ...

class cylinder(surface):
    radius: Any
    def calc_hash(self): ...
    def clone_(self): ...
    def kind(self): ...
    @property
    def matrix(self): ...

class declaration:
    def _is(self, *args: Union[str, declaration]) -> bool: ...
    def as_entity(self) -> Union[entity, None]: ...
    def as_enumeration_type(self) -> Union[enumeration_type, None]: ...
    def as_select_type(self) -> Union[select_type, None]: ...
    def as_type_declaration(self) -> Union[type_declaration, None]: ...
    def index_in_schema(self) -> int: ...
    def name(self) -> str: ...
    def name_uc(self) -> str:
        """Get name in upper case."""
        ...

    def schema(self) -> schema_definition: ...
    def type(self): ...

class direction3:
    def calc_hash(self): ...
    def clone_(self): ...
    @property
    def components(self): ...
    def kind(self): ...

class drawing_meta:
    matrix_3: Any
    pln_3d: Any

class edge(trimmed_curve):
    def calc_hash(self): ...
    def clone_(self): ...
    def kind(self): ...

class ellipse(curve):
    radius: Any
    radius2: Any
    def calc_hash(self): ...
    def clone_(self): ...
    def kind(self): ...
    @property
    def matrix(self): ...

class entity(declaration):
    def all_attributes(self) -> tuple[attribute, ...]: ...
    def all_inverse_attributes(self) -> tuple[inverse_attribute, ...]: ...
    def argument_types(self) -> tuple[str, ...]:
        """Get a tuple of types for each attribute in ``all_attributes()``."""
        ...

    def as_entity(self) -> entity: ...
    def attribute_by_index(self, index: int) -> attribute: ...
    def attribute_count(self) -> int: ...
    def attribute_index(self, *args: Union[str, attribute]) -> int:
        """
        :param args: A single attribute name / attribute.
        """
        ...

    def attributes(self) -> tuple[attribute, ...]: ...
    def derived(self) -> tuple[bool, ...]:
        """Return a tuple of booleans indicating whether each direct attribute is derived."""
        ...

    def is_abstract(self) -> bool: ...
    def set_attributes(self, attributes, derived): ...
    def set_inverse_attributes(self, inverse_attributes): ...
    def set_subtypes(self, subtypes): ...
    def subtypes(self) -> tuple[entity, ...]: ...
    def supertype(self) -> Union[entity, None]: ...

class entity_instance:
    file: ifcopenshell.file
    """Reference to IFC file to prevent it's garbage collection, if entity is still used."""

    file_: Any
    id_: Any
    def data(self, *args): ...
    def declaration(self) -> declaration: ...
    def file_pointer(self):
        """Internal IfcFile pointer address.

        Same as ``file.file_pointer``).
        """
        ...

    def get_argument(self, *args): ...
    def get_argument_index(self, a): ...
    def get_argument_name(self, i): ...
    def get_argument_type(self, i): ...
    def get_attribute_category(self, name: str) -> Literal[0, 1, 2]:
        """Get attribute category id.

        Available categories:
        - `0` - invalid attribute
        - `1` - forward attribute
        - `2` - inverse attributes
        """
        ...

    def get_attribute_names(self): ...
    def get_inverse(self, a): ...
    def get_inverse_attribute_names(self): ...
    def id(self) -> int: ...
    def identity(self) -> int:
        """Entity instance identity, unique across all opened IFC files during current session."""
        ...

    def is_a(self, *args): ...
    def setArgumentAsAggregateOfAggregateOfDouble(self, i, v): ...
    def setArgumentAsAggregateOfAggregateOfEntityInstance(self, i, v): ...
    def setArgumentAsAggregateOfAggregateOfInt(self, i, v): ...
    def setArgumentAsAggregateOfDouble(self, i, v): ...
    def setArgumentAsAggregateOfEntityInstance(self, i, v): ...
    def setArgumentAsAggregateOfInt(self, i, v): ...
    def setArgumentAsAggregateOfString(self, i, v): ...
    def setArgumentAsBool(self, i, v): ...
    def setArgumentAsDouble(self, i, v): ...
    def setArgumentAsEntityInstance(self, i, v): ...
    def setArgumentAsInt(self, i, v): ...
    def setArgumentAsLogical(self, i, v): ...
    def setArgumentAsNull(self, i): ...
    def setArgumentAsString(self, i, a): ...
    def toString(self, arg2, upper): ...
    def to_string(self, valid_spf): ...
    def unset_attribute_value(self, i): ...

class enumeration_type(declaration):
    def argument_types(self) -> tuple[str, ...]: ...
    def as_enumeration_type(self) -> enumeration_type: ...
    def enumeration_items(self) -> tuple[str, ...]: ...
    def lookup_enum_offset(self, string: str) -> int:
        """Get index of the string in enum."""
        ...

    def lookup_enum_value(self, i: int) -> str:
        """Get a string for the index in enum."""
        ...

class extrusion(sweep):
    depth: Any
    direction: Any
    def calc_hash(self): ...
    def clone_(self): ...
    def kind(self): ...
    @property
    def matrix(self): ...

class face:
    basis: Any
    def calc_hash(self): ...
    @property
    def children(self): ...
    def clone_(self): ...
    def kind(self): ...
    @property
    def matrix(self): ...
    def print_impl(self, o, indent): ...

class file:
    INSTANCE_ID: Any
    INSTANCE_TYPE: Any
    ATTRIBUTE_INDEX: Any
    guid_map_: Any
    stream: Any
    def FreshId(self): ...
    def add(self, entity: entity_instance, id: int) -> entity_instance: ...
    def addEntities(self, entities): ...
    def batch(self) -> None:
        """Enable batch mode.

        Batch mode:
        1. Calling ``remove(entity)`` does not immediately remove the entity;
           it marks it for deletion instead.
        2. When you call ``unbatch()``, all marked entities are deleted in a single operation.

        Difference from usual removal:
        - In normal mode, removing an entity immediately traverses and removes all inverse references to it.
        - In batch mode, inverse references are not updated per entity.
          Instead, the entire inverse reference map is scanned during ``unbatch()``
          to remove references to all deleted entities.

        Batch deletion may be slower than immediate deletion, depending on the size of the inverse reference map.
        """
        ...

    def unbatch(self) -> None:
        """Exit batch mode."""
        ...

    def build_inverses(self): ...
    def by_guid(self, guid: str) -> entity_instance: ...
    def by_id(self, id: int) -> entity_instance: ...
    def by_type(self, *args): ...
    def by_type_excl_subtypes(self, *args): ...
    @staticmethod
    def createTimestamp(): ...
    def entity_names(self) -> tuple[int, ...]:
        """Get a tuple of step ids present in the file."""
        ...

    def file_pointer(self) -> int:
        """Internal IfcFile pointer address.

        Same as ``int(self.this)``.
        """
        ...

    def get_inverses_by_declaration(
        self, instance_id: int, type: declaration, attribute_index: int
    ) -> tuple[entity_instance, ...]:
        """Get instance inverses of the particular type defined by ``declaration``.

        :param declaration: Type of inverses to find.
            Supertypes are also supported - e.g. 'IfcRoot' will also include all 'IfcRelationship' inverses.
        :param attribute_index: Find references only from the provided attribute index.
            Could be set to ``-1`` to consider all attributes.
        """
        ...

    def getMaxId(self): ...
    def get_total_inverses_by_id(self, instance_id: int) -> int: ...
    def getUnit(self, unit_type): ...
    def get_inverse(self, e: entity_instance) -> tuple[entity_instance, ...]: ...
    def get_inverse_indices(self, *args: Union[entity_instance, int]) -> tuple[int, ...]:
        """Get the attribute indices for each inverse from `get_inverse`, that reference the provided entity..

        :param args: entity or it's id. Maximum 1 entity at the time.
        """
        ...

    def get_total_inverses(self, e: entity_instance) -> int: ...
    def good(self): ...
    @staticmethod
    def guid_map(*args): ...
    @property
    def header(self) -> IfcSpfHeader: ...
    def ifcroot_type(self) -> entity: ...
    def internal_guid_map(self): ...
    def load(self, entity_instance_name, entity, arg4, attribute_index): ...
    def recalculate_id_counter(self): ...
    def remove(self, entity: entity_instance) -> None: ...
    @property
    def schema(self): ...
    def to_string(self): ...
    @staticmethod
    def traverse(instance: entity_instance, max_level: int) -> tuple[entity_instance, ...]: ...
    @staticmethod
    def traverse_breadth_first(instance: entity_instance, max_level: int) -> tuple[entity_instance, ...]: ...
    def try_read_semicolon(self): ...
    def types(self) -> tuple[str, ...]:
        """Return a tuple of classes present in the file.

        E.g. `("IfcWallType", "IfcWall", "IfcArbitraryClosedProfileDef", ...)`.
        """
        ...

    def types_begin(self): ...
    def types_end(self): ...
    def write(self, fn): ...

class file_open_status:
    SUCCESS: Any
    READ_ERROR: Any
    NO_HEADER: Any
    UNSUPPORTED_SCHEMA: Any
    INVALID_SYNTAX: Any
    def value(self): ...

class fn_evaluator:
    settings_: Any
    def clone(self): ...
    def end(self): ...
    def evaluate(self, u): ...
    def length(self): ...
    def start(self): ...

class function_item(implicit_item):
    def calc_hash(self): ...
    def end(self): ...
    def kind(self): ...
    def length(self): ...
    def start(self): ...

class function_item_evaluator:
    def evaluate(self, *args): ...
    def evaluation_points(self, *args): ...

class functor_item(function_item):
    def calc_hash(self): ...
    def clone_(self): ...
    def end(self): ...
    def kind(self): ...
    def start(self): ...

class geom_item(item):
    matrix: Any
    surface_style: Any

class geometry_exception:
    def what(self): ...

class gradient_function(function_item):
    def calc_hash(self): ...
    def clone_(self): ...
    def end(self): ...
    def get_horizontal(self): ...
    def get_vertical(self): ...
    def kind(self): ...
    def start(self): ...

class horizontal_plan_at_element: ...
class implicit_item(geom_item): ...

class inverse_attribute:
    bag_type: Any
    set_type: Any
    unspecified_type: Any
    def attribute_reference(self): ...
    def bound1(self): ...
    def bound2(self): ...
    def entity_reference(self): ...
    def name(self): ...
    def type_of_aggregation(self): ...
    def type_of_aggregation_string(self): ...

class item:
    instance: Any
    orientation: Any
    def calc_hash(self): ...
    # TODO: hide from the wrapper?
    def clone_(self) -> Self: ...
    def hash(self): ...
    def identity(self): ...
    def reverse(self): ...
    # TODO: hide from the wrapper?
    def kind(self):
        """Internal enum item index."""

class less_functor: ...

class line(curve):
    def calc_hash(self): ...
    def clone_(self): ...
    def kind(self): ...
    @property
    def matrix(self): ...

class line_segment:
    def back(self): ...
    def begin(self): ...
    def empty(self): ...
    def end(self): ...
    def fill(self, u): ...
    def front(self): ...
    def iterator(self): ...
    def rbegin(self): ...
    def rend(self): ...
    def size(self): ...
    def swap(self, v): ...

class loft:
    axis: Any
    def calc_hash(self): ...
    @property
    def children(self): ...
    def clone_(self): ...
    def kind(self): ...
    def print_impl(self, o, indent): ...

class loop:
    closed: Any
    external: Any
    fi: Any
    def calc_hash(self): ...
    def calculate_linear_edge_curves(self): ...
    @property
    def children(self): ...
    def clone_(self): ...
    def is_polyhedron(self): ...
    def kind(self): ...
    def remove_linear_edge_curves(self): ...

class matrix4(item):
    IDENTITY: Any
    AFFINE_WO_SCALE: Any
    AFFINE_W_UNIFORM_SCALE: Any
    AFFINE_W_NONUNIFORM_SCALE: Any
    OTHER: Any
    tag: Any
    def calc_hash(self): ...
    def clone_(self): ...
    @property
    def components(self): ...
    def is_identity(self): ...
    def kind(self): ...
    def translation_part(self): ...

class named_type(parameter_type):
    def _is(self, *args): ...
    def as_named_type(self) -> named_type: ...
    def declared_type(self) -> declaration: ...

class node(item):
    def calc_hash(self): ...
    def clone_(self): ...
    def kind(self): ...

class offset_curve(curve):
    basis: Any
    offset: Any
    reference: Any
    def calc_hash(self): ...
    def clone_(self): ...
    def kind(self): ...

class offset_function(function_item):
    def calc_hash(self): ...
    def clone_(self): ...
    def end(self): ...
    def get_basis(self): ...
    def get_offset(self): ...
    def kind(self): ...
    def start(self): ...

class parameter_type:
    def _is(self, *args: Union[str, declaration]) -> bool:
        """
        :param args: IFC class name or declaration to check.
            Argument accepts only 1 value.
        """
        ...

    def as_aggregation_type(self) -> Union[aggregation_type, None]: ...
    def as_named_type(self) -> Union[named_type, None]: ...
    def as_simple_type(self) -> Union[simple_type, None]: ...

class piecewise_function(function_item):
    def calc_hash(self): ...
    def clone_(self): ...
    def end(self): ...
    def is_empty(self): ...
    def kind(self): ...
    def length(self): ...
    def span_count(self): ...
    def span_fn(self, i): ...
    def spans(self): ...
    def start(self): ...

class plane(surface):
    def calc_hash(self): ...
    def clone_(self): ...
    def kind(self): ...
    @property
    def matrix(self): ...

class point3:
    def calc_hash(self): ...
    def clone_(self): ...
    @property
    def components(self): ...
    def kind(self): ...

class polygon_2:
    boundary: Any
    inner_boundaries: Any
    point_inside: Any

class ray_intersection_result:
    distance: Any
    dot_product: Any
    instance: Any
    normal: Any
    position: Any
    ray_distance: Any
    style_index: Any

class ray_intersection_results:
    def append(self, x): ...
    def assign(self, n, x): ...
    def back(self): ...
    def begin(self): ...
    def capacity(self): ...
    def clear(self): ...
    def empty(self): ...
    def end(self): ...
    def erase(self, *args): ...
    def front(self): ...
    def get_allocator(self): ...
    def insert(self, *args): ...
    def iterator(self): ...
    def pop(self): ...
    def pop_back(self): ...
    def push_back(self, x): ...
    def rbegin(self): ...
    def rend(self): ...
    def reserve(self, n): ...
    def resize(self, *args): ...
    def size(self): ...
    def swap(self, v): ...

class revolve(sweep):
    angle: Any
    axis_origin: Any
    direction: Any
    def calc_hash(self): ...
    def clone_(self): ...
    def kind(self): ...
    @property
    def matrix(self): ...

class schema_definition:
    def declaration_by_name(self, *args: str) -> declaration:
        """
        :return: ``declaration`` but upcasted to the most advanced available type
            (e.g. ``entity``, ``type_declaration``, etc).
        """
        ...

    def declarations(self) -> tuple[declaration, ...]:
        """
        :return: returned declarations are also upcasted, see ``declaration_by_name``.
        """
        ...

    def entities(self) -> tuple[entity, ...]: ...
    def enumeration_types(self) -> tuple[enumeration_type, ...]: ...
    def select_types(self) -> tuple[select_type, ...]: ...
    def type_declarations(self) -> tuple[type_declaration, ...]: ...
    def instantiate(self, decl, data): ...
    def name(self) -> str: ...

class select_type(declaration):
    def as_select_type(self) -> select_type: ...
    def select_list(self) -> tuple[declaration, ...]: ...

class shell:
    closed: Any
    def calc_hash(self): ...
    @property
    def children(self): ...
    def clone_(self): ...
    def kind(self): ...
    def print_impl(self, o, indent): ...

class simple_type(parameter_type):
    binary_type: Any
    boolean_type: Any
    integer_type: Any
    logical_type: Any
    number_type: Any
    real_type: Any
    string_type: Any
    datatype_COUNT: Any
    def as_simple_type(self) -> simple_type: ...
    def declared_type(self): ...

class solid:
    def calc_hash(self): ...
    @property
    def children(self): ...
    def clone_(self): ...
    def kind(self): ...
    @property
    def matrix(self): ...

class sphere(surface):
    radius: Any
    def calc_hash(self): ...
    def clone_(self): ...
    def kind(self): ...
    @property
    def matrix(self): ...

class style(item):
    diffuse: colour
    name: str
    """E.g. 'IfcSurfaceStyleShading-218', where 218 is style's STEP id."""
    specular: colour
    specularity: float
    """Can be `float('nan')`"""
    surface: colour
    transparency: float
    """Can be `float('nan')`"""
    use_surface_color: bool

    def calc_hash(self) -> int: ...
    def clone_(self) -> Self: ...
    def get_color(self) -> colour:
        """ "Return surface color if it's used, otherwise return diffuse color."""
        ...

    def has_specularity(self) -> bool: ...
    def has_transparency(self) -> bool: ...
    def instance_id(self) -> int:
        """
        Possible values for `instance_id`:
        - IFC style id if style assigned to the representation items directly
        or through material with a style;
        - IFC material id if both true:
        - element has a material without a style;
        - there are parts of the geometry that has no other style assigned to them;
        - -1 in case if there is no material;
        - 0 in case if there are default materials used.
        """
        ...

    def kind(self) -> int: ...

class surface(geom_item): ...

class svg_groups_of_line_segments:
    def append(self, x): ...
    def assign(self, n, x): ...
    def back(self): ...
    def begin(self): ...
    def capacity(self): ...
    def clear(self): ...
    def empty(self): ...
    def end(self): ...
    def erase(self, *args): ...
    def front(self): ...
    def get_allocator(self): ...
    def insert(self, *args): ...
    def iterator(self): ...
    def pop(self): ...
    def pop_back(self): ...
    def push_back(self, x): ...
    def rbegin(self): ...
    def rend(self): ...
    def reserve(self, n): ...
    def resize(self, *args): ...
    def size(self): ...
    def swap(self, v): ...

class svg_groups_of_polygons:
    def append(self, x): ...
    def assign(self, n, x): ...
    def back(self): ...
    def begin(self): ...
    def capacity(self): ...
    def clear(self): ...
    def empty(self): ...
    def end(self): ...
    def erase(self, *args): ...
    def front(self): ...
    def get_allocator(self): ...
    def insert(self, *args): ...
    def iterator(self): ...
    def pop(self): ...
    def pop_back(self): ...
    def push_back(self, x): ...
    def rbegin(self): ...
    def rend(self): ...
    def reserve(self, n): ...
    def resize(self, *args): ...
    def size(self): ...
    def swap(self, v): ...

class svg_line_segments:
    def append(self, x): ...
    def assign(self, n, x): ...
    def back(self): ...
    def begin(self): ...
    def capacity(self): ...
    def clear(self): ...
    def empty(self): ...
    def end(self): ...
    def erase(self, *args): ...
    def front(self): ...
    def get_allocator(self): ...
    def insert(self, *args): ...
    def iterator(self): ...
    def pop(self): ...
    def pop_back(self): ...
    def push_back(self, x): ...
    def rbegin(self): ...
    def rend(self): ...
    def reserve(self, n): ...
    def resize(self, *args): ...
    def size(self): ...
    def swap(self, v): ...

class svg_loop:
    def append(self, x): ...
    def assign(self, n, x): ...
    def back(self): ...
    def begin(self): ...
    def capacity(self): ...
    def clear(self): ...
    def empty(self): ...
    def end(self): ...
    def erase(self, *args): ...
    def front(self): ...
    def get_allocator(self): ...
    def insert(self, *args): ...
    def iterator(self): ...
    def pop(self): ...
    def pop_back(self): ...
    def push_back(self, x): ...
    def rbegin(self): ...
    def rend(self): ...
    def reserve(self, n): ...
    def resize(self, *args): ...
    def size(self): ...
    def swap(self, v): ...

class svg_loops:
    def append(self, x): ...
    def assign(self, n, x): ...
    def back(self): ...
    def begin(self): ...
    def capacity(self): ...
    def clear(self): ...
    def empty(self): ...
    def end(self): ...
    def erase(self, *args): ...
    def front(self): ...
    def get_allocator(self): ...
    def insert(self, *args): ...
    def iterator(self): ...
    def pop(self): ...
    def pop_back(self): ...
    def push_back(self, x): ...
    def rbegin(self): ...
    def rend(self): ...
    def reserve(self, n): ...
    def resize(self, *args): ...
    def size(self): ...
    def swap(self, v): ...

class svg_point:
    def back(self): ...
    def begin(self): ...
    def empty(self): ...
    def end(self): ...
    def fill(self, u): ...
    def front(self): ...
    def iterator(self): ...
    def rbegin(self): ...
    def rend(self): ...
    def size(self): ...
    def swap(self, v): ...

class svg_polygons:
    def append(self, x): ...
    def assign(self, n, x): ...
    def back(self): ...
    def begin(self): ...
    def capacity(self): ...
    def clear(self): ...
    def empty(self): ...
    def end(self): ...
    def erase(self, *args): ...
    def front(self): ...
    def get_allocator(self): ...
    def insert(self, *args): ...
    def iterator(self): ...
    def pop(self): ...
    def pop_back(self): ...
    def push_back(self, x): ...
    def rbegin(self): ...
    def rend(self): ...
    def reserve(self, n): ...
    def resize(self, *args): ...
    def size(self): ...
    def swap(self, v): ...

class sweep(geom_item):
    basis: Any

class sweep_along_curve(sweep):
    curve: Any
    surface: Any
    def calc_hash(self): ...
    def clone_(self): ...
    def kind(self): ...

class too_many_faces_exception(geometry_exception): ...
class topology_error: ...

class torus(surface):
    radius1: Any
    radius2: Any
    def calc_hash(self): ...
    def clone_(self): ...
    def kind(self): ...
    @property
    def matrix(self): ...

class tree:
    def add_element(self, *args): ...
    def add_file(self, *args): ...
    def clash_clearance_many(self, set_a, set_b, clearance, check_all): ...
    def clash_collision_many(self, set_a, set_b, allow_touching): ...
    def clash_intersection_many(self, set_a, set_b, tolerance, check_all): ...
    def distances(self): ...
    def enable_face_styles(self, *args): ...
    @staticmethod
    def is_manifold(fs): ...
    def protrusion_distances(self): ...
    def select(self, *args): ...
    def select_box(self, *args): ...
    def select_ray(self, p0, d, length): ...
    def styles(self): ...
    def uint8_to_b64(self, uuids_array): ...
    @staticmethod
    def vector_to_list(ps): ...
    def write_h5(self): ...

class trimmed_curve(geom_item):
    basis: Any
    curve_sense: Any
    start: Any
    end: Any

    def reverse(self): ...

class type_by_kind:
    max: Any

class type_declaration(declaration):
    def argument_types(self): ...
    def as_type_declaration(self) -> type_declaration: ...
    def declared_type(self): ...

def arrange_polygons(polygons): ...
def clear_schemas(): ...
def construct_iterator_with_include_exclude(geometry_library, settings, file, elems, include, num_threads): ...
def construct_iterator_with_include_exclude_globalid(geometry_library, settings, file, elems, include, num_threads): ...
def construct_iterator_with_include_exclude_id(geometry_library, settings, file, elems, include, num_threads): ...
def create_box(*args): ...
def create_epeck(*args): ...
def create_shape(*args): ...
def flatten(deep): ...
def get_feature(x): ...
def get_info_cpp(v, include_identifier): ...
def get_log(): ...
def helmert_curve_point(A0, A1, A2, s): ...
def kind_to_string(k): ...
def less(arg1, arg2): ...
def line_segments_to_polygons(s, eps, segments): ...
def map_shape(settings, instance): ...
def nary_union(sequence): ...
def new_IfcBaseClass(schema_identifier: str, name: str) -> entity_instance: ...
def open(fn): ...
def parse_ifcxml(filename): ...
def polygons_to_svg(*args): ...
def read(data): ...
def register_schema(arg1): ...
def schema_by_name(arg1: str) -> schema_definition: ...
def schema_names() -> tuple[str, ...]: ...
def serialise(schema_name, shape_str, advanced): ...
def set_feature(x, v): ...
def set_log_format_json(): ...
def set_log_format_text(): ...
def svg_to_line_segments(data, class_name): ...
def svg_to_polygons(data, class_name): ...
def taxonomy_item_repr(i): ...
def tesselate(schema_name, shape_str, d): ...
def turn_off_detailed_logging() -> None: ...
def turn_on_detailed_logging() -> None: ...
def version() -> str: ...
