#!/bin/sh 
#!/bin/sh -xv  
# Use -xv option to debug
#    
# $Id: install.sh,v 1.14 2024/07/18 19:41:22 root Exp root $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Installs the Performance Navigator Data Consolidator
#
#&% install.sh and mpgpn.tar must be a matched set of files
#&%
#&% install.sh version must match version of manifest
#&%
#&% This Script must stay posix compliant (/bin/sh) not ksh
#&%
#&% To execute install.sh script type:
#&%    chmod 540 install.sh  # Makes the install.sh executable
#&%    ./install.sh   
#
#& Using ./install.sh without option will install in /usr/local/mpg
#& This is the recommended installation directory
#
#&@ mpgpn.tar is also required. 
#

mkdir -p /tmp/helpsystems_tmp

# Remove old /tmp files from prior installs
rm -f /tmp/devnull_perm_check.tmp /tmp/check_reinstall_needed.hsllc /tmp/df-m_tmp.hsllc df-m_var.hsllc
rm -f /tmp/nmon_running.tmp /tmp/files_to_untar.helpsys /tmp/df-m.hsllc

install_sh_ver=`grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` 
echo "Running $install_sh_ver"
#
copyright="
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
# "

jhost=`hostname`

# Variable to indicate how HelpSystems, LLC. Performance Nav was installed
jinstall_opts="$0 $*"
cron_header_install_opts="# Helpsystems, LLC. Performance Nav installed with (( ${jinstall_opts} ))"

startdir=`pwd`
tarfile="mpgpn.tar" 
def_tarfile="mpgpn.tar" 
jdate=`date +%Y%m%d_%H%M`
# debug="T"


##### :! csum mpgpn.tar; cksum mpgpn.tar; sum mpgpn.tar; ls -l mpgpn.tar ####
##### begin package values
package_md5="f5c29432d1e82e62940acce3f0ce9d35  mpgpn.tar"
package_cksum="1950623874 54261760 mpgpn.tar"
package_sum="30687"
package_size="54261760"
perfnav_version="1.0.0.85"
##### end package values

# perfnav_version is from docker/jenkins build process
installer_version="${perfnav_version}" 

# Create a soft link for ksh at /bin/ksh if it does not exist
chk_ksh () {
kshlocation=`type /bin/ksh  2>/dev/null | sed -e 's,^.*\ \/,\/,' | grep -v "not found"`
# echo "(${kshlocation})"
if [ "x${kshlocation}x" = "xx" ]; then
   # /bin/ksh was not found, lQQk for ksh
   kshlocation=`type ksh  2>/dev/null | sed -e 's,^.*\ \/,\/,' | grep -v "not found"`
   if [ "x${kshlocation}x" != "xx" ]; then
      # if an alternate location to ksh exists create a soft link
      # If /bin/ksh does not exist, create soft link
      if [ ! -s /bin/ksh ]; then
         ln -s ${kshlocation} /bin/ksh
         echo "Created softlink for ksh using (ln -s ${kshlocation} /bin/ksh)"
      fi 
      # If /usr/bin/ksh does not exist, create soft link
      if [ ! -s /usr/bin/ksh ]; then
         ln -s ${kshlocation} /usr/bin/ksh
         echo "Created softlink for ksh using (ln -s ${kshlocation} /usr/bin/ksh)"
      fi 
   else
      # if an alternate location to ksh does not exists, create a soft link to bash
      kshlocation=`type bash  2>/dev/null | sed -e 's,^.*\ \/,\/,' | grep -v "not found"`
      if [ "x${kshlocation}x" != "xx" ]; then
         # if an alternate location to ksh exists create a soft link
         # If /bin/ksh does not exist, create soft link
         if [ ! -s /bin/ksh ]; then
            ln -s ${kshlocation} /bin/ksh
            echo "Created softlink for ksh using (ln -s ${kshlocation} /bin/ksh)"
         fi 
         # If /usr/bin/ksh does not exist, create soft link
         if [ ! -s /usr/bin/ksh ]; then
            ln -s ${kshlocation} /usr/bin/ksh
            echo "Created softlink for ksh using (ln -s ${kshlocation} /usr/bin/ksh)" 
         fi 
      else
         echo "Problems identifying a location to create a soft link from for /bin/ksh"
         exit 1
      fi
   fi  
else
   echo "/bin/ksh was found"
fi
}
# Run function chk_ksh to see if there is a /bin/ksh link or file
# and create a soft link to ksh or bash if it does not
chk_ksh


# Locate applications using normal pathing.
locate_app () {
   # Identify locations of applications
   # Check normal bin sbin directories for application
   for jdirs in /bin/ /sbin/ /usr/bin/ /usr/sbin/ /usr/local/bin/ /usr/local/sbin/ /usr/contrib/bin/ /usr/contrib/sbin/ /opt/hpvm/bin/
   do
      if [ -x ${jdirs}${1} ]; then
         jloc="${jdirs}${1}"
         break
      fi
   done
   if [ "x${jloc}x" != "xx" ]; then
      export jloc
      return 0
   else
      # HP-UX  required the grep "^no "
      jloc=`which $1 2>/dev/null | grep -v "^no "`
      if [ "x${jloc}x" != "xx" ]; then
         export jloc
         return 0
      else
         return 1
      fi
   fi
}


dmi_lookup () {
   if [ "x${1}x" = "xx" ] ; then
      echo "dmi_lookup must have and item to lookup"
      return
   fi
   if [ -s /usr/sbin/dmidecode ] ; then
      DMI="/usr/sbin/dmidecode"         
   else                                    
      DMI="${installdir}/pntestdmi"        
   fi
   # echo "$DMI -s $1" # for testing only command is placed in pn.config 
   jtest=`$DMI -s $1`                            
      echo $jtest | grep "sorry" > /dev/null 
   jgreptest=$?                              
   if [ ${jgreptest} -eq 0 ]                 
   then                                      
      echo $jtest                            
      echo "### This may be an old server ###"
   fi      
      $DMI -s $1 
}

usage () {
echo "
USAGE: install.sh [options]
where options may be any of:
  -i <install_dir>	install directory (default:/usr/local/mpg) 
  -o <mpg_data_dir>	full path to mpg data files (default:/usr/local/mpg) 
  -N <nmon_data_dir>	full path to nmon data files (default:/usr/local/mpg) 
  -s <sar_directory>	full path to the directory containing sar data files
  -t <PerfNav tarfile>	full path to the Performance Navigator package tar file
  -c <config_file>	full path to configuration file
  -a                    disable PN Admin Data Collection Process
  -e                    enable PN External Data Collection Process
  -n                    Don't auto_start_nmon
  -S			install the Performance Navigator sar data consolidator
  -R			re-install (replace data collector and cron entries)
  -f			force install when prereqs not satisfied - may not work!
  -H <shellpath>	full path to shell to use for installed scripts (ksh or bash)
  -r			do not reduce data (normally eliminates some extraneous data)
  -v			verbose output
  -D			Debug output (even more verbose)
  -V			show installer Version
"
#  -z			do not compress nmon daily files
#  -Z			do not compress data file
}

print_greeting () {
  echo "HelpSystems, LLC. Performance Navigator data consolidator installer $installer_version"
}

chk_tar () {
tarname=$1
echo "tarname=(${tarname})"
# Confirm tarname and return if exists
# If tarname does not exist, see if a gzipped or compressed version exists.
# If a gzip version exists, gunzip it.
# If a compressed version exists, uncompress it.
# 
targzipped="${tarname}.gz"
tarcompressed="${tarname}.Z"
if [ -f ${tarname} ] ; then
   return 
elif [ -f ${targzipped} ]; then 
   echo $targzipped exists, gunzip $targzipped
   gunzip $targzipped
   return
elif [ -f ${tarcompressed} ]; then 
   echo $tarcompressed exists, uncompress $tarcompressed
   uncompress $tarcompressed
   return
else
   echo Could not find $tarname, $targzipped, or $tarcompressed
   echo Please ensure one of these files exists
   exit 1
fi
}

locate_app uname
juname="$jloc"

get_ostype () {
 ostype=`$juname -s`
 case $ostype in
   "AIX")	idcmd="id" ; whichcmd="which" ;;
   "Linux")	idcmd="id" ; whichcmd="which" ;;
   "HP-UX")	idcmd="id" ; whichcmd="fixwhich" ;;
   "Darwin")	idcmd="id" ; whichcmd="fixwhich" ;;
   "SunOS")     idcmd="/usr/xpg4/bin/id" ; whichcmd="fixwhich" ;;
    *)		idcmd="id" ; whichcmd="fixwhich" ;;
 esac
}

get_ostype

fixwhich () {
# a "which" function to replace the ones created by (sun,hpux)
# that always return 0 (success), even on a failure...
  what=$1
  ret=`which $what`
  if [ -z "$ret" ] ; then  return 1 ;
  else
    if [ -f "$ret" ] ; then return 0 ;
    else   return 1;
    fi
  fi
}

get_manifest () {
echo tar xvf $tarfile manifest 
 # manifest is required to know what files need to be extracted for installation.
 tar xvf $tarfile manifest 
 rc=$?
 if [ "$debug" = "T" ] ; then echo "rc from tar (untar manifest) : $retcode" ; fi
 if [ "$rc" != "0" ] ; then
   echo "ERROR ($rc) trying to untar manifest - report to HelpSystems" ;
 fi
 . ./manifest
}

verify_pkg () {
 if [ ! -z "$just_verify_pkg" ] ; then save_verbose=$verbose; verbose="T"; fi
 
 get_manifest

 #####  Need to check if md5sum, csum, or sum is available?
 #####  First check if md5sum is available?
 $whichcmd md5sum > /dev/null 2>&1 
 chk_md5sum=$?
 #####  Second check if csum is available?
 $whichcmd csum > /dev/null 2>&1 
 chk_csum=$?

 if [ "$chk_md5sum" = "0" ] ; then
   # The awk statement below is required, because some versions of md5sum
   # place one space instead of two in the output.  This will ensure it is 
   # always two spaces between the md5sum and the filename.
   test_md5=`md5sum mpgpn.tar|awk '{print $1"  "$2}'` 
   if [ "x${package_md5}x" != "x${test_md5}x" ] ; then
     echo "ERROR - package mpgpn.tar failed md5sum check "
     echo "  Please contact HelpSystems, LLC. for correct installation package " ;
     exit 1
   else 
     if [ ! -z "$verbose" ] ; then echo "package md5sum OK" ; fi 
   fi
 elif [ "$chk_csum" = "0" ] ; then 
   # csum output is the same as md5sum output.
   csum_package_chk=`csum mpgpn.tar`
   if [ "x${package_md5}x" != "x${csum_package_chk}x" ] ; then
     echo "ERROR - package mpgpn.tar failed csum check "
     echo "  Please contact HelpSystems, LLC. for correct installation package " ;
     exit 1
   else
     if [ ! -z "$verbose" ] ; then echo "package md5sum from csum OK" ; fi
   fi
 else
   if [ ! -z "$verbose" ] ; then echo "md5sum and csum are not available, trying sum" ; fi
   $whichcmd sum > /dev/null 2>&1
   rc=$?
   if [ "$rc" = "0" ] ; then
     ## have to use "sum -r" - solaris uses old sum 
     if [ "xDarwinx" = "x${ostype}x" ]  ; then
        checkpkgsum=`sum mpgpn.tar | awk '{print $1}'`
     else
        checkpkgsum=`sum -r mpgpn.tar | awk '{print $1}'`
     fi
     if [ "$package_sum" != "$checkpkgsum" ] ; then
       echo "ERROR - package mpgpn.tar failed checksum "
       echo "  Please contact HelpSystems, LLC. for correct installation package " ;
       exit 1 
     else
       if [ ! -z "$verbose" ] ; then echo "package chksum OK" ; fi
     fi
   else
     # md5sum, csum and sum are not available, check package size.
     if [ ! -z "$verbose" ] ; then 
       echo "md5sum, csum, and sum are not available, checking size" 
     fi
     checkpkgsize=`wc -c mpgpn.tar | awk '{print $1}'`
     if [ "$package_size" != "$checkpkgsize" ] ; then
       echo "ERROR - package mpgpn.tar wrong size "
       echo "  Please contact HelpSystems, LLC. for correct installation package " ;
       exit 1
     else
       if [ ! -z "$verbose" ] ; then echo "package size OK" ; fi
     fi
   fi
 fi
 if [ ! -z "$just_verify_pkg" ] ; then
   verbose=$save_verbose;
   exit 0;
 fi
}

#	z)	compressnmon="T" ;;
#	Z)	compressdatafile="T" ;;
#	l)      opt_datacur=$OPTARG ;;

while getopts "xVDvaeo:s:i:t:c:N:nSRrfH:X:" opt ; do
  case $opt in
	x)	testplatform="T" ;;	##### remove for production !!! #####
	V)	just_verify_pkg="T" ;;
	D)	debug="T" ;;
	v)	verbose="T" ;;
	a)      pnadcp="F" ;;
	e)      pnedcp="T" ;;
	N)      opt_nmondatadir=$OPTARG ;;
	o)      opt_datadir=$OPTARG ;;
	s)      opt_sardir=$OPTARG ;;
	i)      opt_instdir=$OPTARG ;;
	t)      opt_tarfile=$OPTARG ;;
	c)      opt_pnconfig=$OPTARG ;;
	S)	install_sar="T" ;;
	R)	reinstall="T" ;;
	f)	force_install="T" ;;
	H)      opt_shelltouse=$OPTARG ;;
	n)	auto_start_nmon="F" ;;
	r)	reduce="T" ;;
	X)	hsllcremove=$OPTARG ;;
	?)	usage; exit ;;
  esac
done
shift `expr $OPTIND - 1`
if [ "$debug" = "T" ] ; then verbose="T" ; fi
## if force, set opt_sardir to something - checks will assume correct and move on

if [ "x${hsllcremove}x" = "xhsllcx" ] ; then
   if [ -s /etc/pn.conf ]; then
      . /etc/pn.conf
      echo "Removing Performance Navigator host install from (${nminst})" 
      # First go to the install directory
      cd ${nminst}
      # Change pn.config file so nmon does not start
      ./change_pn.sh -n "F"
      # Stop nmon so it will not be running
      ./killnmon
      # Go to /tmp/helpsystems_tmp directory
      cd /tmp/helpsystems_tmp
      # Remove mpg/MPG/HelpSystems crontab entries
      # Create new crontab without mpg/MPG entries
      crontab -l | egrep -vi "mpg|HelpSystems|Power Nav" > /tmp/helpsystems_tmp/cronnew.hsllc
      # Start cron without mpg/MPG/HelpSystems entries
      crontab /tmp/helpsystems_tmp/cronnew.hsllc 
      # Remove the install directory
      rm -rf ${nminst}
      # Remove many of the teMporary files in /tmp/helpsystems_tmp
      rm -rf /tmp/helpsystems_tmp/*nmon* /tmp/helpsystems_tmp/*chart* /tmp/helpsystems_tmp/*mpg* /tmp/helpsystems_tmp/*MPG* /tmp/helpsystems_tmp/*.tmp /tmp/helpsystems_tmp/*.mpginc /tmp/helpsystems_tmp/*.hsllc /etc/pn.conf* 
      echo "PerfNav install at (${nminst}) has been removed" ; exit 
   fi
fi

if [ "$force_install" = "T" ] ; then
  if [ -z "$opt_sardir" ] ; then
    $opt_sardir="/var/log/sardir"
  fi
fi

check_for_root () {
## check that we are running as root
runningas=`$idcmd -u`
runningasname=`$idcmd -u -n`
if [ "$runningas" != "0" ] ; then
  echo "ERROR - install must be run as root - current userid is $runningas($runningasname)"
	if [ "$testplatform" = "T" ] ; then
		echo "testplatform set - continuing anyway - install may fail"
	else
  exit 1
	fi
fi
}

set_default_variables () {
 ## default and os specific default settings
 ## note that the order of some of these is important - ie $instdir must be set before $sar_cron_entry, etc.
 ## default mpgdata file location
 defdir="/usr/local/mpg"
 defconfig="pn.config"
 if [ "$install_sar" = "T" ] ; then
	defmpgfile=mpgdata ;	# default for sar
	defmpgcur=mpgdata_current ;	# default for sar
 else
	defmpgfile=mpgdata2 ;	# default for nmon
	defmpgcur=mpgdata2_current ;	# default for nmon
 fi
 if [ "X$opt_instdir" = "X" ] ; then
	instdir=$defdir;
 else
	instdir=`echo $opt_instdir | sed s,\/$,,`;
 fi
 if [ "X$opt_pnconfig" = "X" ] ; then
	pnconfig=$instdir/$defconfig ;
 else
	pnconfig=$opt_pnconfig ;
 fi
 
 if [ -s ${pnconfig} ];then
    # Need to source original variables for 
    # transfer_script_cmd & transfer_current_cmd
    # ext_data_collect include_dir_scans    
    # there may be others later    
    egrep "^(ext_data_collect|include_dir_scans|transfer_script_cmd|transfer_current_cmd)=" ${pnconfig} > /tmp/helpsystems_tmp/variables_2_source.tmp
    . /tmp/helpsystems_tmp/variables_2_source.tmp
    # Only comment next line if testing, so need to see file
    rm -f /tmp/helpsystems_tmp/variables_2_source.tmp
 fi

 if [ "X$auto_start_nmon" != "XF" ] ; then
        auto_start_nmon="T" ;
 fi
 ### regex's to find old installations
 nmonregex_old="$instdir"';.*nmon -F.*date +mpg'
 nmonregex="$instdir"'.*/start_nmon_now -f'	## gets both cd <dir> and direct versions
 cendregex="$instdir"'.*/cend.sh -c'
 pndcmregex="$instdir"'.*/pndcm.sh -c'
 sdcmregex="$instdir"'.*/sdcm.sh -c'
 rackregex="$instdir"'.*/rackdata.sh'
 truncregex="$instdir"'.*/pndc_truncate.sh'
 pndchkregex="$instdir"'.*/pndchk.sh'
 pndchksarregex="$instdir"'.*/pndchk_sar.sh'
 ## command to see if Performance Navigator (pngetinfo) is already in cron
 pngetinforegex="$instdir"'.*/pngetinfo.sh -q'
 ## command to see if Peformance Navigator (pndcm) is already in cron
 pndcmrunning_AIX="crontab -l | grep -v '^#' | grep \"$pndcmregex\""
 pndcmrunning_linux="crontab -l | grep -v '^#' | grep \"$pndcmregex\""
 pndcmrunning_generic="crontab -l | grep -v '^#' | grep \"$pndcmregex\""
 # pndcmrunning_generic="crontab -l | grep -v '^#' | grep pndcm"

 ## command to see if nmon is configured to run in default config
 nmonrunning_AIX_old="crontab -l | grep -v '^#' | grep \"$nmonregex_old\""
 nmonrunning_linux_old="crontab -l | grep -v '^#' | grep \"$nmonregex_old\""
 nmonrunning_generic_old="crontab -l | grep -v '^#' | grep \"$nmonregex_old\""
 nmonrunning_AIX="crontab -l | grep -v '^#' | grep \"$nmonregex\""
 nmonrunning_linux="crontab -l | grep -v '^#' | grep \"$nmonregex\""
 nmonrunning_generic="crontab -l | grep -v '^#' | grep \"$nmonregex\""

 ## Performance Navigator nmon data consolidator crontab entries
 pndcm_cron_entry="25 4 * * * cd $instdir; $instdir/cend.sh -c $pnconfig"
 #OLD# nmon_cron_entry="1 0 * * * cd $instdir; $instdir/start_nmon_now -f"
 nmon_cron_entry="1,16,31,46 * * * * cd $instdir; $instdir/start_nmon_now -f -q"
 pndcm_clean_cron_entry="35 4 * * * cd $instdir; $instdir/pndcm.sh -c $pnconfig clean"
 ## pndchk.sh will run monthly on the 2nd 
 pndchk_cron_entry="30 5 2 * * cd $instdir; $instdir/pndchk.sh " 

 ## pndchk_sar.sh will run monthly on the 2nd 
 pndchk_sar_cron_entry="30 5 2 * * cd $instdir; $instdir/pndchk_sar.sh " 

 ### sar specific default values
 ## defsardir = default sar data location
 defsardir_AIX="/var/adm/sa" ;
 defsardir_HPUX="/var/adm/sa" ;
 defsardir_SunOS="/var/adm/sa" ;
 defsardir_linux="/var/log/sa" ;
 defsardir_linux_debian="/var/log/sysstat" ;
 defsardir_generic="/var/adm/sa" ;

 ## sar package command
 sarq_AIX="lslpp -qLc bos.acct" ;
 sarq_linux="rpm -q sysstat" ;
 #####	same on Suse ???
 sarq_linux_debian="dpkg -s sysstat"
 sarq_generic="$whichcmd sar"

 ## command to see if sar is configured to run in default config
 sarrunning_AIX='grep -s sa1 /var/spool/cron/crontabs/* /var/spool/cron/tabs/* /var/spool/cron/*'
 sarrunning_SunOS='grep -s sa1 /var/spool/cron/crontabs/* /var/spool/cron/tabs/* /var/spool/cron/*'
 sarrunning_HPUX='grep -s sa1 /var/spool/cron/crontabs/* /var/spool/cron/tabs/* /var/spool/cron/*'
 sarrunning_linux='grep -s sa1 /var/spool/cron/crontabs/* /var/spool/cron/tabs/* /var/spool/cron/*'
 sarrunning_linux_debian='grep -s sa1 /var/spool/cron/crontabs/* /var/spool/cron/tabs/* /var/spool/cron/*'
 sarrunning_generic='grep -s sa1 /var/spool/cron/crontabs/* /var/spool/cron/tabs/* /var/spool/cron/*'


 ## command to see if Performance Navigator (sdcm) is already in cron
 sdcmrunning_AIX="crontab -l | grep -v '^#' | grep \"$sdcmregex\""
 sdcmrunning_SunOS="crontab -l | grep -v '^#' | grep \"$sdcmregex\""
 sdcmrunning_HPUX="crontab -l | grep -v '^#' | grep \"$sdcmregex\""
 sdcmrunning_linux="crontab -l | grep -v '^#' | grep \"$sdcmregex\""
 sdcmrunning_linux_debian="crontab -l | grep -v '^#' | grep \"$sdcmregex\""
 sdcmrunning_generic="crontab -l | grep -v '^#' | grep \"$sdcmregex\""

 ## command to see if Performance Navigator (pngetinfo -q) is already in cron
 pngetinforunning_AIX="crontab -l | grep -v '^#' | grep \"$pngetinforegex\""
 pngetinforunning_SunOS="crontab -l | grep -v '^#' | grep \"$pngetinforegex\""
 pngetinforunning_HPUX="crontab -l | grep -v '^#' | grep \"$pngetinforegex\""
 pngetinforunning_linux="crontab -l | grep -v '^#' | grep \"$pngetinforegex\""
 pngetinforunning_linux_debian="crontab -l | grep -v '^#' | grep \"$pngetinforegex\""
 pngetinforunning_generic="crontab -l | grep -v '^#' | grep \"$pngetinforegex\""


 ## sar crontab entries
 sar_cron_entry_AIX='0,5,10,15,20,25,30,35,40,45,50,55 * * * * /usr/lib/sa/sa1 &'
 sar_cron_entry_SunOS='0,5,10,15,20,25,30,35,40,45,50,55 * * * * /usr/lib/sa/sa1 &'
 sar_cron_entry_HPUX='0,5,10,15,20,25,30,35,40,45,50,55 * * * * /usr/lib/sa/sa1 &'
 sar_cron_entry_linux='0,5,10,15,20,25,30,35,40,45,50,55 * * * * /usr/lib/sa/sa1 &'
 sar_cron_entry_linux_debian='0,5,10,15,20,25,30,35,40,45,50,55 * * * * /usr/lib/sysstat/sa1 &'
 sar_cron_entry_generic='0,5,10,15,20,25,30,35,40,45,50,55 * * * * /usr/lib/sa/sa1 &'

 ## Performance Navigator sar data collector (sdcm) crontab entries
 sdcm_cron_entry_AIX="35 4 * * * cd $instdir; ./sdcm.sh -c $pnconfig collect all"
 sdcm_cron_entry_HPUX="35 4 * * * cd $instdir; ./sdcm.sh -c $pnconfig collect all"
 sdcm_cron_entry_SunOS="35 4 * * * cd $instdir; ./sdcm.sh -c $pnconfig collect all"
 sdcm_cron_entry_linux="35 4 * * * cd $instdir; ./sdcm.sh -c $pnconfig collect all"
 sdcm_cron_entry_linux_debian="35 4 * * * cd $instdir; ./sdcm.sh -c $pnconfig collect all"
 sdcm_cron_entry_generic="35 4 * * * cd $instdir; ./sdcm.sh -c $pnconfig collect all"

 ## Performance Navigator pngetinfo quietly get mpg data files, pn.config, and rackdata file
 ## Changes to incorporate comments and variable minute for pngetinfo, because 
 ## it is what triggers the main transfer of data for transfer_script.sh
 jrndmin="$((RANDOM%60))" # 0 to 59
 jgetcomment="# HelpSystems, LLC. pngetinfo will run randomly between 5:00 and 5:59 (install.sh sets it!)"
 jgetcomment2="# HelpSystems True for initial install and subsequent reinstalls of newer versions"
 pngetinfo_cron_entry_AIX="$jrndmin 5 * * * cd $instdir; ./pngetinfo.sh -qa"
 pngetinfo_cron_entry_HPUX="$jrndmin 5 * * * cd $instdir; ./pngetinfo.sh -qa"
 pngetinfo_cron_entry_SunOS="$jrndmin 5 * * * cd $instdir; ./pngetinfo.sh -qa"
 pngetinfo_cron_entry_linux="$jrndmin 5 * * * cd $instdir; ./pngetinfo.sh -qa"
 pngetinfo_cron_entry_linux_debian="$jrndmin 5 * * * cd $instdir; ./pngetinfo.sh -qa"
 pngetinfo_cron_entry_generic="$jrndmin 5 * * * cd $instdir; ./pngetinfo.sh -qa"

 ## command to see if rack config is already in cron
 rackrunning_AIX="crontab -l | grep -v '^#' | grep \"$rackregex\""
 rackrunning_SunOS="crontab -l | grep -v '^#' | grep \"$rackregex\""
 rackrunning_HPUX="crontab -l | grep -v '^#' | grep \"$rackregex\""
 rackrunning_linux="crontab -l | grep -v '^#' | grep \"$rackregex\""
 rackrunning_linux_debian="crontab -l | grep -v '^#' | grep \"$rackregex\""
 rackrunning_generic="crontab -l | grep -v '^#' | grep \"$rackregex\""
 # rackrunning_generic="crontab -l | grep -v '^#' | grep rackdata"

 ## rack config crontab entry
 rack_cron_entry="30 4 * * * cd $instdir; $instdir/rackdata.sh -c $pnconfig"

 chk_tar $tarfile

 verify_pkg

 files_for_all="$pkg_rack_files $pkg_info_files $pkg_install_files"
 files_for_nmon="$pkg_pndcm_files $pkg_nmon_utils $pkg_pndcm_utils" ;
 # nmonver, nmonmergever, reducepatt are added later
 files_for_sar="$pkg_sdcm_files"
 ## generic cron comments
 raw_cron_header="# HelpSystems, LLC. Performance Navigator data consolidator Version"
 cron_header="# HelpSystems, LLC. Performance Navigator data consolidator Version $installer_version"
 # cron_trailer="#"
 ## temporary file that crontab will be stored in
 crontab_file_AIX="crontab.root"
 crontab_file_linux="crontab.root"
 crontab_file_generic="crontab.root"
 ## command to get crontab to edit
 cron_get_AIX="crontab -l > $crontab_file_AIX"
 ##### this removes the header lines on linux - new headers are added when crontab installs
 #####	not really safe (just rip out 3 lines) - should pattern match 'em
# cron_get_linux="crontab -l | sed -e '1,3d' > $crontab_file_linux"
########### removed the rip 3 lines for now - need to test...
 cron_get_linux="crontab -l > $crontab_file_linux"
 cron_get_generic="crontab -l > $crontab_file_generic"
 ## command to install new crontab
 cron_install_AIX='su -c "crontab $crontab_file_AIX"'
 cron_install_linux="crontab $crontab_file_linux"
 cron_install_generic="crontab $crontab_file_generic"

 ## get the machine name
 get_machine_name_AIX=`$juname -n | awk -F. '{print $1}'`
 get_machine_name_linux=`$juname -n | awk -F. '{print $1}'`
 get_machine_name_generic=`$juname -n | awk -F. '{print $1}'`
 get_revision_num=`$juname -r`
 
 ## get the serial number
 ##### AIX serial num, can also use: 'lsattr -E -l sys0 | grep "systemid" | awk \'{print $2}\''
 if [ "xDarwinx" = "x${ostype}x" ]  ; then
    get_serial_num_Darwin='system_profiler SPHardwareDataType 2>/dev/null  | grep "Serial\ Number"'
 fi
 if [ "xAIXx" = "x${ostype}x" ]  ; then
    get_serial_num_AIX='$juname -u'
 fi
 if [ -s /usr/contrib/bin/machinfo ]  ; then
    get_serial_num_HPUX="/usr/contrib/bin/machinfo | grep \"ine serial\" | awk '{print \$NF}'"
 else
    get_serial_num_HPUX='hostid'
 fi
 get_serial_num_SunOS='hostid'
 get_serial_num_linux='dmi_lookup system-serial-number'	
 get_serial_num_generic='echo "serial number not found"'
}

set_AIX_defaults () {
 oslevel=`/usr/bin/oslevel`
 case $oslevel in
	[789]*)	nmonver=nmon12e_aix61 ;; ## Will actually use topas_nmon
	6*)    ## check for 6.1.2 ;; ## nmon ??
		ml=`/usr/bin/oslevel -r | cut -c 6,7`
		case $ml in
			02)		nmonver=nmon12f_aix612 ;;
			*)		nmonver=nmon12e_aix61 ;; ## for 6.1.1 and earlier
		esac
	    ;;
	5.3*)	## nmonver=nmon_aix53 ;; ##nmon11
		ml=`/usr/bin/oslevel -r | cut -c 6,7`
		case $ml in
			0[0123])	nmonver=nmon12e_aix530 ;;
			04)		nmonver=nmon12e_aix534 ;;
			05)		nmonver=nmon12e_aix535 ;;
			06)		nmonver=nmon12e_aix536 ;;
			*)		nmonver=nmon12e_aix537 ;; ## for 5.3.07 and anything later
		esac
		;;
	5.2*)	## nmonver=nmon_aix52 ;; ## bugs in various ML's mean different nmons needed
		ml=`/usr/bin/oslevel -r | cut -c 6,7`
		case $ml in
			0[56789])	nmonver=nmon12e_aix527 ;;
			0[012)		nmonver=nmon12e_aix522 ;;
			0[34])		nmonver=nmon12e_aix51 ;;
			*)		nmonver=nmon12e_aix527 ;;
		esac
		;;
	5.1*)	nmonver=nmon12e_aix51 ;;
	4.3.2*)	nmonver=nmon9f_aix432 ;;
	4.3*)	nmonver=nmon_aix433 ;;
	4.2*)	nmonver=nmon_aix420 ;;
	4.1*)	nmonver=nmon_aix415 ;;
	*)      echo "Unable to determine AIX version - installing nmon12e for AIX 6.1";
                echo "Please contact HelpSystems, LLC. for help determining proper nmon package." ;
		nmonver=nmon12e_aix61 ;;
 esac

 nmonmergever="nmonmerge_aix" ;
 reducepatt="reduce.patt.aix" ;
 pndcmrunning=$pndcmrunning_AIX ;
 nmonrunning=$nmonrunning_AIX ;
 defsardir=$defsardir_AIX ;
 sarq=$sarq_AIX ;
 sarrunning=$sarrunning_AIX ;
 sdcmrunning=$sdcmrunning_AIX ;
 pngetinforunning=$pngetinforunning_AIX ;
 rackrunning=$rackrunning_AIX ;
 sdcm_cron_entry=$sdcm_cron_entry_AIX ;
 pngetinfo_cron_entry=$pngetinfo_cron_entry_AIX ;
 cron_get=$cron_get_AIX ;
 crontab_file=$crontab_file_AIX ;
 cron_install=$cron_install_AIX ;
 get_machine_name=$get_machine_name_AIX ;
 get_serial_num=$get_serial_num_AIX ;
}

set_Linux_defaults () {
# get machine architecture (known: ix86 power s390 i386 i486 i586 i686 x86_64)
 osarch=`$juname -m`	# uname -p on AIX, ?? on linux-power, ix86 on pentium
#	if [ "$testplatform" = "T" ] ; then osarch="s390"; fi
##### ? if unknown achitecture install sar collector?
##  Next line is null if it actually matches the pattern.
 osarchx86=${osarch%%i?86}	# see if x86

 defsardir=$defsardir_linux ;
 sarq=$sarq_linux
 # os=`cat /etc/issue`
 # cat /etc/issue 2> /dev/null | awk '{printf $0}' | sed -e 's,\\\,/,g'`
 # Had to replace sed -e 's,\\,,g' with tr -d '\\' to remove \ characters.
 # os=`find /etc -type f -name issue -o -type f -name \*elease\*  | xargs cat | grep -v "[=|\"]" | grep [0-9] |uniq | sed -e 's,\ \ *,\ ,g'  | tr -d '\\' | tr '\n' '\ ' `
 # os=`find /etc -type f -name issue -o -type f -name \*elease\*  | xargs cat | grep -v "[=|\"]" | grep [0-9] |uniq | tr '\n' ' ' | tr '\l' ' ' | head -1 | sed -e ':a' -e 'N' -e '$!ba' -e 's/\n/ /g' | sed -e 's,\ \ *,\ ,g'`
os=`lsb_release -d 2>/dev/null | sed s,Description:\	,,g`
if [ "xx" = "x${os}x" ]; then 
   os=`find /etc -type f -name \*elease\* -o -type f -name issue \
      | xargs cat |  grep [0-9] |uniq  \
      | egrep -v "BUGZILLA|Welcome|JPackage|GNU|products|release\ key" \
      | egrep "Linux|Red\ Hat|CentOS|Ubuntu"   | sed s,PRETTY_NAME=,, \
      | sed s,DISTRIB_DESCRIPTION=,, | sed s,REDHAT_BUGZILLA_PRODUCT=,, \
      | sed s,\",,g | sed -e 's,\\\,,g' | head -1`
fi
echo "os is ( ${os} )"
# os=`printf "%s\n" "$os"`
os=`printf "%s" "$os"`
nmonver=no_nmon_found

# ----- mainframe s390x architecture 64 bit -----
if [ "$osarch" = "s390x" ] ; then
    plat=mainframe_64
    nmonmergever="nmonmerge_mainframe_64" # defaults to a 64 bit version
    # pndmi is blank then nothing specified
    pndmi=""
    case $os in
	*Red\ Hat*release\ 4*)	nmonver=nmon_"$plat"_rhel4 ; 
                                nmonmergever="nmonmerge_mainframe_64_rhel4" ;;
	*Red\ Hat*release\ 5*)	nmonver=nmon_"$plat"_rhel5 ;
                                nmonmergever="nmonmerge_mainframe_64_rhel5" ;;
##	*SUSE*9*)				nmonver=nmon_"$plat"_rhel4 ;; ## Needs recompile
	*SUSE*10*)				nmonver=nmon_"$plat"_sles10 ;; ## Needs recompile
	*SUSE*11*)				nmonver=nmon_"$plat"_sles11 ;; ## Needs recompile
	*)	nmonver=nmon_${plat}_linux ;;   ## fallback nmon_linux_mainframe_64
    esac
# ----- x86_64 architecture -----
# Centos 7 and 8 are the only ones with updates 9 may not be available for some time.
 elif [ "oo${osarch}oo" = "oox86_64oo" ] ; then	
    plat=x86_64
    nmonmergever="nmonmerge_x86_64_linux" 
    pndmi="dmidecode_x86_64" 
    case $os in
	*CentOS*release\ 5*)	nmonver=nmon_"$plat"_centos5 ;;
	*CentOS*release\ 6*)	nmonver=nmon_"$plat"_centos6 ;;
	*CentOS*release\ 7*)	nmonver=nmon_"$plat"_centos7 ;;
	*CentOS*release\ 8*)	nmonver=nmon_"$plat"_centos8 ;;
	*CentOS*)	nmonver=nmon_"$plat"_centos8 ;;
	*Debian\ GNU\/Linux\ 5*)	nmonver=nmon_"$plat"_debian05 ;;
	*Debian\ GNU\/Linux\ 6*)	nmonver=nmon_"$plat"_debian06 ;;
	*Debian\ GNU\/Linux\ 7*)	nmonver=nmon_"$plat"_debian07 ;;
	*Debian\ GNU\/Linux\ 8*)	nmonver=nmon_"$plat"_debian08 ;;
	*Debian\ GNU\/Linux\ 9*)	nmonver=nmon_"$plat"_debian09 ;;
	*Debian\ GNU\/Linux\ 10*)	nmonver=nmon_"$plat"_debian10 ;;
	*Debian\ GNU\/Linux\ 11*)	nmonver=nmon_"$plat"_debian11 ;;
	*Debian*)	nmonver=nmon_"$plat"_debian11 ;;
	*Mint\ 18*)	nmonver=nmon_"$plat"_mint18 ;;
	*Mint\ 19*)	nmonver=nmon_"$plat"_mint19 ;;
	*Mint\ 20*)	nmonver=nmon_"$plat"_mint20 ;;
	*Mint\ *)	nmonver=nmon_"$plat"_mint20 ;;
	*openSUSE*10*)	nmonver=nmon_"$plat"_opensuse10 ;;
	*openSUSE*11*)	nmonver=nmon_"$plat"_opensuse11 ;;
	*openSUSE*12*)	nmonver=nmon_"$plat"_opensuse12 ;;
	*openSUSE*13*)	nmonver=nmon_"$plat"_opensuse13 ;;
	*openSUSE*15*)	nmonver=nmon_"$plat"_opensuse15 ;;
	*openSUSE*)	nmonver=nmon_"$plat"_opensuse15 ;;
	*Oracle\ Linux*release\ 5*)	nmonver=nmon_"$plat"_oel5 ;;
	*Oracle\ Linux*release\ 6*)	nmonmergever=nmonmerge_"$plat"_rhel6 ;
        				nmonver=nmon_"$plat"_oel6 ;;
	*Oracle\ Linux*release\ 7*)	nmonmergever=nmonmerge_"$plat"_rhel6 ;
        				nmonver=nmon_"$plat"_oel7 ;;
	*Oracle\ Linux*release\ 8*)	nmonmergever=nmonmerge_"$plat"_rhel6 ;
        				nmonver=nmon_"$plat"_oel8 ;;
	*Oracle*)	nmonmergever=nmonmerge_"$plat"_rhel6 ;
        		nmonver=nmon_"$plat"_oel8 ;;
	*Red\ Hat*release\ 5*)	nmonver=nmon_"$plat"_rhel5 ;;
	*Red\ Hat*release\ 6*)	nmonmergever=nmonmerge_"$plat"_rhel6 ;
				nmonver=nmon_"$plat"_rhel6 ;;
	*Red\ Hat*release\ 7*)	nmonmergever=nmonmerge_"$plat"_rhel6 ;
				nmonver=nmon_"$plat"_rhel7 ;;
	*Red\ Hat*release\ 8*)	nmonmergever=nmonmerge_"$plat"_rhel6 ;
				nmonver=nmon_"$plat"_rhel8 ;;
	*Red\ Hat\ Enterprise\ Linux\ Server\ 7*)	nmonmergever=nmonmerge_"$plat"_rhel6 ;
				nmonver=nmon_"$plat"_rhel7 ;;
	*Red\ Hat\ Enterprise\ Linux\ Server\ 8*)	nmonmergever=nmonmerge_"$plat"_rhel6 ;
				nmonver=nmon_"$plat"_rhel8 ;;
	*Red\ Hat\ Enterprise\ Linux\ Server\ *)	nmonmergever=nmonmerge_"$plat"_rhel6 ;
				nmonver=nmon_"$plat"_rhel8 ;;
	*Red\ Hat\ Enterprise\ Linux\ 7*)	nmonmergever=nmonmerge_"$plat"_rhel6 ;
				nmonver=nmon_"$plat"_rhel7 ;;
	*Red\ Hat\ Enterprise\ Linux\ 8*)	nmonmergever=nmonmerge_"$plat"_rhel6 ;
				nmonver=nmon_"$plat"_rhel8 ;;
	*Red\ Hat\ Enterprise\ Linux\ *)	nmonmergever=nmonmerge_"$plat"_rhel6 ;
				nmonver=nmon_"$plat"_rhel8 ;;
	*Red\ Hat*release\ *)	nmonmergever=nmonmerge_"$plat"_rhel6 ;
				nmonver=nmon_"$plat"_rhel8 ;;
	*Rocky*release\ 8*)	nmonmergever=nmonmerge_"$plat"_rhel6 ;
                                nmonver=nmon_"$plat"_rocky8 ;;
	*Rocky*release\ 9*)	nmonmergever=nmonmerge_"$plat"_rhel9 ;
                                nmonver=nmon_"$plat"_rocky9 ;;
	*SUSE*Server\ 10*)	nmonmergever=nmonmerge_"$plat"_debian05 ;
                                nmonver=nmon_"$plat"_sles10 ;;
	*SUSE*Server\ 11*)	nmonver=nmon_"$plat"_sles11 ;;
	*SUSE*Server\ 12*)	nmonver=nmon_"$plat"_sles12 ;;
	*SUSE*Server\ 13*)	nmonver=nmon_"$plat"_sles13 ;;
	*SUSE*Server\ 15*)	nmonver=nmon_"$plat"_sles15 ;;
	*SUSE*Server\ *)	nmonver=nmon_"$plat"_sles15 ;;
	*Ubuntu\ 14.[0-9]*)	nmonver=nmon_"$plat"_ubuntu14 ;;
	*Ubuntu\ 15.[0-9]*)	nmonver=nmon_"$plat"_ubuntu14 ;;
	*Ubuntu\ 16.[0-9]*)	nmonver=nmon_"$plat"_ubuntu16 ;;
	*Ubuntu\ 17.[0-9]*)	nmonver=nmon_"$plat"_ubuntu16 ;;
	*Ubuntu\ 18.[0-9]*)	nmonver=nmon_"$plat"_ubuntu18 ;;
	*Ubuntu\ 19.[0-9]*)	nmonver=nmon_"$plat"_ubuntu18 ;;
	*Ubuntu\ 20.[0-9]*)	nmonver=nmon_"$plat"_ubuntu20 ;;
	*Ubuntu\ 21.[0-9]*)	nmonver=nmon_"$plat"_ubuntu20 ;;
	*Ubuntu\ 22.[0-9]*)	nmonver=nmon_"$plat"_ubuntu22 ;;
	*Ubuntu\ 23.[0-9]*)	nmonver=nmon_"$plat"_ubuntu22 ;;
	*Ubuntu*)	nmonver=nmon_"$plat"_ubuntu22 ;;
	*)	nmonver=nmon_${plat}_debian5 ;;   ## fallback to debian 5 if not available
	*SUSE*Server\ 10*)	nmonmergever=nmonmerge_"$plat"_debian5 ;
    esac
 # ----- ppc64le architecture -----
 elif [ "oo${osarch}oo" = "ooppc64leoo" ] ; then	
       # ----- power 64 architecture -----
       # Add _gpu via ${has_gpu} if nvidia-smi exists in /bin or /usr/bin 
       # to each nmon_version
       if [ -s /usr/bin/nvidia-smi ] || [ -s /bin/nvidia-smi ] ; then
          has_gpu="_gpu"
       else
          has_gpu=""
       fi
       plat=power_64le
       nmonmergever="nmonmerge_power_64le_linux" 
       pndmi="dmidecode_power_64le" 
       case $os in
          *CentOS*release\ 6*)          nmonver=nmon_"$plat"_centos6${has_gpu} ;;
          *CentOS*Linux\ 6*)          nmonver=nmon_"$plat"_centos6${has_gpu} ;;
          *CentOS*release\ 7*)          nmonver=nmon_"$plat"_centos7${has_gpu} ;;
          *CentOS*Linux\ 7*)          nmonver=nmon_"$plat"_centos7${has_gpu} ;;
          *CentOS*release\ 8*)          nmonver=nmon_"$plat"_centos8${has_gpu} ;;
          *CentOS*Linux\ 8*)          nmonver=nmon_"$plat"_centos8${has_gpu} ;;
          *CentOS*release\ *)          nmonver=nmon_"$plat"_centos8${has_gpu} ;;
          *CentOS*Linux\ *)          nmonver=nmon_"$plat"_centos8${has_gpu} ;;
          *Red\ Hat*release\ 6*)	nmonver=nmon_"$plat"_rhel6${has_gpu} ;;
          *Red\ Hat*Linux\ 6*)	nmonver=nmon_"$plat"_rhel6${has_gpu} ;;
          *Red\ Hat*release\ 7*)	nmonver=nmon_"$plat"_rhel7${has_gpu} ;;
          *Red\ Hat*Linux\ 7*)	nmonver=nmon_"$plat"_rhel7${has_gpu} ;;
          *Red\ Hat*Server\ 7*)	nmonver=nmon_"$plat"_rhel7${has_gpu} ;;
          *Red\ Hat*release\ 8*)	nmonver=nmon_"$plat"_rhel8${has_gpu} ;;
          *Red\ Hat*Linux\ 8*)	nmonver=nmon_"$plat"_rhel8${has_gpu} ;;
          *Red\ Hat*Server\ 8*)	nmonver=nmon_"$plat"_rhel8${has_gpu} ;;
          *Red\ Hat*release\ 9*)	nmonver=nmon_"$plat"_rhel9${has_gpu} ;;
          *Red\ Hat*Linux\ 9*)	nmonver=nmon_"$plat"_rhel9${has_gpu} ;;
          *Red\ Hat*Server\ 9*)	nmonver=nmon_"$plat"_rhel9${has_gpu} ;;
          *Red\ Hat*release\ *)	nmonver=nmon_"$plat"_rhel9${has_gpu} ;;
          *Red\ Hat*Linux\ *)	nmonver=nmon_"$plat"_rhel9${has_gpu} ;;
          *Red\ Hat*Server\ *)	nmonver=nmon_"$plat"_rhel9${has_gpu} ;;
	  *SUSE*Server\ 11*)	nmonver=nmon_"$plat"_opensles11${has_gpu}  ;;
	  *SUSE*Server\ 12*)	nmonver=nmon_"$plat"_sles12${has_gpu}  ;;
	  *SUSE*Server\ 15*)	nmonver=nmon_"$plat"_sles15${has_gpu}  ;;
          *Ubuntu\ 14.[0-9]*)	nmonver=nmon_"$plat"_ubuntu14${has_gpu}  ;;
          *Ubuntu\ 15.[0-9]*)	nmonver=nmon_"$plat"_ubuntu15${has_gpu}  ;;
          *Ubuntu\ 16.[0-9]*)	nmonver=nmon_"$plat"_ubuntu16${has_gpu}  ;;
          *Ubuntu\ 17.[0-9]*)	nmonver=nmon_"$plat"_ubuntu17${has_gpu}  ;;
          *Ubuntu\ 18.[0-9]*)	nmonver=nmon_"$plat"_ubuntu18${has_gpu}  ;;
          *Ubuntu\ 19.[0-9]*)	nmonver=nmon_"$plat"_ubuntu19${has_gpu}  ;;
          *Ubuntu\ 20.[0-9]*)	nmonver=nmon_"$plat"_ubuntu20${has_gpu}  ;;
          *Ubuntu\ 22.[0-9]*)	nmonver=nmon_"$plat"_ubuntu20${has_gpu}  ;;
          *Ubuntu\ 24.[0-9]*)	nmonver=nmon_"$plat"_ubuntu20${has_gpu}  ;;
          *Ubuntu*)	nmonver=nmon_"$plat"_ubuntu20${has_gpu}  ;;
          *)	nmonver=nmon_"$plat"_linux ;;   ## fallback ubuntu14 if unknown
       esac
 # ----- power 32 architecture -----
 elif [ "oo${osarch}oo" = "ooppcoo" ] || [ "oo${osarch}oo" = "ooppc64oo" ] ; then	
    # Even if the architecture is 64 bit, the kernel may be 32 bit
    getconf_long_bit=`getconf LONG_BIT`
    if [ "xx${getconf_long_bit}xx" = "xx32xx" ]; then 
        # ----- power 32 architecture -----
        plat=power_32
        nmonmergever="nmonmerge_power_32_linux" 
        pndmi="dmidecode_power_32" 
        case $os in
           *Red\ Hat*release\ 5*)	nmonver=nmon_"$plat"_rhel5 ;;
	   *Red\ Hat*release\ 4*)	nmonver=nmon_"$plat"_rhel4 ;;   #OK
	   *SUSE*9*)	nmonver=nmon_"$plat"_sles9 ;;   #OK
	   *SUSE*10*)	nmonver=nmon_"$plat"_sles10 ;;
	   *SUSE*11*)	nmonver=nmon_"$plat"_sles11 ;; #OK
	   *Ubuntu*)	nmonver=nmon_"$plat"_ubuntu10 ;; #compiled on apple, but works on IBM power systems
	   *VCX*)		nmonver=nmon_"$plat"_rhel4 ;;  #3Com VCX is based on RetHat
           *)	nmonver=nmon_${plat}_linux ;;   ## fallback
       esac
    else
 # ----- power 64 architecture -----
       # Centos 7 and 8 are the only ones with updates 9 may not be available for some time.
       plat=power_64
       nmonmergever="nmonmerge_power_64_linux" 
       pndmi="dmidecode_power_64" 
       case $os in
          *CentOS\ 7*)	nmonver=nmon_"$plat"_centos7${has_gpu} ;;
          *CentOS*release\ 7*)          nmonver=nmon_"$plat"_centos7${has_gpu} ;;
          *CentOS*Linux\ 7*)          nmonver=nmon_"$plat"_centos7${has_gpu} ;;
          *CentOS*release\ 8*)          nmonver=nmon_"$plat"_centos8${has_gpu} ;;
          *CentOS*Linux\ 8*)          nmonver=nmon_"$plat"_centos8${has_gpu} ;;
          *CentOS*release\ *)          nmonver=nmon_"$plat"_centos8${has_gpu} ;;
          *CentOS*Linux\ *)          nmonver=nmon_"$plat"_centos8${has_gpu} ;;
          *IBM_PowerKVM\ release\ 2*)	nmonver=nmon_"$plat"_kvm2 ;;
          *IBM_PowerKVM*)	nmonver=nmon_"$plat"_kvm2 ;;
          *Red\ Hat*release\ 5*)	nmonver=nmon_"$plat"_rhel5 ;;
          *Red\ Hat*release\ 6*)	nmonver=nmon_"$plat"_rhel6 ;;
          *Red\ Hat*release\ 7*)	nmonver=nmon_"$plat"_rhel7 ;;
          *Red\ Hat*release*)	nmonver=nmon_"$plat"_rhel7 ;;
          *SUSE*11*)	nmonver=nmon_"$plat"_sles11 ;; #OK
          *SUSE*)	nmonver=nmon_"$plat"_sles11 ;; #OK
          *)	nmonver=nmon_${plat}_linux ;;   ## fallback to Redhat 5 copy under nmon_linux_power_64 name
       esac
    fi
 # ----- arm 64 architecture -----
 elif [ "oo${osarch}oo" = "ooaarch64oo" ] || [ "oo${osarch}oo" = "ooaarch64oo" ] ; then	
    plat=arm_64
    nmonmergever="nmonmerge_arm_64_linux" 
    pndmi="dmidecode_arm_64" 
    case $os in
	*SUSE*Raspberry*aarch64*)	nmonver=nmon_"$plat"_sles12 ;; #OK
	*SUSE*12*)	nmonver=nmon_"$plat"_sles12 ;; #OK
	*)	nmonver=nmon_${plat}_linux ;; ## 
    esac
# Removed x86 architecture because of its age.
# x86_64 is still current.
 fi
	if [ "$debug" = "T" ] ; then
		echo "osarch=$osarch, osarchx86=$osarchx86" 
		echo "nmonver=$nmonver" 
	fi
 files_for_nmon="$files_for_nmon $pndme" # add nmon ,linux  
 files_for_sar="$files_for_sar " # add sar, linux
 reducepatt="reduce.patt.linux" ;
 pndcmrunning=$pndcmrunning_linux ;
 nmonrunning=$nmonrunning_linux ;
 sarrunning=$sarrunning_linux ;
 sdcmrunning=$sdcmrunning_linux ;
 pngetinforunning=$pngetinforunning_linux ;
 rackrunning=$rackrunning_linux ;
 sdcm_cron_entry=$sdcm_cron_entry_linux ;
 pngetinfo_cron_entry=$pngetinfo_cron_entry_linux ;
 cron_get=$cron_get_linux ;
 crontab_file=$crontab_file_linux ;
 cron_install=$cron_install_linux ;
 get_machine_name=$get_machine_name_linux ;
 get_serial_num="$get_serial_num_linux" ;
}

set_HPUX_defaults () {
   defmpgfile=mpgdata ;	# default for sar
   defmpgcur=mpgdata_current ;	# default for sar
   install_sar="T";	## force sar install on HP-UX - no nmon available
   sar_cron_entry='0,5,10,15,20,25,30,35,40,45,50,55 * * * * /usr/lib/sa/sa1 &'
   if [ "$testplatform" = "T" ] ; then
      if [ "$install_sar" != "T" ] ; then
	 print "installing on HP-UX (must be a test install) allowing nmon install for testplatform";
      fi
   else 
      install_sar="T";	## force sar install on HP-UX - no nmon available
      echo "installing on HP-UX using sar (no nmon available on HP-UX)";
   fi
   if [ "$install_sar" = "T" ] ; then
      defsardir=$defsardir_generic ;
      sarq=$sarq_generic ;
      sarrunning=$sarrunning_generic ;
      sdcmrunning=$sdcmrunning_generic ;
      pngetinforunning=$pngetinforunning_generic ;
   else
      ## nmon may be available later...
      nmonver="nmon64" ;
      pndcmrunning=$pndcmrunning_generic ;
      nmonrunning=$nmonrunning_generic ;
      pngetinforunning=$pngetinforunning_generic ;
   fi
   rackrunning=$rackrunning_generic ;
   sdcm_cron_entry=$sdcm_cron_entry_generic ;
   pngetinfo_cron_entry=$pngetinfo_cron_entry_generic ;
   cron_get=$cron_get_generic ;
   crontab_file=$crontab_file_generic ;
   cron_install=$cron_install_generic ;
   get_machine_name=$get_machine_name_generic ;
   sarrunning=$sarrunning_HPUX ;
   if [ "xDarwinx" = "x${ostype}x" ]  ; then
      get_serial_num=$get_serial_num_Darwin ;
   else
      get_serial_num=$get_serial_num_HPUX ;
   fi
}

set_solaris_defaults () {
   defmpgfile=mpgdata ;	# default for sar
   defmpgcur=mpgdata_current ;	# default for sar
   install_sar="T";	## force sar install on solaris - no nmon available
   sar_cron_entry='0,5,10,15,20,25,30,35,40,45,50,55 * * * * /usr/lib/sa/sa1 &'
   if [ "$testplatform" = "T" ] ; then
      if [ "$install_sar" != "T" ] ; then
         print "installing on Solaris (must be a test install) allowing nmon install for testplatform";
      fi
   else
      install_sar="T";	## force sar install on Solaris - no nmon available
      echo "installing on Solaris using sar (no nmon available on Solaris)";
   fi
   if [ "$install_sar" = "T" ] ; then
      defsardir=$defsardir_generic ;
      sarq=$sarq_generic ;
      sarrunning=$sarrunning_SunOS ;
      sdcmrunning=$sdcmrunning_generic ;
      pngetinforunning=$pngetinforunning_generic ;
   # else
      ## nmon may be available later...
      ## nmonver="nmon64" ;
      ## pndcmrunning=$pndcmrunning_generic ;
      ## nmonrunning=$nmonrunning_generic ;
      ## pngetinforunning=$pngetinforunning_generic ;
   fi
   rackrunning=$rackrunning_generic ;
   sdcm_cron_entry=$sdcm_cron_entry_generic ;
   pngetinfo_cron_entry=$pngetinfo_cron_entry_generic ;
   cron_get=$cron_get_generic ;
   crontab_file=$crontab_file_generic ;
   cron_install=$cron_install_generic ;
   get_machine_name=$get_machine_name_generic ;
   get_serial_num=$get_serial_num_SunOS ;
}

set_defaults () {
#determine OS and set OS-specific defaults
 set_default_variables
 ostype=`$juname -s`
#	if [ "$testplatform" = "T" ] ; then ostype="Linux"; fi
 case $ostype in
   "AIX")	set_AIX_defaults ;;
   "Linux")	set_Linux_defaults ;;
   "HP-UX")	set_HPUX_defaults ;;
   "Darwin")	set_HPUX_defaults ;;
   "SunOS")	set_solaris_defaults ;;
    *)
	echo "unknown OS type";
	if [ "$testplatform" != "T" ] ; then install_sar="T"; fi ##### allow nmon install for testing
	if [ "$install_sar" = "T" ] ; then
		echo " - using sar with mixed generic defaults";
	else
	  if [ "$testplatform" = "T" ] ; then
		nmonver="nmon64" ;
		pndcmrunning=$pndcmrunning_generic ;
		nmonrunning=$nmonrunning_generic ;
		pngetinforunning=$pngetinforunning_generic ;
	  else
		if [ "$force_install" = "T" ] ; then
		  nmonver="nmon_linux_x86"	## pick a basic default - tell the admin
		  echo "##########"
		  echo "  Forced install, but unable to determine nmon version to use:"
		  echo "  please extract and link the correct nmon version"
		  echo "  or use a SAR install (-S)"
		  echo "  note: defaulted to $nmonver which may not work on your platform"
		  echo "##########"
		else
		  echo "unable to determine nmon version to use" ; exit ;
		fi
	  fi
	fi
	defsardir=$defsardir_generic ;			# generic Unix ?
	sarq=$sarq_generic ;				# useless
	sarrunning=$sarrunning_generic ;		# assumes sar runs as user "adm"
	sdcmrunning=$sdcmrunning_generic ;		# checks root crontab
        pngetinforunning=$pngetinforunning_generic ;              # checks root crontab
	rackrunning=$rackrunning_generic ;		# checks root crontab
	sdcm_cron_entry=$sdcm_cron_entry_generic ;	# all sdcm cron entries same
        pngetinfo_cron_entry=$pngetinfo_cron_entry_generic ;      # all pngetinfo cron entries same
	cron_get=$cron_get_generic ;			# should work for most...
	crontab_file=$crontab_file_generic ;		# used for all now
	cron_install=$cron_install_generic ;		# should work if cron_get works...
	get_machine_name=$get_machine_name_generic ;	# used for all now
	get_serial_num=$get_serial_num_generic ;	# useless
	;;
 esac

 if [ "X$opt_sardir" = "X" ] ; then
	sardir=$defsardir;
 else
	sardir=$opt_sardir;
 fi
 
 if [ "X$opt_tarfile" = "X" ] ; then
	tarfile=$def_tarfile;
 else
	tarfile=$opt_tarfile;
 fi
 
 if [ "$install_sar" = "T" ] ; then
    if [ "$ostype" = "HP-UX" ] ; then
      files_to_untar="$files_for_all $files_for_sar $files_for_hpux"
    elif [ "$ostype" = "AIX" ] ; then
      files_to_untar="$files_for_all $files_for_sar $files_for_aix "
    else
      files_to_untar="$files_for_all $files_for_sar"
    fi
 else
   if [ -s /bin/nmon ] ; then
      grep topas /bin/nmon > /dev/null
      jtopas=$?
      if [ $jtopas -eq 0 ]; then
         if [ "$ostype" = "AIX" ] ; then
            files_to_untar="$files_for_all $files_for_nmon $pndmi $nmonmergever $reducepatt $files_for_aix "
         else
            files_to_untar="$files_for_all $files_for_nmon $pndmi $nmonmergever $reducepatt"
         fi
         nmonver='/bin/nmon'
      else
         if [ "$ostype" = "AIX" ] ; then
            files_to_untar="$files_for_all $files_for_nmon $pndmi $nmonver $nmonmergever $reducepatt $files_for_aix "
         else
            files_to_untar="$files_for_all $files_for_nmon $pndmi $nmonver $nmonmergever $reducepatt "
         fi
      fi
   else
      if [ "$ostype" = "AIX" ] ; then
         files_to_untar="$files_for_all $files_for_nmon $pndmi $nmonver $nmonmergever $reducepatt $files_for_aix "
      else
         files_to_untar="$files_for_all $files_for_nmon $pndmi $nmonver $nmonmergever $reducepatt"
      fi
   fi
 fi

 ## Where will nmon output data be stored?
 if [ "X$opt_nmondatadir" = "X" ] ; then
	defmpgnmondatadir=$instdir
 else
	defmpgnmondatadir=$opt_nmondatadir
 fi

 ## Where will we mpg datafiles be stored?
 if [ "X$opt_datadir" = "X" ] ; then
	defmpgdatadir=$instdir
	defmpgdata=$instdir/$defmpgfile
	defmpgcur=$instdir/$defmpgcur
 else
	defmpgdatadir=$opt_datadir
	defmpgdata=$opt_datadir/$defmpgfile
	defmpgcur=$opt_datadir/$defmpgcur
 fi
 sysname="$get_machine_name"
	if [ ! -z "$debug" ] ; then echo "sysname=$sysname" ; fi
 defmpgdata="${defmpgdata}.$sysname"
 defmpgcur="${defmpgcur}.$sysname"
 mpgdatadir=$defmpgdatadir ;
 mpgnmondatadir=$defmpgnmondatadir ;
 mpgdata=$defmpgdata ;
 mpgcur=$defmpgcur ;
 if [ ! -z "$verbose" ] ; then
	echo "nmondatadir = $mpgnmondatadir"
	echo "mpgdatadir = $mpgdatadir"
	echo "datafile = $mpgdata"
	echo "datacur = $mpgcur"
 fi

 if [ "$debug" = "T" ] ; then
 ## show ostype and derived values
	echo "ostype = $ostype" ;
   if [ "$install_sar" = "T" ] ; then
	echo "sardir = $sardir" ;
	echo "sarq = $sarq" ;
	echo "sarrunning = $sarrunning" ;
	echo "sdcmrunning = $sdcmrunning" ;
	echo "sar_cron_entry = $sar_cron_entry"
	echo "sdcm_cron_entry = $sdcm_cron_entry" ;
   else
	echo "nmonver = $nmonver" ;
	echo "nmonmergever = $nmonmergever" ;
	echo "reducepatt = $reducepatt" ;
	echo "pndcmrunning = $pndcmrunning" ;
	echo "nmonrunning = $nmonrunning" ;
	echo "nmon_cron_entry = $nmon_cron_entry" ;
	echo "pndcm_cron_entry = $pndcm_cron_entry" ;
   fi
   echo "pngetinforunning = $pngetinforunning" ;
   echo "pngetinfo_cron_entry = $pngetinfo_cron_entry" ;
   echo "rackrunning = $rackrunning" ;
   echo "rack_cron_entry = $rack_cron_entry" ;
   echo "cron_get = $cron_get" ;
   echo "crontab_file = $crontab_file" ;
   echo "cron_install = $cron_install" ;
   echo "instdir = $instdir" ;
   echo "tarfile = $tarfile" ;
   echo "configfile = $pnconfig" ;
   echo "files_to_untar=$files_to_untar" ;
 fi
}

# Not used for SunOS anymore.
fixshells () {
   ## change the #!... line in .sh files for SunOS (or others that need it)
   cd $instdir
   hasbash=`which bash`
   hasksh=`which ksh`
   if [ ! -z "$opt_shelltouse" ] ; then
      shelltouse=$opt_shelltouse ;
      echo "  using shell: $shelltouse  (from commandline) "
   else
      if [ -z "$hasbash" ] ; then
         # no bash, try ksh
         if [ -z "$hasksh" ] ; then
            #cannot find any usable shell - punt unless forced
            echo "cannot find an appropriate shell"
            if [ "$force_install" = "T" ] ; then
	       useksh="TRUE"
	       shelltouse="/bin/ksh"
	    echo " ----- Forced install, defaulted to /bin/ksh for scripts "
	    echo " -----  if this fails, reinstall with the  -H shellpath  option"
         else
	    exit 1
         fi
      else
         useksh="TRUE"
         shelltouse=$hasksh
      fi
      else
         usebash="TRUE"
         shelltouse=$hasbash
      fi
   fi
 
   for i in *.sh
   do
      cp $i fixshell.tmp
      cat fixshell.tmp | sed -e "1d" > fixshell.noshell
      echo "#!$shelltouse" > $i
      cat fixshell.noshell >> $i
      rm -f fixshell.noshell fixshell.tmp
   done
   cd $startdir 
}

write_config_file () {
   installdir=$instdir
   sc=${1:-"unknown"}	# should be called with "success" or a failure message
   echo "installation disposition: $sc"
   if [ "$debug" = "T" ] ; then echo "current working dir: $PWD" ; fi
   if [ "$debug" = "T" ] ; then echo "writing config file: $pnconfig" ; fi
   instdate=`date`
   serial_num=`eval $get_serial_num`
   revision_num="$get_revision_num"
   ##### could just skip these line on reinstall
   echo "$copyright" > $pnconfig
   echo "# HelpSystems, LLC. Performance Navigator data consolidator configuration" >> $pnconfig
   echo "# $install_sh_ver" >> $pnconfig
   ##### end reinstall skip
   echo "# Performance Navigator installer version $installer_version" >> $pnconfig
   echo "# install date: $instdate" >> $pnconfig
   echo "# installation for: $sysname" >> $pnconfig
   if [ "x${ostype}x" != "xx" ] ; then
      echo "# ostype:           $ostype" >> $pnconfig
   fi
   if [ "x${oslevel}x" != "xx" ] ; then
      echo "# oslevel:          $oslevel" >> $pnconfig
   fi
   if [ "x${os}x" != "xx" ] ; then
      echo "# os:               $os" >> $pnconfig
   fi
   if [ "x${plat}x" != "xx" ] ; then
      echo "# plat:             $plat" >> $pnconfig
   fi
   if [ "x${nmonver}x" != "xx" ] ; then
      echo "# nmonver:          $nmonver" >> $pnconfig
   fi
   if [ "$serial_num" != "serial number not found" ] ; then
      echo "#	serial number: $serial_num" >> $pnconfig
   fi
   echo "#     revision number: $revision_num" >> $pnconfig
   echo "# install disposition: $sc" >> $pnconfig
   if [ "$install_sar" = "T" ] ; then
      echo '#' >> $pnconfig
      echo '# admin_data_collect variable is used to turn off/on admin data collection' >> $pnconfig
      echo '# when rackdata.sh runs. ' >> $pnconfig
      echo '# admin_data_collect="F" # turn off the collection.' >> $pnconfig
      echo '# admin_data_collect="T" # turn on the collection.' >> $pnconfig
      echo 'admin_data_collect="F"' >> $pnconfig
      echo '# ------------------------------------------------------------------ #' >> $pnconfig
      echo '# On systems with an uncommonly large number of files/directories    #' >> $pnconfig
      echo '# or slower disk reads/performance this can take a while with the    #' >> $pnconfig
      echo '# Directory File Counts and Directory File Space enabled. It should  #' >> $pnconfig
      echo '# be tested manually before turning on the (Disk File Counts) and    #' >> $pnconfig
      echo '# (Directory File Space) in each directory.                          #' >> $pnconfig
      echo '# By default, these two are not incorporated, but may be turned on   #' >> $pnconfig
      echo '# manually with "pnadcp.sh -a" or modify the variable in             #' >> $pnconfig
      echo '# pnadcp.config or pn.config (include_dir_scans="T").                #' >> $pnconfig
      echo '# If the variable [include_dir_scans] is included in pn.config, its  #' >> $pnconfig
      echo '# value will supercede any value set in pnadcp.config                #' >> $pnconfig
      echo '# ------------------------------------------------------------------ #' >> $pnconfig
      echo 'include_dir_scans="F"' >> $pnconfig
echo '# ' >> $pnconfig
      echo '# Variable truncate_days is used by pndchk_sar.sh to determine how many days' >> $pnconfig
      echo '# should be retained. Data prior to that period is appended into:' >> $pnconfig
      echo '# mpgdata.hostname_archive.gz - An empty truncate_days defaults to 366.' >> $pnconfig
      echo '# If a value is specified less than 30 days, pndchk.sh will not truncate.' >> $pnconfig
      echo 'truncate_days=""' >> $pnconfig
      echo '#' >> $pnconfig
      if [ "$sardir" != "$defsardir" ] ; then
         echo "sardir=$sardir" >> $pnconfig
      fi
   else
      nmonverstring="# using $nmonver"
      nmon_pkg_ver=`grep $nmonver manifest | awk -F= '{print $1}'`
      if [ ! -z "$nmon_pkg_ver" ] ; then
         nmonverstring="$nmonverstring from $nmon_pkg_ver package"
      fi
      echo $nmonverstring >> $pnconfig
      echo "installdir=$installdir" >> $pnconfig
      echo '# ' >> $pnconfig
      echo '# ' >> $pnconfig
      echo '# # -- nmon is used to gather data for mpgdata2.hostname -- # #' >> $pnconfig
      echo '# When nmon starts, (nmonopts) adds additional options' >> $pnconfig
      echo '# to the starting of nmon' >> $pnconfig
      echo '#         (e.g. -t gathers top on each snap if greater than 10%)' >> $pnconfig
      echo '#         (     -t -I 0.02 top on each snap if greater than 2%)' >> $pnconfig
      echo '#         (     -J Includes df -m output in the nmon BBBP records, but turns of JFS info)' >> $pnconfig
      echo '#         (     -d includes disk service times on each snap)' >> $pnconfig
      echo '#         (     -V includes Volume Group disk data on each snap)' >> $pnconfig
      echo '#         (     -^ used for fiber channel adapter information)' >> $pnconfig
      echo '#         (     -O used for Shared Ethernet Adapter (SEA) on vios)' >> $pnconfig
      echo '#         (     -a used for GPU information on gpu versions of nmon only)' >> $pnconfig
      echo '#         (     -y dfreq=on for TL 4 AIX only adds CPUMHZ to nmon data)' >> $pnconfig
      echo '#         (     "nmon -help" for other options)' >> $pnconfig

      # Put -V in on AIX or VIOS 
      if [ "$ostype" = "AIX" ] ; then
         nmonoptsvg="-V " 
      fi

      # Put -^ in if /proc/sys/adapter/fc directory exists
      if [ -d /proc/sys/adapter/fc  ]; then
         nmonoptsfc="-^ " 
      fi

      # Put -O in if on Vios for Shared Ethernet Adapters (ioscli command exists)
      if [ -s /usr/ios/cli/ioscli ]; then
         nmonoptvios="-O " 
      fi

      # Put -d in if uname -s AIX to display disk service times for AIX and VIOS
      if [ "$ostype" = "AIX" ] ; then
         nmonoptsdst="-d " 
      fi

      # Put -a if gpu nvidia exists
      if [ -s /usr/bin/nvidia-smi ] || [ -s /bin/nvidia-smi ] ; then 
         nmonoptsgpu="-a " 
      fi  
      
      if [ "x${oslevel}x" != "xx" ] ; then
         # Put -y dfreq=on in if on Technology Level 4 is true 
         # Affects powerpc AIX only because oslevel is not blank.
         # 720004011939 is the number where Level 4 starts.
         joslevel_s=`oslevel -s | sed s,\-,,g`
         if [ ${joslevel_s} -ge 720004011939 ] ; then 
            nmonoptscpumhz="-y dfreq=on " 
         fi  
      fi
      # Put "-t -d "  for Linux by default to pn.config with fc, gpu or dfreq if needed
      # Put "-V " by default to pn.config to allow gathering of Volume Group information. 
      nmonoptsbegin="-t " # Unconditionally, top is now in with nmon running
      echo "nmonopts=\"${nmonoptsbegin}${nmonoptsvg}${nmonoptsdst}${nmonoptsfc}${nmonoptvios}${nmonoptsgpu}${nmonoptscpumhz}\"" >> $pnconfig

      echo '# ---------------------------------------------------- #' >> $pnconfig
      echo '# ' >> $pnconfig
      echo '# ' >> $pnconfig
      echo '# gen_dat_prot_reg=T is used to stay compliant with the ' >> $pnconfig
      echo '# European Union (EU) GDPR (General Data Protection Regulation)' >> $pnconfig
      echo '# The systems IP addresses are removed from the data when transmitted.' >> $pnconfig
      echo '# ' >> $pnconfig
      echo '# IP addresses are used to identify Data Centers or clusters' >> $pnconfig
      echo '# To opt-in and include systems IP addresses, change the parm below to' >> $pnconfig
      echo '# gen_dat_prot_reg="F" ' >> $pnconfig
      echo '# ' >> $pnconfig
      echo 'gen_dat_prot_reg="T" ' >> $pnconfig
      echo '# ---------------------------------------------------- #' >> $pnconfig
      echo '# ' >> $pnconfig
      echo '# ' >> $pnconfig
      echo '# # -- For mpgdata3.hostname (pnedcp)-- # # ' >> $pnconfig   
      echo '# (ext_data_collect) used to turn off/on nmon external data collection. ' >> $pnconfig
      echo '# ext_data_collect="F" off the next day, or when nmon restarts. ' >> $pnconfig
      echo '# ext_data_collect="T" on the next day, or when nmon restarts. ' >> $pnconfig
      # Defaults to F for ext_data_collect 
      if [ "x${pnedcp}" = "xT" ]; then
         echo 'ext_data_collect="T"' >> $pnconfig
      else
         if [ "x${ext_data_collect}x" != "xx" ]; then
            echo "ext_data_collect=\"${ext_data_collect}\"" >> $pnconfig
         else
            echo 'ext_data_collect="F"' >> $pnconfig
         fi
      fi
      echo '# For configuration of the  ' >> $pnconfig
      echo '# Performance Navigator External Data Consolidator Process (pnedcp) ' >> $pnconfig
      echo '# (length_args) the length of process args stored in mpgdata3.hostname ' >> $pnconfig
      echo '# (percent_mem) process info of memory stored in mpgdata3.hostname ' >> $pnconfig
      echo '# (percent_cpu) process info of cpu stored in mpgdata3.hostname ' >> $pnconfig
      echo '# (vsz_threshold) process info of vsz stored in mpgdata3.hostname ' >> $pnconfig
      echo '# (page_in) process info of pages in stored in mpgdata3.hostname ' >> $pnconfig
      echo '# (thread_cnt) process info of thread count stored in mpgdata3.hostname ' >> $pnconfig
      echo 'length_args=400 ' >> $pnconfig
      echo 'percent_mem=5 ' >> $pnconfig
      echo 'percent_cpu=5 ' >> $pnconfig
      echo 'vsz_threshold=60000 ' >> $pnconfig
      echo 'page_in=9 ' >> $pnconfig
      echo 'thread_cnt=100 ' >> $pnconfig
      echo '# ---------------------------------------------------- # ' >> $pnconfig
      echo '# ' >> $pnconfig
      echo '# ' >> $pnconfig
      echo '# # -- For mpgdata5.hostname ALL process information Kernel and Normal  -- # #' >> $pnconfig
      echo '# Uses daily files mpgdataps_YYYYMMDD.hostname' >> $pnconfig
      echo '# (ext_ps_collect) used to turn off/on external process collection.' >> $pnconfig
      echo '# ext_ps_collect="F" (default) off the next day, or when nmon restarts.' >> $pnconfig
      echo '# ext_ps_collect="T" on the next day, or when nmon restarts.' >> $pnconfig
      echo 'ext_ps_collect="T"' >> $pnconfig
      echo '# An empty ext_ps_days defaults to 7 days retention' >> $pnconfig
      echo 'ext_ps_days="7"' >> $pnconfig
      echo '# ---------------------------------------------------- # ' >> $pnconfig
      echo '#' >> $pnconfig
      echo '#' >> $pnconfig
      echo '# # -- For mpgdata4.hostname (pnadcp) -- # #' >> $pnconfig
      echo '# (admin_data_collect) variable is used to turn off/on admin data collection' >> $pnconfig
      echo '# when rackdata.sh runs.'   >> $pnconfig
      echo '# admin_data_collect="F" # turn off the collection.' >> $pnconfig
      echo '# admin_data_collect="T" # turn on the collection.' >> $pnconfig
      # Defaults to T for admin_data_collect 
      if [ "x${pnadcp}" = "xF" ]; then
         echo 'admin_data_collect="F"' >> $pnconfig
      else
         echo 'admin_data_collect="T"' >> $pnconfig
      fi
      if [ "x${include_dir_scans}x" != "xx" ]; then
         echo "include_dir_scans=\"${include_dir_scans}\"" >> $pnconfig
      else 
         echo 'include_dir_scans="F"' >> $pnconfig
      fi
      echo '# (include_dir_scans) detail' >> $pnconfig 
      echo '# ------------------------------------------------------------------- #' >> $pnconfig
      echo '# On systems with an uncommonly large number of files/directories     #' >> $pnconfig
      echo '# or slower disk reads/performance this can take a while with the     #' >> $pnconfig
      echo '# Directory File Counts and Directory File Space enabled. It should   #' >> $pnconfig
      echo '# be tested manually before turning on the (Disk File Counts) and     #' >> $pnconfig
      echo '# (Directory File Space) in each directory.  By default, these two    #' >> $pnconfig 
      echo '# are not incorporated in mpgdata5.hostname, but may be turned on     #' >> $pnconfig
      echo '# manually once with "pnadcp.sh -a" or set (include_dir_scans) to "T" #' >> $pnconfig
      echo '# e.g. (include_dir_scans="T").                                       #' >> $pnconfig
      echo '# This was formerly specified in pnadcp.config                        #' >> $pnconfig
      echo '# ------------------------------------------------------------------- #' >> $pnconfig
      echo '# Admin Data Collection Program thresholds for pnadcp.sh              #' >> $pnconfig
      echo '# ------------------------------------------------------------------- #' >> $pnconfig
      echo '# (TopDFCnt)   # Number of Largest Directory File Counts per file system' >> $pnconfig
      echo '# (TopDSpc)    # Number of Largest Directory Space used per file system' >> $pnconfig
      echo '# (TopBigFile) # Number of Largest Files per file system' >> $pnconfig
      echo '# (MinFSz)     # Minimum File System Size (in bytes)' >> $pnconfig
      echo '# --      MinFCnt and MinDSpc used if (include_dir_scans="T")      -- #' >> $pnconfig
      echo '# (MinFCnt)    # Minimum Directory File Count (dir scan)' >> $pnconfig
      echo '# (MinDSpc)    # Minimum Directory Space (in Kbytes) (dir scan)' >> $pnconfig
      echo 'TopDFCnt=20' >> $pnconfig
      echo 'TopDSpc=20' >> $pnconfig
      echo 'TopBigFile=20' >> $pnconfig
      echo 'MinFSz=50000000' >> $pnconfig
      echo 'MinFCnt=100' >> $pnconfig
      echo 'MinDSpc=10000' >> $pnconfig
      echo '# ------------------------------------------------------------------- #' >> $pnconfig
      echo '#' >> $pnconfig
      echo '#' >> $pnconfig
      echo '# # -- For automatic transfer of Performance Navigator host files to shared server  -- # ' >> $pnconfig
      echo '# (transfer_script_cmd) the command line for transferring nmon data' >> $pnconfig
      echo '# to an alternate location using the following files:' >> $pnconfig
      echo '# mpgdata[2-5].hostname mpgdata[2,5]_current.hostname' >> $pnconfig
      echo '# rackdata.hostname pn.config.hostname ' >> $pnconfig
      echo '# e.g. "/usr/local/mpg/transfer_script.sh -c /usr/local/mpg/transfer_scp.config"' >> $pnconfig
      echo "transfer_script_cmd=\"${transfer_script_cmd}\"" >> $pnconfig
      echo '# ------------------------------------------------------------------ #' >> $pnconfig
      echo '# (transfer_current_cmd) the command line for transferring nmon update' >> $pnconfig
      echo '# data to an alternate location using the following files:' >> $pnconfig
      echo '# mpgdata[2,5]_current.hostname pn.config.hostname' >> $pnconfig
      echo '# e.g. ' >> $pnconfig
      echo '# "/usr/local/mpg/transfer_current.sh -c /usr/local/mpg/transfer_scp.config"' >> $pnconfig
      echo "transfer_current_cmd=\"${transfer_current_cmd}\"" >> $pnconfig
      echo '# ------------------------------------------------------------------ #' >> $pnconfig
      echo '#' >> $pnconfig
      echo '#' >> $pnconfig
      echo '# # ----    To limit Performance Navigator host data retention ----    # #' >> $pnconfig
      echo '# (truncate_days) used by pndchk.sh to determine how many days' >> $pnconfig
      echo '# should be retained. Data prior to that period is appended into:' >> $pnconfig
      echo '# mpgdata2.hostname_archive.gz - An empty truncate_days defaults to 366.' >> $pnconfig
      echo '# If a value is specified less than 30 days, pndchk.sh will not truncate.' >> $pnconfig
      echo 'truncate_days="366"' >> $pnconfig
      echo '# ---------------------------------------------------- #' >> $pnconfig
      echo '# (ext_data_truncate_days) used by pndchk.sh to determine how many' >> $pnconfig
      echo '# days should be retained. Data prior to that period is appended into:' >> $pnconfig
      echo '# mpgdata3.hostname_archive.gz-An empty ext_data_truncate_days defaults to 90.' >> $pnconfig
      echo '# If a value is specified less than 30 days, pndchk.sh will not truncate.' >> $pnconfig
      echo 'ext_data_truncate_days="90"' >> $pnconfig
      echo '# ---------------------------------------------------- #' >> $pnconfig
      echo '# (remove_old_arc_data) used by pndchk.sh to determine how many ' >> $pnconfig
      echo '# days should be retained for mpgdata2 mpgdata3 & rdhist files. ' >> $pnconfig
      echo '# 180 days minimum, blank or default is 366, can be set higher. ' >> $pnconfig
      echo 'remove_old_arc_data="366"' >> $pnconfig
      echo '# ---------------------------------------------------- #' >> $pnconfig
      echo '# (purge_top_days) used by pndchk.sh to determine how many days of' >> $pnconfig 
      echo '# TOP, DISK, IO, FC, NPIV data should be retained. ' >> $pnconfig 
      echo '# These lines of this data beyond this setting will be purged and ' >> $pnconfig 
      echo '# there will be no way to get it back once that decision has been made.' >> $pnconfig  
      echo '# This is also used for df.hostname for reducing days retained which' >> $pnconfig  
      echo '# affects the size of rackdata.hostname.' >> $pnconfig  
      echo '# By default this variable is set to 90.' >> $pnconfig  
      echo '# If a value is specified less than 30 days, pndchk.sh will not purge.' >> $pnconfig  
      echo '# No purging occurs in this case.' >> $pnconfig  
      echo '# If a value is specified greater than the variable truncate_days,' >> $pnconfig 
      echo '# pndchk.sh will not purge.' >> $pnconfig
      echo 'purge_top_days=90' >> $pnconfig
      echo '# ---------------------------------------------------- #' >> $pnconfig
      echo '# (nmondaystokeep) used by pndcm.sh to determine how many nmon daily' >> $pnconfig
      echo '# data files to retain.  Minimum value is 7 days.  This can be set higher.' >> $pnconfig
      echo 'nmondaystokeep="7"' >> $pnconfig
      echo '# ---------------------------------------------------- #' >> $pnconfig
      echo '#' >> $pnconfig
      echo '#' >> $pnconfig
      echo '# (auto_start_nmon) used by start_nmon_now.sh to determine if it' >> $pnconfig
      echo '# should start nmon automatically.  T is default, but F can be set if nmon ' >> $pnconfig
      echo '# is running independently from Performance Navigator.' >> $pnconfig
      if [ "X$auto_start_nmon" != "XF" ] ; then
         echo 'auto_start_nmon="T"' >> $pnconfig
      else
         echo 'auto_start_nmon="F"' >> $pnconfig
      fi
      echo '#' >> $pnconfig
      echo '#' >> $pnconfig
      echo '# (compressdatafile) used to turn off making a compressed copy of the nmon' >> $pnconfig
      echo '# data file. If it is set to "nocopy" there will not be a copy made.' >> $pnconfig
      echo '# There is no need for the compressed copy, pngetinfo.sh gathers same info.' >> $pnconfig
      echo 'compressdatafile="nocopy"' >> $pnconfig
      echo '#' >> $pnconfig
      echo '#' >> $pnconfig

      ## always need installdir for rackdata
      ## if [ "$instdir" != "$defdir" ] ; then
      ##   fi
   fi
   # Create an mpgdata or mpgdata2 data file if it does not exist on install
   # depending on nmon or sar 
   if [ ! -s $mpgdata ] ; then
      touch $mpgdata
   fi
   echo "# # -- Do NOT change variables below manually -- # #" >> $pnconfig
   echo "mpgdatadir=$mpgdatadir" >> $pnconfig
   echo "nmondatadir=$mpgnmondatadir" >> $pnconfig
   echo "datafile=$mpgdata" >> $pnconfig
   echo "datacur=$mpgcur" >> $pnconfig
   echo "sysname=$sysname" >> $pnconfig
   ## add rackfile var for transfer_script
   echo "rackfile=$instdir/rackdata.$sysname" >> $pnconfig
   if [ ! -z "$reduce" ] ; then
      echo "reduce=F" >> $pnconfig
   fi
   if [ ! -z "$compressnmon" ] ; then
      echo "compressnmonfiles=none" >> $pnconfig
   fi
   if [ ! -z "$compressdatafile" ] ; then
      echo "compressdatafile=none" >> $pnconfig
   fi
}

add_to_etc_conf () {
  if [ -f /etc/pn.conf ] ; then
     cp -p /etc/pn.conf /etc/pn.conf.${jdate}
     cp -p /etc/pn.conf /etc/pn.conf.org
  else
     touch /etc/pn.conf
  fi
  grep $instdir /etc/pn.conf
  inconf=$?
  if [ "$inconf" = "0" ] ; then
     echo "found an instance already in /etc/pn.conf ???"
  else
     echo "nminst=$instdir" >> /etc/pn.conf
  fi
}

install_inits () {
 if [ -d /etc/init.d ] ; then
   initbasedir="/etc"
 elif [ -d /etc/rc.d/init.d ] ; then
   initbasedir="/etc/rc.d" 
 fi
 cp pnndc.rc $initbasedir/init.d/pnndc
##### set rcdirs (aix: rc2.d only?, linux how to determine which dirs to set up?)
 rlstring=`who -r 2>/dev/null | grep run-level`
 rlknown=$?
 if [ "$rlknown" != "0" ] ; then
	echo "runlevel undetermined - please create init script links"
	echo "init script is in $initbasedir/init.d/pnndc"
 else
   if [ "$ostype" = "AIX" ] ; then
     currl=`who -r | cut -c23 2>/dev/null`
     krl=$currl		# whatever...
   else
     currl=`who -r | cut -c20 2>/dev/null`
     krl="0"
   fi
#   currlok=${currl/[235]/OK}
#   if [ "$currlok" = "OK" ] ; then
   currlok=${currl%%[235]}
   if [ "$currlok" = "" ] ; then
     echo "creating links to start PerformanceNavigator data collector at runlevel $currl"
     ln -s $initbasedir/init.d/pnndc $initbasedir/rc${currl}.d/S99pnndc
     ln -s $initbasedir/init.d/pnndc $initbasedir/rc${krl}.d/K01pnndc
   else
	echo "currl=$currl, rlstring=$rlstring"
	echo "runlevel undetermined - please create init script links"
	echo "init script is in $initbasedir/init.d/pnndc"
   fi
 fi
}

incron_message () {
 found_message=$1;
 existing_entry=${2:-"none"};
 rc_prog=${3:-"none"};
 example_entry=${4:-"none"};
   echo
   echo "##########"
   echo "$found_message"
   if [ "$existing_entry" != "none" ] ; then
	echo "existing crontab entry:"
	echo "$existing_entry"
   fi
   if [ "$rc_prog" != "none" ] ; then
	echo "----- instruct admin to re-configure $rc_prog in crontab if needed -----"
   fi
   if [ "$example_entry" != "none" ] ; then
	echo "example:"
	echo "$example_entry"
   fi
   echo "##########"
   echo
}

create_install_dir () {
## make $instdir and parents if needed
 if [ ! -d "$instdir" ] ; then
	if [ "$debug" = "T" ] ; then echo "need to create $instdir" ; fi
   id=$instdir
   tomake="$id"
   idp=`dirname $id`
   while [ "$idp" != "$id" ] ; do
     if [ ! -d "$idp" ] ; then
	if [ "$debug" = "T" ] ; then echo "need to create $idp" ; fi
	tomake="$idp $tomake"
	id=$idp
	idp=`dirname $id`
     else
	id=$idp
     fi
   done
   for dir in $tomake
   do
     mkdir -p $dir
     retcode=$?
     if [ "$retcode" != "0" ] ; then
	echo "ERROR ($retcode) unable to create $dir - aborting"
	exit 1
     fi
     chmod 755 $dir
     retcode=$?
     if [ "$retcode" != "0" ] ; then
	echo "ERROR ($retcode) unable to set permissions on $dir - aborting"
	exit 1
     fi
   done
 fi
 chmod 755 $instdir
}

create_output_dir () {
## make $mpgdatadir and parents if needed
 if [ ! -d "$mpgdatadir" ] ; then
	if [ "$debug" = "T" ] ; then echo "need to create $mpgdatadir" ; fi
   id=$mpgdatadir
   tomake="$id"
   idp=`dirname $id`
   while [ "$idp" != "$id" ] ; do
     if [ ! -d "$idp" ] ; then
	if [ "$debug" = "T" ] ; then echo "need to create $idp" ; fi
	tomake="$idp $tomake"
	id=$idp
	idp=`dirname $id`
     else
	id=$idp
     fi
   done
   for dir in $tomake
   do
     mkdir -p $dir
     retcode=$?
     if [ "$retcode" != "0" ] ; then
	echo "ERROR ($retcode) unable to create $dir - aborting"
	exit 1
     fi
     chmod 755 $dir
     retcode=$?
     if [ "$retcode" != "0" ] ; then
	echo "ERROR ($retcode) unable to set permissions on $dir - aborting"
	exit 1
     fi
   done
 fi
 chmod 755 $mpgdatadir
}

create_nmon_data_dir () {
## make $mpgnmondatadir and parents if needed
 if [ ! -d "$mpgnmondatadir" ] ; then
	if [ "$debug" = "T" ] ; then echo "need to create $mpgnmondatadir" ; fi
   id=$mpgnmondatadir
   tomake="$id"
   idp=`dirname $id`
   while [ "$idp" != "$id" ] ; do
     if [ ! -d "$idp" ] ; then
	if [ "$debug" = "T" ] ; then echo "need to create $idp" ; fi
	tomake="$idp $tomake"
	id=$idp
	idp=`dirname $id`
     else
	id=$idp
     fi
   done
   for dir in $tomake
   do
     mkdir -p $dir
     retcode=$?
     if [ "$retcode" != "0" ] ; then
	echo "ERROR ($retcode) unable to create $dir - aborting"
	exit 1
     fi
     chmod 755 $dir
     retcode=$?
     if [ "$retcode" != "0" ] ; then
	echo "ERROR ($retcode) unable to set permissions on $dir - aborting"
	exit 1
     fi
   done
 fi
 chmod 755 $mpgnmondatadir
}

chk_min_space_dirs () {

   jminfssize=1000
   
   # Line below had to be replaced for Solaris
   # df -m $mpgdatadir | tail -1 | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m.hsllc
   # Replaced with lines below because Solaris does not have a df -m
   if [ "x${ostype}x" = "xSunOSx" ]; then
      df -k $mpgdatadir \
          | grep "\/" \
          | awk '{printf "%s %.2f %.2f %s %s %s %s \n", $1, $2/1024, $3/1024, $4, $5, $6, $7}'\
          | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m.hsllc
     # Replaced with lines above because Solaris does not have a df -m
   else
      df -m $mpgdatadir \
          | grep "\/" \
          | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m.hsllc
   fi

   jfilessystem=`cat /tmp/helpsystems_tmp/df-m.hsllc | awk '{print $1}'`
   jcurfilesize=`cat /tmp/helpsystems_tmp/df-m.hsllc | awk '{printf "%d", $2}'`
   jmntpoint=`cat /tmp/helpsystems_tmp/df-m.hsllc | awk '{print $3}'`

   if [ ${jminfssize} -gt ${jcurfilesize} ] ; then
      echo "# ($jcurfilesize) is less than ($jminfssize) Meg free on $mpgdatadir ( mpgdatadir )"
      jspaceneeded=`echo "$jcurfilesize $jminfssize" | awk '{print $2-$1}' `
      echo "Space needed is ($jspaceneeded) Meg"
      echo "# [ `cat /tmp/helpsystems_tmp/df-m.hsllc` ]"
      echo "# Recommend that you increase the size of $jmntpoint by $jspaceneeded M "
      if [ "x${ostype}x" = "xAIXx" ]; then
         echo "# Command for AIX or VIOS has been implemented automatically "
         echo "to increase space with the following command: "
         echo "chfs -a size=+${jspaceneeded}M $jmntpoint"
         chfs -a size=+${jspaceneeded}M $jmntpoint
         df -m $mpgdatadir
      else
         echo " # # # Please contact your system admin for this system # # # "
      fi
   else
      echo "# ($jcurfilesize) is more than ($jminfssize) Meg free on $mpgdatadir ( mpgdatadir )"
   fi

   # Only run if mpgdatadir != instdir #

   if [ "x${mpgdatadir}x" != "x${instdir}x" ]; then

      # Min installdir file system size is 1000 M
      jinstallminfssize=1000

      # Line below had to be replaced for Solaris
      # df -m $instdir | tail -1 | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m.hsllc
      # Replaced with lines below because Solaris does not have a df -m
      if [ "x${ostype}x" = "xSunOSx" ]; then
      df -k $instdir \
          | grep "\/" \
          | awk '{printf "%s %.2f %.2f %s %s %s %s \n", $1, $2/1024, $3/1024, $4, $5, $6, $7}'\
          | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m_install.hsllc
     # Replaced with lines above because Solaris does not have a df -m
     else
        df -m $instdir \
            | grep "\/" \
            | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m_install.hsllc
     fi

      jfilessystem=`cat /tmp/helpsystems_tmp/df-m_install.hsllc | awk '{print $1}'`
      jcurfilesize=`cat /tmp/helpsystems_tmp/df-m_install.hsllc | awk '{printf "%d", $2}'`
      jmntpoint=`cat /tmp/helpsystems_tmp/df-m_install.hsllc | awk '{print $3}'`

      if [ $jinstallminfssize -gt $jcurfilesize ]; then
         echo "# ($jcurfilesize) is less than ($jinstallminfssize) Meg free on $instdir ( instdir )"
         jspaceneeded=`echo "$jcurfilesize $jinstallminfssize" | awk '{print $2-$1}' `
         echo "Space needed is ($jspaceneeded) Meg"
         echo "# [ `cat /tmp/helpsystems_tmp/df-m_install.hsllc` ]"
         echo "# Recommend that you increase the size of $jmntpoint by $jspaceneeded M "
         if [ "x${ostype}x" = "xAIXx" ]; then
            echo "# Command for AIX or VIOS has been implemented automatically "
            echo "to increase space with the following command: "
            echo "chfs -a size=+${jspaceneeded}M $jmntpoint"
            chfs -a size=+${jspaceneeded}M $jmntpoint
            df -m $instdir
         else
            echo " # # # Please contact your system admin for this system # # # "
         fi
      else
         echo "# ($jcurfilesize) is more than ($jinstallminfssize) Meg free on $instdir ( instdir )"
      fi
   fi

   # Only run if mpgdatadir != mpgnmondatadir  #

   if [ "x${mpgdatadir}x" != "x${mpgnmondatadir}x" ]; then

      # Min nmondatafile file system size is 1000 M
      jnmondataminfssize=1000

      # Line below had to be replaced for Solaris
      # df -m $mpgnmondatadir | tail -1 | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m_nmondata.hsllc
      # Replaced with lines below because Solaris does not have a df -m
      if [ "x${ostype}x" = "xSunOSx" ]; then
         df -k $mpgnmondatadir \
            | grep "\/" \
            | awk '{printf "%s %.2f %.2f %s %s %s %s \n", $1, $2/1024, $3/1024, $4, $5, $6, $7}'\
            | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m_nmondata.hsllc
      # Replaced with lines above because Solaris does not have a df -m
      else
         df -m $mpgnmondatadir \
          | grep "\/" \
          | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m_nmondata.hsllc
      fi

      jfilessystem=`cat /tmp/helpsystems_tmp/df-m_nmondata.hsllc | awk '{print $1}'`
      jcurfilesize=`cat /tmp/helpsystems_tmp/df-m_nmondata.hsllc | awk '{printf "%d", $2}'`
      jmntpoint=`cat /tmp/helpsystems_tmp/df-m_nmondata.hsllc | awk '{print $3}'`

      if [ $jnmondataminfssize -gt $jcurfilesize ]; then
         echo "# ($jcurfilesize) is less than ($jnmondataminfssize) Meg free on $mpgnmondatadir ( mpgnmondatadir )"
         jspaceneeded=`echo "$jcurfilesize $jnmondataminfssize" | awk '{print $2-$1}' `
         echo "Space needed is ($jspaceneeded) Meg"
         echo "# [ `cat /tmp/helpsystems_tmp/df-m_nmondata.hsllc` ]"
         echo "# Recommend that you increase the size of $jmntpoint by $jspaceneeded M "
         if [ "x${ostype}x" = "xAIXx" ]; then
            echo "# Command for AIX or VIOS has been implemented automatically "
            echo "to increase space with the following command: "
            echo "chfs -a size=+${jspaceneeded}M $jmntpoint"
            chfs -a size=+${jspaceneeded}M $jmntpoint
            df -m $mpgnmondatadir
         else
            echo " # # # Please contact your system admin for this system # # # "
         fi
      else
         echo "# ($jcurfilesize) is more than ($jnmondataminfssize) Meg free on $mpgnmondatadir ( mpgnmondatadir )"
      fi
   fi

   # # 

   # Min /tmp/helpsystems_tmp file system size is 1000 M
   jtmpminfssize=1000

   # Min /var file system size is 1000 M
   jvarminfssize=1000

   mpgtmpdir='/tmp/helpsystems_tmp'

   # Line below had to be replaced for Solaris
   # df -m $mpgtmpdir | tail -1 | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m.hsllc
   # Replaced with lines below because Solaris does not have a df -m
   if [ "x${ostype}x" = "xSunOSx" ]; then
      df -k $mpgtmpdir \
          | grep "\/" \
          | awk '{printf "%s %.2f %.2f %s %s %s %s \n", $1, $2/1024, $3/1024, $4, $5, $6, $7}'\
          | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m_tmp.hsllc
     # Replaced with lines above because Solaris does not have a df -m
   else
      df -m $mpgtmpdir \
          | grep "\/" \
          | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m_tmp.hsllc
   fi

   mpgvardir='/var'

   # Line below had to be replaced for Solaris
   # df -m $mpgvardir | tail -1 | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m.hsllc
   # Replaced with lines below because Solaris does not have a df -m
   if [ "x${ostype}x" = "xSunOSx" ]; then
      df -k $mpgvardir \
          | grep "\/" \
          | awk '{printf "%s %.2f %.2f %s %s %s %s \n", $1, $2/1024, $3/1024, $4, $5, $6, $7}'\
          | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m_var.hsllc
     # Replaced with lines above because Solaris does not have a df -m
   else
      df -m $mpgvardir \
          | grep "\/" \
          | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m_var.hsllc
   fi

   jtmpfilessystem=`cat /tmp/helpsystems_tmp/df-m_tmp.hsllc | awk '{print $1}'`
   jtmpcurfilesize=`cat /tmp/helpsystems_tmp/df-m_tmp.hsllc | awk '{printf "%d", $2}'`
   jtmpmntpoint=`cat /tmp/helpsystems_tmp/df-m_tmp.hsllc | awk '{print $3}'`

   if [ $jtmpminfssize -gt $jtmpcurfilesize ]; then
      echo "# ($jtmpcurfilesize) is less than ($jtmpminfssize) Meg free on $mpgtmpdir ( mpgtmpdir )"
      jtmpspaceneeded=`echo "$jtmpcurfilesize $jtmpminfssize" | awk '{print $2-$1}' `
      echo "Space needed is ($jtmpspaceneeded) Meg"
      echo "# [ `cat /tmp/helpsystems_tmp/df-m_tmp.hsllc` ]"
      echo "# Recommend that you increase the size of $jtmpmntpoint by $jtmpspaceneeded M "
      if [ "x${ostype}x" = "xAIXx" ]; then
         echo "# Command for AIX or VIOS has been implemented automatically "
         echo "to increase space with the following command: "
         echo "chfs -a size=+${jtmpspaceneeded}M $jtmpmntpoint"
         chfs -a size=+${jtmpspaceneeded}M $jtmpmntpoint
         df -m $mpgtmpdir
      else
         echo " # # # Please contact your system admin for this system # # # "
      fi
   else
      echo "# ($jtmpcurfilesize) is more than ($jtmpminfssize) Meg free on $mpgtmpdir ( mpgtmpdir )"
   fi

   jvarfilessystem=`cat /tmp/helpsystems_tmp/df-m_var.hsllc | awk '{print $1}'`
   jvarcurfilesize=`cat /tmp/helpsystems_tmp/df-m_var.hsllc | awk '{printf "%d", $2}'`
   jvarmntpoint=`cat /tmp/helpsystems_tmp/df-m_var.hsllc | awk '{print $3}'`

   if [ $jvarminfssize -gt $jvarcurfilesize ]; then
      echo "# ($jvarcurfilesize) is less than ($jvarminfssize) Meg free on $mpgvardir ( mpgvardir )"
      jvarspaceneeded=`echo "$jvarcurfilesize $jvarminfssize" | awk '{print $2-$1}' `
      echo "Space needed is ($jvarspaceneeded) Meg"
      echo "# [ `cat /tmp/helpsystems_tmp/df-m_var.hsllc` ]"
      echo "# Recommend that you increase the size of $jvarmntpoint by $jvarspaceneeded M "
      if [ "x${ostype}x" = "xAIXx" ]; then
         echo "# Command for AIX or VIOS has been implemented automatically "
         echo "to increase space with the following command: "
         echo "chfs -a size=+${jvarspaceneeded}M $jvarmntpoint"
         chfs -a size=+${jvarspaceneeded}M $jvarmntpoint
         df -m $mpgvardir
      else
         echo " # # # Please contact your system admin for this system # # # "
      fi
   else
      echo "# ($jvarcurfilesize) is more than ($jvarminfssize) Meg free on $mpgvardir ( mpgvardir )"
   fi

}


untar_perfnav_pkg () {
## untar the performance navigator package
	if [ ! -z "$verbose" ] ; then echo "copying files to $instdir" ; fi
 cp $tarfile $instdir
 retcode=$?
	if [ "$debug" = "T" ] ; then echo "retcode from cp : $retcode" ; fi
 if [ "$retcode" != "0" ] ; then
   echo "ERROR ($retcode) trying to copy files to $instdir - aborting" ;
   exit 1;
 fi
 cd $instdir
 # remove old .mpginc files from instdir and /tmp/helpsystems_tmp , all new will be .hsllc 
 rm -f *.mpginc /tmp/helpsystems_tmp/*.mpginc
 ps -ef | grep "${instdir}/nmon" | grep -v grep | tee /tmp/helpsystems_tmp/nmon_running.tmp
 if [ -s /tmp/helpsystems_tmp/nmon_running.tmp ] ; then
    echo "*** nmon process still running ***"
    echo "killing nmon, it will restart within 15 minutes."
    ./killnmon
    # echo "You may need to run the following command:"
    # cat /tmp/helpsystems_tmp/nmon_running.tmp | awk '{print "# kill ",$2 }'
 fi
 if [ ! -z "$verbose" ] ; then
   tar xvf $tarfile $files_to_untar | tee /tmp/helpsystems_tmp/files_to_untar.helpsys 
 else
   tar xvf $tarfile $files_to_untar | tee /tmp/helpsystems_tmp/files_to_untar.helpsys > /dev/null 2>&1
 fi
 retcode=$?
 # Ensure .sh files are set to execute for root.
 chmod 740 *.sh
 # Ensure nmon_*_*_* files are set to execute for root.
 if [ -s /usr/bin/topas_nmon ]; then
   echo "### Not installing AIX nmon files, will be using /usr/bin/topas_nmon ### "
 fi
 if [ -s nmon_*_*_* ] ; then
   # Added in the 2>&1 so sun and hp will not display no nmon exists
   chmod 740 nmon_*_*_*  2>&1 > /dev/null
 fi
 if [ "$debug" = "T" ] ; then echo "retcode from tar : $retcode" ; fi
 if [ "$retcode" != "0" ] ; then
   echo "ERROR ($retcode) trying to untar files in $instdir - Please report to HelpSystems!" ;
 fi
}

check_sar_installed () {
## is sar installed?
  if [ ! -z "$verbose" ] ; then
    eval $sarq
  else
    eval $sarq > /dev/null
  fi
  if [ "$?" != "0" ] ; then
    if [ "X$opt_sardir" != "X" ] ; then
	echo
	echo "##########"
	echo "sar package not found, however sardir set to non-default location $sardir"
	echo "continuing as though sar were installed!"
	echo "##########"
	sc="unknown, sar in non-default location?"
    else
	echo "apparently sar is not installed"
	echo
	echo "##########"
	echo "----- instruct admin to install sar package and configure it to run -----"
	echo "##########"
	echo
	write_config_file "failed - sar not installed"
	exit 1
    fi
  else
    if [ ! -z "$verbose" ] ; then
	echo "found sar installed"
    fi
  fi
}

check_sar_in_crontab () {
## is sar configured and running?
  sar_in_cron="`$sarrunning`"
  # Detection of existing sa1 entries 
  if [ "x${sar_in_cron}x" = "xx" ]; then
     found_sar=1
  else
     found_sar=0
  fi    
  if [ "$debug" = "T" ] ; then
        echo "found_sar=$found_sar";
        echo "sar_in_cron=$sar_in_cron";
  fi
  if [ "$found_sar" != "0" ] ; then
    if [ "X$opt_sardir" != "X" ] ; then
	echo
	echo "##########"
	echo "sar configuration not found, however sardir set to non-default location $sardir"
	echo "continuing as though sar were configured!"
	echo "example sar crontab entry: "
	echo "$sar_cron_entry"
	if [ "$ostype" = "AIX" ] ; then
	  echo "NOTE: please verify that sar is configured in the adm crontab"
	else
	  echo "NOTE: please verify that sar is configured in cron"
	fi
	echo "##########"
	sc="$sc - unknown sar, not configured or in non-default location?"
    else
	# echo
	if [ ! -z "$verbose" ] ; then
		echo "Apparently sar is not configured - will add sar entry to cron" ;
	fi
	echo
	if [ "$ostype" = "AIX" ] ; then
	  add_sar_to_AIX_cron="T";  add_header_to_cron="T";
	else
	  add_sar_to_cron="T";  add_header_to_cron="T";
	fi
    fi
  else
    #if [ ! -z "$verbose" ] ; then
	m1="Found an existing crontab entry for sar"
	incron_message "$m1" "$sar_in_cron" "sar" "$sar_cron_entry"
    #fi
  fi
}

#####  extra check - not finished - probably not needed
## where are sar files?
# ? are the files in the default sar dir? or the dir specified on commandline (opt_sardir)
##	??? use the default search pattern ???
#	ls -al $defsardir/*

check_devnull () {
   ## Confirm permission on /dev/null are 666 or 777
   ## That is read write for owner group everyone
   find /dev/null -perm  666 > /tmp/helpsystems_tmp/devnull_perm_check.tmp
   find /dev/null -perm 1666 >> /tmp/helpsystems_tmp/devnull_perm_check.tmp
   find /dev/null -perm  777 >> /tmp/helpsystems_tmp/devnull_perm_check.tmp
   find /dev/null -perm 1777 >> /tmp/helpsystems_tmp/devnull_perm_check.tmp
   if [ ! -s /tmp/helpsystems_tmp/devnull_perm_check.tmp ] ; then
      ls -al /dev/null
      echo "Please correct the permissions of /dev/null"
      echo "Permissions should be 666, 1666, 777 or 1777;"
      echo "the syntax to correct this is on the next line:"
      echo ""
      echo "#    chmod  666 /dev/null"
      echo "#    or"
      echo "#    chmod 1666 /dev/null"
      echo "#    or"
      echo "#    chmod  777 /dev/null"
      echo "#    or"
      echo "#    chmod 1777 /dev/null"
      echo ""
      echo "Exiting, please correct the permissions of /dev/null."
      echo "Then run the install.sh script again."
      exit 1
   fi
}

check_sdcm_in_crontab () {
## add sdcm to crontab if needed
  sdcm_in_cron=`eval $sdcmrunning 2>&1`
  found_sdcm=$?
  if [ "$debug" = "T" ] ; then
	echo "found_sdcm=$found_sdcm";
	echo "sdcm_in_cron=$sdcm_in_cron";
  fi
  if [ "$found_sdcm" != "0" ] ; then
	# echo
	if [ ! -z "$verbose" ] ; then
		echo 'Cannot find data collector (sdcm.sh) configured in crontab' ;
	fi
		echo "Will add Performance Navigator Data Consolidator for sar (sdcm) to cron" ;
	echo
	add_sdcm_to_cron="T"; add_header_to_cron="T"; add_pndchk_sar_to_cron="T";
  else
	m1='Found an existing crontab entry for Performance Navigator Data Consolitator (sdcm.sh)'
	incron_message "$m1" "$sdcm_in_cron" "sdcm.sh" "$sdcm_cron_entry"
  fi
}

check_pngetinfo_in_crontab () {
## add pngetinfo to crontab if needed
  pngetinfo_in_cron=`eval $pngetinforunning 2>&1`
  found_pngetinfo=$?

  if [ "$debug" = "T" ] ; then
        echo "found_pngetinfo=$found_pngetinfo";
        echo "pngetinfo_in_cron=$pngetinfo_in_cron";
  fi
  if [ "$found_pngetinfo" != "0" ] ; then
	# echo
	if [ ! -z "$verbose" ] ; then
           echo 'cannot find data collector (pngetinfo.sh) configured in crontab' ;
	fi
		echo "Will add pngetinfo to cron" ;
	echo
        add_pngetinfo_to_cron="T";  add_header_to_cron="T";
  else
        m1='Found an existing crontab entry for Performance Navigator data consolidator (pngetinfo.sh)'
        incron_message "$m1" "$pngetinfo_in_cron" "pngetinfo.sh" "$pngetinfo_cron_entry"
  fi
}

check_nmon_in_crontab () {
## add nmon to crontab if needed
  nmon_in_cron=`eval $nmonrunning 2>&1`
  found_nmon=$?
  if [ "$debug" = "T" ] ; then
	echo "found_nmon=$found_nmon";
	echo "nmon_in_cron=$nmon_in_cron";
  fi
  if [ "$found_nmon" != "0" ] ; then
	# echo
	if [ ! -z "$verbose" ] ; then
		echo "Apparently nmon is not configured - will add nmon entry to cron" ;
	fi
	echo
	add_nmon_to_cron="T" ; add_header_to_cron="T";
  else
    if [ ! -z "$verbose" ] ; then
	m1="Found an existing crontab entry for nmon"
	incron_message "$m1" "$nmon_in_cron" "nmon" "$nmon_cron_entry"
    fi
  fi
}

check_pndcm_in_crontab () {
## add pndcm to crontab if needed
  pndcm_in_cron=`eval $pndcmrunning 2>&1`
  found_pndcm=$?
  if [ "$debug" = "T" ] ; then
	echo "found_pndcm=$found_pndcm";
	echo "pndcm_in_cron=$pndcm_in_cron";
  fi
  if [ "$found_pndcm" != "0" ] ; then
	# echo
	if [ ! -z "$verbose" ] ; then
		echo 'cannot find data collector (pndcm.sh) configured in crontab' ;
	fi
	echo "Will add Performance Navigator Data Consolidator (pndcm.sh) to cron" ;
	echo
	add_pndcm_to_cron="T" ; add_header_to_cron="T";
	add_pndcm_clean_to_cron="T" ;
	add_pndchk_to_cron="T" ;
 	pndchk_cron_entry="$pndchk_cron_entry"
  else
	m1='Found an existing crontab entry for Performance Navigator data collector (pndcm.sh)'
	incron_message "$m1" "$pndcm_in_cron" "pndcm.sh" "$pndcm_cron_entry"
  fi
}

create_nmon_symlinks () {
  cd $instdir	# should already have been done...
  if [ "$debug" = "T" ] ; then echo "creating symbolic link $nmonver -> nmon" ; fi
  ln -s $nmonver nmon
  if [ "$debug" = "T" ] ; then echo "creating symbolic link $nmonmergever -> nmonmerge" ; fi
  if  [ "oo${ostype}oo" = "ooLinuxoo" ] && [ "oo${pndmi}oo" != "oooo" ] ; then
     ln -s $pndmi pntestdmi 
     if [ "$debug" = "T" ] ; then echo "creating symbolic link $pndmi -> pntestdmi" ; fi
  fi
  ln -s $nmonmergever nmonmerge
  if [ "$debug" = "T" ] ; then echo "creating symbolic link $reducepatt -> reduce.patt" ; fi
  ln -s $reducepatt reduce.patt
}

check_rackdata_in_crontab () {
## check if rackdata is in crontab
 rack_in_cron=`eval $rackrunning 2>&1`
 found_rack=$?
 if [ "$debug" = "T" ] ; then
	echo "found_rack=$found_rack";
	echo "rack_in_cron=$rack_in_cron";
 fi
 if [ "$found_rack" != "0" ] ; then
	if [ ! -z "$verbose" ] ; then echo "Will add rack config entry to crontab" ; fi
	echo
	add_rack_to_cron="T" ;  add_header_to_cron="T";
 else
	m1='Found an existing crontab entry for rack config'
	incron_message "$m1" "$rack_in_cron" "rackdata.sh" "$rack_cron_entry"
 fi
}

force_testplatform_settings () {
##### this section only for testing on unsupported systems #####
 # force attempt to add cron entries - so they will be printed...
 if [ "$testplatform" = "T" ] ; then
	if [ "$install_sar" = "T" ] ; then
		add_sar_to_cron="T";  add_header_to_cron="T";
	else
		add_nmon_to_cron="T";  add_header_to_cron="T"; 
		add_pndcm_to_cron="T";  add_header_to_cron="T"; 
		add_pndcm_clean_to_cron="T" ;
	fi
	add_rack_to_cron="T";  add_header_to_cron="T"
	add_pngetinfo_to_cron="T";
 fi	##### end testplatform section
}

create_crontab_entries () {
   ## create crontab entries as needed
   if [ "$add_header_to_cron" = "T" ] ; then
      echo "creating Performance Navigator crontab entries"
      ##### debian specific
      CRONTAB_NOHEADER="N"
      export CRONTAB_NOHEADER
      ##### end debian specific
      eval $cron_get
      cp $crontab_file ${crontab_file}.save
      # Placed add sar to cron above the header intentionally.
      # Otherwise, it will change position on subsequent installs.
      if [ "$add_sar_to_cron" = "T" ] ; then echo "$sar_cron_entry" >> $crontab_file ; fi
      echo $cron_header >> $crontab_file ;
      echo $cron_header_install_opts >> $crontab_file ;
      if [ "$add_sdcm_to_cron" = "T" ] ; then echo "$sdcm_cron_entry" >> $crontab_file ; fi
      if [ "$add_nmon_to_cron" = "T" ] ; then echo "$nmon_cron_entry" >> $crontab_file ; fi
      if [ "$add_pndcm_to_cron" = "T" ] ; then echo "$pndcm_cron_entry" >> $crontab_file ; fi
      if [ "$add_pndcm_clean_to_cron" = "T" ] ; then echo "$pndcm_clean_cron_entry" >> $crontab_file ; fi
      if [ "$add_rack_to_cron" = "T" ] ; then echo "$rack_cron_entry" >> $crontab_file ; fi
      if [ "$add_pndchk_to_cron" = "T" ] ; then echo "$pndchk_cron_entry" >> $crontab_file ; fi
      if [ "$add_pndchk_sar_to_cron" = "T" ] ; then echo "$pndchk_sar_cron_entry" >> $crontab_file ; fi
      if [ "$add_pngetinfo_to_cron" = "T" ] # Added jrndmin and comments for pngetinfo.sh
      then
         echo "$jgetcomment" >> $crontab_file 
         echo "$jgetcomment2" >> $crontab_file 
         echo "$pngetinfo_cron_entry" >> $crontab_file 
      fi
      # echo $cron_trailer >> $crontab_file ;
      if [ "$testplatform" = "T" ] ; then cron_install="false" ; fi ##### remove for production !!!
      eval $cron_install
      sic=$?
      if [ "$debug" = "T" ] ; then echo "add to cron: $sic" ; fi
      if [ "$sic" != "0" ] ; then
         sc="failed - unable to create cron entries; $sc"
         echo
         echo "##########"
         echo "unable to create crontab entries -- please have admin set them up"
         echo " desired crontab entry:"
         echo
         echo $cron_header ;
         if [ "$add_sar_to_cron" = "T" ] ; then echo "$sar_cron_entry" ; fi
         if [ "$add_sdcm_to_cron" = "T" ] ; then echo "$sdcm_cron_entry" ; fi
         if [ "$add_nmon_to_cron" = "T" ] ; then echo "$nmon_cron_entry" ; fi
         if [ "$add_pndcm_to_cron" = "T" ] ; then echo "$pndcm_cron_entry" ; fi
         if [ "$add_pndcm_clean_to_cron" = "T" ] ; then echo "$pndcm_clean_cron_entry" ; fi
         if [ "$add_rack_to_cron" = "T" ] ; then echo "$rack_cron_entry" ; fi
         if [ "$add_pndchk_to_cron" = "T" ] ; then echo "$pndchk_cron_entry" ; fi
         if [ "$add_pndchk_sar_to_cron" = "T" ] ; then echo "$pndchk_sar_cron_entry" ; fi
         if [ "$add_pngetinfo_to_cron" = "T" ] ; then echo "$pngetinfo_cron_entry" ; fi
         echo $cron_trailer ;
         echo "##########"
      fi
      if [ "$add_sar_to_AIX_cron" = "T" ] ; then
	  crontab -l adm > crontab.adm
	  cp crontab.adm crontab.adm.save
	  echo $cron_header >> crontab.adm
	  echo "$sar_cron_entry" >> crontab.adm
	  echo $cron_trailer >> crontab.adm
	  su adm -c "crontab crontab.adm"
	  sica=$?
	  if [ "$sica" != "0" ] ; then
	     sc="failed - unable to create adm cron entry for sar; $sc"
	     echo "##########"
	     echo "Unable to create crontab entry for sar"
	     echo "Please add the following to the adm crontab:"
	     echo "$sar_cron_entry"
	     echo "##########"
	  fi
      fi
   else
      echo "nothing to add to cron";
   fi
}

do_os_specific_setup () {
## do remaining os-specific setup stuff
 if [ "$ostype" = "AIX" ] ; then
   fileowner="root:system" ;
   oslevel=`/usr/bin/oslevel`
   if [ "$oslevel" = "4.*" ] ; then
     chmod ugo+r /dev/kmem ;	## only needed for nmon 9 on AIX 4.x
   fi
   # All current AIX systems, iostat=true is the default behavior.
   # This value has set for many years by Performance Navigator Data Consolidator, 
   # because on much older systems it may be turned off.
   # Because of this, we automatically ensure it is set correctly.
   # 
   # To enable the collection of disk input/output statistics, you would type: 
   # # chdev -dev sys0 -attr iostat=true 
   # 
   # We set this on all AIX systems.
   # 
   # To see the setting, type:
   # # lsattr -E -l sys0 | grep iostat
   # iostat  true  Continuously maintain DISK I/O history    True
   # 
   chdev -l sys0 -a iostat=true 2>&1 > /dev/null ;
 elif [ "$ostype" = "Linux" ] ; then
   fileowner="root:root" ;
 elif [ "$ostype" = "HP-UX" ] ; then
   fileowner="root:root" ;
 fi
}

set_file_ownerships () {
## set ownership of installed files
# NOTE: directory permissions set when created (above)
#	file permissions set by the untar process
   if [ "X$fileowner" != "X" ] ; then
      if [ "$testplatform" != "T" ] ; then	# do not set file perms on testplatform
         if [ ! -z "$verbose" ] ; then
            echo "setting file and directory ownerships and permissions" ;
         fi
         chown -R $fileowner $instdir
         if [ "$install_sar" != "T" ] ; then
            chown -h $fileowner $instdir/nmon	## chown the link, not the target
         fi
      fi  # testplatform fi
   fi
}

save_rack_config () {
## save the rack configuration
 if [ ! -z "$verbose" ] ; then echo "saving rack configuration" ; fi
 ${instdir}/rackdata.sh -c $pnconfig
 rd=$?
 if [ "$rd" != "0" ] ; then
	sc="rackdata failed; $sc"
	echo
	echo "rackdata failed - please verify installation"
	echo
 fi
}

check_reinstall_needed () {
 if [ -z "$reinstall" ] ; then
	if [ ! -z "$verbose" ] ; then echo "----- reinstall not set on commandline" ; fi
   if [ -d "$instdir" ] ; then
	if [ ! -z "$verbose" ] ; then echo "----- $instdir exists" ; fi
     if [ -s "$pnconfig" ] || [ -s "$mpgdata" ] || [ -s "pndcm.sh" ] || [ -s "pndcm.sh" ] ; then
#	if [ ! -z "$verbose" ] ; then
	   echo "----- previous install found at $instdir : setting reinstall"
#	fi
	reinstall="T"
   echo "# PWD (${PWD}) #" > /tmp/helpsystems_tmp/check_reinstall_needed.hsllc
   set >> /tmp/helpsystems_tmp/check_reinstall_needed.hsllc
     fi
   fi
 fi
}

prep_reinstall_pn () {
 	if [ "$debug" = "T" ] ; then echo "preparing for re-install" ; fi
##CONF	remove instance from /etc/pn.conf
  if [ -f /etc/pn.conf ] ; then
	cp /etc/pn.conf /etc/pn.conf.org
	grep $instdir /etc/pn.conf
	inconf=$?
	if [ "$inconf" = "0" ] ; then
		grep -v $instdir /etc/pn.conf.org > /etc/pn.conf
	fi
  fi
##### need to read config file and preserve options - ??? check for changed options...
##### quickie - just preserve the config file as .org
  cp -p $instdir/pn.config $instdir/pn.config.${jdate}
  cp -p $instdir/pn.config $instdir/pn.config.org
  cd $instdir
## get installer version of current installation
## use it to create "old_cron_header" line to be removed from cron
  old_pnversion=`grep 'Performance Navigator' pn.config.org | grep -i version | awk '{print $NF}'` 
 	if [ "$debug" = "T" ] ; then echo "	old PNVersion: $old_pnversion" ; fi
  old_cron_header="$raw_cron_header $old_pnversion"
 	if [ "$debug" = "T" ] ; then echo "	old cron header: $old_cron_header" ; fi

 	if [ "$debug" = "T" ] ; then echo "	removing old files" ; fi
# remove old files that need to be replaced
  rm -f $instdir/mpgpn.tar $instdir/rackdata.sh 
  rm -f $instdir/rackd.sh $instdir/pngetinfo.sh 
  if [ "$install_sar" != "T" ] ; then
    rm -f $instdir/pndcm.sh $instdir/pndcutils.sh $instdir/pndchk.sh 
    rm -f $instdir/pntestdmi $instdir/dmi* 
    rm -f $instdir/pndc_truncate.sh $instdir/trunc.sh $instdir/nmon 2>/dev/null
    rm -f $instdir/nmon_*_*_* $instdir/nmonmerge* $instdir/reduce.patt* $instdir/pngetinfo.sh 2>/dev/null
  else
    rm -f $instdir/sdcm.sh $instdir/sar.sh $instdir/sar.awk $instdir/pngetinfo.sh $instdir/pndchk_sar.sh 
  fi
# clean out cron entries (will replace)
 	if [ "$debug" = "T" ] ; then echo "	cleaning out cron entries" ; fi
  ##### debian specific
  CRONTAB_NOHEADER="N"
  export CRONTAB_NOHEADER
  ##### end debian specific
  eval $cron_get
  cp $crontab_file ${crontab_file}.pre_remove
  grep -v "$cendregex" $crontab_file > ${crontab_file}.0
  grep -v "$nmonregex" ${crontab_file}.0 > ${crontab_file}.1
  grep -v "$nmonregex_old" ${crontab_file}.1 > ${crontab_file}.2
  grep -v "$pndcmregex" ${crontab_file}.2 > ${crontab_file}.3
  grep -v "$rackregex" ${crontab_file}.3 > ${crontab_file}.4
  grep -v "$sdcmregex" ${crontab_file}.4 > ${crontab_file}.5
  grep -v "$truncregex" ${crontab_file}.5 > ${crontab_file}.6
  grep -v "$pngetinforegex" ${crontab_file}.6 > ${crontab_file}.7
  egrep -v "# MPG |# HelpSystems| Performance Nav inst|^${old_cron_header}$" ${crontab_file}.7 > ${crontab_file}.8
  # Next line removes erroneous headers from crontab in RedHat linux versions
  grep -v "DO NOT EDIT THIS FILE|.*crontab.*installed on|Cron version -" ${crontab_file}.8 > ${crontab_file}.9
  grep -v "$pndchkregex" ${crontab_file}.9 > ${crontab_file}.a
  grep -v "$pndchksarregex" ${crontab_file}.a > ${crontab_file}.b
  mv ${crontab_file}.b $crontab_file
  eval $cron_install
  # remove temporary files
  rm -f ${crontab_file}.0 ${crontab_file}.1 ${crontab_file}.2 
  rm -f ${crontab_file}.3 ${crontab_file}.4 ${crontab_file}.5 
  rm -f ${crontab_file}.6 ${crontab_file}.7 ${crontab_file}.8 
  rm -f ${crontab_file}.9 ${crontab_file}.a
  cd $startdir
}

check_for_pnconfig_change () {
   # pn.config check for changes after an install/reinstall  
   cd $instdir
   if [ -s pn.config ] && [ -s pn.config.org ] ; then
      diff pn.config pn.config.org \
         | grep -v "#" \
         | grep "=" \
         | sed s/\</\#\ \(\*Changed\)/ \
         | sed s/\>/\#\ \(Previous\)/ > last_pnconfig_install_change.hsllc
   fi
   if [ -s  last_pnconfig_install_change.hsllc ] ; then
      echo "#### Please review the changes made in pn.config ####"
      cat last_pnconfig_install_change.hsllc
      echo "#### End of the changes made in pn.config        ####" 
      echo "# To change them back.                              #" 
      echo "# ( cd ${instdir} ; ./change_pn.sh -p )         #" 
      echo "# ------------------------------------------------- #" 
   fi
}

nmon_first_time_message () {
   # Message displayed if first nmon install
   if [ "$install_sar" != "T" ] && [ "$reinstall" != "T" ] 
   then
      echo "This appears to be a first install of Performance Navigator Data Consolidator for" 
      echo "nmon data!  If you have data from previous iterations of nmon that were" 
      echo "collected prior to this installation, it can be included if you contact"
      echo "HelpSystems (MPG) within 7 days."
   fi
}

long_vs_short_hostname_on_reinstall_message () {
   # Message displayed if short and long hostname is different on reinstall and
   # there are files or pn.config variables that use the long form of hostname
   # Check for long and short different
   # same_hostname
   host_long_form=`$juname -n`
   host_short_form=`$juname -n | awk -F. '{print $1}'`
   if [ "${host_long_form}" != "${host_short_form}" ] ; then
      host_long_form_check="F" # Start with it not true then detect problem 
      # Check if any file in Performance Navigator host directory have longform hostname 
      find $instdir -name \*${host_long_form}\* 2>/dev/null > /tmp/helpsystems_tmp/host_long_form_check.tmp
      # Check if pn.config has longform hostname 
      cd ${instdir} ; grep "${host_long_form}" pn.config 2>/dev/null >> /tmp/helpsystems_tmp/host_long_form_check.tmp
      if [ -s /tmp/helpsystems_tmp/host_long_form_check.tmp ] ; then
         host_long_form_check="T" # long form hostname in filename or pn.config
      fi
   fi
   if [ "$host_long_form" != "$host_short_form" ] && [ "$reinstall" = "T" ]  && [ "$host_long_form_check" = "T" ] 
   then
      echo "# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx #" 
      echo "# xxxxxxxxxxxx    Error - Did not install     xxxxxxxxxxxxxxxxxxxx #" 
      echo "# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx #" 
      echo "It appears that long and short name for hostname are different and" 
      echo "either files exist with the long hostname form in the file name, "
      echo "or pn.config variables include the long form of hostname. " 
      echo "Please contact HelpSystems (MPG) to correct this situation."
      echo "or email support.mpginc@helpsystems.com"
      echo ""
      echo "To correct, in the install directory type:"
      tar xvf mpgpn.tar change_long2short.sh
      echo "( ./change_long2short.sh ) # It was automatically extracted."
      echo "exiting"; exit
      echo "# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx #" 
   fi
}


## "main"
 print_greeting
 get_ostype
 check_for_root
 check_devnull
 set_defaults
 check_reinstall_needed
 create_install_dir
 create_output_dir
 create_nmon_data_dir

 if [ "x${ostype}x" != "xSunOSx" ] ; then # may not be needed
    chk_min_space_dirs
 fi

 if [ "$reinstall" = "T" ] ; then 
    prep_reinstall_pn
 fi
 
 untar_perfnav_pkg
 if [ "$install_sar" = "T" ] ; then	## sar specific section
    if [ "$debug" = "T" ] ; then echo "installing sar data collector " ; fi
    check_sar_installed
    check_sar_in_crontab
    check_sdcm_in_crontab
    if [ -d $sardir ]; then
       echo "The directory $sardir exists." 
    else
       echo "The directory $sardir missing. Creating $sardir" 
       mkdir -p $sardir 
    fi
 else	# end sar specific section 
    if [ "$debug" = "T" ] ; then echo "installing nmon data collector " ; fi
    check_nmon_in_crontab
    check_pndcm_in_crontab
    create_nmon_symlinks
 fi  # end nmon specific setup
 
 
 # Message if long and short hostname is different and either filenames or 
 # pn.config have long hostname in them. 
 long_vs_short_hostname_on_reinstall_message

 check_pngetinfo_in_crontab
 check_rackdata_in_crontab
 force_testplatform_settings
 create_crontab_entries
 do_os_specific_setup
#	 install_inits	# AIX ignores these
 add_to_etc_conf
 set_file_ownerships

## Remove fixshells for SunOS or any other.
## SunOS default shell non-posix (or ksh or bash) - get a useful one
# if [ "$ostype" = "SunOS" ] || [ ! -z "$opt_shelltouse" ] ; then
#    fixshells
# fi

 sc=${sc:-"success"} ; # no news is good news
 write_config_file "$sc"

 # Changed to start nmon after the config file is created.
 if [ "$install_sar" != "T" ] ; then	## nmon (not sar) specific section
    $instdir/start_nmon_now -f -v
 fi

 # pn.config check for changes after an install/reinstall  
 check_for_pnconfig_change  
 # Message if nmon first time install incase they have existing nmon data 
 nmon_first_time_message
 save_rack_config

 # Min file system size is 300 M
 jminfssize=300

 # Source pn.config if it exists
   if [ -s ./pn.config ]; then
      . ./pn.config
   fi
 
# Line below had to be replaced for Solaris
   if [ -s ./pn.config ]; then
      . ./pn.config
   fi
 
if [ "x${reinstall}x" = "xTx" ]; then
   # On reinstall, jminfssize=1000 (1G) for free files system available.
   jminfssize=1000
   jinstalltype="reinstall"
else
   # On new install, jminfssize=3000 (3G) for free files system available.
   jminfssize=3000
   jinstalltype="new install"
fi

# Line below had to be replaced for Solaris
# df -m $mpgdatadir | tail -1 | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m.hsllc
# Replaced with lines below because Solaris does not have a df -m
if [ "x${ostype}x" = "xSunOSx" ]; then
   df -k $mpgdatadir \
       | grep "\/" \
       | awk '{printf "%s %.2f %.2f %s %s %s %s \n", $1, $2/1024, $3/1024, $4, $5, $6, $7}'\
       | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m.hsllc
  # Replaced with lines above because Solaris does not have a df -m
else
   df -m $mpgdatadir \
       | grep "\/" \
       | awk '{ print $1, $3, $NF }' > /tmp/helpsystems_tmp/df-m.hsllc
fi

 jfilessystem=`cat /tmp/helpsystems_tmp/df-m.hsllc | awk '{print $1}'`
 jcurfilesize=`cat /tmp/helpsystems_tmp/df-m.hsllc | awk '{printf "%d", $2}'`
 jmntpoint=`cat /tmp/helpsystems_tmp/df-m.hsllc | awk '{print $3}'`

 if [ "$ostype" != "SunOS" ] ; then
    if [ $jminfssize -gt $jcurfilesize ]; then
       echo "# ($jcurfilesize) is less than ($jminfssize) Meg free for (${jinstalltype}) on $mpgdatadir ( mpgdatadir )"
       jspaceneeded=`echo "$jcurfilesize $jminfssize" | awk '{print $2-$1}' `
       echo "Space needed is ($jspaceneeded) Meg"
       echo "# [ `cat /tmp/helpsystems_tmp/df-m.hsllc` ]"
       echo "# Recommend that you increase the size of $jmntpoint by $jspaceneeded M "
       if [ "x${ostype}x" = "xAIXx" ]; then
          echo "# Command for AIX or VIOS has been implemented automatically "
          echo "to increase space with the following command: "
          echo "chfs -a size=+${jspaceneeded}M $jmntpoint"
          chfs -a size=+${jspaceneeded}M $jmntpoint
          df -m $mpgdatadir
       else
          echo " # # # Please contact your system admin for this system # # # "
       fi
    else
       echo "# ($jcurfilesize) is more than ($jminfssize) Meg free for (${jinstalltype}) on $mpgdatadir ( mpgdatadir )"
   fi
 fi

 if [ "$sc" = "success" ] ; then
    exit 0;
 else
    exit 1;
 fi
## "End of main"		   
