#!/bin/ksh
#
# $Id: transfer_test.sh,v 1.1 2023/03/27 16:07:05 root Exp $ 
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& transfer_test.sh script is to test the setup in pn.config and see if it  
#&& works.  It uses the same commands that are listed for the variables
#&& transfer_script_cmd and transfer_current_cmd 
#&& The only option is -D for debug
#& 
#
if [ "x${1}x" = "x-Dx" ] ; then
   export debug="T"
fi 


invocdir=`dirname $0`
if [ -s $invocdir/pndcutils.sh ] ; then
   . $invocdir/pndcutils.sh
fi

if [ -s $invocdir/pn.config ] ;  then
   . $invocdir/pn.config
fi

# Three new environmental variables
# installdir
# mpgdatadir
# nmondatadir

# installdir should be defined, but if not use invocdir
if [ -z "$installdir" ] ; then
   installdir=$invocdir
fi

# mpgdatadir should be defined, but if not use invocdir
if [ -z "$mpgdatadir" ] ; then
   mpgdatadir=$invocdir
fi

# nmondatadir should be defined, but if not use invocdir
if [ -z "$nmondatadir" ] ; then
   nmondatadir=$invocdir
fi

cd $installdir

if [ -z "$transfer_script_cmd" ] ; then
   echo "transfer_script_cmd in pn.config is not set"
fi

if [ -z "$transfer_current_cmd" ] ; then
   echo "transfer_current_cmd in pn.config  is not set"
fi

if [ -z "$transfer_script_cmd" ] ||  [ -z "$transfer_current_cmd" ] ; then
   echo "### Correct problem listed above and try again.  Exiting!"
   exit 1
fi

echo "# ---- Running transfer_script_cmd"
echo "($transfer_script_cmd)"
$transfer_script_cmd
jtest=$?
if [ $jtest -eq 0 ] ; then
   echo ""
   echo "OK transfer_script_cmd return 0 error code, appeared OK"
   echo "# ---- Check the transfer directory location."
   echo ""
else
   echo "### Error ### transfer_script_cmd returned ($jtest) error code"
fi


echo "# ---- Running transfer_current_cmd"
echo "($transfer_current_cmd)"
$transfer_current_cmd
jtest=$?
if [ $jtest -eq 0 ] ; then
   echo ""
   echo "OK transfer_current_cmd returned 0 error code, appeared OK"
   echo "# ---- Check the transfer directory location."
   echo ""
else
   echo "### Error ### transfer_current_cmd returned ($jtest) error code"
fi

export debug=""



