#!/bin/ksh
#
# $Id: transfer_current.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& transfer_script.sh & transfer_current.sh are the same except for the name
#&& and the Id line near the top of the scripts.  The script will behave 
#&& differently depending on the name of the file.
#
#&& Transfer script can aid in gathering nmon/sar data to a common location.
#&& cp is local or a mounted system, 
#&& ftp requires password, 
#&& scp requires passwordless key based authentication, 
#&& rcp requires administrative setup of /etc/rhost files  
#&& pull requires a list of server file information and requires passwordless 
#&& key based authentication 
#
#& Example configuration files are included.
#
#&% To execute this script, substitute a config file depending on the type of transfer
#&% ./transfer_script.sh -c ./transfer_scp.config 
#&% ./transfer_script.sh -c ./transfer_rcp.config 
#&% ./transfer_script.sh -c ./transfer_ftp.config 
#&% ./transfer_script.sh -c ./transfer_cp.config 
#&% ./transfer_script.sh -c ./transfer_pull.config 
#&% These config files need to be modified to the specific needs of the customer
#
#&@ Requires user modified configuration file for normal operation.
#&@ In addition if using the pull option, a list of servers file with info on
#&@ servers/users and locations needs to be identified separately.
#
# A second copy of this script named transfer_current.sh is an exact copy
# except for the name. 
# jscript_name is the variable used to change behavior based on the name
 jscript_name=`basename $0`
# echo "Script name is: ($jscript_name)" # can't be used with debug in this location

mkdir -p /tmp/helpsystems_tmp
rm -f /tmp/transfer_*.err* /tmp/transfer_*.out* # helpsystems_tmp

invocdir=`dirname $0`
if [ "x${invocdir}x" == 'x.x' ]; then
   invocdir=`pwd`
fi

function chkcmderr {
   eval "$command"
   rc=$?
   if [ "$rc" != "0" ] ; then 
      echo "ERROR in data transfer: error code: $rc"
   fi
}

function usage {
echo "usage: $0 [options]
  where Options may be any of:
        -v Verbose
	-D Debug  
	-c configfile (or options can be included manually on the command line)
	-m transfer_method (Choices are ftp,scp,rcp,cp,pull)
	-s transfer_target_system (required for ftp,scp,rcp)
	-d transfer_target_dir
	-o transfer_data_file
	-S pull_server_list_data_file
	-l transfer_data_current
	-x transfer_data_file_external
	-y transfer_data_file_external_day
	-a transfer_data_file_admin
	-r transfer_rackfile
        -k key_file (may be need for scp to work properly [id_rsa, id_dsa])
	-u transfer_userid (required for ftp,scp,rcp)
	-p transfer_password (Only required for ftp)
	-O transfer_options
	-P permissions on files (640 or 644 recommended) 
	-h Display help 
"
}

function check_targ_dir {
 if [ -z "$transfer_target_dir" ] ; then
   echo " No target directory set - please run config script or set on commandline"
   exit
 fi
}

function check_pull_server_list_data_file {
   if [ -z "$pull_server_list_data_file" ] ; then
      echo " No pull server list file specified - please run config script or set on commandline"
      exit
   else
      if [ ! -s "$pull_server_list_data_file" ] ; then
         echo "Pull server list file specified does not exist. "
         echo "What was specified was ($pull_server_list_data_file)"
         exit
      fi
   fi
}

function check_targ_sys {
 if [ -z "$transfer_target_system" ] ; then
   echo " No target system set - please run config script or set on commandline"
   exit
 fi
}

function check_targ_uid {
 if [ -z "$transfer_userid" ] ; then
   echo " No target userid set - please run config script or set on commandline"
   exit
 fi
}

function check_targ_pwd {
 if [ -z "$transfer_password" ] ; then
   echo " No password set - please run config script or set on commandline"
   exit
 fi
}

function check_parms {
 if [ -z "$transfer_method" ] ; then
#   echo " No transfer method set - please run config script or set on commandline"
   echo " No transfer method set - please set in config file or on commandline"
   exit
 fi
 if [ "x${transfer_method}x" != "xpullx" ] && [ "x${jscript_name}x" != "xtransfer_topas.shx" ] ; then
    if [ ! -f "$datafile" ] ; then
      echo " Unable to find datafile: $datafile"
      exit
    fi
    if [ ! -f "$rackfile" ] ; then
      echo " Unable to find rackfile: $rackfile"
      exit
    fi
 fi
 case $transfer_method in
	ftp)	check_targ_dir; check_targ_sys; check_targ_uid; check_targ_pwd;;
	rcp)	check_targ_dir; check_targ_sys; check_targ_uid;;
	scp)	check_targ_dir; check_targ_sys; check_targ_uid;;
	cp)	check_targ_dir;;
	pull)	check_pull_server_list_data_file;;
	*)	echo "unknown transfer method: $transfer_method"
		echo "please run config script or set on commandline"
		echo "exiting..." ; exit;
		;;
esac
}

#MAIN#
# Ensure transfer options are set.  If not, show usage message.
if [ "xx" = "x${1}x" ] ; then 
   usage
   exit 1 
fi

while getopts "Dvo:c:p:k:u:s:d:m:S:O:r:l:x:y:a:P:h" opt ; do
  case $opt in
        D)      debug="T" ;;
        v)      verbose="T" ;;
        o)      opt_datafile=$OPTARG ;;
        l)      opt_data_current=$OPTARG ;;
        x)      opt_datafile_external=$OPTARG ;;
        y)      opt_datafile_external_day=$OPTARG ;;
        a)      opt_datafile_admin=$OPTARG ;;
        c)      opt_configfile=$OPTARG ;;
	r)	opt_rackfile=$OPTARG ;;
        p)      opt_password=$OPTARG ;;
        k)      opt_keyfile=$OPTARG ;;
        u)      opt_userid=$OPTARG ;;
        s)      opt_target_system=$OPTARG ;;
        S)      opt_pull_server_list_data_file=$OPTARG ;;
        d)      opt_target_dir=$OPTARG ;;
        m)      opt_transfer_method=$OPTARG ;;
        O)      opt_transfer_options=$OPTARG ;;
        P)      opt_permsfiles=$OPTARG ;;
        h)      usage;  exit ;;
        ?)      usage;  exit ;;
  esac
done
shift `expr $OPTIND - 1`


if [ ! -z "$opt_configfile" ] ; then configfile=$opt_configfile; fi
##### quick+dirty configfile - unsafe!
if [ ! -z "$configfile" ] ; then
   . $configfile
fi

# set > /tmp/helpsystems_tmp/set_jack.tmp

## this allows just transfer of pn.config.hostname created during pngetinfo.sh
def_configfile_host="pn.config.$sysname"    # pn.config.hostname 
if [ -z "$configfile_host" ] ; then configfile_host="$def_configfile_host" ; fi
# echo "$configfile_host"

## this allows just setting datafile in the configfile
def_datafile="${invocdir}/mpgdata2.$sysname"    # default datafile name
if [ -z "$datafile" ] ; then datafile="$def_datafile" ; fi

## this allows just setting datafile_external_day in the configfile
if [ -s ${invocdir}/mpgdata3_day.$sysname ] ; then  
   def_datafile_external_day="${invocdir}/mpgdata3_day.$sysname"    # default datafile_external_day name
else
   def_datafile_external_day="" # if no default datafile_external_day name set blank
fi

## this allows just setting datafile_external in the configfile
if [ -s ${invocdir}/mpgdata3.$sysname ] ; then  
   def_datafile_external="${invocdir}/mpgdata3.$sysname"    # default datafile_external name
else
   def_datafile_external="" # if no default datafile_external name set blank
fi
if [ -z "$datafile_external" ] ; then datafile_external="$def_datafile_external" ; fi

## this allows just setting datafile_admin in the configfile
if [ -s ${invocdir}/mpgdata4.$sysname ] ; then  
   def_datafile_admin="${invocdir}/mpgdata4.$sysname"    # default datafile_admin name
else
   def_datafile_admin="" # if no default datafile_admin name set blank
fi

## this allows just setting datafile_ps in the configfile
if [ -s ${invocdir}/mpgdata5.$sysname ] ; then  
   def_datafile_ps="${invocdir}/mpgdata5.$sysname"    # default datafile_admin name
   def_datafile_ps_cur="${invocdir}/mpgdata5_current.$sysname"    # default datafile_admin name
else
   def_datafile_ps="" # if no default datafile_ps name set blank
   def_datafile_ps_cur="" # if no default datafile_ps_cur name set blank
fi

if [ -z "$datafile_admin" ] ; then datafile_admin="$def_datafile_admin" ; fi

## this allows just setting data_current in the configfile
def_data_current="${invocdir}/mpgdata2_current.$sysname"    # default datafile name
if [ -z "$data_current" ] ; then data_current="$def_data_current" ; fi

function debug_display {
   verbose="T"
   echo "permsfiles(${permsfiles})"
   echo "datafile(${datafile})"
   echo "datafile_external(${datafile_external})"
   echo "datafile_external_day(${datafile_external_day})"
   echo "datafile_admin(${datafile_admin})"
   echo "data_current(${data_current})"
   echo "rackfile(${rackfile})"
   echo "transfer_method(${transfer_method})"
   echo "target_system(${transfer_target_system})"
   echo "target_dir(${transfer_target_dir})"
   echo "transfer_userid(${transfer_userid})"
   echo "transfer_password(${transfer_password})"
   echo "key_file(${key_file})"
   echo "transfer_options(${transfer_options})"
   echo "pull_server_list_data_file(${pull_server_list_data_file})"
   echo "def_data_current(${def_data_current})"
   echo "def_datafile(${def_datafile})"
   echo "def_datafile_admin(${def_datafile_admin})"
   echo "def_datafile_external(${def_datafile_external})"
   echo "def_datafile_external_day(${def_datafile_external_day})"
   echo "def_datafile_ps(${def_datafile_ps})"
   echo "def_datafile_ps_cur(${def_datafile_ps_cur})"
}

if [ "xx" != "x${debug}x" ] ; then
   echo " -- options after configfile processing: -- "
   debug_display
fi

# commandline options override config file
if [ ! -z "$opt_permsfiles" ] ; then permsfiles=$opt_permsfiles; fi
if [ ! -z "$opt_datafile" ] ; then datafile=$opt_datafile; fi
if [ ! -z "$opt_datafile_external" ] ; then datafile_external=$opt_datafile_external; fi
if [ ! -z "$opt_datafile_external_day" ] ; then datafile_external_day=$opt_datafile_external_day; fi
if [ ! -z "$opt_datafile_admin" ] ; then datafile_admin=$opt_datafile_admin; fi
if [ ! -z "$opt_data_current" ] ; then data_current=$opt_data_current; fi
if [ ! -z "$opt_transfer_method" ] ; then transfer_method=$opt_transfer_method; fi
if [ ! -z "$opt_target_system" ] ; then transfer_target_system=$opt_target_system; fi
if [ ! -z "$opt_pull_server_list_data_file" ] ; then pull_server_list_data_file=$opt_pull_server_list_data_file; fi
if [ ! -z "$opt_target_dir" ] ; then transfer_target_dir=$opt_target_dir; fi
if [ ! -z "$opt_userid" ] ; then transfer_userid=$opt_userid; fi
if [ ! -z "$opt_password" ] ; then transfer_password=$opt_password; fi
if [ ! -z "$opt_key_file" ] ; then key_file=$opt_key_file; fi
if [ ! -z "$opt_transfer_options" ] ; then transfer_options=$opt_transfer_options; fi

if [ "xx" != "x${debug}x" ] ; then
   echo " ----- options after commandline option processing:"
   debug_display
fi

check_parms

## chmod the files that are transferred.
## If variable permsfiles set chmod to the files before they are transferred.
if [ "xx" != "x${permsfiles}x" ] ; then
   chmod ${permsfiles} $transfer_options $configfile_host $datafile $datafile_external $datafile_external_day $datafile_admin $data_current $datafile_ps $datafile_ps_cur $rackfile  2>/dev/null
fi

# if script is called with name other than transfer_script.sh, then null
# non current variables.
if [ "x${jscript_name}x" != "xtransfer_script.shx" ]; then
   datafile='' 
   datafile_external='' 
   datafile_admin=''  
   datafile_ps=''  
   rackfile=''
   # Used to set topas variables for auto transfer of topas data
   if [ "x${jscript_name}x" = "xtransfer_topas.shx" ]; then
      datafile="`ls -1tr /tmp/helpsystems_tmp/mpgdata_topas*gz | tail -1`" 
      data_current=''  
   fi 
fi

## create transfer command
case $transfer_method in
	ftp)	
	      	command="ftp -i -n <<-EOF
		open $transfer_target_system
		user $transfer_userid $transfer_password
		cd $transfer_target_dir
                bin 
		mput $datafile $datafile_external $datafile_external_day $datafile_admin $data_current $datafile_ps $datafile_ps_cur $rackfile $configfile_host
		quit
EOF
"
	;;
	rcp)	command="rcp $transfer_options $datafile $datafile_external $datafile_external_day $datafile_admin $data_current $datafile_ps $datafile_ps_cur $rackfile $configfile_host ${transfer_userid}@${transfer_target_system}:$transfer_target_dir" ;;
	scp)	command="scp $transfer_options $datafile $datafile_external $datafile_external_day $datafile_admin $data_current $datafile_ps $datafile_ps_cur $rackfile $configfile_host ${transfer_userid}@${transfer_target_system}:$transfer_target_dir" ;;
	cp)	command="cp -f $transfer_options $datafile $datafile_external $datafile_external_day $datafile_admin $data_current $configfile_host $datafile_ps $datafile_ps_cur $configfile_host $rackfile $transfer_target_dir; cd $transfer_target_dir; chmod $permsfiles $datafile $datafile_external $datafile_admin $data_current $datafile_ps $datafile_ps_cur $configfile_host $rackfile "  ;;
	pull)	command="while
read jid_filename juser_name jhost_name jsource_dir jport 
do
if [ \"x\${jid_filename}x\" != \"x#x\" ] && [ \"x\${jid_filename}x\" != \"x#&&x\"  ]; then
      if [ \"x\${jscript_name}x\" != \"xtransfer_current.shx\" ]; then
         scp -p -P \${jport} -i \${jid_filename} \${juser_name}@\${jhost_name}:\"\${jsource_dir}/mpgdata[0-9].\${jhost_name}\" ${transfer_target_dir}  2>/tmp/helpsystems_tmp/transfer_pull_\${jhost_name}.err0 >/tmp/helpsystems_tmp/transfer_pull_\${jhost_name}.out0
         scp -p -P \${jport} -i \${jid_filename} \${juser_name}@\${jhost_name}:\"\${jsource_dir}/mpgdata[0-9]_current.\${jhost_name}\" ${transfer_target_dir}  2>/tmp/helpsystems_tmp/transfer_pull_\${jhost_name}.err1 >/tmp/helpsystems_tmp/transfer_pull_\${jhost_name}.out1
         scp -p -P \${jport} -i \${jid_filename} \${juser_name}@\${jhost_name}:\"\${jsource_dir}/pn.config.\${jhost_name}\" ${transfer_target_dir}  2>/tmp/helpsystems_tmp/transfer_pull_\${jhost_name}.err2 >/tmp/helpsystems_tmp/transfer_pull_\${jhost_name}.out2
         scp -p -P \${jport} -i \${jid_filename} \${juser_name}@\${jhost_name}:\"\${jsource_dir}/rackdata.\${jhost_name}\" ${transfer_target_dir}  2>/tmp/helpsystems_tmp/transfer_pull_\${jhost_name}.err3 >/tmp/helpsystems_tmp/transfer_pull_\${jhost_name}.out3
      else
         scp -p -P \${jport} -i \${jid_filename} \${juser_name}@\${jhost_name}:\"\${jsource_dir}/mpgdata[0-9]_current.\${jhost_name}\" ${transfer_target_dir}  2>/tmp/helpsystems_tmp/transfer_pull_\${jhost_name}.err1 >/tmp/helpsystems_tmp/transfer_pull_\${jhost_name}.out1
      fi
fi

# Change owner on all files in target directory to pullchown variable if set
if [ "xx" != "x${pullchown}x" ] ; then
   chown "${pullchown}" ${transfer_target_dir}/mpg* ${transfer_target_dir}/pn* ${transfer_target_dir}/rack*
fi

done < ${pull_server_list_data_file}

"  ;;
	*)	echo "unknown transfer method: $tm - exiting"; exit;;
esac

if [ "xx" != "x${debug}x" ] ; then
   echo "command=$command"
fi

# echo "Remove Exit later"; exit

chkcmderr 
# echo $datafile >> /tmp/helpsystems_tmp/jtestdatafile
if [ "xx" != "x${cplocal}x" ] ; then
   command="cp -f $transfer_options $datafile $datafile_external $datafile_external_day $datafile_admin $data_current $configfile_host $datafile_ps $datafile_ps_cur $configfile_host $rackfile $transfer_target_dir; cd $transfer_target_dir; chmod $permsfiles $datafile $datafile_external $datafile_admin $data_current $datafile_ps $datafile_ps_cur $configfile_host $rackfile " 
   chkcmderr 
   # Change owner on all files in target directory to pullchown variable if set
   if [ "xx" != "x${pullchown}x" ] ; then
      chown "${pullchown}" ${transfer_target_dir}/mpg* ${transfer_target_dir}/pn* ${transfer_target_dir}/rack*
   fi
fi


