#!/bin/ksh
#!/bin/ksh -xv
#
# $Id: topas2nmonchart.sh,v 1.1 2023/08/21 16:51:28 root Exp root $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Can process .topas files that customer sent into nmonchart files.
#
#@ Requires topasout which is part of AIX/VIOS systems
#
#
#&% Customer should be running rackdata.sh -T
#

echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
#

ls -1 *topas 2>1 > /dev/null
jchk=$?


if [ ${jchk} -eq 0 ]; then
echo "Processing topas files and making nmonchart html files (${jchk})"
for jfile in `ls -1 *.topas`
do
        topasout -a $jfile
done
#
for jfile in `ls -1 *.topas.csv`
do
        /home/pn/hold4build/topaschart $jfile $jfile.html
done
tar cvf topas2nmonchart.tar *csv*
ls -ltr topas2nmonchart.tar
   
else
	echo "No .topas files (${jchk})"
fi

