#!/bin/ksh
#
# $Id: test_targz.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# (c) Copyright Fortra, LLC. and its group of companies.
#
#
#&& Used to test a tar.gz file to see files and determine space when gunzipped 
#&& and untarred.
#&& Also counts files, gz, tar, tar.gz, rackdata and mpgdata2 files 
#

echo "# Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
echo "# ($0 $1)"

if [ "x${1}x" = "xx"  ]; then
   echo "A tar.gz file needs to be specified."
   exit 1
fi

jtest=`echo $1 | awk -F\. '{print $2"."$3}'`

if [ "x${jtest}x" != "xtar.gzx"  ]; then
   echo "(${1}) is not a tar.gz file."
   exit 1
fi

gunzip -c ${1} | tar tvf - | awk '{print $0}{ sum+=$4}{if(substr($9,1,8) == "rackdata") rdfiles++ }{if(substr($9,1,8) == "mpgdata2") mpfiles++ }{if(substr( $9, length($9) - 2, length($9)) == ".gz") gzfiles++ }{ if(index( $NF , "nmon") != 0 ) nmonf++ }{ if( index( $NF , "topas" ) != 0 ) topasf++ }{if(substr( $9, length($9) - 3, length($9)) == ".tar") tarfiles++ }{if(substr( $9, length($9) - 6, length($9)) == ".tar.gz") targz++ } END { {printf "%s %d\n", "Bytes", sum }{printf "%s %d\n", "rd_files", rdfiles }{printf "%s %d\n", "mpgd2_files", mpfiles }{printf "%s %d\n", "tar_files", tarfiles }{printf "%s %d\n", "gz_files", gzfiles }{printf "%s %d\n", "targz_files", targz }{printf "%s %d\n", "nmon_files", nmonf }{printf "%s %d\n", "topas_files", topasf }{printf "%s %d\n", "Files", NR } }'


#& # /perfnav-nix/pn/scripts/test_targz.sh /dirname/test.tar.gz 
#& # Running test_targz.sh,v #.## YYYY/MM/DD hh:mm:ss
#& # (/perfnav-nix/pn/scripts/test_targz.sh /dirname/test.tar.gz)
#& -rw-rw---- 0   0       20 Sep 13 19:07:33 2015 jserver.gz
#& -rw-rw---- 0   0       20 Sep 13 19:07:40 2015 jserver.tar
#& -rw-rw---- 0   0       20 Sep 13 19:07:15 2015 jserver.tar.gz
#& -rw-rw---- 0   0       20 Sep 13 19:08:02 2015 mpgdata2.jserver
#& -rw-rw---- 0   0       20 Sep 13 19:08:09 2015 rackdata.jsersver
#& Bytes 100
#& rd_files 1
#& mpgd2_files 1
#& tar_files 1
#& gz_files 2
#& targz_files 1
#& nmon_files 0
#& topas_files 0
#& Files 5

