#!/bin/ksh
#
# $Id: test_ping.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Used to test ftp to other servers.
#&
#&@ Requires ping_test.list 
#&
#
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
echo "# ========================= #"
mkdir -p /tmp/test_ping_files # helpsystems_tmp
jdirname=`dirname $0`

if [ -s ${jdirname}/test_ping.list ] ; then
   echo Using list file ${jdirname}/test_ping.list
else
   echo "### Error ### List file ${jdirname}/test_ping.list does not exist"
   exit 1
fi   
echo "# ========================= #"
# echo $jdirname
usage () {
   echo "USAGE: $0 [options]
   where options may be any of:
   -D                  debug
   -v                  verbose
   "
}

while getopts "Dvc:" opt; do
  case $opt in
        D)      debug="T" ;;
        v)      verbose="T" ;;
        ?)      usage;  exit ;;
  esac
done


while 
read jhosttcp jhostname
do 
   if [ "x${jhosttcp}x" != "xx" ] && [ "x${jhosttcp}x" != "x#x" ] && [ "x${jhosttcp}x" != "x#&x" ] && [ "x${jhosttcp}x" != "x#&&x" ]  ; then
      ping  -c 1 -w 1  $jhosttcp  2>/dev/null > /tmp/test_ping_files/test_ping.${jhostname} # helpsystems_tmp
      jchk=$?
      if [ "x${jchk}x" == "x0x" ] ; then
         jping="Ok"
      else
         jping="Failed"
      fi
   echo $jhosttcp $jhostname $jping
   fi

done < ${jdirname}/test_ping.list
echo "# ========================= #"
echo $0 output files are in /tmp/test_ping_files # helpsystems_tmp


#& Test runs of test_ping.sh
#& # ========================= #
#& 
#&  ./test_ping.sh
#& Running
#& # ========================= #
#& ### Error ### List file ./test_ping.list does not exist
#& 
#& 
#&  ./test_ping.sh
#& Running
#& # ========================= #
#& Using list file ./test_ping.list
#& # ========================= #
#& 159.203.224.42 ftp.fortra.net Ok
#& 96.69.172.229 ftp.fortra.com Ok
#& 96.69.172.226 www.fortra.com Ok
#& # ========================= #

