#!/bin/ksh
#
# $Id: split_mpgd2.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Splits mpgdata2.hostname file into individual nmon files in splits directory 

mkdir -p /tmp/helpsystems_tmp

jorig_filename="$1"

# You must specify a filename
if [ "x" = "x${jorig_filename}" ] ; then
   echo "You must specify a mpgdata2 file to split."; exit 1
fi

# The filename must exist
if [ ! -s ${jorig_filename} ] ; then
   echo "The filename (${jorig_filename}) is empty or does not exist."; exit 1
fi

# All split out files will go into splits
mkdir -p splits
# Create file  /tmp/helpsystems_tmp/split_file_list.tmp of details to create individual nmonfiles.
# Change 3 chacter month on dates to 2 digit number 
cat $jorig_filename \
   | sed s,-JAN-,-01-, \
   | sed s,-FEB-,-02-, \
   | sed s,-MAR-,-03-, \
   | sed s,-APR-,-04-, \
   | sed s,-MAY-,-05-, \
   | sed s,-JUN-,-06-, \
   | sed s,-JUL-,-07-, \
   | sed s,-AUG-,-08-, \
   | sed s,-SEP-,-09-, \
   | sed s,-OCT-,-10-, \
   | sed s,-NOV-,-11-, \
   | sed s,-DEC-,-12-, \
   | sed s,-,,g \
   | sed s,:,,g \
   | awk -F, '{
{if($2 == "progname" && NR != 1 ) {
jbegin = NR;
print jbeginlast, jbegin-1, jhost, jyear, jmonth, jday, jtime, "mpg_" jhost "_" jyear jmonth jday "_" jtime ".nmon" 
}}
{if($2 == "progname" ) {
jbegin = NR
}}
# Test
{if($2 == "host") jhost = $3}
{if($2 == "time") jtime = substr($3,1,4)}
{if($2 == "date") jdate = $3;
jyear = substr(jdate,5,8);
jmonth = substr(jdate,3,2);
jday = substr(jdate,1,2) ;
jbeginlast = jbegin }
}
END {{print jbeginlast, NR, jhost, jyear, jmonth, jday, jtime, "mpg_" jhost "_" jyear jmonth jday "_" jtime ".nmon" }
}' > /tmp/helpsystems_tmp/split_file_list.tmp

# Build the individual nmonfiles in the splits directory
while 
read jbegin jend jhost jyr jmnth jday jhour jfname
do
# echo "$jbegin $jend $jhost $jyr $jmnth $jday $jhour $jfname"
awk  -v jstart=$jbegin -v jlast=$jend ' NR >= jstart && NR <= jlast ' $jorig_filename  > splits/$jfname 
done < /tmp/helpsystems_tmp/split_file_list.tmp

# Next move the original mpgdata2 file to orig_mpgdata2 and gzip it.
mv $jorig_filename orig_${jorig_filename}  
gzip orig_${jorig_filename}

# Now use nmonmerge to combine any files that have the same day.
rm -f this_day.nmon
touch this_day.nmon
jymd=""
while
read jbegin jend jhost jyr jmnth jday jhour jfname
do
   echo "( $jbegin $jend $jhost $jyr $jmnth $jday $jhour $jfname )"
   if [ "$jymd" != "${jyr}${jmnth}${jday}" ]; then
      cat this_day.nmon >> ${jorig_filename}
      cp splits/$jfname this_day.nmon
      jlastfname=$jfname
      jymd="${jyr}${jmnth}${jday}"
   else
      ./nmonmerge this_day.nmon splits/$jfname > this_day.nmon_merged
      mv this_day.nmon_merged this_day.nmon
   fi
done < /tmp/helpsystems_tmp/split_file_list.tmp

cat this_day.nmon >> ${jorig_filename}

gzip ${jorig_filename}

# End of file #
