#!/bin/ksh
#!/bin/ksh -xv
#
# $Id: single_directory_check.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#
#&& Used to check how long it takes to list a directory with only filename
#&& and list directory with details. 
#& syntax: single_directory_check.sh directory 
#
#
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "

if [ "xx" = "x${1}x" ]; then
   echo "### You have not specified a directory ($1)"
   echo "### syntax: [ single_directory_check.sh directory ]"
   exit 1
fi

if [ ! -d $1 ]; then
   echo "### ($1) is not directory. "
   exit 1
fi

echo '#### ls -1 $1 | wc -l #### > /var/tmp/ls-1_nohup.out' | tee /var/tmp/ls-1_nohup.out   
date >> /var/tmp/ls-1_nohup.out  
ls -1 $1 | wc -l >> /var/tmp/ls-1_nohup.out  
date >> /var/tmp/ls-1_nohup.out  

echo '#### ls -al $1 | wc -l #### > /var/tmp/ls-al_nohup.out' | tee /var/tmp/ls-al_nohup.out   
date >> /var/tmp/ls-al_nohup.out  
ls -al $1 | wc -l >> /var/tmp/ls-al_nohup.out
date >> /var/tmp/ls-al_nohup.out

echo "#### Please send /var/tmp/ls-1_nohup.out /var/tmp/ls-al_nohup.out #### "

cat /var/tmp/ls-1_nohup.out

echo "##########"

cat /var/tmp/ls-al_nohup.out

#$ 

#& ###    ./single_directory_check.sh ./single_directory_check.sh
#& ### (./single_directory_check.sh) is not directory.
#& 
#& ###  ./single_directory_check.sh
#& ### You have not specified a directory ()
#& ### syntax: [ single_directory_check.sh directory ]
#& 
#& #### ./single_directory_check.sh /nmondata
#& #### ls -1 $1 | wc -l #### > /var/tmp/ls-1_nohup.out
#& #### ls -1 $1 | wc -l #### > /var/tmp/ls-al_nohup.out
#& #### Please send /var/tmp/ls-1_nohup.out /var/tmp/ls-al_nohup.out ####
#& #### ls -1 $1 | wc -l #### > /var/tmp/ls-1_nohup.out
#& Tue Sep 17 08:29:37 MDT 2019
#&      129
#& Tue Sep 17 08:29:37 MDT 2019
#& ##########
#& #### ls -1 $1 | wc -l #### > /var/tmp/ls-al_nohup.out
#& Tue Sep 17 08:29:37 MDT 2019
#&      132
#& Tue Sep 17 08:29:37 MDT 2019



