#!/bin/ksh
#!/bin/ksh -xv
#
# $Id: send2ibm.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Send the pninfo file to ftp.ibminc.net as user anonymous
#
#@ Requires ftp command
#
#& Requires CompanyName.  
#& Syntax:
#&    ./send2ibm.sh CompanyName 
#& Gets the directory from /etc/pn.conf 
#
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
#
# Original name was sendpinfo2ibm.sh
#
jhelp () {
echo "##########
Syntax:
      ./sendibm.sh (-m) CompanyName 
      -m is to send pninfo_multiple file
##########"
}

#Confirm that ftp command is available
jftp=`which ftp 2>$1 > /dev/null`
jftpchk=${?}

if [ "x1x" = "x${jftpchk}x" ] ; then
   echo "##########"
   echo "Command ftp is not available" 
   jhelp
   echo "Exiting" ; exit
fi

if [ "xx" = "x${1}x" ] && [ "xx" = "x${2}x" ] ; then
   jhelp
   echo "Exiting" ; exit
fi

if [ "x${1}x" != "x-mx" ]; then
   # If -m is not specified will use $0 for CompanyName 
   echo "If -m is not specified will use \$0 for CompanyName" 
   . /etc/pn.conf
   if [ ! -s $nminst ]; then
      jhelp
      echo "Exiting" ; exit
   fi
   cd ${nminst}
   jcomp=`echo "$*" | sed s,\ ,\.,g`
else
   # If -m is specified will use all but $1 for CompanyName 
   echo " If -m is specified will use all \$1 for CompanyName "
   echo " and will send a pninfo file from the current directory. "
   jcomp=`echo "$*" | cut -f 2- | sed s,\ ,\.,g`
fi
echo " (${jcomp}) "
# jcname=`echo "$jcomp" | awk -F@ '{print $1}'`
# jcweb=`echo "$jcomp" | awk -F@ '{print $2}'`

# jdirname=`echo $jcweb | tr '.' '_'` 
echo "Sending pninfo file from ($jcomp) to user anonymous at ftp.ibminc.net"

jpninfofile=`ls -1tr pninfo* | tail -1`
# echo "Remove later, exiting!"; exit 1

# echo "( ${jpninfofile} )"
jtemp_user="${jcomp}\.${jpninfofile}"
# echo "${pninfofile} from $jcomp"
# echo "( ${jtemp_user} )"
if [ -s /etc/pn.conf ] && [ -s ${jpninfofile} ]  ; then
   echo "Sending (${jpninfofile}) from (${jcomp}) user anonymous at ftp.ibminc.net"
ftp -nv <<-jamjam
open testcase.boulder.ibm.com
user anonymous ${jcomp}
binary
prompt
cd /eserver/toibm/zseries
put ${jpninfofile} ${jtemp_user}
dir ${jtemp_user}
quit
jamjam

else
   echo " /etc/pn.conf and ${jpninfofile} all have to exist."
fi

#& ###################
#& Sample Run
#& ###################
#& # ./send2ibm.sh MPG Inc Randy
#& Running send2ibm.sh,v 1.9 2018/05/07 17:24:54
#& If -m is not specified will use $0 for CompanyName (MPG.Inc.Randy)
#& Sending pninfo file from (MPG.Inc.Randy) to user anonymous at ftp.ibminc.net
#& Sending (pninfo.hostname.AIX.tar.gz) from (MPG.Inc.Randy) user anonymous at ftp.ibminc.net
#& Connected to testcase.boulder.ibm.com.
#& 220-IBM's internal systems must only be used for conducting IBM's
#& 220-business or for purposes authorized by IBM management.
#& 220-
#& 220-Use is subject to audit at any time by IBM management.
#& 220-
#& 220-Before using this service for technical support purposes, refer
#& 220-to the terms of use for Exchanging Diagnostic Data with IBM
#& 220-(see http://www.ibm.com/de/support/ecurep/service.html).
#& 220-
#& 220-Important changes are coming on May 24, 2018 due to GDPR
#& 220-see http://public.dhe.ibm.com/SupportFileTransferDetails.html
#& 220-
#& 220 testcase-yellow secure FTP server ready.
#& 331 Password required for anonymous.
#& 230 virtual user anonymous logged in from /96.69.172.233:44655.
#& 200 Type set to I.
#& Interactive mode off.
#& 250 CWD command successful.
#& 200 PORT command successful.
#& 150 Opening BINARY mode data connection for MPG.Inc.Randy.pninfo.AIX720.AIX.tar.gz.
#& 226 Transfer complete.
#& 7277844 bytes sent in 2.472 seconds (2875 Kbytes/s)
#& local: pninfo.AIX720.AIX.tar.gz remote: MPG.Inc.Randy.pninfo.AIX720.AIX.tar.gz
#& 200 PORT command successful.
#& 150 Opening ASCII mode data connection for file list.
#& total 0
#& 226 Transfer complete.
#& 221 Goodbye.
#& #
