#!/bin/ksh
#!/bin/ksh -xv
#
# $Id: send2helpsys_sftp.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#& If prompted about authenticity, answer yes and press return 
#& When prompted for password, answer powernav and press return
#&
#@ Requires sftp command and access to ftp.mpginc.net 
#&
#&& Automatically sends the pninfo file from /usr/local/mpg if no filename is 
#&& specified to Help Systems
#&& If a filename is specified, then it will send that filename.
#&& Note: Can be used do send any file including a pninfo_topas file.
#&
# Minor change for push 

echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
echo ""
echo "If prompted about authenticity, answer yes and press return"
echo ""
echo "When prompted for password, answer (powernav) and press return"
echo ""

if [ "x${1}x" != "xx" ];then
   jpninfofilename=$1
else
   cd /usr/local/mpg
fi

if [ "x${jpninfofilename}x" = "xx" ];then
   jpninfofilename=`ls -1 pninfo*|grep -v topas` 
fi
echo mput ${jpninfofilename} | sftp -oPort=2202  scapplan@ftp.mpginc.net
echo ""
echo "Please send email to support.mpginc@helpsystems.com with the following subject:"
echo ""
echo "sftp'd ${jpninfofilename} to user scapplan ftp.mpginc.net for HelpSystem "

#& ###################
#& Sample Runs
#& ###################
#& #################
#& No filename specified will send /usr/local/mpg/pninfo.hostname.systemtype.tar.gz
#& #################
#& # ./send2helpsys_sftp.sh
#& Running send2helpsys_sftp.sh,v 1.2 2021/09/29 16:50:24
#& 
#& If prompted about authenticity, answer yes and press return
#& 
#& When prompted for password, answer (powernav) and press return
#& 
#& scapplan@ftp.mpginc.net's password:
#& Connected to ftp.mpginc.net.
#& sftp> mput pninfo.rocky.AIX.tar.gz
#& Uploading pninfo.hostname.systemtype.tar.gz to /home/scapplan/pninfo.rocky.AIX.tar.gz
#& pninfo.hostname.systemtype.tar.gz    100%   14MB   3.0MB/s   00:04
#& 
#& Please send email to support.mpginc@helpsystems.com with the following subject:
#& 
#& sftp'd pninfo.rocky.AIX.tar.gz to user scapplan ftp.mpginc.net for HelpSystem
#& 
#& #################
#& Specifying a filename
#& #################
#& # ./send2helpsys_sftp.sh README
#& Running send2helpsys_sftp.sh,v 1.2 2021/09/29 16:50:24
#& 
#& If prompted about authenticity, answer yes and press return
#& 
#& When prompted for password, answer (powernav) and press return
#& 
#& scapplan@ftp.mpginc.net's password:
#& Connected to ftp.mpginc.net.
#& sftp> mput README
#& Uploading README to /home/scapplan/README
#& README                                                      100%   22KB 111.8KB/s   00:00
#& 
#& Please send email to support.mpginc@helpsystems.com with the following subject:
#& 
#& sftp'd README to user scapplan ftp.mpginc.net for HelpSystem
#& 
#& #################

