# $Id: sar.awk,v 1.1 2023/03/27 21:25:54 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& collect multiple sar outputs into consolidated format
#& expects all data to be from a single day
#& invoke as:  (see sar.sh)
#   export LC_TIME="C" ; sar -<flags> | awk -f sar.awk oslabel=`uname -s`
# NOTES
#  setting LC_TIME="C" ensures the expected date format
#  oslabel=`uname -s` required to allow finding the sar date
#"options":
#  oslabel="whatever"  to override if needed
#  add  debug="T"  for debugging output
#  add  OSEP="c"  to change the field separator character to "c"
#  add  LSEP="c"  to change the multi-line separator character to "c"

##### needs better variable names and more docs/comments
##### need to verify what happens when headers change - and/or data changes (number of devices...)

##### sar -A output still too varied for this
#  ie:
# appends varying number of str's (ie: lo,eth0 later lo,eth0,ppp0)
# does not handle missing "AVERAGE"
#
#  tested "safe" (AIX,Linux) flags are: u r d w c v
#  work on AIX only: y m
#	AIX -q has varying fields (some are blank)
#  work on Linux only: t B q
#  known problem flags: A 
#  other flags are untested...



BEGIN {
 tc = 0;
 hts="not-yet-found";
 reset_flags() ;
	if (debug == "T") { print "sysname:" sysname }
 OSEP = ";" ;	# Field separator - may change on command line
 LSEP = "" ;	# multi-line separator - may change/set on command line
 headers = "sysname=" sysname OSEP "time" ;
	if (debug == "T") { print "oslabel:" oslabel }
## get header translation table
 while( getline <"sar-header-trans" >= 1 ) {
	if (debug == "T") { print "htt: " $4 " " $3 " " $1 " " $2 }
   if ( $4 == oslabel ) {
     htt[$1] = $2
#	if (debug == "T") { print "	htt:" $1 " = " htt[$1] ", " $3 ", " $4 }
	if (debug == "T") { print "	htt:" $1 " = " htt[$1] }
   }
 }
}


/sarlabel:/ {
 sarlabel = LSEP OSEP "##" $2 "##" LSEP;
	if (debug == "T") {
	printf("\nsarlabel found: "); print sarlabel;
	}
 needheaders="T";
}


/linelabel:/ {
 linelabel = OSEP $2;
	if (debug == "T") {
	printf("\nlinelabel found: "); print linelabel;
	}
# needheaders="T"; # not needed?
}

## find the sar header line with the date
$1 == oslabel {
 sardate = $NF;
 split(sardate,dateparts,"/");
 DATE = dateparts[3] dateparts[1] dateparts[2] ;
 if ( length(dateparts[3]) == 2 ) { DATE = "20" DATE ; }
	if (debug == "T") {
	printf("\noslabel found:"); print ;
	print "DATE=" DATE ", dateparts=" dateparts[1] "," dateparts[2] "," dateparts[3] ;
	}
 if ( sarlabel == "" ) { sarlabel = LSEP ; }
}


## look for headers - do not save headers in data arrays
# (this just grabs the first timestamped line as the headers and moves on)
$1 ~ /^[0-9][0-9]:[0-9][0-9]:[0-9][0-9]/ && needheaders == "T" {
 new_headers() ;
 next
}


## this finds header lines by matching the timestamp (after the first one)
## allows handling flags with no average like AIX sar -v
$1 == hts {
	if (debug == "T" ) {  print "FOUND TS = HTS:" ; print ; }
 sar_section_done() ;
 new_headers() ;
 next
}


## lines starting with a timestamp are the data we want
$1 ~ /^[0-9][0-9]:[0-9][0-9]:[0-9][0-9]/  && collecting == "T" {
 	nocollect = "F" ; ## TEST
 # May need to comment out the next three lines on HP-UX sar -MPq causes error,
 # but prints correctly 
 # if (NF != nhf) {
 #    print "field count mismatch: found " NF ", expected " nhf ;
 # }
## check for "extra" header lines
 qhs = ""
 for ( i=2; i<=NF; i++ ) { qhs = qhs OSEP $i ; }
 if (qhs == uths) {
	if (debug == "T") { print "discarded extra header" }
   next
 }

 to=$1
 split( to, ta, /:/ )
 ts = ta[1] ta[2] ta[3] ;
 t = DATE ts ;
	if ( debug == "T" ) {
	  print "to=" to ", ts=" ts ", ta[1]=" ta[1] ", ta[2]=" ta[2] ", ta[3] = " ta[3]; 
	}
# str = "" ; for ( i=2; i<=NF; i++ ) { str = str OSEP $i ; }
 str = linelabel ; for ( i=2; i<=NF; i++ ) { str = str OSEP $i ; }

## Linux multi-line (has timestamp)
 if ( t == prevtime ) {
  data[t] = data[t] LSEP str ;
  nt++; if ( nt > maxnt ) maxnt = nt ;
	if (debug == "T" ) { print "c:" c " " t str ; }
 } else {
## "normal" line (or first of multi-line)
  c++
   if (ot[c] == "") {
     ot[c] = t
   } else { 
     if ( ot[c] != t ) { print "TIME MISMATCH: " t " : " ot[c]  }
   }
  data[t] = data[t] sarlabel str ;
 }
	if (debug == "T" ) { print "c:" c " " t str ; }
 prevtime = t
 nt=1
}

## AIX multi-line (no timestamp on line)
$0 ~ /^        /  && collecting == "T" {
	if ( nocollect == "T" ) { next }  ## TEST # in Average section - skip
  str = linelabel ; for ( i=1; i<=NF; i++ ) { str = str OSEP $i ; }
  data[t] = data[t] LSEP str ;
  nt++; if ( nt > maxnt ) maxnt = nt ;
	if (debug == "T" ) { print "c:" c " " t str ; }
}


##### do not collect averages
/Average/	{
	if (debug == "T" ) {  print "FOUND AVERAGE:" ; print ; }
	if ( needheaders == "T" ) { next }	# short circuit on multi-line
  sar_section_done() ; ###still needed here ?
	nocollect = "T" ; ## TEST # set until next timestamp (or end of section)
}


END {
  if ( collecting == "T" ) { sar_section_done() }
	if (debug == "T") { print "\ndata from data:" }
 print headers ;
 for ( i=1 ; i<=tc ; i++ ) {
  t = ot[i];  print t data[t] ;
 }

}


function new_headers() {
 needheaders = "F";
 nhf = NF;
 hts = $1;
## save the unmodified headers
 for ( i=2; i<=NF; i++ ) { uths = uths OSEP $i ; }
## do header translation
 for ( i=2; i<=NF; i++ ) { if ( $i in htt ) { $i = htt[$i] } }
 for ( i=2; i<=NF; i++ ) { hs = hs OSEP $i ; }
	if (debug == "T" ) { printf( "\nFOUND HEADERS:" ) ; print ; print hs ;
	  print "DATE=" DATE ;
	}
 collecting = "T";
 if ( sarlabel == "" ) { sarlabel = LSEP ; }
}


function sar_section_done() {
 for ( i=1; i<=maxnt; i++ ) { headers = headers sarlabel hs ; sarlabel=LSEP; }
 if ( tc == 0 ) { tc = c }
 if ( tc != c ) {
   print " TIME COUNT MISMATCH !!! "
   if ( c > tc ) { tc = c }	# just keep the larger if mismatch occurs (should not!)
 }
 collecting = "F"
 reset_flags() ;
}


function reset_flags() {
 needheaders = "T" ;
 c=0 ;
 nt=0 ;
 maxnt=1 ;
 hs = "" ;
 uths = "" ;
 h1 = "";
 sarlabel="";
 linelabel="";
}

