#!/bin/ksh
#
# $Id: reseq_mult_mpgd2_files.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Resequence multiple mpgdata2 files if many in the build process are out 
#&& of date sequence(reseq_mult_mpgd2_files.sh)
#&
#& This is not intended to be ran all the time, but only if needed.
#& It will automatically run pndchk.sh on each mpgdata2 file and delete any
#& temporary files. 
#&
#& It may take significant time to run on many files.
#
# Resequence a group of mpgdata2 files
for jmpgfile in `ls -1tr mpgdata2.*`
do
   ./pndchk.sh ${jmpgfile}
   if [ -s ${jmpgfile} ] && [ -s ${jmpgfile}.sorted ]; then
      mv ${jmpgfile}.sorted ${jmpgfile} 
   fi
   rm ${jmpgfile}.d[a,v,u]* ${jmpgfile}.tim* 
done
#
#
#
