#!/bin/ksh
#!/bin/ksh -xv
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
# $Id: rd_disk_type_sort.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
#&& Disk type and size from rackdata files sorted into a file
#
#& General comment
#
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` " | tee /tmp/helpsystems_tmp/rackdata_disk_type_sort.hsllc
echo ""
echo "Analyzing disk-types-sizes of rackdatas in $PWD" | tee -a /tmp/helpsystems_tmp/rackdata_disk_type_sort.hsllc
mkdir -p /tmp/helpsystems_tmp
ls -1 rackdata.* > /tmp/helpsystems_tmp/rackdata.hsllc
while 
read jrdfile
do
    echo "${jrdfile}"
    grep " type: " ${jrdfile} | cut -d " " -f -4- | sort -n +3 +8 | uniq -c
done  <  /tmp/helpsystems_tmp/rackdata.hsllc >> /tmp/helpsystems_tmp/rackdata_disk_type_sort.hsllc
echo ""
echo "( more /tmp/helpsystems_tmp/rackdata_disk_type_sort.hsllc )"
echo ""
echo "( mailfile /tmp/helpsystems_tmp/rackdata_disk_type_sort.hsllc )"

#& 
#& Running rackdata_disk_type_sort.sh,v 1.2 2018/07/09 19:38:37
#& 
#& Analyzing disk-types-sizes of rackdatas in /nmondata/Randstad/20180706/Randy
#& 
#& ( more /tmp/helpsystems_tmp/rackdata_disk_type_sort.hsllc )
#& 
#& ( mailfile /tmp/helpsystems_tmp/rackdata_disk_type_sort.hsllc )
#& 
