#!/bin/ksh
#!/bin/ksh -xv    
#
# $Id: rackdata.sh,v 1.4 2024/06/05 16:26:28 root Exp root $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#& If rackdata.sh is ran/downloaded idependently, please run:
#& (chmod 744 rackdata.sh)
#& (ls -al rackdata.sh) 
#& -rwxr--r--   1 root   system   ##### MMM DD hh:mm rackdata.sh
#&
#&& rackdata.sh creates a file rackdata.(uname -n | awk -F. '{print $1}') with system information.
#& A continuous df -k or bdf of disk data is gathered daily or whenever it it ran.
#&
#& -D option will add outputs to the screen
#
#&@ df.hostname is used to gather history of disk space  
#
#&% If the df.(uname -n | awk -F. '{print $1}') file does not exist, only the present data is gathered 
#&% Ran daily in crontab
#
#

mkdir -p /tmp/helpsystems_tmp/HSdata_topas
rm -f /tmp/rackdata_* /tmp/sissas.tmp /tmp/pn_chart_*.tmp  
rm -f /tmp/pnadcp_running.tmp /tmp/chk_global.tmp
rm -f /tmp/transfer_topas_rackdata.tar /tmp/transfer_topas_rackdata.tar.gz
rm -f /tmp/pnbuild.tar /tmp/pnbuild.tar.gz tmp/rackdata.tar /tmp/rackdata.tar.gz
rm -f /tmp/jtest.tmp /tmp/virsh_test.tmp /tmp/cpu_min_cur_max_gov.tmp
rm -rf /tmp/test_pnbuild_new /tmp/test_pnbuild_ori
rm -rf /tmp/test_transfer_topas_rackdata_new /tmp/test_transfer_topas_rackdata_ori

jdirectory=`pwd`

invocdir=`dirname $0`

if [ "x${invocdir}x" == 'x.x' ]; then
   invocdir=`pwd`
fi

jscript_name=`basename $0`
# echo ${jscript_name}
if [ -s $invocdir/pndcutils.sh ]; then
      . $invocdir/pndcutils.sh
fi


jstartdir=`pwd`
# echo "Remove later ($jstartdir)"


jscript_name=`basename $0`
# echo ${jscript_name}
if [ -s $invocdir/pndcutils.sh ]; then
   . $invocdir/pndcutils.sh
fi

# copy last rackdata.hostname to /tmp/helpsystems_tmp for -T option    
jsysname=`uname -n | awk -F. '{print $1}'`
if [ -s ${invocdir}/rackdata.${jsysname} ] ; then
   cp ${invocdir}/rackdata.${jsysname} /tmp/helpsystems_tmp
fi

if [ -s $invocdir/pn.config ];  then
   . $invocdir/pn.config
fi

# Added to see if a sorted file exists and it 24+ hours old then remove it.
if [ -s ${datafile}.sorted ] && [ -s ${rackfile} ]; then
   find ${datafile}.sorted -newer ${rackfile} 2>&1 > /tmp/helpsystems_tmp/mpg2_sort_test.tmp
   if [ -s /tmp/helpsystems_tmp/mpg2_sort_test.tmp ] ; then
      rm -f ${datafile}.sorted
   fi
fi

# Three new environmental variables
# installdir
# mpgdatadir
# nmondatadir

# installdir should be defined, but if not use invocdir
if [ -z "$installdir" ] ; then
   installdir=$invocdir
fi

# mpgdatadir should be defined, but if not use invocdir
if [ -z "$mpgdatadir" ] ; then
   mpgdatadir=$invocdir
fi

# nmondatadir should be defined, but if not use invocdir
if [ -z "$nmondatadir" ] ; then
   nmondatadir=$invocdir
fi

PATH=$PATH:/sbin

dateformat=`date '+%d-%b-%C%y'`
jdate=`date +%Y%m%d_%H%M`

if [ -s $invocdir/change_pn.sh ];  then
   $invocdir/change_pn.sh -s > pn_status_detail.hsllc
   cat pn_status_detail.hsllc \
      | egrep "ystart_time|:$|Version|====|Install/Da"\
      | grep -v Entr > pn_status.hsllc
fi

lscfg -v 2>/dev/null | sed s,^\ \ *,, | sed s,\ \ *,\ ,g > lscfg-v.hsllc  
lscfg  2>/dev/null  | sed s/\ \ \ \ \ \ */,/g | sed s/\ /,/   > lscfg.hsllc
grep sissas lscfg.hsllc | awk -F, '{print $2}'> /tmp/helpsystems_tmp/sissas.tmp

# /tmp/helpsystems_tmp/rackdata_debug.tmp used to temporarily store debug messages for the screen.
rm -f /tmp/helpsystems_tmp/rackdata_debug.tmp
touch /tmp/helpsystems_tmp/rackdata_debug.tmp



build_html () { 
   html_file=${1}
   html_host=${2}
   rm -f ${html_file}.html
   # echo "Building html file (${html_file})"
   echo '<HTML>' > ${html_file}.html
   echo '<HEAD> <TITLE>topaschart</TITLE> </HEAD>' >> ${html_file}.html
   echo '<BODY>' >> ${html_file}.html
   echo '<P align=LEFT>' >> ${html_file}.html
   echo '<STRONG><font size="6" color="blue">(c) Copyright Fortra, LLC. and its group of companies.</font><BR>' >> ${html_file}.html
   echo "<BR><font size=\"5\">${html_host} topaschart files created by (rackdata.sh -T)</font></STRONG><BR>" >> ${html_file}.html
   echo '<img src="http://www.fortra.com/images/CirclesSignMar2016.jpg" width="400" alt="mpglogo">' >> ${html_file}.html
   echo '<BR>Select <A HREF= "http://nmon.sourceforge.net/pmwiki.php?n=Main.HomePage" >Info on nmon</A>' >> ${html_file}.html
   echo '<BR>Select <A HREF= "http://nmon.sourceforge.net/pmwiki.php?n=Site.Nmonchart" >Info on nmonchart</A>' >> ${html_file}.html
   echo '<BR>Select <A HREF= "http://nmon.sourceforge.net/pmwiki.php?n=Site.TOPASchart" >Info on topaschart</A>' >> ${html_file}.html
   echo '' >> ${html_file}.html
   echo '' >> ${html_file}.html
   echo '<BR>Select <A HREF= "http://www.fortra.com/pownavlinux.html" >FREE powernavigator data collector</A> to obtain the most recent copy.</A>' >> ${html_file}.html
   echo '<BR>Select <A HREF= "ftp://anonymous@96.69.172.229/powernav.tar.gz" >ftp powernav.tar.gz file</A> to obtain the most recent copy.</A>' >> ${html_file}.html
   echo '<BR>Select <A HREF= "ftp://anonymous@96.69.172.229" >ftp from fortra.com</A> to obtain the most recent copy of other scripts, applications or documents.</A>' >> ${html_file}.html
   echo '<P><STRONG>Performance Navigator Support </STRONG><BR>' >> ${html_file}.html
   echo '<A HREF= "http://www.fortra.com/" >http://www.fortra.com</A><BR>' >> ${html_file}.html
   echo '<BR>Email: <A HREF="mailto:support@helpsystems.com">support@helpsystems.com</A> <BR><BR>' >> ${html_file}.html
   echo '' >> ${html_file}.html
   echo '' >> ${html_file}.html

   for jfile in `ls -1 *topas.csv`
   do
      echo "<A HREF= \"${jfile}.html\" >${jfile}</A><BR>" >> ${html_file}.html
   done

   echo '' >> ${html_file}.html
   echo '</BODY>' >> ${html_file}.html
   echo '</HTML>' >> ${html_file}.html
   # End of build_html 
}

get_topas_data_proc () {
   # Begin of get_topas_data_proc used in get_topas_data.sh and "rackdata.sh -T"
   jscript_name=`basename $0`
   jdate=`date '+%Y%m%d_%H%M'`
   jsysname=`uname -n | awk -F. '{print $1}'`
   # echo "Remove later () "; exit
   if [ "xTx" = "x${get_topas_data}x" ] || [ ! -s mpgdata2.${jsysname} ] ; then
      # This is a where new get_topas_data.sh to rackdata.sh starts 
      # Try to find out where the data for topasrec is currently if running.
      topasrec_dir=`ps -ef | egrep "\/topasrec" | grep -v "egrep" | sed s,^..*\-o\ ,, | awk '{print $1}'`
      # echo "Remove later 1"; topasrec_dir=""
      
      if [ "xx" == "x${topasrec_dir}x" ]; then
         # Try to find out where the data may have been if not running.
         echo "Found topasrec is NOT currently running!"
         if [ -s /etc/inittab ]; then
            topasrec_dir=`grep "\/topasrec" /etc/inittab | grep -v "egrep" | sed s,^..*\-o\ ,, | awk '{print $1}'`
         fi
      # echo "Remove later 2"; topasrec_dir="" 
         if [ "xx" != "x${topasrec_dir}x" ]; then
            echo "Found topasrec had been running periodically in directory "
            echo "(${topasrec_dir}) previously"
   else
      for jjdir in /var/perf/daily/  /etc/perf/daily/  /home/ios/perf/topas/
      do
	 topasrec_dir=${jjdir}
	 if [ -d ${topasrec_dir} ] ; then
            echo "topasrec is not running but may have been previously in directory"
            echo "(${topasrec_dir})"
	    break
	 else
	    topasrec_dir=""
	 fi
      done
         fi
      else
         echo "Found topasrec is running periodically in directory"
         echo "(${topasrec_dir})"
         # If rackdata.sh is running, copy rackdata.hostname to /tmp/helpsystems_tmp 
         if [ "x${jscript_name}x" = "xrackdata.shx" ] ; then
            cp rackdata.${jsysname} /tmp/helpsystems_tmp 
         fi
      fi


      # Check the status of topasrec
      rm -f /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo 'ps -ef | grep "\/topasrec"' >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      ps -ef | grep "\/topasrec" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo 'grep "\/topasrec" /etc/inittab' >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      if [ -s /etc/inittab ] ; then
         grep "\/topasrec" /etc/inittab >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      else
         echo "file /etc/inittab does not exist"
      fi
      echo "" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo 'crontab -l | grep "\/pmcfg"' >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      crontab -l | grep "\/pmcfg" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      # Keep from running if not on  AIX systems with daily topas files #
      if [ ! -d ${topasrec_dir} ] ; then
         echo "### This can only be used on AIX systems with topas!! ### " 
         echo "### This can only be used on AIX systems with topas!! ### " >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      else
         echo "Identified a directory for topas"
      fi
      # cat /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      # End of Check the status of topasrec
   
   
      echo "# Gathering topas data!"
      mkdir -p /tmp/helpsystems_tmp/HSdata_topas
      tar -cvf /tmp/helpsystems_tmp/HSdata_topas/mpgTSinfo_${jsysname}.tar pn.config pnadcp.config pnedcp.config *.mpg *.hsllc *.inf 2> /dev/null  > /dev/null
      cd /tmp/helpsystems_tmp/HSdata_topas
      rm -f /tmp/helpsystems_tmp/HSdata_topas/*.csv
      rm -f /tmp/helpsystems_tmp/HSdata_topas.${jsysname}
      # for jfile in `ls -1tr /etc/perf/daily/${jsysname}*topas`
      # Add check for topas files in the topas directory.
      ls -1tr ${topasrec_dir}${jsysname}*topas 2>/dev/null > /tmp/helpsystems_tmp/ls-1tr_test.tmp
      if [ -s /tmp/helpsystems_tmp/ls-1tr_test.tmp ]; then
         echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
         echo 'cat /tmp/helpsystems_tmp/ls-1tr_test.tmp' >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
         echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
         cat /tmp/helpsystems_tmp/ls-1tr_test.tmp >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
         rm -f /tmp/helpsystems_tmp/ls-1tr_test.tmp
      else
         echo "# There are no topas files to process "
         echo "# There are no topas files to process " >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      fi

      for jfile in `ls -1tr ${topasrec_dir}${jsysname}*topas`
      do
         # Option that allows nmon type output
         topasout -a ${jfile}
         touch -r ${jfile} ${jfile}.csv
         echo  "# HSdata_topas ${jfile}.csv " >> /tmp/helpsystems_tmp/mpgdata2_topas.${jsysname}
         grep ^AAA,  ${jfile}.csv >> /tmp/helpsystems_tmp/mpgdata2_topas.${jsysname}
         grep -v ^AAA,  ${jfile}.csv >> /tmp/helpsystems_tmp/mpgdata2_topas.${jsysname}
      done

      mv ${topasrec_dir}${jsysname}*csv .
      
      for jfile in `ls -1 *topas.csv`
      do
	 jhost=`grep ,host, ${jfile} | awk -F, '{print $3}'`
      done

      japptest="topaschart"
      okapp=""
      jappavail=`${jstartdir}/$japptest 2>&1 > /dev/null`
      # jtest=`echo $?`
      # echo $jtest
      # If not on path see if available on current path then invocdir.
      if [ $jtest -eq 0 ]; then
         okapp=${jstartdir}/$japptest 
      else
	 jappavail=`${jstartdir}/$japptest 2>&1 > /dev/null`
	 jtest=`echo $?`
	 # echo $jtest $PWD
	 if [ $jtest -eq 0 ]; then
	    okapp="$j{startdir}/$japptest"
         else 
            jappavail=`./$japptest 2>&1 > /dev/null`
            jtest=`echo $?`
	    if [ $jtest -eq 0 ]; then
	       okapp="./$japptest"
            fi
	 fi
      fi

      echo $okapp
      if [ "x${okapp}x" != "xx" ] && [ `$juname -s` = "AIX" ] ; then
         # echo "Removing later. Using ($okapp)" # Addback for testing
         cd /tmp/helpsystems_tmp/HSdata_topas

         ## pwd > /tmp/rackdata.testing
         ## set >> /tmp/rackdata.testing
         ## echo "okapp($okapp)"
 
         for jfile in `ls -1 *topas.csv`
         do
            jhost=`grep ,host, ${jfile} | awk -F, '{print $3}'`
            $okapp ${jfile} ${jfile}.html
            touch -r ${jfile} ${jfile}.html # Allows for original timestamp
         done

         build_html mpg_${jhost}_tchart_rackdata ${jhost}

         # Move the topas charts into tchart.tar.gz then remove html files  
         tar -cf - *.html | gzip -c > tchart_${jhost}.tar.gz 
         rm -f *html
         # remove earlier tchart.tar.gz without a hostname
         rm -f tchart.tar.gz

      # else
      #    echo "Unable to find ($okapp), will not be running topaschart"
      fi


      cd /tmp/helpsystems_tmp
      # If proc is used in rackdata.sh use first half else get_topas_data.sh 
      # Next line is for rackdata.sh 
      if [ "x${jscript_name}x" = "xrackdata.shx" ] ; then
         tar -cvf /tmp/helpsystems_tmp/pninfo_topas_${jsysname}_${jdate}.tar HSdata_topas mpgdata2_topas.${jsysname} topasrec_status.${jsysname} rackdata.${jsysname}
         gzip  -f /tmp/helpsystems_tmp/pninfo_topas_${jsysname}_${jdate}.tar 
         echo "Please send  /tmp/helpsystems_tmp/pninfo_topas_${jsysname}_${jdate}.tar.gz"
         cp  /tmp/helpsystems_tmp/pninfo_topas_${jsysname}_${jdate}.tar.gz ${jdirectory}
	 echo "Send this file to your service or business provider."
      else
         tar cvf /tmp/helpsystems_tmp/HSdata_topas_${jsysname}_${jdate}.tar HSdata_topas mpgdata2_topas.${jsysname} topasrec_status.${jsysname} rackdata.${jsysname}
         gzip  -f /tmp/helpsystems_tmp/HSdata_topas_${jsysname}_${jdate}.tar 
         echo "Please send  /tmp/helpsystems_tmp/HSdata_topas_${jsysname}_${jdate}.tar.gz"
	 echo "Send this file to your service or business provider."
      fi


      # This is a new get_topas_data
   fi
   # End of get_topas_data_proc
}

locate_app () {
   # Identify locations of applications 
   # Matt identified need for next line; Thanks!
   jloc=''  
   # HP-UX  required the grep "^no "
   # Check normal bin sbin directories for application
   for jdirs in /bin/ /sbin/ /usr/bin/ /usr/sbin/ /usr/local/bin/ /usr/local/sbin/ /usr/contrib/bin/ /usr/contrib/sbin/ /opt/hpvm/bin/ ${jsolaris_sbin}
   do 
      if [ -x ${jdirs}${1} ]; then
         jloc="${jdirs}${1}"
         break
      fi 
   done
   if [ "x${jloc}x" != "xx" ]; then
      export jloc  
      return 0
   else
      jloc=`which $1 2>/dev/null | grep -v "^no "`
      if [ "x${jloc}x" != "xx" ]; then
         export jloc  
         return 0
      else
         export jloc  
         return 1
      fi
   fi
}

disk_info () {
   ### Beginning of disk gathering information disk_info
   ### Disk information originally for AIX. 
   ### Setting up for linux solaris hpux 
   ### get disk info (number, name, type, and sizes)
   locate_app powermt
   jpowermt=$jloc
   if [ "xx" != "x${jpowermt}x" ] ; then
      if [ `$juname -s` = "AIX" ] ; then
         # ###############
         # AIX - hdiskpower#
         # ###############
         $jpowermt display dev=all 2>/dev/null \
            | egrep -v "unknown|dead" \
            | sed '/./,/^$/!d' \
            | sed "s/=/ /"  \
            | awk '/^Pseudo/ {printf substr($3,11)" "$3" "} /active/{printf $3" "}/^$/' > /tmp/helpsystems_tmp/rackdata_powermt.tmp
         while
         read jline
         do
            jpseudo=`echo $jline | awk '{print $1}'`
            jpseudo2=`echo $jline | awk '{print $2}'`
            echo "$jline" \
               | cut -d" " -f3- \
               | tr " " "\n" \
               | sed "s/hdisk/_/g" \
               | sort -t_ -k1n -k2n -k3n -k4n \
               | sed "s/_/hdisk/" \
               | tr "\n" " " \
               | awk -v jpse=$jpseudo -v jpse2=$jpseudo2 '{print jpse, jpse2, $0}'
         done < /tmp/helpsystems_tmp/rackdata_powermt.tmp \
            | sort -n \
            | cut -d" " -f2- > ${installdir}/powermt.hsllc
         cat ${installdir}/powermt.hsllc 2>/dev/null \
            | awk '{if( NF != 0 )print $1, NF-1}' > ${installdir}/powermt_paths.hsllc
      elif [ `$juname -s` = "HP-UX" ] ; then
         # ############
         # HPUX without pseudoname
         # ############
         $jpowermt display dev=all 2>/dev/null \
            | egrep -v "unknown|dead" \
            | sed '/./,/^$/!d' \
            | awk '/^$/ {print} /active/{printf " " $3}  ' > /tmp/helpsystems_tmp/rackdata_powermt.tmp
         while
         read jline
         do
           echo "$jline" \
             | tr " " "\n" \
             | sed "s/[a-z]/_/g" \
             | sort -t_ -k1n -k2n -k3n -k4n \
             | sed s/_/c/ \
             | sed s/_/t/ \
             | sed s/_/d/ \
             | tr "\n" " "
           echo ""
         done < /tmp/helpsystems_tmp/rackdata_powermt.tmp \
            | grep -v "^\ *$" \
            | awk '{print $0}' \
            | sed s,c,_, \
            | sed s,t,_, \
            | sed s,d,_, \
            | sort -t_ -k1n -k2n -k3n -k4n \
            | sed s,_,c, \
            | sed s,_,t, \
            | sed s,_,d, \
            | awk '{print $1,$0}' > ${installdir}/powermt.hsllc
         cat ${installdir}/powermt.hsllc 2>/dev/null \
            | awk '{if( NF != 0 )print "/dev/rmt/"$1, NF-1}' > ${installdir}/powermt_paths.hsllc
	    # Added the /dev/rmt so diskinfo would work.

      elif [ `$juname -s` = "Linux" ]  ; then
         # ###############
         # Linux - emcdisk[a-z]
         # ###############
         $jpowermt display dev=all 2>/dev/null \
            | egrep -v "unknown|dead" \
            | sed '/./,/^$/!d' \
            | sed "s/=/ /"  \
            | awk '/^Pseudo/ {printf substr($3,9)" "$3" "} /active/{printf $(NF-6)" "}/^$/' > /tmp/helpsystems_tmp/rackdata_powermt.tmp
         while
         read jline
         do
            jpseudo=`echo $jline | awk '{print $1}'`
            jpseudo2=`echo $jline | awk '{print $2}'`
            echo "$jline" \
               | cut -d" " -f3- \
               | tr " " "\n" \
               | sed "s/hdisk/_/g" \
               | sort -t_ -k1n -k2n -k3n -k4n \
               | sed "s/_/hdisk/" \
               | tr "\n" " " \
               | awk -v jpse=$jpseudo -v jpse2=$jpseudo2 '{print jpse, jpse2, $0}'
         done < /tmp/helpsystems_tmp/rackdata_powermt.tmp \
            | sort -n \
            | cut -d" " -f2- > ${installdir}/powermt.hsllc
         cat ${installdir}/powermt.hsllc 2>/dev/null \
            | awk '{if( NF != 0 )print $1, NF-1}' > ${installdir}/powermt_paths.hsllc
      elif [ `$juname -s` = "Darwin" ]  ; then
         diskutil list | grep dev  | awk '{print $1,1}' > darwin_paths.hsllc
      elif [ `$juname -s` = "SunOS" ]  ; then
         # ########
         # solaris emcpower#a
         # ########
         $jpowermt display dev=all 2>/dev/null \
            | egrep -v "unknown|dead" \
            | sed '/./,/^$/!d' \
            | sed "s/=/ /"  \
            | awk '/^Pseudo/ {printf substr($3,9)" "$3" "} /active/{printf $3" "}/^$/' > /tmp/helpsystems_tmp/rackdata_powermt.tmp
         while
         read jline
         do
            jpseudo=`echo $jline | awk '{print $1}'`
            jpseudo2=`echo $jline | awk '{print $2}'`
            echo "$jline" \
               | cut -d" " -f3- \
               | tr " " "\n" \
               | sed "s/[a-z]/_/g" \
               | sort -t_ -k1n -k2n -k3n -k4n -k5n \
               | sed s,_,c, \
               | sed s,_,t, \
               | sed s,_,d, \
               | sed s,_,s, \
               | tr "\n" " " \
               | awk -v jpse=$jpseudo -v jpse2=$jpseudo2 '{print jpse, jpse2, $0}'
         done < /tmp/helpsystems_tmp/rackdata_powermt.tmp \
            | sort -n \
            | cut -d" " -f2- > ${installdir}/powermt.hsllc
         cat ${installdir}/powermt.hsllc 2>/dev/null \
            | awk '{if( NF != 0 )print $1, NF-1}' > ${installdir}/powermt_paths.hsllc

      # For use with Unexpected OS ?? 
      # elif [ `$juname -s` = "NewOS" ]  ; then
      fi
   fi

   # # echo $OStype

   if [ "$OStype" = "HP-UX" ] ; then
      locate_app ioscan
      jioscan=$jloc
      ${jioscan} -funC disk \
         | awk '/rdsk/ {print $1"\n"$2"\n"$3}' \
         | grep rdsk \
         | grep -v "s[0-9]" \
         | while read vRdisk
           do
              print ${vRdisk} 1
           done > ${installdir}/ioscan_rdsk_paths.hsllc
      # If both powermt and ioscan_rdsk_paths have space, create a uniq list 
      # of all paths from powermt.  Trim ioscan_rdsk_paths to not include items 
      # that are uniq and listed powermt.  powermt_paths will only list 
      # the first path in multipath situations and the path count.
      if [ -s ${installdir}/powermt.hsllc ] && [ -s ${installdir}/ioscan_rdsk_paths.hsllc ] ; then
	  # Remove items from ioscan_rdsk_paths that are already in powermt.
	  # This will only leave items that are not listed in the ioscan_rdsk_paths.
	  # This may mean that it is back to a zero byte file.
	  # ioscan_rdsk_paths_hold is the file before it is trimmed.
	  for jpath in `cat ${installdir}/powermt.hsllc `
	  do
	     echo $jpath
	  done | sort | uniq > ${installdir}/powermt_uniq.hsllc
	  mv ${installdir}/ioscan_rdsk_paths.hsllc ${installdir}/ioscan_rdsk_paths_hold.hsllc 
         egrep -vw -f ${installdir}/powermt_uniq.hsllc ${installdir}/ioscan_rdsk_paths_hold.hsllc > ${installdir}/ioscan_rdsk_paths.hsllc

         # If there are colons ":" in the data, 
         # the -f option in grep did not work.
         # So redo grep -vw one grep at a time.
         grep ':' ${installdir}/ioscan_rdsk_paths.hsllc >/dev/null
         greptest=$?
         if [ ${greptest} -eq 0 ]; then
	     # First return ioscan_rdsk_paths_hold to ioscan_rdsk_paths
            cp ${installdir}/ioscan_rdsk_paths_hold.hsllc ${installdir}/ioscan_rdsk_paths.hsllc
            cat ${installdir}/powermt_uniq.hsllc | while
            read jpath
	        do
               cp ${installdir}/ioscan_rdsk_paths.hsllc ${installdir}/ioscan_rdsk_paths_hold2.hsllc
               egrep -vw "${jpath}" ${installdir}/ioscan_rdsk_paths_hold2.hsllc > ${installdir}/ioscan_rdsk_paths.hsllc
            done
         fi
      fi
   fi
  
   if [ "$OStype" = "Linux" ] ; then
      /sbin/fdisk -l 2>/dev/null \
         | grep "^Disk" \
         | grep dev \
         | egrep -v "\/ram[0-9]|\/loop[0-9]" \
         | sed s/://g | sed s/,//g | sed s,bytes..*$,bytes, \
         | awk '{print $2,"1"}' > ${installdir}/fdisk-l_path.hsllc
      # First check if multipath is available and not erroring
      multichk=`multipath 2>/dev/null`
      jchkmult=$?
      if [ $jchkmult -eq 0 ] ;  then 
         multipath -lv 2>/dev/null > multipath_out.hsllc
      fi 
      if [ $jchkmult -eq 0 ] && [ -s multipath_out.hsllc ] ;  then 
         mv ${installdir}/fdisk-l_path.hsllc ${installdir}/fdisk-l_path_ori.hsllc
         multipath -lv 2>/dev/null | tee multipath_out.hsllc  \
            | egrep "policy|running" \
            | paste - -  \
            | sed s,^.*status=,,g \
            | sed s,\|,\ ,  \
            | sed s,\`.*\ sd,\ sd, \
            | awk '{ if( $1 == "active" && NR != 1 ) { print jfirst } if( $1 == "active" )  { jfirst=$2}  if( $1 != "active" )  { jfirst=jfirst" "$2}  } END { print jfirst }' | tee multipath_trimmed.hsllc | awk '{print "/dev/"$1,NF}' | grep -v "^/dev/\ " > multipath_paths.hsllc  
      
         # mpath_1.hsllc is a list of all paths in multipath and needs to be
         # removed first since it is appended.
         rm -f mpath_1.hsllc
      
         for jdev in `cat multipath_trimmed.hsllc` 
         do 
            echo $jdev >> mpath_1.hsllc
         done 

         grep -v -f mpath_1.hsllc ${installdir}/fdisk-l_path_ori.hsllc 2>/dev/null > ${installdir}/fdisk-l_path.hsllc  

         # mpath_1.hsllc needs to be removed after use
         rm -f mpath_1.hsllc
      fi
      if [ -s /bin/lsscsi ] ; then
         lsscsi --scsi_id --size | sort  -k7 | grep dev  >  lsscsi_sorted.hsllc
         cat lsscsi_sorted.hsllc | awk '{print $7}' | uniq -c | sed s,^\ \ *,,g > uniqdisks.hsllc
         while
         read jcnt jww
         do
            grep ${jww} lsscsi_sorted.hsllc | head -1 | awk -v Jcnt=${jcnt} '{print $6,Jcnt}'
         done < uniqdisks.hsllc > lsscsi_paths.hsllc
      fi
   fi
  
   if [ "$OStype" = "AIX" ] ; then
      # for AIX systems only
      # Changes to incorporate mpio
      touch ${installdir}/lspath.hsllc 
      # lspath 2>/dev/null > ${installdir}/lspath.hsllc # Original line
      locate_app lspath
      jlspath=$jloc
      if [ "xx" != "x${jlspath}x" ] ; then
         $jlspath 2>/dev/null \
            | awk '{if(substr($2,1,3) != "dac" && substr($2,1,3) != "ses")print $2,$1,$2,$3}' \
            | sed -e 's,^[a-z][a-z]*,,' \
            | sort -n  \
            | cut -d" " -f2-  > ${installdir}/lspath.hsllc
      fi

      # for AIX systems only
      # Changes to incorporate mpio on non-powerpath drives
      # cat ${installdir}/lspath.hsllc | awk '{print $2, "1"}' > ${installdir}/lspath_paths.hsllc # Original line
      # Do not include Available paths that are not configured. 
      egrep -v "Available|Available" ${installdir}/lspath.hsllc  \
         | awk '{print $2}' \
         | uniq -c \
         | awk '{print $2,$1}' > ${installdir}/lspath_paths.hsllc 

      # for AIX systems only
      # Changes to incorporate lsdev
      touch ${installdir}/lsdev.hsllc 
      locate_app lsdev
      jlsdev=$jloc
      if [ "xx" != "x${jlsdev}x" ] ; then
         $jlsdev -C 2>/dev/null > ${installdir}/lsdev.hsllc
      fi
      # Only include hdisks that are Available 
      egrep "Available|Available" ${installdir}/lsdev.hsllc  \
         | egrep "hdisk|hdisk" \
         | awk '{print $1}' \
         | uniq -c \
         | awk '{print $2,$1}' > ${installdir}/lsdev_paths.hsllc
      # If both lspath_paths.hsllc and lsdev_paths.hsllc have space
      # trim lsdev_paths to not include items that are on lspath_paths
      if [ -s ${installdir}/lsdev_paths.hsllc ] && [ -s ${installdir}/lspath_paths.hsllc  ] ; then
	 # Remove items from lsdev_paths that are already in lspath_paths.
	 # This will only leave items that are not listed in the lspath_paths. 
	 # This may mean that it is back to a zero byte file.
	 # lsdev_paths_hold is the file before it is trimmed. 
         mv ${installdir}/lsdev_paths.hsllc  ${installdir}/lsdev_paths_hold.hsllc 
         awk '{print $1}' ${installdir}/lspath_paths.hsllc > ${installdir}/lspath_disks.hsllc 
	 egrep -vw -f ${installdir}/lspath_disks.hsllc ${installdir}/lsdev_paths_hold.hsllc > ${installdir}/lsdev_paths.hsllc
         if [ -s ${installdir}/powermt.hsllc ]; then
            for jpath in `cat ${installdir}/powermt.hsllc`
	    do
	       echo $jpath
            done | sort > ${installdir}/powermt_uniq.hsllc
            mv ${installdir}/lsdev_paths.hsllc ${installdir}/lsdev_paths_hold2.hsllc
            grep -vw -f ${installdir}/powermt_uniq.hsllc ${installdir}/lsdev_paths_hold2.hsllc > ${installdir}/lsdev_paths.hsllc
         fi
      fi
      # If both powermt and lsdev_paths have space, create a uniq list 
      # of all paths from powermt.  Trim lsdev_paths to not include items 
      # that are uniq and listed in powermt.  powermt_paths will only list 
      # the first path in multipath situations and the path count.
      if [ -s ${installdir}/powermt.hsllc ] && [ -s ${installdir}/lsdev_paths.hsllc ] ; then
	  # Remove items from lsdev_paths that are already in powermt.
	  # This will only leave items that are not listed in the lsdev_paths.
	  # This may mean that it is back to a zero byte file.
	  # lsdev_paths_hold3 is the file before it is trimmed.
	  for jpath in `cat ${installdir}/powermt.hsllc `
	  do
	     echo $jpath
	  done | sort | uniq > ${installdir}/powermt_uniq.hsllc
	  mv ${installdir}/lsdev_paths.hsllc ${installdir}/lsdev_paths_hold3.hsllc 
         egrep -vw -f ${installdir}/powermt_uniq.hsllc ${installdir}/lsdev_paths_hold3.hsllc > ${installdir}/lsdev_paths.hsllc

         # If there are colons ":" in the data, 
         # the -f option in grep did not work.
         # So redo grep -vw one grep at a time.
         grep ':' ${installdir}/lsdev_paths.hsllc >/dev/null
         greptest=$?
         if [ ${greptest} -eq 0 ]; then
	     # First return lsdev_paths_hold3 to lsdev_paths
            cp ${installdir}/lsdev_paths_hold3.hsllc ${installdir}/lsdev_paths.hsllc
            cat ${installdir}/powermt_uniq.hsllc | while
            read jpath
	        do
               cp ${installdir}/lsdev_paths.hsllc ${installdir}/lsdev_paths_hold4.hsllc
               egrep -vw "${jpath}" ${installdir}/lsdev_paths_hold4.hsllc > ${installdir}/lsdev_paths.hsllc
            done
         fi
      fi
   fi

# This section gathers the disks and determines disk sizes 

# Disk information for gathering size	 
# AIX             bootinfo -s hdisk#  	
# FreeBSD         fdisk -v ad0 	
# HP-UX           diskinfo /dev/rdsk/c#t#d# 	
# Linux/RedHat    cat /proc/scsi/scsi0/sda/model 	
# SunOS           format -d c#t#d#
#                 format>current
#                 format>inquiry 	
# Tru64           file /dev/rrz0c
#
# Darwin
# diskutil info /dev/disk0 | egrep  "Disk\ Size:" | awk '{print $3*1024}'
#

   # added limit of 1024 to all_paths
   cat ${installdir}/lspath_paths.hsllc ${installdir}/lsdev_paths.hsllc ${installdir}/ioscan_rdsk_paths.hsllc ${installdir}/powermt_paths.hsllc ${installdir}/fdisk-l_path.hsllc ${installdir}/multipath_paths.hsllc ${installdir}/lsscsi_paths.hsllc ${installdir}/darwin_paths.hsllc 2>/dev/null \
      | sort \
      | egrep -v "mapper|d[bm]-|sd[a-z][0-9]|sd[a-z][a-z][0-9]" \
      | head -1024 > ${installdir}/all_paths.hsllc 
   i=0
   while
   read d jpaths
   do
      unset jdisktype
      unset jdisksize
      if [ "xx" = "x${jdisktype}x" ] && [ "$OStype" = "Darwin" ] ; then
         # Disk type from Darwin
         jdisktype=`diskutil info $d | egrep  "Type:" | awk '{print $3}'` 
      fi
      if [ "xx" = "x${jdisktype}x" ] && [ "$OStype" = "AIX" ] ; then
	 # Formerly used to strip to only the fist part of disk type.
	 # On enterprise customers, it is better to have it all
         # jdisktype=`lsdev -Cc disk -l $d -F description 2>/dev/null | awk '{print $1}' `
         jdisktype=`lsdev -Cc disk -l $d -F description 2>/dev/null `
      fi
      if [ "xx" = "x${jdisktype}x" ] && [ "$OStype" = "HP-UX" ] ; then
         jdisktype=`diskinfo -v ${d} 2>/dev/null | egrep "removable|vendor|product" | awk -F: '{print $2}' | sed s,^\ ,, | paste - - - | awk '{if($NF=="no") print $0}' | sed s,\	,\ ,g | sed s,\ \ *,\_,g | sed s,\_no$,,` 
      fi
      # Determine the disk size, until non-zero
      # Order changed to work better on a Raid Array
      if [ "xx" = "x${jdisksize}x" ] && [ "$OStype" = "Darwin" ] ; then
         # Disk size from Darwin
         jdisksize=`diskutil info $d | egrep  "(Disk|Total)\ Size:" | awk '{print $3*1024}'`
      fi
      if [ "xx" = "x${jdisksize}x" ] ; then
         jdisksize=`lsattr -F value -l $d -a size_in_mb 2>/dev/null`
      fi
      if [ "xx" = "x${jdisksize}x" ] ; then
         if [ "$osv" = "5" ] && [ "$osr" -lt "3" ] ; then
            jdisksize=`lspv $d 2>/dev/null | grep 'TOTAL' | sed s/\(//g | awk '{print $4}' `
         else
            jdisksize=`getconf DISK_SIZE /dev/${d} 2>/dev/null`
         fi
      fi
      if [ "xx" = "x${jdisksize}x" ] && [ "$OStype" = "HP-UX" ] ; then
         jdisksize=`diskinfo -b ${d} 2>/dev/null | awk '{ print $1/1000 }'`
      fi
      if [ "xx" = "x${jdisksize}x" ] && [ "$OStype" = "Linux" ] ; then
         jdisksize=`/sbin/fdisk -l ${d} 2>/dev/null \
            | grep "^Disk" \
            | grep "bytes" \
            | grep dev \
            | sed s/://g| sed s/,//g | sed s,bytes..*$,bytes, \
            | awk '{print $(NF-1)/(1000*1000)}'`    
      fi
      # Added for ppc64le ubuntu
      if [ "xx" = "x${jdisksize}x" ] && [ "$OStype" = "Linux" ] ; then
         /sbin/fdisk -l ${d} 2>/dev/null > /tmp/helpsystems_tmp/fdisk-l_device.tmp 
         jnumcylinders=`grep ^Disk /tmp/helpsystems_tmp/fdisk-l_device.tmp | awk '{print $7}'` 
         jsizecylinders=`grep ^Units /tmp/helpsystems_tmp/fdisk-l_device.tmp | awk '{print $5 * $7}'` 
         # echo ${jnumcylinders} ${jsizecylinders} 
         jdisksize=`echo ${jnumcylinders} ${jsizecylinders} | awk '{print $1 * $2 / (1000* 1000)}'` 
      fi
      # New field in disk info for queue_depth
      if [ "xx" = "x${jqdepth}x" ] && [ "$OStype" = "AIX" ] ; then
         jqdepth=`lsattr -E -l ${d} -a queue_depth  | awk '{print $2}'`
      fi
      if [ "xx" = "x${jdisktype}x" ] && [ "$OStype" = "Linux" ] ; then
         jdisktype=`/usr/sbin/smartctl -a "${d}" 2>/dev/null \
            | egrep "Device:|Product" \
            | awk -F: '{print $2}' \
            | cut -c2-  \
            | sed s,\ Version,, \
            | sed s,\ \ *,\_,g \
	    | sed s,^\_,,g \
	    | sed s,\_$,,g`
            # echo "(${d}) # jack " 
            # echo "(${jdisktype}) # jack " 
      fi

      if [ "xx" = "x${jdisktype}x" ] && [ "$OStype" = "Linux" ] ; then
         locate_app lsscsi 
         jlsscsi="$jloc"
         if [ "xppcx" = "x${jproctype}x" ] || [ "xppc64x" = "x${jproctype}x" ] || [ "xppc64lex" = "x${jproctype}x" ]  ; then
        
             if [ "xx" != "x${jlsscsi}x" ] ; then
                jdisktype=`lsscsi \
                   | grep "${d}" \
                   | sed s,\ \ *,\ ,g \
                   | cut -d" " -f3- \
                   | sed s,\ ,\_, | awk '{print $1}'` 
             else
                echo "# Recommend: Install lsscsi"  >> messages.hsllc
             fi
         fi
      fi
      if [ "xx" = "x${jdisktype}x" ] ; then
         jdisktype="Unknown"
      fi
      if [ "xx" = "x${jqdepth}x" ] ; then
         jqdepth="Unknown"
      fi
      # Added next group to ensure that disks that cannot be read for size
      # are still included.
      if [ "xx" = "x${jdisksize}x" ] ; then
	       jdisksize="Unknown"
      fi
      if [ "xx" != "x${jdisksize}x" ] ; then
         disksize[$i]=$jdisksize
         diskpath[$i]=$jpaths
         diskname[$i]=$d
         disktype[$i]=$jdisktype
         qdepth[$i]=$jqdepth
         disksizedesc[$i]="Size in MB"
         disp_disksize[$i]=": ${disksizedesc[$i]}: ${disksize[$i]}"
         let i=$i+1
         ## The next line replaces the line above and will set i to 0 if i is not
         ## defined.
         # i=`expr "${i-0}" + 1`
      fi
   done < ${installdir}/all_paths.hsllc
   nd=$i
   ## report disk info
   if [ -s messages.hsllc ]; then
      cat messages.hsllc | sort | uniq 
   fi 
   echo ; echo "found $nd disk devices :"
   i=0;
   while [ $i -lt $nd ]
   do
      echo " ${diskname[$i]} : type: ${disktype[$i]} ${disp_disksize[$i]}: paths : ${diskpath[$i]}: qdepth : ${qdepth[$i]}" 
      let i=$i+1
      # The next line replaces the line above and will set i to 0 if i is not
      # defined.
      # i=`expr "${i-0}" + 1`
   done
   ### End of disk gathering information disk_info
}

get_tl_level () {
   # Query for AIX TL level
   OSLV=`oslevel -r | cut -c1-2`
   if (( OSLV >= 53 ))
   then
      tl=`oslevel -s | cut -c9-10`
      tld="Technology Level"
      printf "%22s = %s\n" "$tld" "$tl"
   fi
}

get_lru_file_repage () {
   # Query for AIX TL level
   lrufr=`vmo -L lru_file_repage 2>/dev/null | grep lru_file_repage | awk '{print $2}'`
   if [ "x${lrufr}x" = "xx" ]
   then
      lrufr="NA"
   fi
   lrufrd="lru_file_repage"
   printf "%22s = %s\n" "$lrufrd" "$lrufr"
}

# get rack config info 

locate_app uname
juname="$jloc"

chk_software () {
echo "# Product versions"

   # Ensure gzip binary is installed and report either version or not installed
   jwhich=`which gzip 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
         echo "gzip installed" 
   else
         echo "### gzip not installed ###" 
   fi

   # Ensure gunzip script is installed and report either installed or not installed
   jwhich=`which gunzip 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
         echo "gunzip installed" 
   else
         echo "### gunzip not installed ###" 
   fi

   # git version
   jwhich=`which git 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      git --version 
   fi

   # Ruby version
   jwhich=`which ruby 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      ruby --version 
   fi

   # Python2 version
   jwhich=`which python 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      jversion_python=`python -V 2>&1 | grep "Python "`
      if [ "x${jversion_python}x" != "xx" ]; then
	 echo $jversion_python
      fi
   fi
   
   # Python3 version
   jwhich=`which python3 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      python3 --version  | sed s,Python,Python3,
   fi

   # MongoDb version
   jwhich=`which mongo 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      mongo --version | grep -i mongo 
   fi

   # Caffe version
   jwhich=`which caffe 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      caffe -version 
   fi

   # Docker version
   jwhich=`which docker 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      docker --version 
   fi

   # Spark version
   jwhich=`which spark 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      spark -version | grep Exam | sed s,\ \ *,, | awk '{print "Spark:",$0}'
   fi

   # Samba version
   chk4samba=`ps -ef | grep smbd | grep " 1 " | awk '{print $(NF-3), "-V"}' | grep smbd`
   jversion_samba=`$chk4samba 2>/dev/null` 
   # echo $jversion_samba
   if [ "x${jversion_samba}x" != "xx" ]; then
      echo Samba ${jversion_samba}
   fi

   # PostGres version
   ####   chk4postgres=`ps -ef | grep "bin\/postgres" | awk '{print $NF}' | sed -e "s,\/data,\/bin\/postgres\ \-\-version 2\>\/dev\/null,"`
   # The "\n" in the next line allows looking for process line for a specific field by 
   # putting carraige returns between them.  Date section can mess it up, because it does 
   # not always have the same number of fields.
   chk4postgres=`ps -ef | grep postgresql | grep -v grep |  awk '{print $6 "\n" $7 "\n" $8 "\n" $9   }' | grep postgresql 2>/dev/null`
   if [ "x${chk4postgres}x" != "xx" ]; then
      jversion_postgres=`$chk4postgres -V`
      echo ${jversion_postgres}
   fi

   # Cassandra version
   if [ -s /opt/insite/WatchList/apache-cassandra/bin/cassandra ];
   then
      /opt/insite/WatchList/apache-cassandra/bin/cassandra --version
   fi

   # Cuda version
   if [ -s /usr/local/cuda/version.txt ]; then
      jversion_cuda=`cat /usr/local/cuda/version.txt`
      if [ "x${jversion_cuda}x" != "xx" ]; then
         echo ${jversion_cuda}
      fi
   fi

   # Nvidia version
   jwhich=`which nvidia-smi 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      nvidia-smi  2>/dev/null > /tmp/helpsystems_tmp/nvidia-smi.jck
      jversion_nvidia=`grep -i NVIDIA /tmp/helpsystems_tmp/nvidia-smi.jck | sed s,\|,,g | awk '{print $1,$2,"-",$3,$4,$5,"-",$6,$7,$8}' `
      if [ "x${jversion_nvidia}x" != "xx" ]; then
         echo ${jversion_nvidia}| grep [a-z]
      fi
   fi

   # Zabbix version
   jwhich=`which zabbix_server 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      jversion_zabbix=`zabbix_server --version`
      if [ "x${jversion_zabbix}x" != "xx" ]; then
         echo ${jversion_zabbix}
      fi
   fi

   # Check kerberos installed
   jwhich=`which klist 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
         echo "kerberos installed" 
   fi

   # Check perl version
   jwhich=`which perl 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      jversion_perl=`perl -v | grep This | sed s,This\ is\ ,,`
      if [ "x${jversion_perl}x" != "xx" ]; then
         echo $jversion_perl
      fi
   fi

   # Check gcc version
   jwhich=`which gcc 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      jversion_gcc=`gcc --version 2>/dev/null | grep ^gcc`
      if [ "x${jversion_gcc}x" != "xx" ]; then
         echo $jversion_gcc
      fi
   fi

   jwhich=`which make 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      jversion_make=`make -v 2>/dev/null | grep " Make "`
      if [ "x${jversion_make}x" != "xx" ]; then
         echo $jversion_make
     fi
   fi

   jwhich=`which apt 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      apt list --installed 2>/dev/null > apt_list_--installed_`hostname`.hsllc
      echo "(apt list --installed) is in apt_list_--installed_`hostname`.hsllc"
   fi

   jwhich=`which yum 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      yum list installed 2>/dev/null > yum_list_installed_`hostname`.hsllc
      echo "(yum list installed) is in yum_list_installed_`hostname`.hsllc"
   fi
   jhostname=`hostname`

   jwhich=`which zypper 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      ### Note:  If not current on repository subscription will hang without the
      ###        the --disable-repositories option.
      zypper --disable-repositories search 2>/dev/null > zypper_search_${jhostname}.hsllc
      echo "(zypper --disable-repositories search) is in zypper_search_${jhostname}.hsllc"
   fi

   jwhich=`which rpm 2>/dev/null`
   jtest=`echo $?`
   if [ $jtest -eq 0 ]; then
      rpm -qa 2>/dev/null > rpm-qa_${jhostname}.hsllc
      echo "(rpm -qa) is in rpm-qa_${jhostname}.hsllc"
   fi

}

rac_generic () {
   rm -f messages.hsllc 
   # Added warning for diskspace too high at 98%
   maxpercent=98
   if [ `$juname -s` != "SunOS" ]; then
      df -Pk 2>/dev/null \
         | sed s,\%,,g \
         | egrep -vi "Avail|free|\/loop[0-9]" \
         | sed s/\ \ */\ /g \
         | awk -v jdiskmax=${maxpercent} '{if ($5 >= jdiskmax ) print "# Warning disk space:",$0}' 
   else
   # Solaris works better with gawk over awk.
      df -Pk 2>/dev/null \
         | sed s,\%,,g \
         | egrep -vi "Avail|free|\/loop[0-9]" \
         | sed s/\ \ */\ /g \
         | gawk -v jdiskmax=${maxpercent} '{if ($5 >= jdiskmax ) print "# Warning disk space:",$0}'
   fi
   # who -b should work on any system, but format may be different.
   echo "# lastboot ( `who -b` )"  | sed s,\ \ *,\ ,g
   # generic rack info (should work on any system)
   ##### see about using a parm for width (%40s or %30s or %25s...)

   nn=`$juname -n | awk -F. '{print $1}'`
   nnd="Machine Node Name"
   printf "%22s = %s\n" "$nnd" "$nn"

      grep -is open /etc/*release* > /dev/null
      gchk=$?
      if [ $gchk -eq 0 ]
      then
         jopen="Open "
      else 
         jopen=""
      fi

   os=`$juname -s`
   if [ "$os" = "SunOS" ]; then
      case `$juname -r` in
        4*) os="${jopen}SunOS";;
        5*) os="${jopen}Solaris";;
        *) os="${jopen}Unknown";;
      esac
   fi
   osd="Operating System Name"
   printf "%22s = %s\n" "$osd" "$os"

   osv=`$juname -v`
   osvd="OS Version"
   printf "%22s = %s\n" "$osvd" "$osv"

   osr=`$juname -r`
   osrd="OS Release"
   printf "%22s = %s\n" "$osrd" "$osr"
   
   # This is for vios servers only (vhost) to determine vios version.
   if [ -s /usr/ios/cli/ioscli ]
   then
      viosv=`/usr/ios/cli/ioscli ioslevel`
      if [ "x${viosv}x" = "xx" ] ; then
         viosv="# No results from (/usr/ios/cli/ioscli ioslevel)"
      fi
      viosvd="Vios Version"
      printf "%22s = %s\n" "$viosvd" "$viosv"
   fi

   locate_app hostid
   jchk=$?
   if [ ${jchk} -eq 0 ]; then
      # osi=$jloc
      # echo "jloc($jloc)"
      osi=`$jloc 2>/dev/null`
   else
      osi="NA"
   fi
   osid="hostid"
   if [ "x${osi}x" != "xx" ]; then
      printf "%22s = %s\n" "$osid" "$osi"
   fi

   if [ "$OStype" != "HP-UX" ] ; then
      # uname -p does not work on HP-UX 
      if [ "$OStype" != "AIX" ] ; then
         jproctype=`$juname -p 2>/dev/null`
         if [ "x${jproctype}x" = "xunknownx" ]; then
            jproctype=`$juname -m 2>/dev/null`
         fi
      else
         jproctype=`lsconf 2>/dev/null | tee /tmp/helpsystems_tmp/rackdata_lsconf.tmp | grep "Processor Type:" | awk '{print $NF}'`
      fi
      jtitle="Processor Type"
      if [ "x${jproctype}x" != "xx" ]; then
         printf "%22s = %s\n" "$jtitle" "$jproctype" 
      fi
   fi 
# Changes to DMI variable selection to compensate for older copies of dmidecode
# which to not accept the -s option.  In that case, DMI will be set to a 
# soft linked version kept as /usr/local/mpg/pntestdmi if available
   if [ -s /usr/sbin/dmidecode ] ; then
      DMI="/usr/sbin/dmidecode"
      jdmi_s_test=`$DMI -s system-manufacturer 2>/dev/null |  sed s,\ ,,g | awk '{print $1}'`
      if [ -s ${installdir}/pntestdmi ] && [ "xx" = "x${jdmi_s_test}x" ] ; then
         DMI="${installdir}/pntestdmi"
      fi
   else
      if [ -s ${installdir}/pntestdmi ] ; then
         DMI="${installdir}/pntestdmi"
      else
         DMI=""
      fi
   fi



   if [ "$jproctype" != "ppc64" ] && [ `$juname -s` = "Linux" ] && [ "x${jserial}x" = "xx" ] && [ "x${DMI}x" != "xx" ] ; then 
     jserial=`$DMI -s system-serial-number 2>/dev/null | sed s,\ ,,g | egrep -iv "NotSpecified|dell" 2>/dev/null | awk '{print $1}'`
     if [ ! -z "$debug" ] ; then echo "#1 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi 
   fi
   
   if [ "$jproctype" = "ppc64" ] && [ `$juname -s` = "Linux" ] && [ "x${jserial}x" = "xx" ] && [ -s /sbin/lshw ] ; then 
     jserial=`lshw -class system 2>&1 | grep serial | head -1 | awk '{print $2}'`
     if [ ! -z "$debug" ] ; then echo "#1a serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi 
   fi
   
   # On some sparc systems, the system-board-serial# is populated.
   if [ "x${jproctype}x" = "xsparcx" ] && [ "x${jserial}x" = "xx" ] ; then 
     jserial=`eeprom | egrep "system-board-serial#=" | awk -F= '{print $2}'`
     if [ ! -z "$debug" ] ; then echo "#2 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
   fi

   if [ "x${jproctype}x" = "xsparcx" ] && [ "x${jserial}x" = "xx" ] ; then 
     jserial=${osi}
     if [ ! -z "$debug" ] ; then echo "#3 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
   fi
   if [ "$jproctype" = "ppc64" ] && [ `$juname -s` = "Linux" ] && [ -e /proc/ppc64/lparcfg ] &&  [ "x${jserial}x" = "xx" ]  ; then 
     jserial=`grep -s serial_number /proc/ppc64/lparcfg | awk -F\= '{print $2}' | awk -F\, '{print substr($2,length($2)-6)}'` 
     if [ ! -z "$debug" ] ; then echo "#4 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
   fi 

   if [ `$juname -s` = "AIX" ] && [ "x${jserial}x" = "xx" ] ; then 
     # jserial=`$juname -m` ## This one does not truly give you serial number
     # jserial=`lsconf | grep "Machine Serial Number" | awk '{print $NF}'` ## This one is too slow
     jserial=`uname -u | awk '{print substr($1,length($1)-6)}'` ## This on is quick and valid
     if [ ! -z "$debug" ] ; then echo "#5 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
   fi
   if [ `$juname -s` = "HP-UX" ] && [ "x${jserial}x" = "xx" ] ; then 
      locate_app machinfo
      jret=$?
      if [ ${jret} -eq 0 ]; then
         jmachinfo=$jloc   
      fi
      jserial=`$jmachinfo | grep "ine serial" | egrep -iv "available" | awk '{print $NF}'`
      if [ ! -z "$debug" ] ; then echo "#6 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
   fi
   if [ "x${jserial}x" = "xx" ]; then
      if [ -s "${installdir}/pntestdmi" ] ; then 
         jserial=`${installdir}/pntestdmi -s system-serial-number 2>/dev/null | egrep -vi "dell" 2>/dev/null | awk '{print $1}'`
      if [ ! -z "$debug" ] ; then echo "#7 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
      fi
   fi
   if [ "x${jserial}x" = "xx" ]; then
      if [ -s "/usr/sbin/smbios" ] ; then
         /usr/sbin/smbios 2>/dev/null > ./smbios.test 
         if [ -s ./smbios.test ] ; then
            jserial=`/usr/sbin/smbios -t SMB_TYPE_SYSTEM| grep Serial | awk '{print $NF}'`
         fi
      if [ ! -z "$debug" ] ; then echo "#8 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
      fi
   fi
   if [ "x${jserial}x" = "xx" ]; then
      if [ -s "/usr/bin/getsn" ] ; then
         /usr/bin/getsn 2>/dev/null > ./getsn.test 
         if [ -s ./getsn.test ] ; then
            jserial=`/usr/bin/getsn | awk '{print $NF}' | egrep -iv "available"`
            if [ ! -z "$debug" ] ; then echo "#9 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
         fi
      fi
   fi
   if [ "x${jserial}x" = "xx" ]; then 
      if [ -s "/usr/bin/getconf" ] ; then
         /usr/bin/getconf MACHINE_SERIAL 2>/dev/null > ./getconf.test 
         if [ -s ./getconf.test ] ; then
            jserial=`/usr/bin/getconf MACHINE_SERIAL | awk '{print $NF}'`
            if [ ! -z "$debug" ] ; then echo "#10 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
         fi
      fi
   fi
   if [ "x${jserial}x" = "xx" ]; then
      if [ -s "/usr/sbin/cstm" ] ; then
         ( echo "selclass qualifier system;info;wait;infolog" | /usr/sbin/cstm ) | grep -i "System serial" 2>/dev/null > ./cstm.test 
         if [ -s ./cstm.test ] ; then
            jserial=`cat ./cstm.test | awk '{print $NF}'`
            if [ ! -z "$debug" ] ; then echo "#11 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
         fi
      fi
   fi
   if [ "x${jserial}x" = "xx" ]; then
      locate_app ifconfig
      jret=$?
      if [ ${jret} -eq 0 ]; then
         ifc_loc=$jloc   
      fi
   fi
   if [ "x${jserial}x" = "xx" ] && [ "x${osi}x" != "xNAx" ] ; then
      jserial=$osi
   fi
   if [ "x${jserial}x" = "xx" ]; then
      jserial=`$ifc_loc -a 2>/dev/null \
         | grep HWaddr \
         | head -1 \
         | sed -e "s,:,,g" \
         | awk '{print "JQIX-"substr(toupper($NF),5)}'`
      if [ ! -z "$debug" ] ; then echo "#12 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
   fi
   if [ "x${jserial}x" = "xx" ]; then
      ifconfig_ip=`$ifc_loc -a  2>/dev/null \
         | grep inet \
         | grep -v 127.0.0.1 \
         | grep "\ [0-9]*\.[0-9]*\.[0-9]*\.[0-9]*\ " \
         | sed -e "s,^.*inet\ ,,g" \
         | sed -e "s,\ .*$,,g" \
         | head -1 \
         | sed -e "s,\.,\ ,g"`
      ifconfig_ip_hex=`for i in $ifconfig_ip
      do
         printf '%02X' "$i"
      done`
      if [ "x${ifconfig_ip_hex}x" != "xx" ]; then
         jserial="JQBE-${ifconfig_ip_hex}"
      if [ ! -z "$debug" ] ; then echo "#13 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
      fi
   fi
   if [ "x${jserial}x" = "xx" ]; then
      # Added check for inode number of /usr/local/mpg.
      jserial="JQJO-`ls -id /usr/local/mpg | awk '{print $1}'`"
      if [ ! -z "$debug" ] ; then echo "#14 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
   fi
   if [ "x${jserial}x" = "xx" ]; then
      jserial="NoSerial"
      if [ ! -z "$debug" ] ; then echo "#15 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
   fi    
   if [ $jserial ] 
   then 
      # jserial has been populated check for multiples serial numbers
      if [ -s serial.hsllc ]; then
         mv serial.hsllc serial.hsllc.last
         echo $jserial > serial.hsllc.now
         cat serial.hsllc.last serial.hsllc.now | sort | uniq > serial.hsllc
      fi
      # If serial has been populated check for multiples serial numbers
      # Display serial number count 
      jwcserial=`wc -l serial.hsllc 2>/dev/null | awk '{print $1}'`
      if [ "x${jwcserial}x" != "x1x" ] && [ "x${jwcserial}x" != "xx" ]  ; then
         echo "# ($jwcserial) Serial Numbers in serial.hsllc" 
      fi
      # Remove temporary files
      rm -f serial.hsllc.last serial.hsllc.now

      memd="Serial"
      printf "%22s = %s\n" "$memd" "$jserial"
   fi
   jtz=`date "+%Z %z"`
   if [ "x${jtz}" != "x" ] 
   then 
      memd="TZ"
      printf "%22s = %s\n" "$memd" "$jtz"
   fi
}

rac_aix () {
   #  Collect "rack config" on AIX systems
   #  this only works completely on AIX 5.3 and later

   rac_generic
   ##### AIX specific
   get_tl_level
   get_lru_file_repage

   # Grab the output from
   # vmo -L lru_file_repage
   # and vmo -L
   echo "### vmo -L ###"  > ${installdir}/vmo-L_commands.hsllc
   echo "" >> ${installdir}/vmo-L_commands.hsllc
   vmo -L 2>/dev/null >> ${installdir}/vmo-L_commands.hsllc
   echo "" >> ${installdir}/vmo-L_commands.hsllc
   echo "" >> ${installdir}/vmo-L_commands.hsllc
   echo "### vmo -L lru_file_repage ###" >> ${installdir}/vmo-L_commands.hsllc
   echo "" >> ${installdir}/vmo-L_commands.hsllc
   vmo -L lru_file_repage 2>/dev/null >> ${installdir}/vmo-L_commands.hsllc

   isa=`$juname -p 2>/dev/null`
   isad="Instruction set architecture"
   printf "%40s = %s\n" "$isad" "$isa"

   mt_mn=`$juname -M`
   mt_mnd="Machine Type and Model Name"
   printf "%40s = %s\n" "$mt_mnd" "$mt_mn"
   lparstat -i 2>/dev/null > lparstat-i.hsllc
   Act_Phy_CPUs=`grep ^Active\ Phys lparstat-i.hsllc | awk '{print $NF}'`
   if [ ! -z "$Act_Phy_CPUs" ] ; then
      Act_Phy_CPUsd="Active Physical CPUs"
      printf "%40s = %s\n" "$Act_Phy_CPUsd" "$Act_Phy_CPUs"
   fi

   Shared_Pool_ID=`grep "^Shared\ Pool\ ID" lparstat-i.hsllc | awk '{print $NF}'`
   if [ ! -z "$Shared_Pool_ID" ] ; then
      Shared_Pool_IDd="Shared Pool ID"
      printf "%40s = %s\n" "$Shared_Pool_IDd" "$Shared_Pool_ID"
   fi

   Act_CPUs_in_Pool=`grep "^Active\ CPUs\ in\ Pool" lparstat-i.hsllc | awk '{print $NF}'`
   if [ ! -z "$Act_CPUs_in_Pool" ] ; then
      Act_CPUs_in_Poold="Act CPUs in Pool"
      printf "%40s = %s\n" "$Act_CPUs_in_Poold" "$Act_CPUs_in_Pool"
   fi

   SMT=`grep "^Type\ " lparstat-i.hsllc \
      | sed -e "s,SMT$,SMT-2," \
      | sed s,\-,:,g \
      | sed s,:\ ,:, \
      | sed s,d$,d:notdisplayed:off,\
      | awk -F: '{print $(NF-2), $NF}'`
   if [ ! -z "$SMT" ] ; then
      SMTd="SMT"
      printf "%40s = %s\n" "$SMTd" "$SMT"
   fi

   # Logic for this is based on Backplane CCIN being always available on an 
   # IBM Power System that is AIX, RedHat or SUSE.
   # Also added logic in case it is not.
   # If BP and PROC missing nothing prints 
   # If BP only, CCIN = BP#
   # If PROC only, CCIN = PROC#,na
   # If BP and PROC are there, CCIN = PROC#,BP#
   BP_CCIN=`lscfg -vp 2>/dev/null | sed s,:,\ ,g | sed -e "s,\.,\ ,g" | awk 'BEGIN {j=0};{if($1=="SYSTEM")j=1};{if($1=="Customer" && j==1) print $NF}{if($1=="Physical" )j=0}'|uniq`
   PRC_CCIN=`lscfg -vp 2>/dev/null | sed s,:,\ ,g | sed -e "s,\.,\ ,g" | awk 'BEGIN {j=0};{if($2=="PROC")j=1};{if($1=="Customer" && j==1) print $NF}{if($1=="Physical" )j=0}'|uniq`
   PRC_CCINd="CCIN"
   if [ ! -z "$PRC_CCIN" ] && [ ! -z "$BP_CCIN" ] ; then
      printf "%40s = %s\n" "$PRC_CCINd" "${PRC_CCIN},${BP_CCIN}"
   fi
   if [ ! -z "$PRC_CCIN" ] && [  -z "$BP_CCIN" ] ; then
      printf "%40s = %s\n" "$PRC_CCINd" "${PRC_CCIN},na"
   fi
   if [ -z "$PRC_CCIN" ] && [ ! -z "$BP_CCIN" ] ; then
      printf "%40s = %s\n" "$PRC_CCINd" "${BP_CCIN}"
   fi

   CUOD_Procs=`lscfg -vp 2>/dev/null |grep WAY | sed s,\:,, |sort | uniq -c | awk '{print $1,$2,$3,$4}'`
   CUOD_YProcs=`lscfg -vp 2>/dev/null |grep WAY | grep CUOD | sed s,\:,, |sort | uniq -c | awk '{print $1,$2}'`
   if [ ! -z "$CUOD_Procs" ] ; then
      # If the Processor display has CUOD display differntly. 
      if [ ! -z "$CUOD_YProcs" ] ; then
         CUOD_YProcsd="Proc CUOD"
         printf "%40s = %s\n" "$CUOD_YProcsd" "$CUOD_YProcs"
      else
         CUOD_Procsd="Processors"
         printf "%40s = %s\n" "$CUOD_Procsd" "$CUOD_Procs"
      fi
   fi

   Proc_Clk_Speed=`prtconf -s 2>/dev/null | awk '{print $(NF-1), $NF}'`
   if [ ! -z "$Proc_Clk_Speed" ] ; then
      Proc_Clk_Speedd="Processor Clock Speed"
      printf "%40s = %s\n" "$Proc_Clk_Speedd" "$Proc_Clk_Speed"
   fi

   pc_mi=`$juname -u`
   pc_mid="Plant Code and Machine ID"
   printf "%40s = %s\n" "$pc_mid" "$pc_mi"

   ## Memory info

   mem=`lsattr -El sys0 -a realmem -F value`
   memd="Amount of usable physical memory in K"
   printf "%40s = %s\n" "$memd" "$mem"

   if (( OSLV >= 53 )); then
   # if [ "$osv" = "5" ] && [ "$osr" -gt "2" ] ; then
      ## LPAR specific (V5R3)
      # lpnn=`$juname -L`  #  Did not work for older versions of AIX 
      lpnn=` egrep -i "Partition N" lparstat-i.hsllc |  awk '{print $NF}' | paste - - | awk '{print $2,$1}'`
      lpnnd="LPAR Number and LPAR Name"
      printf "%40s = %s\n" "$lpnnd" "$lpnn"

      lpcap=`lsattr -El sys0 -a capped -F value`
      lpcapd="Partition is capped"
      printf "%40s = %s\n" "$lpcapd" "$lpcap"

      lpded=`lsattr -El sys0 -a dedicated -F value`
      lpdedd="Partition is dedicated"
      printf "%40s = %s\n" "$lpdedd" "$lpded"

      lpentcap=`lsattr -El sys0 -a ent_capacity -F value`
      lpentcapd="Entitled processor capacity"
      printf "%40s = %s\n" "$lpentcapd" "$lpentcap"

      Online_Virtual_CPUs=`grep "^Online\ Virtual\ CPUs" lparstat-i.hsllc | awk '{print $NF}'`
      if [ ! -z "$Online_Virtual_CPUs" ] ; then
         Online_Virtual_CPUsd="Online Virtual CPUs"
         printf "%40s = %s\n" "$Online_Virtual_CPUsd" "$Online_Virtual_CPUs"
      fi

      lpmincap=`lsattr -El sys0 -a min_capacity -F value`
      lpmincapd="Minimum potential processor capacity"
      printf "%40s = %s\n" "$lpmincapd" "$lpmincap"

      lpmaxcap=`lsattr -El sys0 -a max_capacity -F value`
      lpmaxcapd="Maximum potential processor capacity"
      printf "%40s = %s\n" "$lpmaxcapd" "$lpmaxcap"

      numcfglpars=`lparstat -s 2>/dev/null | grep LPARs  | awk '{print $NF}'`
      numcfglparsd="Number of Configured LPARs"
      printf "%40s = %s\n" "$numcfglparsd" "$numcfglpars"

      numfscnt=`lsfs | egrep -v "VFS|procfs|cdrfs" | wc -l | awk '{print $1}'`
      numfscntd="Number of File Systems"
      printf "%40s = %s\n" "$numfscntd" "$numfscnt"

      numlvcnt=`for jvg in \`lsvg\`
                do
                   echo "#------------#"
                   lsvg -l $jvg
                done | egrep -v "NAME|:|\#" | wc -l | awk '{print $1}' `
      numlvcntd="Number of Logical Volumes"
      printf "%40s = %s\n" "$numlvcntd" "$numlvcnt"
    
      numvgcnt=`lsvg | egrep -v "VFS|procfs" | wc -l | awk '{print $1}'`
      numvgcntd="Number of Volume Groups"
      printf "%40s = %s\n" "$numvgcntd" "$numvgcnt"
    
   fi
   
   # Call to disk_info procedure
   disk_info
   #
   # mpgdatadir total vs filesystem df -m versus du -m
   # Whole line of df and du is stored in disk_df_du.hsllc
   if [ -s ${nminst}/pn.config ];  then
      . ${nminst}/pn.config
   fi
   if [ -s /etc/pn.conf ];  then
      . /etc/pn.conf 
   fi
   echo "`df -Pm ${mpgdatadir} \
      | tail -1` `du -m ${mpgdatadir} \
      | tail -1`" \
      | sed s,\ \ *,\ ,g \
      | sed s,%,,g \
      | sed s,\	\	\*,\ ,g  \
      | sed -e "s/\ /\,/g" > disk_df_du.hsllc
   echo "# mpg data directory"
   echo "FS,FSSizeMB,FSUsedMB,FSFreeMB,%full,FSMount,PerfDataMB,PerfDataDir" 
   echo "`cat disk_df_du.hsllc`"

   # lsmpio - Display Info about the MultiPath I/O (MPIO) storage devices
   if [ -s /usr/bin/lsmpio ]; then
      /usr/bin/lsmpio > lsmpio.hsllc
      if [ -s lsmpio.hsllc ]; then
         echo "# lsmpio"
         cat lsmpio.hsllc
      fi
   fi


   # This will display the IBM raid information
   if [ -s /tmp/helpsystems_tmp/sissas.tmp ]; then
      echo "# sissas ( sissasradmgr -L -l sissas# ) "
      for jsissas in `cat /tmp/helpsystems_tmp/sissas.tmp`
      do
          sissasraidmgr -L -l $jsissas | grep -v ^$
      done
   fi

   echo "# lsfs " 
   lsfs

   echo "# Volume Groups and Logical Volumes"
   echo "#------------#"
   for jvg in `lsvg`
   do
      lsvg -l $jvg
      echo "#------------#"
   done

   # Collect Volume Group Info 
   lsvg 2>/dev/null > /tmp/helpsystems_tmp/rackdata_lv_info4aix.tmp
   if [ -s /tmp/helpsystems_tmp/rackdata_lv_info4aix.tmp ]; then
      # List volume group information
      echo "# vginfo"
      echo "vgname,vgstate,vgperm,ppsize,totalpp,lvname,lvtype,lp,pp,pv,lvstate,mtpoint,mirrorp,mirror"
      for jvg in `lsvg 2>/dev/null`
      do
         jvginfo=`lsvg ${jvg} 2>/dev/null | egrep "STATE|GROUP|PERMISS" | awk '{print $3,$6}' | paste - - - | awk '{print $1,$3,$5,$4,$6}'`
         lsvg -l ${jvg} 2>/dev/null | tail -n +3 | sort  > /tmp/helpsystems_tmp/rackdata_lsvg-1_vg.tmp
         cat /tmp/helpsystems_tmp/rackdata_lsvg-1_vg.tmp | awk '{print $1}'  > /tmp/helpsystems_tmp/rackdata_lsvg-l_vg_lv.tmp
         lsvg -m ${jvg} 2>/dev/null | tail -n +2 | sort   > /tmp/helpsystems_tmp/rackdata_lsvg-m_vg.tmp
	 # The next two lines emulated no lsvg -m volume_group information
	 # rm /tmp/helpsystems_tmp/rackdata_lsvg-m_vg.tmp
	 # touch /tmp/helpsystems_tmp/rackdata_lsvg-m_vg.tmp
         join -a 1 /tmp/helpsystems_tmp/rackdata_lsvg-l_vg_lv.tmp /tmp/helpsystems_tmp/rackdata_lsvg-m_vg.tmp | awk '{j1=0}{if($2 != "None" && $2 != "" )j1++1}{if($3 != "None" && $3 != "" )j1++1}{if($4 != "None" && $4 != "" )j1++1}{print $1,"MP"j1}' > /tmp/helpsystems_tmp/rackdata_mp_counts.tmp
         join -a 1 /tmp/helpsystems_tmp/rackdata_lsvg-1_vg.tmp /tmp/helpsystems_tmp/rackdata_mp_counts.tmp | awk -v jvgi="${jvginfo}" '{print jvgi, $0, "M"($4/$3-1)}' > /tmp/helpsystems_tmp/rackdata_vginfo.tmp
         cat /tmp/helpsystems_tmp/rackdata_vginfo.tmp | sed -e "s|\ |\,|g" 
      done

      # List physical volume information
      echo "# pvinfo"
      echo "vg_name,pv_name,pv_state,total_pps,free_pps"
      for jvg in `lsvg 2>/dev/null`
      do
         lsvg -p ${jvg} 2>/dev/null| tail -n +3 | sed -e "s/\ \ */\ /" | awk  -v jvn="${jvg}" 'BEGIN{OFS=","}{print jvn, $1, $2, $3, $4}' 
      done
   fi
   # This is for vios servers only (vhost).
   if [ -s /usr/ios/cli/ioscli ]
   then
      sysname=`uname -n | awk -F. '{print $1}'` # used in default datafile names
      # Defaults to VSCSI adapter devices with only -all 
      /usr/ios/cli/ioscli lsmap -all  > ioscli_lsmap-all_${sysname}.hsllc
      # lsmap -net  Specifies supplied device is virtual server Ethernet adapter.
      /usr/ios/cli/ioscli lsmap -net -all  -fmt "," > ioscli_lsmap-net-all_${sysname}.hsllc
      # lsmap -npiv Displays NPIV binding information (Virtual Network Adapter). 
      /usr/ios/cli/ioscli lsmap -npiv -all  > ioscli_lsmap-npiv-all_${sysname}.hsllc
      # lsmap -ams  Displays (AMS)Active Memory Sharing paging space device information.
      /usr/ios/cli/ioscli lsmap -ams  -all -fmt "," > ioscli_lsmap-ams-all_${sysname}.hsllc
      if [  -s ioscli_lsmap-all_${sysname}.hsllc ] ; then
      cat ioscli_lsmap-all_${sysname}.hsllc \
	 |  awk '
               BEGIN{{OFS="," ; javail=0 ; jnot=0 ; svsa_totals=0 ; jsub_avail=0 ; jsub_not=0 ; vtd_totals=0 ; svsa_last="" ; svsa"" ; print "# VHOST" ; print "svsa,vtd,status,backing,mirrored" }}
               {if(substr($3,2,1) == "x") {svsa = $1 ; {if(svsa_last != svsa && svsa_last != "") print "SVSA_info", svsa_last, vtd_totals, jsub_avail, jsub_not } ; svsa_last = svsa ; svsa_totals=svsa_totals+1 ; jsub_avail=0 ; jsub_not=0 ; vtd_totals=0 ; vtd = "" ; status = "" ; backing = "" ; mirrored = "" }} 
               {if($1 == "VTD" && $2 == "NO" ) {vtd = "NO_VIRTUAL_TARGET_DEVICE_FOUND" ; print svsa, vtd, status, backing, mirrored }}
               {if($1 == "VTD" && $2 != "NO" ) {vtd = $2; vtd_totals=vtd_totals+1}}
               {if($1 == "Status") {status = $2 ; if($2 =="Available"){javail=javail+1 ; jsub_avail=jsub_avail+1 } else {jnot=jnot+1 ; jsub_not=jsub_not+1 }}}
               {if($1 == "Backing") backing = $3}
               {if($1 == "Mirrored") {mirrored = $2 ; print svsa, vtd, status, backing, mirrored }}
               {if($1 == "Device" && $4 == "not" && $6 == "AVAILABLE" ) {svsa = substr($2,2,length($2)-2) ; {if(svsa_last != svsa && svsa_last != "") print "SVSA_info", svsa_last, vtd_totals, jsub_avail, jsub_not } ; svsa_last = svsa",Device_is_not_in_AVAILABLE" ; svsa_totals=svsa_totals+1 ; jsub_avail=0 ; jsub_not=0 ; vtd_totals=0 ; vtd = "" ; status = "" ; backing = "" ; mirrored = "" }}
               END { print "SVSA_info", svsa_last, vtd_totals, jsub_avail, jsub_not ; print "SVSA_totals",svsa_totals, javail + jnot, javail, jnot }' | tee vhostinfo_${sysname}.hsllc
      fi
      
      if [ ! -s ioscli_lsmap-all_${sysname}.hsllc ] ; then
         echo "# VHOST # No results from (/usr/ios/cli/ioscli lsmap -all)"
      fi

      if [ -s ioscli_lsmap-npiv-all_${sysname}.hsllc ] ; then
      cat ioscli_lsmap-npiv-all_${sysname}.hsllc \
         | sed s,\:,\ ,g \
         | sed s,IBM\ i,IBM_i,g \
         | sed s,Not_logged_in,NOT_LOGGED_IN,g \
         | sed -e 's/a<LOGGED_IN,STRIP_MERGE>//g' \
         | sed s,\	,\ ,g \
         | sed s,^\ \ *,,g \
         | awk '
              BEGIN {OFS="," ; loggedin=0 ; not=0 ; vfch_totals=0 ; total_loggedin=0 ; total_notloggedin=0 ; notloggedin=0 ; vfch_last="" ; vfch="" ; total_not_avail=0 ; total_ports_logdin = 0; ports_logdin = 0; print "# VFCHOST" ; print "Name,Status,PortsLogdin,Flags,PhyLoc,FCName,FCLoc,VFCLoc,VFCName,ClntId,ClntName,ClntOS,Logdin,NotLogdin"}

              {if($1 == "Device" && $4 == "not" && $6 == "AVAILABLE" )
              {ports_logdin = 0; vfch = substr($2,2,length($2)-2) ; status = "Device_is_not_in_AVAILABLE" ;  loggedin = 0 ; notloggedin=0 ; vtd = "" ; clnt_id = "" ; clnt_name = "" ; clnt_os = "" ; phy_loc = "" ;  fcname = "" ; fc_loc_code = "" ; vfc_loc_code = "" ; vfcname = "" ; flags = ""  ; vfch_totals = vfch_totals + 1 ; total_not_avail = total_not_avail + 1 }}

              {if(substr($2,1,1) == "U") 
                  {vfch = $1 ; phy_loc = $2 ; clnt_id = $3 ; clnt_name = $4 ; clnt_os = $5 ; vfch_totals = vfch_totals + 1 }} 

              {if($1 == "FC" && $2 == "name" && $3 == "FC" ) 
                  { fcname = "NO_FC_Name" }}

              {if($1 == "FC" && $2 == "name" && $3 != "FC" ) 
                  { fcname = $3 }}

              {if($1 == "FC" && $2 == "name" && $6 != "code" ) 
                  {fc_loc_code = "NO_FC_Loc_Code" }}

              {if($1 == "FC" && $2 == "name" && $6 == "code" ) 
                  {fc_loc_code = $7 }}

              {if($1 == "VFC" && $2 == "client" && $4 == "VFC" ) 
                  { vfcname = "NO_VFC_Name" }}

              {if($1 == "VFC" && $2 == "client" && $4 != "VFC" ) 
                  { vfcname = $4 }}

              {if($1 == "VFC" && $2 == "client" && substr($NF,1,1) == "U" ) 
                  { vfc_loc_code = $NF }}

              {if($1 == "VFC" && $2 == "client" && substr($NF,1,1) != "U" ) 
                  { vfc_loc_code = "NO_VFC_Loc_Code" }}

              {if($1 == "Status") 
                  {status = $2}}

              {if($1 == "Status" && $2 == "LOGGED_IN")
                  {total_loggedin=total_loggedin+1; loggedin=1 }}

              {if($1 == "Status" && $2 == "NOT_LOGGED_IN")
                  {not = not + 1 ; total_notloggedin = total_notloggedin + 1 ; loggedin = 0  }}

              {if($1 == "Ports") 
                  {ports_logdin = $4 ; total_ports_logdin = total_ports_logdin + ports_logdin }}

              {if($1 == "Flags") {flags = $2$3$4$5 }}

              {if(($1 == "VFC" && $2 == "client" && $3 == "name" ) || ($1 == "Device" && $4 == "not" && $6 == "AVAILABLE" ) ) 
                  {print  vfch, status, ports_logdin, flags, phy_loc, fcname, fc_loc_code, vfc_loc_code, vfcname, clnt_id, clnt_name, clnt_os, loggedin, notloggedin} }

              END { print "Totals", "Hosts", "Ports", "Logged_In", "Not_Logged_In", "Available", "Not_Available"  ; print "Totals", vfch_totals, total_ports_logdin, total_loggedin, total_notloggedin, vfch_totals - total_not_avail, total_not_avail } 
       ' # can be added for testing | tee vfchostinfo_${sysname}.hsllc
      fi
      if [ ! -s ioscli_lsmap-npiv-all_${sysname}.hsllc ] ; then
         echo "# VFCHOST # No npiv results from (/usr/ios/cli/ioscli lsmap -npiv -all)"
      fi

      if [ -s ioscli_lsmap-net-all_${sysname}.hsllc ] ; then
         echo "# SVEA (Shared Virtual Ethernet Adapter) # " 
         echo "SVEA,PhysLoc1,SEA,BackDev,Status,Physloc2" 
         cat ioscli_lsmap-net-all_${sysname}.hsllc 
      else
         echo  "# SVEA (Shared Virtual Ethernet Adapter) # No net results from (/usr/ios/cli/ioscli lsmap -net -all)"
      fi

      if [  -s ioscli_lsmap-ams-all_${sysname}.hsllc ] ; then
         echo "# AMS (Active Memory Sharing) # " 
         echo "Paging,StreamId,ClientId,Status,RedunduntUsage,BackDev,PoolId,VASI,Pager,VBSD" 
         cat ioscli_lsmap-ams-all_${sysname}.hsllc 
      else
         echo  "# AMS (Active Memory Sharing) #  No ams results from (/usr/ios/cli/ioscli lsmap -ams -all)"
      fi

   fi
}


rac_linux () {
   #####
   # linux rack config info
   #####

   ##? uname -i	gets the machine id #  (?equiv AIX serial # ?)
   # vmstat	
   # ? iostat
   # ? hwconf

   rac_generic

   ##### semi-os specific (not on debian)

   #isa=`$juname -p`
   #isad="Instruction set architecture"
   #printf "%30s = %s\n" "$isad" "$isa"

   ##### L3 specific from lscpu info
   if [ "x${L3Cache}x" = "xx" ]; then
      L3Cache=`lscpu | grep L3  | sed s/\,.*// | sed s,K,\ K, \
         | awk '{print $(NF-1), $NF}'`
      if [ "x${L3Cache}x" != "xx" ]; then
         L3Cached="L3 Cache"
         printf "%24s = %s\n" "$L3Cached" "$L3Cache"
      fi
   fi

   ##### os specific
   distinfo=`lsb_release -d 2>/dev/null | sed s,Description:\	,,g`
   if [ "xx" = "x${distinfo}x" ]; then
      distinfo=`find /etc -type f -name \*elease\* -o -type f -name issue \
         | xargs cat |  grep [0-9] |uniq  \
         | egrep -v "BUGZILLA|Welcome|JPackage|GNU|products|release\ key" \
         | egrep "Debian|Linux|Red\ Hat|CentOS|Ubuntu" | sed s,PRETTY_NAME=,, \
         | sed s,DISTRIB_DESCRIPTION=,, | sed s,REDHAT_BUGZILLA_PRODUCT=,, \
         | sed s,\",,g | sed -e 's,\\\,,g' | head -1`
   fi
   # echo "distinfo is ( ${os} )"
   # distinfo=`cat /etc/issue | grep -v "^$" | head -1 `
   distinfod="distinfo"
   if [ "x${distinfo}x" != "xx" ] ; then 
      printf "%24s = %s\n" "$distinfod" "$distinfo"
   fi
   osm=`$juname -m`
   osmd="Machine model"
   # check for mainframe model & type
   if [ "$osm" = "s390x" ] ; then 
      MFtype=`cat /proc/sysinfo | grep 'Type' | awk '{print $2}'`
      MFmodel=`cat /proc/sysinfo | grep 'Model:' | awk '{print $2, $3}'`
      printf "%24s = %s %s %s\n" "$osmd" "$osm" "$MFtype" "$MFmodel"
   elif [ "$osm" = "ppc64le" ] ; then 
      osm=`grep model /proc/cpuinfo | awk '{print $NF}'`
      printf "%24s = %s\n" "$osmd" "$osm"
   else
      printf "%24s = %s\n" "$osmd" "$osm"
   fi

   ## Memory info

   mem=`grep MemTotal /proc/meminfo | awk '{print $2}'`
   memd="Amount physical memory"
   printf "%24s = %s\n" "$memd" "$mem"

## Place linux calls hear
### echo "${jproctype}, Remove or comment later." 
if [ "$jproctype" != "ppc64" ] && [ "$jproctype" != "s390" ] && [ "$jproctype" != "s390x" ] ; then
### dmidecode gathered information.
   if [ -s /usr/sbin/dmidecode ] ; then
       DMI="/usr/sbin/dmidecode"
   else
       DMI="${installdir}/pntestdmi"
   fi 
   jtest=`$DMI 2>/dev/null >/dev/null`
      echo $jtest | grep "sorry" > /dev/null 
   jgreptest=$?
      echo $jtest | grep "No SMBIOS nor DMI" > /dev/null 
   jgreptest2=$?
   if [ ${jgreptest2} -eq 0 ] ; then
      echo "### No SMBIOS nor DMI  ###" 
   else
      if [ ${jgreptest} -eq 0 ] ; then
   #      echo $jtest
         echo "### This may be an old server ###"
      fi 
   fi
   while
   read s_item
   do
      s_details=`$DMI -s $s_item 2>/dev/null |sed -e "s,\ *$,," |sed -e "s,\ \ *,\ ,g" | egrep -vi "000000000|Unknown|Not Specified|NotSpecified"  | sort | uniq `
      if [ "x${s_details}x" != "xx" ] ; then 
         printf "%24s = %s\n" "$s_item" "$s_details" 
      fi
   done <<- jamjam
system-manufacturer
system-product-name
system-version
system-serial-number
system-uuid
bios-vendor
bios-version
bios-release-date
chassis-type
processor-family
processor-manufacturer
processor-version
processor-frequency
jamjam
   # Intentionally not gathering the following:
   # baseboard-manufacturer
   # baseboard-product-name
   # baseboard-version
   # baseboard-serial-number
   # baseboard-asset-tag
   # chassis-manufacturer
   # chassis-version
   # chassis-serial-number
   # chassis-asset-tag

   $DMI --type cache 2>/dev/null    \
      | egrep "Socket Designation:|Installed Size:|Location:"    \
      | awk -F\: '{print $2}'  \
      | sed -e "s,^\ ,," \
      | paste - - - \
      | sed -e "s,\	,\ ," \
      | sed -e "s,\	,\ \=\ ," \
      | grep -v "L[1-2]" \
      | awk '{print "    ", $0}'

fi   

if [ "x${DMI}x" != "xx" ] ;then
   nmbr_cpus=`$DMI 2>/dev/null | grep 'Status: Populated' |sed -e "s,\ *$,," | wc -l | awk '{print $1}' `
   CpuSpeed=`$DMI 2>/dev/null | grep -i speed: | grep -i "current"  | egrep -vi "unknown|\ ns$"  | sed s,^.*:\ ,, | sort | uniq`
fi

if [ "x${CpuSpeed}x" = "xx" ]
then
   CpuSpeed=`lscpu | grep "CPU max MHz" | sed -e 's,\.00*,,' | sed s,MHz,, | sort -n | tail -1 | awk '{print $NF, "MHz"}'`
fi

if [ "x${CpuSpeed}x" = "xx" ]
then
   CpuSpeed=`grep "cpu MHz" /proc/cpuinfo | sort | uniq -c | sed -e 's,\.00*,,' | awk '{print $NF, "MHz"}'`
fi

if [ "x${CpuSpeed}x" != "xx" ]
then
   CpuSpeedd='CPU Speed'
   printf "%24s = %s\n" "$CpuSpeedd" "$CpuSpeed"
fi

# This display is only for power machines with Linux 
if [ "x${nmbr_cpus}x" = "x0x" ] && [ "$jproctype" = "ppc64" ] ; then
   nmbr_cpus=`grep -i "^processor" /proc/cpuinfo | wc -l | awk '{print $1}'`
   if [ "x${nmbr_cpus}x" != "xx" ] && [ ${nmbr_cpus} -gt 0 ] ; then 
      printf "%24s = %s\n" "Nmbr of Cores" "$nmbr_cpus" 
   else
      printf "%24s = %s\n" "Nmbr of Cores" "1" 
   fi
fi


# This display is only for x86 type machines with Linux 
if [ "x${cores_per_cpu}x" = "xx" ] && [ "$jproctype" != "ppc64" ] ; then
   cores_per_cpu=`grep -i "cores" /proc/cpuinfo | uniq | awk '{print $NF}'`
   if [ "x${cores_per_cpu}x" != "xx" ] && [ ${cores_per_cpu} -gt 0 ] ; then 
      printf "%24s = %s\n" "Cores per Socket" "$cores_per_cpu" 
   else
      printf "%24s = %s\n" "Cores per Socket" "1" 
   fi
fi

# This display is only for x86 type machines with Linux 
if [ "x${processors}x" = "xx" ] && [ "$jproctype" != "ppc64" ] ; then
   processors=`grep -i "processor" /proc/cpuinfo | egrep -v "model" | sort | uniq | awk '{print $NF}'|wc -l | awk '{print $1}'`
   if [ "x${processors}x" != "xx" ] && [ ${processors} -gt 0 ] ; then 
      printf "%24s = %s\n" "Processors" "$processors" 
   else
      printf "%24s = %s\n" "Processors" "1" 
   fi
fi

# This display is only for x86 type machines with Linux 
if [ "x${physical}x" = "xx" ] && [ "$jproctype" != "ppc64" ] ; then
   physical=`grep -i "physical id" /proc/cpuinfo | sort | uniq | awk '{print $NF}' | wc -l | awk '{print $1}'`
   if [ "x${physical}x" != "xx" ] && [ ${physical} -gt 0 ] ; then 
      printf "%24s = %s\n" "Physical sockets" "$physical" 
   else
      printf "%24s = %s\n" "Physical sockets" "1" 
   fi
fi

### Added ppc64le to next line with an AND OR statement
if [ "$OStype" = "Linux" ] && ( [ "$jproctype" = "ppc64" ] || [ "$jproctype" = "ppc64le" ] ); then
   # Get Machine Type and Model Name using /proc/cpuinfo model on IBM ppc64
   jmodel=`grep "^model" /proc/cpuinfo | awk '{print $NF}'`
   if [ "x${jmodel}x" != "xx" ]; then
      modeld="Machine Type and Model Name"
      printf "%24s = %s\n" "$modeld" "$jmodel"
   fi

   lparstat -i 2>/dev/null > lparstat-i.hsllc
   Act_Phy_CPUs=`grep ^Active\ Phys lparstat-i.hsllc | awk '{print $NF}'`
   if [ ! -z "$Act_Phy_CPUs" ] ; then
      Act_Phy_CPUsd="Active Physical CPUs"
      printf "%24s = %s\n" "$Act_Phy_CPUsd" "$Act_Phy_CPUs"
   fi

   Shared_Pool_ID=`grep "^Shared\ Pool\ ID" lparstat-i.hsllc | awk '{print $NF}'`
   if [ ! -z "$Shared_Pool_ID" ] ; then
      Shared_Pool_IDd="Shared Pool ID"
      printf "%24s = %s\n" "$Shared_Pool_IDd" "$Shared_Pool_ID"
   fi

   Online_Virtual_CPUs=`grep "^Online\ Virtual\ CPUs" lparstat-i.hsllc | awk '{print $NF}'`
   if [ ! -z "$Online_Virtual_CPUs" ] ; then
      Online_Virtual_CPUsd="Online Virtual CPUs"
      printf "%24s = %s\n" "$Online_Virtual_CPUsd" "$Online_Virtual_CPUs"
   fi

   Act_CPUs_in_Pool=`grep "^Active\ CPUs\ in\ Pool" lparstat-i.hsllc | awk '{print $NF}'`
   if [ ! -z "$Act_CPUs_in_Pool" ] ; then
      Act_CPUs_in_Poold="Act CPUs in Pool"
      printf "%24s = %s\n" "$Act_CPUs_in_Poold" "$Act_CPUs_in_Pool"
   fi

   SMT=`grep "^Type\ " lparstat-i.hsllc \
      | sed -e "s,SMT$,SMT-2," \
      | sed s,\-,:,g \
      | sed s,:\ ,:, \
      | sed s,d$,d:notdisplayed:off,\
      | awk -F: '{print $(NF-2), $NF}'`
   if [ ! -z "$SMT" ] ; then
      SMTd="SMT"
      printf "%24s = %s\n" "$SMTd" "$SMT"
   fi

   # Logic for this is based on Backplane CCIN being always available on an 
   # IBM Power System that is AIX, RedHat or SUSE.
   # Also added logic in case it is not.
   # If BP and PROC missing nothing prints 
   # If BP only, CCIN = BP#
   # If PROC only, CCIN = PROC#,na
   # If BP and PROC are there, CCIN = PROC#,BP#
   BP_CCIN=`lscfg -vp 2>/dev/null | sed s,:,\ ,g | sed -e "s,\.,\ ,g" | awk 'BEGIN {j=0};{if($1=="SYSTEM")j=1};{if($1=="Customer" && j==1) print $NF}{if($1=="Physical" )j=0}'|uniq`
   PRC_CCIN=`lscfg -vp 2>/dev/null | sed s,:,\ ,g | sed -e "s,\.,\ ,g" | awk 'BEGIN {j=0};{if($2=="PROC")j=1};{if($1=="Customer" && j==1) print $NF}{if($1=="Physical" )j=0}'|uniq`
   PRC_CCINd="CCIN"
   if [ ! -z "$PRC_CCIN" ] && [ ! -z "$BP_CCIN" ] ; then
      printf "%24s = %s\n" "$PRC_CCINd" "${PRC_CCIN},${BP_CCIN}"
   fi
   if [ ! -z "$PRC_CCIN" ] && [  -z "$BP_CCIN" ] ; then
      printf "%24s = %s\n" "$PRC_CCINd" "${PRC_CCIN},na"
   fi
   if [ -z "$PRC_CCIN" ] && [ ! -z "$BP_CCIN" ] ; then
      printf "%24s = %s\n" "$PRC_CCINd" "${BP_CCIN}"
   fi

   CUOD_Procs=`lscfg -vp 2>/dev/null |grep WAY | sed s,\:,, |sort | uniq -c | awk '{print $1,$2,$3,$4}'`
   CUOD_YProcs=`lscfg -vp 2>/dev/null |grep WAY | grep CUOD | sed s,\:,, |sort | uniq -c | awk '{print $1,$2}'`
   if [ ! -z "$CUOD_Procs" ] ; then
      # If the Processor display has CUOD display differntly. 
      if [ ! -z "$CUOD_YProcs" ] ; then
         CUOD_YProcsd="Proc CUOD"
         printf "%24s = %s\n" "$CUOD_YProcsd" "$CUOD_YProcs"
      else
         CUOD_Procsd="Processors"
         printf "%24s = %s\n" "$CUOD_Procsd" "$CUOD_Procs"
      fi
   fi

   Proc_Clk_Speed=`prtconf -s 2>/dev/null | awk '{print $(NF-1), $NF}'`
   if [ ! -z "$Proc_Clk_Speed" ] ; then
      Proc_Clk_Speedd="Processor Clock Speed"
      printf "%24s = %s\n" "$Proc_Clk_Speedd" "$Proc_Clk_Speed"
   fi


   # Get Plant Code and Model ID using /proc/ppc64/lparcfg serial_number on IBM ppc64
   if [ -e /proc/ppc64/lparcfg ]; then
      jpc_mi=`grep "^serial_number" /proc/ppc64/lparcfg | awk -F= '{print $NF}'`
   fi
   if [ "x${jpc_mi}x" != "xx" ]; then
      pc_mid="Plant Code and Model ID"
      printf "%24s = %s\n" "$pc_mid" "$jpc_mi"
   fi
   # Get Partition ID using /proc/ppc64/lparcfg partion_id on IBM ppc64
   if [ -e /proc/ppc64/lparcfg ]; then
      jpart_id=`grep "^partition_id" /proc/ppc64/lparcfg | awk -F= '{print $NF}'`
   fi
   if [ "x${jpart_id}x" != "xx" ]; then
      part_idd="Partition ID"
      printf "%24s = %s\n" "$part_idd" "$jpart_id"
   fi



   if [ -s /sbin/ppc64_cpu ] || [ -s /usr/sbin/ppc64_cpu ] ; then
      # Get Power Savings Mode (ppc64_cpu) IBM ppc64
      PwrSvngMode=`ppc64_cpu --frequency -t 1 2>/dev/null | grep "Power Savings Mode:" | sed s,:\ ,:, | awk -F: '{print $2}'`
      if [ "x${PwrSvngMode}x" != "xx" ]
      then
         PwrSvngModed='Power Savings Mode'
         printf "%24s = %s\n" "$PwrSvngModed" "$PwrSvngMode"
      fi

      # Get Average CPU Speed (ppc64_cpu) IBM ppc64
      AvgCpuSpeed=`ppc64_cpu --frequency -t 1 2>/dev/null | grep avg | sed s,GHz,, | sed -e "s,:\	,:," |awk -F: '{print $2*1000,"MHz"}'`
      if [ "x${AvgCpuSpeed}x" != "xx" ]
      then
         AvgCpuSpeedd='Average CPU Speed'
         printf "%24s = %s\n" "$AvgCpuSpeedd" "$AvgCpuSpeed"
      fi
   fi


   # Get clock IBM ppc64
   jclock=`grep "^clock" /proc/cpuinfo 2>/dev/null | sed -e "s,00M,\ M,"  | awk '{print int($(NF-1)), $NF}' | sort | uniq -c | sed s,^\ \ *,, | sed s,\ ,\@, | tr '\n' ',' | sed s/,/,\ /g  | sed s/,\ $//`
   if [ "x${jclock}x" != "xx" ]; then
      sysclockd="Processor frequency"
      printf "%24s = %s\n" "$sysclockd" "$jclock"
   fi
fi

if [ "$OStype" = "Linux" ] && [ "$jproctype" != "ppc64" ] ; then
   jmodname=`grep "^model name" /proc/cpuinfo | sed s,:\ ,:,g |sed -e "s,\ \ *,\ ,g" | awk -F: '{print $NF}' | uniq`
   if [ "x${jmodname}x" != "xx" ]; then
      modnamed='CPU model name'
      printf "%24s = %s\n" "$modnamed" "$jmodname"
   fi
fi

   # The next uncommented line will gather 4 lines of info on linux systems.
   #
   #  We will strip the (s) and replace with s on these lines
   #                      CPU(s) = 4
   #          Thread(s) per core = 4
   #          Core(s) per socket = 1
   #                   Socket(s) = 1
   #
   # The lscpu command is used to get the information.
   # It will need to be tested on mainframe linux
   lscpu 2>/dev/null | tee ${installdir}/lscpu.hsllc | egrep "^CPU\(s\)|^Thread\(s\)|^Core\(s\)|^CPU sock|^Socket" | sed s,CPU\ s,S, | sed s,:\ \ *,:,| sed s,\(s\),s, | awk -F: '{ printf("%24s = %s\n", $1, $2)}'
   # Following may be slightly different in a virtual environment.
   # Calculate Total Cores from Sockets X Cores per Socket 
   # if the file ${installdir}/lscpu.hsllc exists.

   if [ -s ${installdir}/lscpu.hsllc ]; then
      Sockets=`egrep "^Socket|^CPU\ socket" ${installdir}/lscpu.hsllc | awk '{print $NF}'`     
      CoresPerSocket=`grep "per socket" ${installdir}/lscpu.hsllc | awk '{print $NF}'`     
      total_cores=`echo $Sockets $CoresPerSocket | awk '{print $1 * $2}'`
      # echo "Remove later" "Sockets=$Sockets CoresPerSocket=$CoresPerSocket"
      total_coresd="Total cores"
      printf "%24s = %s\n" "$total_coresd" "$total_cores"
   fi

      # File System Counts
      numfscnt=`findmnt | egrep "^├─/" | sed s,\ \ *,\;,g | sed s,^├─,, | wc -l | awk '{print $1}'`
      numfscntd="Number of File Systems"
      printf "%24s = %s\n" "$numfscntd" "$numfscnt"

      # Logical Volume Counts
      numlvcnt=`lvs | egrep -v "Attr" | sed s,\ \ *,\;,g | sed s,^├─,, | wc -l | awk '{print $1}'`
      numlvcntd="Number Logical Volumes"
      printf "%24s = %s\n" "$numlvcntd" "$numlvcnt"

      # Volume Group Counts
      numvgcnt=`vgs | egrep -v "Attr" | wc -l | awk '{print $1}'`
      numvgcntd="Number of Volume Groups"
      printf "%24s = %s\n" "$numvgcntd" "$numvgcnt"

  
   if [ -s /sbin/ppc64_cpu ]; then

      jtest=`/sbin/ppc64_cpu | grep ' \--subcores-per-core ' `
      if [ "$jtest" != "" ] ; then
         subcores_per_core=`/sbin/ppc64_cpu --subcores-per-core 2>/dev/null | awk '{print $NF}'` 
         subcores_per_cored="Subcores per core"
         printf "%24s = %s\n" "$subcores_per_cored" "$subcores_per_core"
      fi
      jtest=`/sbin/ppc64_cpu | grep ' \--threads-per-core ' `
      if [ "$jtest" != "" ] ; then
         threads_per_core=`/sbin/ppc64_cpu --threads-per-core|awk '{print $NF}'`
         threads_per_cored="Threads per core"
         printf "%24s = %s\n" "$threads_per_cored" "$threads_per_core"

      fi
      jtest=`/sbin/ppc64_cpu | grep ' \--smt ' `
      if [ "$jtest" != "" ] ; then
         smt_stat=`/sbin/ppc64_cpu --smt 2>/dev/null`
         smt_statd="Smt status"
         printf "%24s = %s\n" "$smt_statd" "$smt_stat"
      fi

   fi
   # Added kvm info
   which virsh 2>/dev/null > /tmp/helpsystems_tmp/virsh_test.tmp 
   if [ -s /tmp/helpsystems_tmp/virsh_test.tmp ] ; then
      virsh list --all \
         | sed s,\ \ *,\ ,g \
         | sed s,^\ \ *,\, \
         | egrep -v "Id |-----"  \
         | grep  -v ^$ > /tmp/helpsystems_tmp/virsh_list.tmp
      if [ -s /tmp/helpsystems_tmp/virsh_list.tmp ] ; then
         #      echo "# kvm Extra info"
         echo ""
         echo "# kvm virsh list and dominfo"
         printf "%2s  %10s  %10s  %3s  %10s\n" Id Domain State Cpu MaxMem\(Gb\)  
         echo "----------------------------------------------------"
         while 
         read jId jName jState
         do
            jCpu=`virsh dominfo $jName | egrep "CPU\(s\)" | awk '{print $2}'`
            jMaxMem=`virsh dominfo $jName | egrep "Max memory"  | awk '{printf "%-9.2f\n", $3/1024/1024}'`
            #      echo $jId $jName $jState $jCpu $jMaxMem 
            printf "%2s  %10s  %10s  %3s  %10s\n" $jId $jName $jState $jCpu $jMaxMem  
         done < /tmp/helpsystems_tmp/virsh_list.tmp 
         echo "#" # End of kvm Additional information
      fi
   fi
   # First find cpu, min, cur, max, and gov.
   find /sys/devices/system/cpu -name cpuinfo_min_freq | xargs grep [0-9] | sed s,\/sys\/devices\/system\/cpu\/,, | sed s,\/cpufreq\/cpuinfo_min_freq,\ min,  | sed s,:,\ ,g | sort > /tmp/helpsystems_tmp/cpu_min.tmp
   find /sys/devices/system/cpu -name cpuinfo_cur_freq | xargs grep [0-9] | sed s,\/sys\/devices\/system\/cpu\/,, | sed s,\/cpufreq\/cpuinfo_cur_freq,\ cur,  | sed s,:,\ ,g | sort > /tmp/helpsystems_tmp/cpu_cur.tmp
   find /sys/devices/system/cpu -name cpuinfo_max_freq | xargs grep [0-9] | sed s,\/sys\/devices\/system\/cpu\/,, | sed s,\/cpufreq\/cpuinfo_max_freq,\ max,  | sed s,:,\ , | sort > /tmp/helpsystems_tmp/cpu_max.tmp
   find /sys/devices/system/cpu -name scaling_govern\* | xargs grep [a-z] | sed s,\/sys\/devices\/system\/cpu\/,, | sed s,\/cpufreq\/scaling_governor,\ gov, | sed s,:,\ ,g | sort > /tmp/helpsystems_tmp/cpu_gov.tmp
   # Second join for cpu, min, cur, max, gov
   join /tmp/helpsystems_tmp/cpu_max.tmp  /tmp/helpsystems_tmp/cpu_gov.tmp  > /tmp/helpsystems_tmp/cpu_max_gov.tmp
   join /tmp/helpsystems_tmp/cpu_min.tmp  /tmp/helpsystems_tmp/cpu_cur.tmp  > /tmp/helpsystems_tmp/cpu_min_cur.tmp
   join /tmp/helpsystems_tmp/cpu_min_cur.tmp /tmp/helpsystems_tmp/cpu_max_gov.tmp > /tmp/helpsystems_tmp/cpu_min_cur_max_gov.tmp
   # Third print out the cpu, min, cur, max, gov
   if [ -s /tmp/helpsystems_tmp/cpu_min_cur_max_gov.tmp ]; then    awk 'BEGIN { OFS = "," ; print "# kvm Cpu specs" ; print "Cpu#","Min","Cur","Max","Gov"}{print $1, $3, $5, $7, $9}' /tmp/helpsystems_tmp/cpu_min_cur_max_gov.tmp; fi
   # Fourth remove unneeded temporary files
   rm -f /tmp/helpsystems_tmp/cpu????.tmp /tmp/helpsystems_tmp/cpu????????.tmp

   ## Mainframe LPAR data
   if [ "$osm" = "s390x" ] ; then 
      lpnn=`cat /proc/sysinfo | grep 'LPAR Number:' | awk '{print $3}'`
      lpnnd="LPAR Number"
      printf "%22s = %sb\n" "$lpnnd" "$lpnn"

      lpchar=`cat /proc/sysinfo | grep 'LPAR Characteristics:' | awk '{print $3}'`
      lpchard="LPAR Characteristics"
      printf "%22s = %s\n" "$lpchard" "$lpchar"

      lpvmtot=`cat /proc/sysinfo | grep 'VM.. CPUs Total:' | awk '{print $4}'`
      lpvmtotd="VM Total CPUs"
      printf "%22s = %s\n" "$lpvmtotd" "$lpvmtot"
 
      lpvmcfg=`cat /proc/sysinfo | grep 'VM.. CPUs Configured:' | awk '{print $4}'`
      lpvmcfgd="VM Configured CPUs"
      printf "%22s = %s\n" "$lpvmcfgd" "$lpvmcfg"
   fi
 
   ## get disk info (number, name, and sizes)
   if [ -s /sbin/fdisk ]; then
      jtest=`/sbin/fdisk -l 2>/dev/null`
   else
      jtest='' 
   fi
   if [ "x${jtest}x" != "xx" ] 
   then 
      echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
   /sbin/fdisk -l 2>/dev/null | egrep "Disk" | sed s,Disk\ i,I,g | sed -e "s,Identifier:,Id is,g"  | paste - -  | sed -e "s/	/\,\ /g" | grep -v "\/loop[0-9]"
      echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
   fi

#   i=0
#   for d in `/sbin/fdisk -l 2>/dev/null | grep 'Disk' | sed 's/://g' | awk '{print $2}'` 
#   do
#      diskname[$i]=`echo $d | sed 's/\/dev\///g; s/://g'`
#      disksize[$i]=`/sbin/fdisk -l $d 2>/dev/null | grep 'Disk' | sed 's/\/dev\///g; s/://g; s/,//g' | awk '{print $3, $4}'`
#      disksizedesc[$i]='Size'
#      disp_disksize[$i]=" ${disksizedesc[$i]}: ${disksize[$i]}"
#      let i=$i+1
#      The next line replaces the line above and will set i to 0 if i is not
#      defined.
#      i=`expr "${i-0}" + 1`
#      let i=$i+1
#   done
#   nd=$i
#   ## report disk info
#   echo ; echo "found $nd disk devices :"
#   i=0;
#   while [ $i -lt $nd ]
#   do
#      echo "${diskname[$i]}: ${disp_disksize[$i]}"
#      let i=$i+1
#      let i=$i+1
#      The next line replaces the line above and will set i to 0 if i is not
#      defined.
#      i=`expr "${i-0}" + 1`
#   done
   
   # Call to disk_info procedure
   disk_info 
   #
   # mpgdatadir total vs filesystem df -m versus du -m
   # Whole line of df and du is stored in disk_df_du.hsllc
   if [ -s ${nminst}/pn.config ];  then
      . ${nminst}/pn.config
   fi
   if [ -s /etc/pn.conf ];  then
      . /etc/pn.conf 
   fi
   if [ -s /usr/bin/nvidia-smi ] || [ -s /bin/nvidia-smi ]  ; then
      echo "######################"
      echo "# nvidia-smi --query #"
      nvidia-smi --query 
      # echo "# end results nvidia-smi --query #"
   fi
   echo "`df -Pm ${mpgdatadir} \
      | tail -1` `du -m ${mpgdatadir} \
      | tail -1`" \
      | sed s,\ \ *,\ ,g \
      | sed s,%,,g \
      | sed s,\	\	\*,\ ,g \
      | sed -e "s/\ /\,/g" > disk_df_du.hsllc
   echo "# mpg data directory"
   echo "FS,FSSizeMB,FSUsedMB,FSFreeMB,%full,FSMount,PerfDataMB,PerfDataDir" 
   echo "`cat disk_df_du.hsllc`"

   echo "# File Systems Details"
   findmnt | egrep "^├─/|TARGET" | sed s,\ \ *,\;,g | sed s,^├─,,
  
   echo "# Logical Volumes Detail"
   lvs
  
   echo "# Volume Groups Details"
   vgs
 
} 

rac_hpux () {
   #####
   # hpux rack config info
   #####
   ## uname -i	gets the machine id #  (?equiv AIX serial # ?)
   ## getconf	gets hpux specific stuff - possibly useful ones:
   ##	MACHINE_MODEL	= "model" command
   # vmstat	
   # ? iostat
   # ? hwconf
   rac_generic
   ##### semi-os specific
   ##### os specific
   osm=`model`	## more complete than uname -m
   osmd="Machine model"
   printf "%20s = %s\n" "$osmd" "$osm"

   osi=`$juname -i 2>/dev/null`
   osid="Machine ID"
   printf "%20s = %s\n" "$osid" "$osi"
  
   if [ "x${jmachinfo}x" != "xx" ] ; then
 
      mem=`$jmachinfo | grep -i memory | sed s,:,\ :, | cut -d" " -f3-4`
      if [ "x${mem}x" != "xx" ]
      then
         memd="Memory"
         printf "%20s = %s\n" "$memd" "$mem"
      fi

      CpuCount=`$jmachinfo | grep "Number of CPUs" | sed s,^.*\=\ ,,`
      if [ "x${CpuCount}x" != "xx" ]
      then
         CpuCountd="# of CPUs"
         printf "%20s = %s\n" "$CpuCountd" "$CpuCount"
      fi

      CpuSpeed=`$jmachinfo | grep "Clock speed" | sed s,^.*\=\ ,,`
      if [ "x${CpuSpeed}x" != "xx" ]
      then
         CpuSpeedd="CPU Speed"
         printf "%20s = %s\n" "$CpuSpeedd" "$CpuSpeed"
      fi

      CpuInfo=`$jmachinfo | grep "processor" | sed s,^\ *,,`
      if [ "x${CpuInfo}x" != "xx" ]
      then
         CpuInfod="CPU Info"
         # Removed print of CPU Info, but segmented instead
         # printf "%20s = %s\n" "$CpuInfod" "$CpuInfo"
         CpuCountd="CPU Count"
         CpuCount=`echo $CpuInfo |awk '{print $1}'`
         if [ "x${CpuCount}x" != "xprocessorx" ]; then
            printf "%20s = %s\n" "$CpuCountd" "$CpuCount"
            CpuTyped="CPU Type"
            CpuType=`echo $CpuInfo \
               | grep proc \
               | grep ')$' \
               | sed s,\ \(.*,,g \
               | sed s,^\ \*,,g  | cut -d" " -f2-`
            printf "%20s = %s\n" "$CpuTyped" "$CpuType"
            CpuSpeedd="CPU Speed"
            CpuSpeed=`echo $CpuInfo | grep proc | grep ')$' | sed s/\,.*//g | sed s/^.*\(// | awk '{if($2 == "GHz") {print $1 * 1000, "MHZ"} else {print $0}}'`
            printf "%20s = %s\n" "$CpuSpeedd" "$CpuSpeed"
         fi
      fi

      CpuType=`$jmachinfo | grep "processor model:" \
                     | sed s,\ \ *,\ ,g  | sed s,^\ ,, \
                     | cut -d" " -f4-`
      if [ "x${CpuType}x" != "xx" ]
      then
         CpuTyped="CPU Type"
         printf "%20s = %s\n" "$CpuTyped" "$CpuType"
      fi

      #
      # Cores per socket = 2
      # L3 Cache (per core) = 9216 KB
      #

      L3Cache=`$jmachinfo -v \
         | grep L3 \
         | sed s/\,.*// \
         | awk '{print $(NF-1), $NF}'`

      if [ "x${L3Cache}x" != "xx" ]
      then
         PerCore=`$jmachinfo -v \
                      | grep -i "(per core)" \
                      | sed s/\,.*// \
                      | awk '{print $(NF-1), $NF}'`
         # CoresPerSocket if not specified it will be one, unless there is 
	 # a per core statement it will be two.
	 CoresPerSocket=`$jmachinfo -v \
            | grep -i "Cores per socket" \
            | sed s/\,.*// \
            | awk '{print $(NF-1), $NF}'`

         if [ "x${CoresPerSocket}x" != "xx" ]
         then
            CoresPerSocketd="Cores per socket"
	 else
            CoresPerSocketd="Cores per socket"
            CoresPerSocket="1"
         fi
         if [ "x${PerCore}x" != "xx" ]
         then
            L3Cached="L3 Cache \(per core\)"
            CoresPerSocket="2"
         else
            L3Cached="L3 Cache"
         fi
         printf "%20s = %s\n" "$CoresPerSocketd" "$CoresPerSocket"
         printf "%20s = %s\n" "$L3Cached" "$L3Cache"
      fi

   fi

   # Added in for processor counts on older HP-UX machines that do not have machinfo
   # ioscan -fnk 2>/dev/null |grep -i Processor |wc -l 
   if [ "x${CpuCount}x" = "xx" ]
   then
      CpuCount=`ioscan -fnk 2>/dev/null |grep -i Processor |wc -l | awk '{print $1}'`
      CpuCountd="# of CPUs"
      if [ "${CpuCount}" -eq 0 ]
      then
         CpuCount='?'
      fi
      printf "%20s = %s\n" "$CpuCountd" "$CpuCount"
   fi
  
   # Added in for Memory check on older HP-UX machines that do not have machinfo
   if [ "x${mem}x" = "xx" ]; then
      mem=`/opt/ignite/bin/print_manifest 2>/dev/null |grep -i memory| awk '{print $(NF-1),$NF}'`
      if [ "x${mem}x" != "xx" ]; then
         memd="Memory"
         printf "%20s = %s\n" "$memd" "$mem"
      else
         printf "%20s = %s\n" "$memd" "Unknown"
      fi
   fi
   
   locate_app hpvminfo
   jchk=$?
   if [ $jchk -eq 0 ] ; then 
      HostSerial=`$jloc -V | grep "Host serial number" | awk '{print $NF}'`
      if [ "x${HostSerial}x" != "xx" ]
      then
         HostSeriald="Host serial"
         printf "%20s = %s\n" "$HostSeriald" "$HostSerial"
      fi
      HostServer=`$jloc -V | grep "Host model string" | awk '{print $NF}'`
      if [ "x${HostServer}x" != "xx" ]
      then
         HostServerd="Host server model"
         printf "%20s = %s\n" "$HostServerd" "$HostServer"
      fi
   fi

   
   # Call to disk_info procedure
   disk_info  
}

rac_darwin () {
   #####
   # darwin specific rack config
   #####
   #####
   # Identify disks and paths for later use
   #####




   rac_generic

   platform=`$juname -i 2>/dev/null`
   jprtdiag=/usr/platform/`uname -i 2>/dev/null`/sbin/prtdiag
   jsolaris_sbin=/usr/platform/`uname -i 2>/dev/null`/sbin/

   osc="`$jprtdiag 2>/dev/null | sed -e "s,\ \ *,\ ,g" | awk -F: '/System Configuration/ {print $2}'`"
   if [ "x${osc}x" != "xx" ] 
   then 
      oscd="System Configuration"
      printf "%23s = %s\n" "$oscd" "$osc"
   fi

   # Specifically for Darwin
   system_profiler SPHardwareDataType 2>/dev/null | grep ": " | sed s,\ \ *,\ ,g | sed s,\:\ ,:, | sed s,^\ ,,  > system_profiler_SPHardwareDataType.hsllc

   while IFS='' read -r line || [[ -n "$line" ]]; do
   tmpsysprof=`echo $line|awk -F: '{print $2}''`
   tmpsysprofd=`echo $line|awk -F: '{print $1}''`
   if [ "x${tmpsysprof}x" != "xx" ] && [ "x${tmpsysprofd}x" != "xx" ] 
   then 
      printf "%23s = %s\n" "$tmpsysprofd" "$tmpsysprof"
   fi
   done < system_profiler_SPHardwareDataType.hsllc
  
   # Call to disk_info procedure
   if [ "$OStype" = "Darwin" ] ; then
      diskutil list | grep dev  | awk '{print $1,1}' > darwin_paths.hsllc
   fi
   disk_info  
}


rac_solaris () {
   #####
   # solaris specific rack config
   #####

   rac_generic

   platform=`$juname -i 2>/dev/null`
   jprtdiag=/usr/platform/`uname -i 2>/dev/null`/sbin/prtdiag
   jsolaris_sbin=/usr/platform/`uname -i 2>/dev/null`/sbin/

   osc="`$jprtdiag 2>/dev/null | sed -e "s,\ \ *,\ ,g" | awk -F: '/System Configuration/ {print $2}'`"
   if [ "x${osc}x" != "xx" ] 
   then 
      oscd="System Configuration"
      printf "%23s =%s\n" "$oscd" "$osc"
   fi

   # sysclock=`$jprtdiag 2>/dev/null | awk -F: '/System clock frequency/ {print $2}'`
   # if [ "x${sysclock}x" != "xx" ] 
   # then 
   #    sysclockd="System clock frequency"
   #    printf "%23s =%s\n" "$sysclockd" "$sysclock"
   # fi

   # jclock=`psrinfo -vp \
   # jclock=`psrinfo -v \
   #    | grep -i hz\
   #    | sed -e "s,The\ ,,g" \
   #    | sed -e "s/,//g" \
   #    | sed -e "s,(,,g" \
   #    | sed -e "s,),,g" | awk '{print $(NF-1),$NF}' | uniq`  
   # if [ "x${jclock}x" != "xx" ] 
   # then 
   #    sysclockd="Processor frequency"
   #    printf "%23s = %s\n" "$sysclockd" "$jclock"
   # fi

   mem=`$jprtdiag 2>/dev/null |awk -F: '/Memory size/ {print $2}'`
   if [ "x${mem}x" != "xx" ] 
   then 
      memd="Memory size"
      printf "%23s = %s\n" "$memd" "$mem"
   else  
      # Alternative way to get memory size if first does not work
      ###  prtconf | grep -v "^$"| awk '{print "prtconf.out"NR" =",$0}'
      prtconf -vp 2>/dev/null  | egrep "^Memory size:" \
         | sed -e "s,^\ *,,"  \
         | sed -e "s,\ \ *,\ ,g" \
         | sed -e "s,:,\ =," \
         | sed -e "s,\',,g"  \
         | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'
   fi

   ###  prtconf | grep -v "^$"| awk '{print "prtconf.out"NR" =",$0}'
   prtconf -vp 2>/dev/null  | egrep "^    name:|^    model:" \
      | sed -e "s,^\ *,,"  \
      | sed -e "s,\ \ *,\ ,g" \
      | sed -e "s,:,\ =," \
      | sed -e "s,\',,g"  \
      | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'


   $juname -X | egrep "Machine|NumCPU" \
      | sed -e "s,^\ *,,"  \
      | sed -e "s,\ \ *,\ ,g" \
      | sed -e "s,:,\ =," \
      | sed -e "s,\',,g"  \
      | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'

   if [ -s /usr/sbin/smbios ] ; then
      /usr/sbin/smbios 2>/dev/null > ./smbios.test 
      if [ -s ./smbios.test ] ; then
         /usr/sbin/smbios -t SMB_TYPE_SYSTEM \
            | grep : \
            | egrep "Manu|Prod|Vers|Seri|UUID" \
            | sed -e "s,:,\ =," \
            | sed -e "s,\ \ *,\ ,g"\
            | sed -e "s,^,System,g"\
            | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'

         /usr/sbin/smbios -t SMB_TYPE_BIOS \
            | grep : \
            | egrep "Vend|Vers|Rele" \
            | sed -e "s,:,\ =," \
            | sed -e "s,\ \ *,\ ,g"\
            | sed -e "s,^,Bios,g"\
            | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'

         /usr/sbin/smbios -t SMB_TYPE_CHASSIS \
            | grep : \
            | egrep "Type" \
            | sed -e "s,:,\ =," \
            | sed -e "s,\ \ *,\ ,g"\
            | sed -e "s,^\ ,,g"\
            | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'

         /usr/sbin/smbios -t SMB_TYPE_PROCESSOR \
            | grep : \
            | egrep "Manu|Vers|Curr" \
            | sed -e "s,:,\ =," \
            | sed -e "s,\ \ *,\ ,g"\
            | sed -e "s,^,Processor,g"\
            | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'

         /usr/sbin/smbios -t SMB_TYPE_MEMARRAYMAP \
            | grep : \
            | grep Size \
            | sed -e "s,:,\ =," \
            | sed -e "s,\ \ *,\ ,g"\
            | sed -e "s,^,Total Memory,g"\
            | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'

         /usr/sbin/smbios -t SMB_TYPE_MEMDEVICE \
            | grep : \
            | egrep "Location|Size|Type" \
            | sed -e "s,:,\ =," \
            | sed -e "s,\ \ *,\ ,g"\
            | sed -e "s,^,MemCard,g"\
            | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'
      fi
   fi

   # Many details came from script showcpuinfo for Solaris.
   if [ -s /usr/bin/kstat ]; then
      /usr/bin/kstat -m cpu_info  | egrep -i "chip_id|core_id|module: cpu_info|clock_Mhz" > /tmp/helpsystems_tmp/cpu_info.log
   fi
   if [ -s /tmp/helpsystems_tmp/cpu_info.log ]; then
      # The next line was used for testing only
      # cat  /tmp/helpsystems_tmp/cpu_info.log_hold | egrep -i "chip_id|core_id|module: cpu_info|clock_Mhz" > /tmp/helpsystems_tmp/cpu_info.log
      Sockets=`(grep chip_id /tmp/helpsystems_tmp/cpu_info.log | awk '{ print $2 }' | sort -u | wc -l | tr -d ' ')`
      TotalCores=`(grep core_id /tmp/helpsystems_tmp/cpu_info.log | awk '{ print $2 }' | sort -u | wc -l | tr -d ' ')`
      CPUs=`(grep 'module: cpu_info' /tmp/helpsystems_tmp/cpu_info.log | awk '{ print $4 }' | sort -u | wc -l | tr -d ' ')`
      ThreadsPerCore=$(($CPUs/$TotalCores))
      CoresPerSocket=$(($TotalCores/$Sockets))
      SpeedMHz=`(grep clock_MHz /tmp/helpsystems_tmp/cpu_info.log | awk '{ print $2 }' | sort -u)`
      # Next line was placed for trouble shooting
      # echo "($speedinmhz)"

      # SpeedGHz will not be used
      SpeedGHz=`echo "scale=2; $SpeedMHz/1000" | bc`

      SpeedMHzd="Processor frequency" 
      printf "%23s = %s\n" "$SpeedMHzd" "$SpeedMHz MHz" 
      CPUsd="CPUs"
      printf "%23s = %s\n" "$CPUsd" "$CPUs"
      ThreadsPerCored="Threads per core"
      printf "%23s = %s\n" "$ThreadsPerCored" "$ThreadsPerCore"
      CoresPerSocketd="Cores per socket"
      printf "%23s = %s\n" "$CoresPerSocketd" "$CoresPerSocket"
      Socketsd="Sockets"
      printf "%23s = %s\n" "$Socketsd" "$Sockets"
      TotalCoresd="Total cores"
      printf "%23s = %s\n" "$TotalCoresd" "$TotalCores"
   fi
   # End of details which came from script showcpuinfo for Solaris.

   # Determine Solaris Zonetype, poolstat and name
   ps -ef | grep "\/sbin\/init" | grep -v grep 2>/dev/null | awk '{if($2==1 && $3==0 ) print $0 }' > /tmp/helpsystems_tmp/chk_global.tmp
   if [ -s /tmp/helpsystems_tmp/chk_global.tmp ]; then
      Chk_Global="Global"
      Zonename="global"
      Poolstat=`poolstat 2>/dev/null | grep [0-9] | grep " 0 " | awk '{print $1, $2, $3}'`
   else
      Chk_Global="Non-Global"
      Zonename=`zoneadm list 2>/dev/null`
      Poolstat=`poolstat 2>/dev/null | grep [0-9] | awk '{print $1, $2, $3}'`
   fi
   Zone_Type=`echo $Zonename $Chk_Global`
   if [ "x${Zone_Type}x" != "x x" ]
   then
      Zone_Typed="Zone"
      printf "%23s = %s\n" "$Zone_Typed" "$Zone_Type"
   fi
   if [ "x${Poolstat}x" != "xx" ]
   then
      Poolstatd="Pool"
      printf "%23s = %s\n" "$Poolstatd" "$Poolstat"
   fi

   # End of Solaris Zonetype, poolstat and name


   # Added blank line to be consistent with AIX output
   echo "" 
   # ====================
   # This will work for Solaris 8,9,10, and 11
   # ====================
   iostat -E \
      | egrep "Model|Vendor|Size|Soft" \
      | sed s,\ Size:,\
Size:, \
      | sed s,Revision.*Serial\ No:,, \
      | sed s,\<.*\>,, \
      | sed s,Soft.*$,, | paste - - -\
      | sed s,\	,\ ,g \
      | sed -e 's,\ [A-Z][a-z]*:\ ,,g' \
      | sed s,\ \ *,\ ,g \
      | egrep -v "0.00GB|[0-9]XCD|\ st[0-9]|\ JLMS\ " \
      | awk '{print "Device",NR,$0}' | sed s,GB\ $,\ GB, > ./disktest.$sysname.tmp
   #   | awk '{print $1,$2,$3,$(NF-2)}'
   jdiskline=` wc -l ./disktest.$sysname.tmp | awk '{print $1}'`
   echo "found $jdiskline disk devices :"
   cat ./disktest.$sysname.tmp
   rm -f ./disktest.$sysname.tmp

   cat *.err 2>/dev/null | awk '{print "# Error",$0}'
   rm -f *.err *.test
   if [ ! -z "$debug" ] ; then
      # Section put in debug only (possibly too much info)
      # jtest=`psrinfo -vp`
      jtest=`psrinfo -v`
      if [ "x${jtest}x" != "xx" ] ; then
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
	     # psrinfo -vp | awk '{print "#",$0}'
	     psrinfo -v | awk '{print "#",$0}'
	     echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
      fi
   fi

   which zfs | grep zfs$
   jchk=$?
   if [ ${jchk} -eq 0 ]; then
      # jtest=`ps -ef | grep "\/sbin\/init" | grep -v grep `
      jtest=`ps -ef | grep "\/sbin\/init" | grep -v grep 2>/dev/null`
      if [ "x${jtest}x" != "xx" ]
      then
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
         echo "# ps -ef | grep \/sbin\/init | grep -v grep 2>/dev/null"
         # ps -ef | grep "\/sbin\/init" | grep -v grep 2>/dev/null | awk '{print "#",$0}'
         ps -ef | grep "\/sbin\/init" 2>/dev/null | grep -v grep | awk '{print "#",$0}'
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
      fi
      # jtest=`poolstat`
      jtest=`poolstat 2>/dev/null`
      if [ "x${jtest}x" != "xx" ]
      then
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
         echo '# poolstat'
         # poolstat | awk '{print "#",$0}'
         poolstat | awk '{print "#",$0}'
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
      fi
      # jtest=`zoneadm list`
      jtest=`zoneadm list 2>/dev/null`
      if [ "x${jtest}x" != "xx" ]
      then
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
         echo '# zoneadm list'
         # zoneadm list | awk '{print "#",$0}'
         zoneadm list | awk '{print "#",$0}'
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
      fi
      # jtest=`zfs list`
      jtest=`zfs list 2>/dev/null`
      if [ "x${jtest}x" != "xx" ]
      then
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
         echo '# zfs list'
         # zfs list | awk '{print "#",$0}'
         zfs list | awk '{print "#",$0}'
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
      fi
      # jtest=`zpool list`
      jtest=`zpool list 2>/dev/null`
      if [ "x${jtest}x" != "xx" ]
      then
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
         echo '# zpool list'
         # zpool list | awk '{print "#",$0}'
         zpool list | awk '{print "#",$0}'
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
         # jtest=`zpool list | egrep -vi "NAME|no pool" | awk '{print $1}'`
         jtest=`zpool list | egrep -vi "NAME|no pool" | awk '{print $1}' 2>/dev/null`
         if [ "x${jtest}x" != "xx" ]
         then
            for jpool in $jtest
            do
            echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
               echo "# zpool status $jpool"
               zpool status $jpool | awk '{print "#",$0}'
            echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
            done
         fi
      fi
   fi
   
   if [ "$OStype" = "Darwin" ] ; then
      diskutil list | grep dev  | awk '{print $1,1}' > darwin_paths.hsllc
   fi
   # Call to disk_info procedure
   disk_info  
}

rac_sco () {
   #####
   # sco specific rack config
   #####

   rac_generic
   # echo "Start_sco_specific details"
   platform=`$juname -i 2>/dev/null`
   jprtdiag=/usr/platform/`uname -i 2>/dev/null`/sbin/prtdiag
   jsolaris_sbin=/usr/platform/`uname -i 2>/dev/null`/sbin/

   osc="`$jprtdiag 2>/dev/null | sed -e "s,\ \ *,\ ,g" | awk -F: '/System Configuration/ {print $2}'`"
   if [ "x${osc}x" != "xx" ] 
   then 
      oscd="System Configuration"
      printf "%23s =%s\n" "$oscd" "$osc"
   fi

#   jclock=`psrinfo -v | tee psrinfo-v.hsllc \
#      | grep -i hz\
#      | sed -e "s,The\ ,,g" \
#      | sed -e "s/,//g" \
#      | sed -e "s,(,,g" \
#      | sed -e "s,),,g" | awk '{print $(NF-1),$NF}' | uniq`  

   # Run once since it takes some time.
   hw 2>/dev/null > /tmp/helpsystems_tmp/hw_output.tmp

   jclock=`cat /tmp/helpsystems_tmp/hw_output.tmp \
              | grep -i "speed of C" \
              | sed s,Mhz,\ Mhz, \
              | awk '{print $(NF-1),$NF}' \
              | sort -n \
              | tail -1`
   if [ "x${jclock}x" != "xx" ] 
   then 
      sysclockd="Processor frequency"
      printf "%23s = %s\n" "$sysclockd" "$jclock"
   fi
   mem=`cat /tmp/helpsystems_tmp/hw_output.tmp | grep "Total Mem" | awk '{print $(NF-1),$NF}'`

   if [ "x${mem}x" != "xx" ] 
   then 
      memd="Memory size"
      printf "%23s = %s\n" "$memd" "$mem"
   else  
      # Alternative way to get memory size if first does not work
      ###  prtconf | grep -v "^$"| awk '{print "prtconf.out"NR" =",$0}'
      prtconf -vp 2>/dev/null  | egrep "^Memory size:" \
         | sed -e "s,^\ *,,"  \
         | sed -e "s,\ \ *,\ ,g" \
         | sed -e "s,:,\ =," \
         | sed -e "s,\',,g"  \
         | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'
   fi

   oemid=`cat /tmp/helpsystems_tmp/hw_output.tmp | grep "oemid" | awk -F\" '{print $2}'`
   if [ "x${oemid}x" != "xx" ] 
   then 
      oemidd="OEM Id"
      printf "%23s = %s\n" "$oemidd" "$oemid"
   fi

   prodid=`cat /tmp/helpsystems_tmp/hw_output.tmp | grep "productid" | awk -F\" '{print $2}'`
   if [ "x${prodid}x" != "xx" ] 
   then 
      prodidd="Product Id"
      printf "%23s = %s\n" "$prodidd" "$prodid"
   fi

   prtconf -vp 2>/dev/null  | egrep "^    name:|^    model:" \
      | sed -e "s,^\ *,,"  \
      | sed -e "s,\ \ *,\ ,g" \
      | sed -e "s,:,\ =," \
      | sed -e "s,\',,g"  \
      | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'


   $juname -X | egrep "Machine|NumCPU" \
      | sed -e "s,^\ *,,"  \
      | sed -e "s,\ \ *,\ ,g" \
      | sed -e "s,:,\ =," \
      | sed -e "s,\',,g"  \
      | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'

   if [ -s /usr/sbin/smbios ] ; then
      /usr/sbin/smbios 2>/dev/null > ./smbios.test 
      if [ -s ./smbios.test ] ; then
         /usr/sbin/smbios -t SMB_TYPE_SYSTEM \
            | grep : \
            | egrep "Manu|Prod|Vers|Seri|UUID" \
            | sed -e "s,:,\ =," \
            | sed -e "s,\ \ *,\ ,g"\
            | sed -e "s,^,System,g"\
            | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'

         /usr/sbin/smbios -t SMB_TYPE_BIOS \
            | grep : \
            | egrep "Vend|Vers|Rele" \
            | sed -e "s,:,\ =," \
            | sed -e "s,\ \ *,\ ,g"\
            | sed -e "s,^,Bios,g"\
            | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'

         /usr/sbin/smbios -t SMB_TYPE_CHASSIS \
            | grep : \
            | egrep "Type" \
            | sed -e "s,:,\ =," \
            | sed -e "s,\ \ *,\ ,g"\
            | sed -e "s,^\ ,,g"\
            | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'

         /usr/sbin/smbios -t SMB_TYPE_PROCESSOR \
            | grep : \
            | egrep "Manu|Vers|Curr" \
            | sed -e "s,:,\ =," \
            | sed -e "s,\ \ *,\ ,g"\
            | sed -e "s,^,Processor,g"\
            | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'

         /usr/sbin/smbios -t SMB_TYPE_MEMARRAYMAP \
            | grep : \
            | grep Size \
            | sed -e "s,:,\ =," \
            | sed -e "s,\ \ *,\ ,g"\
            | sed -e "s,^,Total Memory,g"\
            | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'

         /usr/sbin/smbios -t SMB_TYPE_MEMDEVICE \
            | grep : \
            | egrep "Location|Size|Type" \
            | sed -e "s,:,\ =," \
            | sed -e "s,\ \ *,\ ,g"\
            | sed -e "s,^,MemCard,g"\
            | awk '{jeq=index($0,"=")}{j1st=substr($0,1,jeq-2)}{j2nd=substr($0,jeq+2)}{printf("%23s = %s\n", j1st, j2nd)}'
      fi
   fi
   # Added blank line to be consistent with AIX output
   echo "" 
   # ====================
   # This will work for Solaris 8,9,10, and 11
   # ====================
   iostat -E 2>/dev/null  \
      | egrep "Model|Vendor|Size|Soft" \
      | sed s,\ Size:,\
Size:, \
      | sed s,Revision.*Serial\ No:,, \
      | sed s,\<.*\>,, \
      | sed s,Soft.*$,, | paste - - -\
      | sed s,\	,\ ,g \
      | sed -e 's,\ [A-Z][a-z]*:\ ,,g' \
      | sed s,\ \ *,\ ,g \
      | egrep -v "0.00GB|[0-9]XCD|\ st[0-9]|\ JLMS\ " \
      | awk '{print "Device",NR,$0}' | sed s,GB\ $,\ GB, > ./disktest.$sysname.tmp
   #   | awk '{print $1,$2,$3,$(NF-2)}'
   jdiskline=` wc -l ./disktest.$sysname.tmp | awk '{print $1}'`
   echo "found $jdiskline disk devices :"
   cat ./disktest.$sysname.tmp
   rm -f ./disktest.$sysname.tmp

   cat *.err 2>/dev/null | awk '{print "# Error",$0}'
   rm -f *.err *.test
   if [ ! -z "$debug" ] ; then
      # Section put in debug only (possibly too much info)
      # jtest=`psrinfo -vp` 
      jtest=`psrinfo -v` 
      if [ "x${jtest}x" != "xx" ] 
      then 
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
         # psrinfo -vp | awk '{print "#",$0}'
         psrinfo -v | awk '{print "#",$0}'
       echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
      fi
   fi
   
   which zfs | grep zfs$
   jchk=$?
   if [ ${jchk} -eq 0 ]; then
      # jtest=`zfs list`
      jtest=`zfs list 2>/dev/null`
      if [ "x${jtest}x" != "xx" ]
      then
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
         echo '# zfs list'
         # zfs list | awk '{print "#",$0}'
         zfs list | awk '{print "#",$0}'
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
      fi
      # jtest=`zpool list`
      jtest=`zpool list 2>/dev/null`
      if [ "x${jtest}x" != "xx" ]
      then
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
         echo '# zpool list'
         # zpool list | awk '{print "#",$0}'
         zpool list | awk '{print "#",$0}'
         echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
         # jtest=`zpool list | egrep -vi "NAME|no pool" | awk '{print $1}'`
         jtest=`zpool list | egrep -vi "NAME|no pool" | awk '{print $1}' 2>/dev/null`
         if [ "x${jtest}x" != "xx" ]
         then
            for jpool in $jtest
            do
            echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
               echo "# zpool status $jpool"
               zpool status $jpool | awk '{print "#",$0}'
            echo '# -~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~'
            done
         fi
      fi
   fi
   
   # Call to disk_info procedure
   echo 5 | fdisk | egrep "[0-9][0-9][0-9]" | grep Active > /tmp/helpsystems_tmp/jtmp
   cat /tmp/helpsystems_tmp/jtmp | awk '{print "#",$0}'
   grep "[0-9],[0-9]:" /var/adm/syslog | grep DISK | sed s,:,,g | sed s,\ \ *,\ ,g | cut -d" " -f5- | sort | uniq | awk '{print "#",$0}'
   echo "q" | divvy 2>/dev/null | egrep -v "\[|^$|quit" | awk '{print "#",$0}'
   disk_info  
}

df_data () {
   # generate historical file of DF data for  any OS)
   # printf "file system info: $dateformat\n"
   # 
   # df -Pk works for AIX and SCO.  The -P ensures the data is on one line 
   if [ "$OStype" = "AIX" ] || [ "$OStype" = "SCO_SV" ] ; then
      df -Pk \
         | sed s,Mounted\ on,Mounted_on,g \
         | sed s,\ \ *,\ ,g \
         | sed s/\ /,/g \
         | awk '{print jdate","$0}' jdate=$jdate \
         | egrep -v ",swap,|\/opt\/|,0,0,0,0|,0,0,0,-|,-,-,-,-|\/media\/|/dev/fd|\/etc/mnttab|\/proc|\/cdrom|\/dev\/cd[0-9]"
   # 
   # df -Pk works on most versions of Linux, and ensures data is on one line. 
   # However, some versions of Linux do not have the -P option.  In that case,
   # the sript will use df -k.
   elif [ "$OStype" = "Linux" ] ; then
      jtest=`df -Pk`
      if [ "x${jtest}x" != "xx" ] ; then
         df -Pk \
            | sed s,Mounted\ on,Mounted_on,g \
            | sed s,\ \ *,\ ,g \
            | sed s/\ /,/g \
            | awk '{print jdate","$0}' jdate=$jdate \
            | egrep -v "\/platform\/|,swap,|\/opt\/|,0,0,0,0|,-,-,-,-|\/media\/|/dev/fd|\/etc/mnttab|\/proc|\/cdrom|\/dev\/cd[0-9]"
      else
         jtest=`df -k`
         if [ "x${jtest}x" != "xx" ] ; then
            df -k \
               | sed s,Mounted\ on,Mounted_on,g \
               | sed s,\ \ *,\ ,g \
               | sed s/\ /,/g \
               | awk '{print jdate","$0}' jdate=$jdate \
               | egrep -v "\/platform\/|,swap,|\/opt\/|,0,0,0,0|,-,-,-,-|\/media\/|/dev/fd|\/etc/mnttab|\/proc|\/cdrom|\/dev\/cd[0-9]"
         else
            echo "*** Error *** The command (df -k) did not get an output."
         fi
      fi
   # 
   # bdf appears to work for HP-UX, the awk line corrects for breaks in data.   
   elif [ "$OStype" = "HP-UX" ] ; then
      bdf \
         | awk '{if (NF==1) {line=$0;getline;sub(" *"," ");print line$0} else {print}}' \
         | sed s,Mounted\ on,Mounted_on,g \
         | sed s,\ \ *,\ ,g \
         | sed s/\ /,/g \
         | awk '{print jdate","$0}' jdate=$jdate \
         | egrep -v "\/platform\/|,swap,|\/opt\/|,0,0,0,0|,-,-,-,-|\/media\/|/dev/fd|\/etc/mnttab|\/proc|\/cdrom|\/dev\/cd[0-9]"
   # 
   # df -k works Solaris.  The data is on one line. 
   elif [ "$OStype" = "Darwin" ] ; then
      df -k \
         | sed s,Mounted\ on,Mounted_on,g \
         | sed s,\ \ *,\ ,g \
         | sed s/\ /,/g \
         | awk '{print jdate","$0}' jdate=$jdate \
         | egrep -v "\/platform\/|,swap,|\/opt\/|,0,0,0,0|,-,-,-,-|\/media\/|/dev/fd|\/etc/mnttab|\/proc|\/cdrom|\/dev\/cd[0-9]"
   elif [ "$OStype" = "SunOS" ] ; then
      df -k \
         | sed s,Mounted\ on,Mounted_on,g \
         | sed s,\ \ *,\ ,g \
         | sed s/\ /,/g \
         | awk '{print jdate","$0}' jdate=$jdate \
         | egrep -v "\/platform\/|,swap,|\/opt\/|,0,0,0,0|,-,-,-,-|\/media\/|/dev/fd|\/etc/mnttab|\/proc|\/cdrom|\/dev\/cd[0-9]"
   elif [ "$OStype" = "SCO_SV" ] ; then
      df -k \
         | sed s,Mounted\ on,Mounted_on,g \
         | sed s,\ \ *,\ ,g \
         | sed s/\ /,/g \
         | awk '{print jdate","$0}' jdate=$jdate \
         | egrep -v "\/platform\/|,swap,|\/opt\/|,0,0,0,0|,-,-,-,-|\/media\/|/dev/fd|\/etc/mnttab|\/proc|\/cdrom|\/dev\/cd[0-9]"
   else
      # 
      # This is for systems unable to test.  IE Irix? 
      printf "*** Error *** file system info: ($OStype) is unknown OS\n"
   fi
}

### utility functions and default values :
invocdir=`dirname $0`	    #doesn't work with linux - need path as parm??
sysname=`$juname -n | awk -F. '{print $1}'` # used 4 default nmon datafile names

usage () {
   echo "USAGE: $0 [options]
   where options may be any of:
   -c <configfile>     specify configfile (full path)
   -T                  get topas data
   -D                  debug
   -v                  verbose
   "
}

while getopts "Dvc:T" opt; do
  case $opt in
	c)	opt_configfile=$OPTARG ;;
	T)	get_topas_data="T" ;;
        D)	debug="T" ;;
	v)	verbose="T" ;;
	?)	usage;  exit ;;
  esac
done

shift `expr $OPTIND - 1`

if [ ! -z "$opt_configfile" ]; then 
   configfile=$opt_configfile
else
   if [ -s ${invocdir}/pn.config ]; then 
      configfile=${invocdir}/pn.config 
   fi
fi

## Old comment ##### quick+dirty configfile - unsafe!
if [ ! -z "$configfile" ] ; then
   if [ -s "$configfile" ] ; then
      . $configfile
   else
      echo "Could not find (${configfile})!!!"
   fi
fi

set > /tmp/helpsystems_tmp/rackdata_set_env.tmp

if [ ! -d "$installdir" ] ; then
   if [ ! -z "$datafile" ] ; then
      installdir=`dirname $datafile` 
   else
      installdir=$invocdir 
   fi
fi

# For new split of nmondatadir installdir and mpgdatadir
if [  ! -d "$mpgdatadir" ] ; then
      mpgdatadir=$invocdir
fi


if [ ! -z "$debug" ] ; then echo "configfile=$configfile" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
if [ ! -z "$debug" ] ; then echo "sysname=$sysname" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi

outfile="${mpgdatadir}/rackdata.$sysname"
touch $outfile

if [ ! -z "$debug" ] ; then echo "outfile=$outfile" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi

echo "rackdata for $sysname" > $outfile
grep "\$Id\:" $0 | awk '{print $1,$3,$4,$5,$6}' >> $outfile
# Added in to specify version of nmon in use
mpgnmonfile=`ls -al nmon 2>/dev/null | awk '{print $NF}'` 
if [ -e ${datafile}.out.of.sequence ]; then
   echo "#" >> $outfile
   echo "# ${datafile} is out of sequence ( ./pndchk.sh )" >> $outfile
fi
if [ -s /usr/bin/topas_nmon ]; then
   echo "#" >> $outfile
   strings -a /usr/bin/topas_nmon  | grep 'topas\.c,'  | awk '{print "# Using /usr/bin/topas/nmon Version",$2,$(NF-1),$NF}' >> $outfile
   echo "#" >> $outfile
else
   find nmon -type l 2>/dev/null  >/dev/null
   jchk=$?
   if [ $jchk -eq 0 ]
   then
      echo "#" >> $outfile
      # in case strings does not exist..puppy?
      echo $mpgnmonfile `strings -a $mpgnmonfile 2>/dev/null | grep ^nmon\ [0-9]` | awk '{if (NF == 3)print "# Using",$1,"Version",$3}' > /tmp/helpsystems_tmp/jtest.tmp 
      # In case version is not in strings of compiled version
      # ./nmon -h | grep "Hint for nmon" | awk '{print $NF }'
      if [ ! -s /tmp/helpsystems_tmp/jtest.tmp ]; then
         ./nmon -h 2>/dev/null \
            | grep "Hint for nmon" \
            | awk -v jnmonname=$mpgnmonfile '{print "# Using", jnmonname, "Version", $NF}'  > /tmp/helpsystems_tmp/jtest.tmp
      fi
      if [ -s /tmp/helpsystems_tmp/jtest.tmp ]; then
         cat /tmp/helpsystems_tmp/jtest.tmp >> $outfile
      else
         echo "# $mpgnmonfile version_undetected" >> $outfile
      fi
      echo "#" >> $outfile
   else
      OStype=`$juname`
      if [ "$OStype" != "Linux" ] && [ "$OStype" != "AIX" ] ; then
         echo "#" >> $outfile
         echo "# Using sar to collect performance data on $OStype" >> $outfile
         echo "#" >> $outfile
      fi  
   fi
fi 


if [ -s ${installdir}/pn.config ]; then
   echo `grep "Performance Navigator installer version" ${installdir}/pn.config` >> $outfile
   echo "#" >> $outfile
fi

OStype=`$juname`
if [ ! -z "$debug" ] ; then echo "OStype=$OStype" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
if [ "$OStype" = "AIX" ] ; then
   rac_aix >> $outfile 
elif [ "$OStype" = "Linux" ] ; then
   rac_linux >> $outfile 
elif [ "$OStype" = "HP-UX" ] ; then
   rac_hpux >> $outfile 
elif [ "$OStype" = "SunOS" ] ; then
   rac_solaris >> $outfile 
elif [ "$OStype" = "Darwin" ] ; then
   rac_darwin >> $outfile 
elif [ "$OStype" = "SCO_SV" ] ; then
   rac_sco >> $outfile 
else
   echo "unknown system type : $OStype" >> $outfile 
   rac_generic >> $outfile 
fi

# Run chk_software into outfile for AIX or Linux
if [ "$OStype" = "AIX" ] || [ "$OStype" = "Linux" ] ; then
   chk_software >> $outfile 
fi

echo "# df history" >> $outfile
echo "# dfinfo" >> $outfile

dffile="${mpgdatadir}/df.$sysname"

#& rackdata history (rdhist.hostname) documents any changes that occur
#& in the top part of the rackdata.hostname file.
#&% rdhist.hold is used to retain last rackdata output for comparison.
#&% rdhist.tmp is a temporary file

rdhistfile="${mpgdatadir}/rdhist.$sysname"
rdhisthold="${installdir}/rdhist.hold"
rdhisttemp="${installdir}/rdhist.tmp"

cat $outfile | grep -v "^#" > $rdhisttemp

if [ ! -s $rdhistfile ] ; then
   touch $rdhisthold 
   touch $rdhistfile 
fi

if [ -s $rdhisthold ]; then
  cmp -s $rdhisttemp $rdhisthold 2>&1 > /dev/null
  jcmp=$?
else
  jcmp=1
fi

if [ $jcmp -ne 0 ] ;then
   cat $outfile | awk '{print JDate", "$0}' JDate=$jdate >> $rdhistfile 
   cat $outfile | grep -v "^#" > $rdhisthold
fi

# If pnadcp.sh exists, and it is less than 0600, and Sunday (Sun), 
# then next check if running already, if not start it in the background. 
# Time limit set to ensure it is started in the AM.  pnadcp.sh is an 
# admin data collection program that runs several disk related checks
jhour=`date +%H`
jDOW=`date +%a` 
jhourlimit="05"
jday2run="Sun"
if [ -s ${installdir}/pnadcp.sh ] && [ "$jhour" -lt "$jhourlimit" ] && [ "$jDOW" = "$jday2run" ] ; then
   # If pnadcp.sh is not already running start it.
   ps -ef | grep pnadcp.sh | grep -v grep  > /tmp/helpsystems_tmp/pnadcp_running.tmp
   # If /tmp/helpsystems_tmp/pnadcp_running.tmp is empty, start pnadcp.sh in background
   if [ ! -s /tmp/helpsystems_tmp/pnadcp_running.tmp ]; then
      ${installdir}/pnadcp.sh  & 
   fi
fi
if [ ! -z "$debug" ] ; then echo "jhour=$jhour" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
if [ ! -z "$debug" ] ; then echo "jDOW=$jDOW" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
if [ ! -z "$debug" ] ; then echo "jhourlimit=$jhourlimit" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
if [ ! -z "$debug" ] ; then echo "jday2run=$jday2run" >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi
if [ ! -z "$debug" ] ; then ls -al /tmp/helpsystems_tmp/pnadcp_running.tmp >> /tmp/helpsystems_tmp/rackdata_debug.tmp ; fi


dffile="${mpgdatadir}/df.$sysname"

df_data >> $dffile

##### jfix #### elif [ ${purge_top_days} -gt ${truncate_days} ]; then

# Prior to trimming dffile ensure purge_top_days is set correctly.
# Set purge_top_days
purge_top_minimum=30
purge_top_default=90  # Apx 90 days, may set it different in the future

if [ "x${truncate_days}x" = "xx" ]; then
   truncate_days=366
fi

if [ `$juname -s` = "Linux" ] || [ `$juname -s` = "AIX" ] ; then

   if [ "x${purge_top_days}x" = "xx" ] ; then
      if [ ! -s mpgdata2.${jsysname} ] && [ -s pn.config ] ; then
         echo "purge_top_days not specified (${purge_top_days}); setting value to (${purge_top_default})."
      fi
      purge_top_days=${purge_top_default}
   fi

   if [ ${purge_top_days} -gt ${truncate_days} ] ; then
      purge_top_days=${purge_top_default}
   fi

fi

# This is where trimming of dffile needs to be done.
firstdate=`cat ${dffile} | awk -F_ '{print $1}' | uniq | tail -${purge_top_days} | head -1` 
jdfstart=`grep -n ${firstdate} ${dffile} | awk -F: '{print $1}' | head -1`
jwcdffile=`wc -l ${dffile} | awk '{print $1}'`
let jdftail=${jwcdffile}-${jdfstart}
let jdftail=${jdftail}+1
tail -${jdftail} ${dffile}  > ${dffile}_hold
mv ${dffile}_hold ${dffile}  
cat $dffile >> $outfile

# if ./pn_chart_nmon_files.sh exists then run it once each day
# unless this is a new install.

ls ./mpg*nmon* 2>/dev/null > /tmp/helpsystems_tmp/pn_chart_files.tmp

jsysname=`uname -n | awk -F. '{print $1}'`

if [ -s ./pn_chart_nmon_files.sh ] && [ -s /tmp/helpsystems_tmp/pn_chart_files.tmp ] && [ -s mpgdata2.${jsysname} ] ; then
   touch /tmp/helpsystems_tmp/pn_chart_nmon_files.today.hsllc /tmp/helpsystems_tmp/pn_chart_nmon_files.last.hsllc
   date '+%Y%m%d' > /tmp/helpsystems_tmp/pn_chart_nmon_files.today.hsllc
   diff /tmp/helpsystems_tmp/pn_chart_nmon_files.today.hsllc /tmp/helpsystems_tmp/pn_chart_nmon_files.last.hsllc > /tmp/helpsystems_tmp/pn_chart_nmon_files.diff.hsllc
   if [ -s /tmp/helpsystems_tmp/pn_chart_nmon_files.diff.hsllc ] && [ -s /tmp/helpsystems_tmp/pn_chart_files.tmp ] ; then
      # Run pn_chart_nmon_files.sh if it has not been ran today
      ./pn_chart_nmon_files.sh > /dev/null
      mv /tmp/helpsystems_tmp/pn_chart_nmon_files.today.hsllc /tmp/helpsystems_tmp/pn_chart_nmon_files.last.hsllc
   fi
fi


if [ ! -z "$debug" ] ; then 
   echo "df file=$dffile" >> /tmp/helpsystems_tmp/rackdata_debug.tmp 
   cat /tmp/helpsystems_tmp/rackdata_debug.tmp 
   cp /tmp/helpsystems_tmp/rackdata_debug.tmp rackdata_debug.tmp
   chown root:system *
   tar -cvf ${outfile}.tar $outfile *.hsllc rackdata_debug.tmp 2>&1 > /dev/null
   gzip -f ${outfile}.tar  
   chown root:system *
   echo "Debug file is ${outfile}.tar.gz" 
else
   rm -f /tmp/helpsystems_tmp/rackdata_debug.tmp
   rm -f rackdata_debug.tmp
   rm -f ${outfile}.tar.gz 
fi

# Check and see if topas data exists before checking topas data 
if [ -s /etc/inittab ] ; then
   cat /etc/inittab | grep topas > topas_inittab.hsllc
fi
if [ ! -s mpgdata2.${jsysname} ] && [ -s pn.config ] && [ -s topas_inittab.hsllc ] && [ `$juname -s` = "AIX" ]  ; then
   get_topas_data_proc > topas_info.hsllc
else
   if [ "xTx" = "x${get_topas_data}x" ] && [ -s topas_inittab.hsllc ] ; then 
      get_topas_data_proc
   fi
fi

exit


#& # ===================== #
#& # Sample run of rackdata.sh with -T option to gather topas data
#& # ===================== #
#& ./rackdata.sh -T
#& Found topasrec is running periodically in directory
#& (/etc/perf/daily/)
#& Identified a directory for topas
#& Gathering topas data!
#& a HSdata_topas
#& a HSdata_topas/yourhostname_140610.topas.csv 414 blocks.
#& a HSdata_topas/yourhostname_140909.topas.csv 489 blocks.
#& a HSdata_topas/yourhostname_140910.topas.csv 489 blocks.
#& a HSdata_topas/yourhostname_140911.topas.csv 488 blocks.
#& a HSdata_topas/yourhostname_140912.topas.csv 488 blocks.
#& a HSdata_topas/yourhostname_140913.topas.csv 488 blocks.
#& a HSdata_topas/yourhostname_140914.topas.csv 488 blocks.
#& a HSdata_topas/yourhostname_140915.topas.csv 340 blocks.
#& a mpgdata2_topas.yourhostname 3268 blocks.
#& a topasrec_status.yourhostname 3268 blocks.
#& a rackdata.yourhostname 3268 blocks.
#& Please send  /tmp/helpsystems_tmp/rackdata_topas_yourhostname_YYYYMMDD_hhmm.tar.gz
#& You can send by:
#& ./send2helpsys_sftp.sh /tmp/helpsystems_tmp/rackdata_topas_yourhostname_YYYYMMDD_hhmm.tar.gz

