#!/bin/ksh
#!/bin/ksh -xv
#
# $Id: quickmpgd2.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& This is only intended for internal use, but can be used by a partner
#&& It does NO validation and maybe the only way to get mpgdata2 and rackdata
#&& for virtual servers that have little if any information that is expected
#&& normally. Much better for them to install powernav.tar.gz on each lpar.
#
#@ Requires pnbrdf.sh script 
#
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
#

# The next two safety exits are in place to prevent this script from being 
# used in the system Performance Navigator Data Consolidator directory.

# Cannot and should not be ran in the /usr/local/mpg directory
mkdir -p /tmp/helpsystems_tmp
jpwd=`pwd`
if [ "xx${jpwd}xx" = "xx/usr/local/mpgxx" ] ; then 
      echo "Exiting cannot be ran in /usr/local/mpg!" ; exit 
fi

# Cannot have mpgdata2.hostname in current directory
jhostname=`hostname`
 
if [ -s mpgdata2.${jhostname} ] ; then 
      echo "Exiting mpgdata2.${jhostname} should not exist!" ; exit 
fi

grep "host," *nmon | awk -F, '{print $NF}' | uniq > /tmp/helpsystems_tmp/quickmpgd2_hosts.hsllc
while 
read jhost
do
   if [ "xx" = "x${jhost}x" ]; then
      echo "exiting!" ; exit 
   fi
   echo "Host (${jhost})"
   rm -f mpgdata2.${jhost} rackdata.${jhost}
   ls -1 ${jhost}*nmon > /tmp/helpsystems_tmp/quickmpgd2_files.tmp 
   while
   read jfile
   do
      echo "${jfile}"
      cat $jfile >> mpgdata2.${jhost}
   done < /tmp/helpsystems_tmp/quickmpgd2_files.tmp 
   ./pnbrdf.sh  mpgdata2.${jhost}
done < /tmp/helpsystems_tmp/quickmpgd2_hosts.hsllc 
tar cvf - mpgdata2.* rackdata.* | gzip -c > quickmpgd2.tar.gz
ls -altr quickmpgd2.tar.gz
echo "Done!!!!" 

