#!/bin/ksh   
#
# $Id: pngetinfo_transfer.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& NEED to change comments after finishing new script
#&& Performance Navigator Get Information (pngetinfo_transfer.sh)
#
#& This script gets 60 days or less of data gathered by transfer scripts.
#& and puts them in one file. (pninfo_multiples.tar.gz) 
#& Options have yet to be determined.  
#&   Options are:
#& 	-a auto gzip of tar file (Does not build a tar file first)
#& 	-q quite compression
#& 	-c current data only (7 days)(large files not included)
#&      -n # number of days to gather (most recent)(large files not included)
#&         if no -n specified, will default to everyday
#&         unless there is a -c specified
#& 	-h help/usage message
#&   Can gather large files: mpgdata, mpgdata1, mpgdata2, mpgdata3, mpgdata4 
#&   Always gathers current, last# (days), config files, rackdata outputs,
#&   *.mpginc and *.hsllc  
#
#&@ pndcutils.sh is also required
#
#&% Not scheduled and will run only when used from directory with multiple 
#&% files from multiple servers. 
#
# Added a -q for quiet operation (Nothing echoes to the screen for cron)
# Will replace the current compression option to create the tar file 
# of all data files.

# Three new environmental variables
# installdir
# mpgdatadir
# nmondatadir

invocdir=`dirname $0`
cd $invocdir
installdir=$invocdir
if [ -s $invocdir/pndcutils.sh ] ; then 
   . $invocdir/pndcutils.sh
else
   echo "$invocdir/pndcutils.sh is required for this script to work, exiting"; exit 1
fi
if [ -s $invocdir/pn.config ] ; then 
   echo "$invocdir/pn.config should not exist if this script is in the transfer"
   echo "repository , exiting"; exit 1
#   . $invocdir/pn.config
fi

echo "This is a forced exit that will be removed later, moved it for testing " ; exit 1

# Will be using a list of multiple files and procedures. 

# hostnames will be in a list # pnhost=`uname -n | cut -d. -f1`

PATH=$PATH:/usr/contrib/bin:/usr/bin

function usage {
echo "usage: $0 [options]
  ### ### Options will need to be changed. ### ### 
  Options may be any of:
   	-A Gather all data (default is 60 days)
   	-a auto gzip of tar file (Does not build a tar file first)
   	-q quite compression
   	-c current data only (7 days)(large files not included)
        -n # number of days to gather (most recent)(large files not included)
           if no -n specified, will default to everyday
           unless there is a -c specified
        -h help/usage message
"
}

#& This script gets the information that is used by Fortra, LLC. (HelpSystems|MPG)
#& and puts them in one file. (pninfo_transfer_files.tar.gz) 
#&   Options are:
#& 	-a auto gzip of tar file (Does not build a tar file first)
#& 	-q quite compression
#& 	-c current data only (7 days)(large files not included)
#&      -n # number of days to gather (most recent)(large files not included)
#&         if no -n specified, will default to everyday
#&         unless there is a -c specified
#& 	-h help/usage message
#&   Can gather large files: mpgdata, mpgdata1, mpgdata2, mpgdata3 
#&   Gathers (last# days by default 60 or if specified different # ) 
#&   unless -A all is selected. 
#&   Always gets current, config files, rackdata outputs, *.mpginc and *.hsllc  
#&   
#& Because output data may be in a seperate place than the install directory, 
#& there is an append to the original tar file for additional files  
#&   

jthissystem="T"

if [ ! -d "${mpgdatadir}" ];then
   mpgdatadir=${invocdir}
fi
 
if [ ! -d "${installdir}" ];then
   installdir=${invocdir}
fi

if [ ! -z "$debug" ]; then
   echo "pnhost is (${pnhost})"
fi

if [ -s "${mpgdatadir}/rackdata.${pnhost}\.*" ] || [ -s "${mpgdatadir}/rackdata.${pnhost}" ] ; then 
   pnsys=`uname -s`
else
   echo "Looks like this is being ran on data that is not from this system."
   pnhost=`grep "Machine Node Name" ${mpgdatadir}/rackdata.* | head -1 |  awk '{print $NF}'`
   pnsys=`grep "Operating System Name" ${mpgdatadir}/rackdata.* | head -1 | awk '{print $NF}'`
   echo "Running on files from ${pnhost} on a ${pnsys} system."
   jthissystem="F"
fi

cd $mpgdatadir
# First remove and existing _last files
rm -f mpg*_last[0-9]*.${pnhost}

jautogzip="F"
jcurrent="T"
jquiet="F"
jcntchange="F" 

while getopts ":Aachqn:" opt ; do
   case $opt in
	  A)      jcurrent="F" ;;
	  a)      jautogzip="T" ;;
	  c)      jcurrent="T" ;;
	  q)      jquiet="T" ;;
	  n)      jcntchange="T" 
			jcurrent="T" 
			jdays="$OPTARG";;
	  h)      usage;  exit ;;
	  ?)      usage;  exit ;;
   esac
done

# If no count change is specified, default to 60 days
if [ "$jcurrent" = "T" ] && [ "$jcntchange" = "F" ] ; then
   jdays="60"
fi
# # If no number of days is not still specified, default to 60 days
if [ "x${jdays}x" = "xx" ] ; then
   jdays="60"
fi


if [ "x${jcurrent}x" = "xTx" ] ; then
   if [ "x${jquiet}x" != "xTx" ] ; then
      echo No Big files
   fi
   jbigfiles=""
else
   if [ "x${jquiet}x" != "xTx" ] ; then
      echo With Big files
   fi
   jbigfiles="mpgdata.${pnhost}* mpgdata1.${pnhost}* mpgdata2.${pnhost}* mpgdata3.${pnhost}* mpgdata4.${pnhost}*   "
fi

# chosen_files is in mpgdatadir
chosen_files="${jbigfiles} mpgdata4_last${jdays}.${pnhost}* \
mpgdata3_last${jdays}.${pnhost}* mpgdata2_current.${pnhost}* \
mpgdata2_last${jdays}.${pnhost}* mpgdata1_last${jdays}.${pnhost}* \
mpgdata_current.${pnhost}* mpgdata_last${jdays}.${pnhost}* rackdata.${pnhost}* \
rdhist.${pnhost} df.${pnhost} pn.config.${pnhost} mpgTSinfo_${pnhost}.tar " 

# chosen_files2 is in installdir NOTE built a mpgTSinfo_${pnhost}.tar in the output directory 
# with these files
chosen_files2="etc_pn.conf.${pnhost}* pn.config pnadcp.config pnedcp.config *.mpg *.hsllc *.info"

cd ${installdir}
tar -cvf ${mpgdatadir}/mpgTSinfo_${pnhost}.tar $chosen_files2 2> /dev/null  > /dev/null
cd ${mpgdatadir}

# echo $chosen_files ; echo comment out later ; exit 1

# tail command different on SunOS systems
jtailchk=`uname -s`
if [ "x${jtailchk}x" = "xSunOSx" ] ; then
   jtailmod=''
else
   jtailmod='-n'
fi



# Not currently gathering mpgdata1.hostname, but placed for future
if [ -s mpgdata1.${pnhost} ] && [ "xx" != "x${jdays}x" ] ; then
   ## To gather a last 60 days file or specified for current data gathering 
   ## mpgdata1
   ## This will aid in troubleshooting with customers on recent data
   j7day=`egrep -n "ZZZZ,T0001,00"  mpgdata1.${pnhost} | tail ${jtailmod} -${jdays} | head -1 | awk -F: '{print $1}'`
   tail ${jtailmod} +${j7day} mpgdata1.${pnhost} > mpgdata1_last${jdays}.${pnhost}
fi

if [ -s mpgdata2.${pnhost} ] && [ "xx" != "x${jdays}x" ] ; then
   ## To gather a last 7 day file for current data gathering mpgdata2
   ## This will aid in troubleshooting with customers on recent data
   # Find the find the location of the oldest of the last 7 dates in mpgdata3
   j7day=`egrep -n "AAA,progname|AAA,date"  mpgdata2.${pnhost} | paste - - | tail ${jtailmod} -${jdays} | head -1 | awk -F: '{print $1}'`
   # Tail mpgdata2.hostname jloc2 as the 1st line of mpgdata2_last7.hostname
   tail ${jtailmod} +${j7day} mpgdata2.${pnhost} > mpgdata2_last${jdays}.${pnhost}
fi

if [ -s mpgdata3.${pnhost} ] && [ "xx" != "x${jdays}x" ] ; then
   ## To gather a last 7 day file for current data gathering mpgdata3
   ## This will aid in troubleshooting with customers on recent data
   # Find the last 7 dates in mpgdata3
   jdate=`egrep ",date,"  mpgdata3.${pnhost} | uniq | tail ${jtailmod} -${jdays} | head -1 | awk -F: '{print $1}'`
   if [ "x${jdate}x" = "xx" ] ; then
      # if date is blank create a blank mpgdata3_last7.${pnhost}
      touch mpgdata3_last${jdays}.${pnhost}
   else
      # Find the find the location of the oldest of the last 7 dates in mpgdata3
      jloc=`egrep -n "$jdate"  mpgdata3.${pnhost} | head -1 | awk -F: '{print $1}'`
      # Adjust the location by two lines backwards
      jloc2=$(expr $jloc - 2)
      # Tail mpgdata3.hostname jloc2 as the 1st line of mpgdata3_last${jdays}.hostname
      tail ${jtailmod} +${jloc2} mpgdata3.${pnhost} > mpgdata3_last${jdays}.${pnhost}
   fi
fi

grep ^PS  ${mpgdatadir}/mpgdata3_last${jdays}.${pnhost} | egrep -v "USER|\<" | awk -F, '{print $4}' | sort | uniq -c | sort -n  >  ${mpgdatadir}/mpgdata3_users_${pnhost}.hsllc

# pnadcm.sh creates mpgdata4.hostname and is common to all unix/linux
# to gather admin data and is keyed by rackdata.sh script on Sunday only.
if [ -s mpgdata4.${pnhost} ] && [ "xx" != "x${jdays}x" ] ; then
   ## To gather a last 7 day file for current data gathering mpgdata4
   ## This will aid in troubleshooting with customers on recent data
   j7daypoint=`egrep "MPG,date"  mpgdata4.${pnhost} | uniq | tail ${jtailmod} -${jdays} | head -1 | awk -F, '{print $3}'`
   j7day=`egrep -n "${j7daypoint}"  mpgdata4.${pnhost} | head -1 | awk -F: '{print $1}'`
   tail ${jtailmod} +${j7day} mpgdata4.${pnhost} > mpgdata4_last${jdays}.${pnhost}
fi

# pnadcm.sh creates mpgdata.hostname and common to Solaris, HPUX, and other sar data collections
# to gather sar data and is keyed by sa1 in the crontab for root or sys 
if [ -s mpgdata.${pnhost} ] && [ "xx" != "x${jdays}x" ] ; then
   ## To gather a last 7 day file for current data gathering mpgdata
   ## This will aid in troubleshooting with customers on recent data
   jfirstdate=`grep ^2 mpgdata.${pnhost} | cut -c1-40 | awk -F\; '{print substr($1,1,8)}' | uniq | tail ${jtailmod} -${jdays} | head -1`
   jloc=`grep -n ${jfirstdate} mpgdata.${pnhost} | head -1 | awk -F: '{print $1}'`
   jloc2=$(expr $jloc - 1)
   tail ${jtailmod} +${jloc2} mpgdata.${pnhost} > mpgdata_last${jdays}.${pnhost}
fi

## if there is no nmon then we are on a Sun/HP-UX/SCO system or one running
## sar.
jchk=`find nmon 2>/dev/null`
if [ "xx" = "x${jchk}x" ] && [ -s ./sar.sh ] ; then
   ## Gather the todays mpgdata_current file
   ./sar.sh > mpgdata_current.${pnhost}
fi

if [ "x${jthissystem}x" = "xTx" ]; then
  cp -p /etc/pn.conf ${installdir}/etc_pn.conf.${pnhost}
  if [ -s ${installdir}/pn.config ] ; then
     cp -p ${installdir}/pn.config ${mpgdatadir}/pn.config.${pnhost}
  fi
  echo "# root crontab #" > ${mpgdatadir}/mpgcrontab.${pnhost}
  echo "#==============#" >> ${mpgdatadir}/mpgcrontab.${pnhost}
  crontab -l 2>/dev/null | egrep "MPG|start_nmon_now|cend.sh|pndcm.sh|rackdata.sh|pngetinfo.sh|sar.sh|sa1|sdcm" | awk '{print "#",$0} END {if (NR == 0) print "No MPG root entries"}' >> ${mpgdatadir}/mpgcrontab.${pnhost}
  echo "" >> ${mpgdatadir}/mpgcrontab.${pnhost}
  echo "# sys crontab  #" >> ${mpgdatadir}/mpgcrontab.${pnhost}
  echo "#==============#" >> ${mpgdatadir}/mpgcrontab.${pnhost}
  crontab -l sys 2>/dev/null | egrep "MPG|start_nmon_now|cend.sh|pndcm.sh|rackdata.sh|pngetinfo.sh|sar.sh|sa1|sdcm" | awk '{print "#",$0} END {if (NR == 0) print "No MPG sys entries"}' >> ${mpgdatadir}/mpgcrontab.${pnhost}
fi

# If transfer_script_cmd variable assigned:
# If there is a transfer_script_cmd variable, and it has transfer_script.sh
# in the variable, then run the transfer_script_cmd commmand.
if [ "x${transfer_script_cmd}x" != "xx" ] ; then
   echo ${transfer_script_cmd} | grep transfer_script.sh > /dev/null
   jchk=$?
   if [ ${jchk} -eq 0 ] ; then
      if [ "x${jquiet}x" = "xTx" ] ; then
         ${transfer_script_cmd} > /dev/null
      else
         echo "#==============#" 
         echo "Running tranfer script"
	 echo "# (${transfer_script_cmd})" 
 	 ${transfer_script_cmd} 
         echo "#==============#" 
      fi
   fi
fi


if [ "x${jquiet}x" = "xTx" ] ; then
   if [ "x${jautogzip}x" = "xTx" ] ; then
      tar -cvf - ${chosen_files} 2> /dev/null | gzip -c > pninfo.${pnhost}.${pnsys}.tar.gz
   else
      tar -cvf pninfo.${pnhost}.${pnsys}.tar ${chosen_files} 2> /dev/null  > /dev/null
      gzip -f pninfo.${pnhost}.${pnsys}.tar
   fi
else
   if [ "x${jautogzip}x" = "xTx" ] ; then
      tar -cvf - ${chosen_files} 2> /dev/null | gzip -c > pninfo.${pnhost}.${pnsys}.tar.gz
   else
      tar -cvf pninfo.${pnhost}.${pnsys}.tar ${chosen_files} 2> /dev/null 
      gzip -f pninfo.${pnhost}.${pnsys}.tar
   fi
   jtestsize=`find pninfo.${pnhost}.${pnsys}.tar.gz -size +10000000c` 
   if [ -z "$jtestsize" ]; then
      echo "Please email file ${mpgdatadir}/pninfo.${pnhost}.${pnsys}.tar.gz "
      echo "for Performance Navigator to Fortra, LLC. (HelpSystems|MPG)" 
      echo "Possibly to SOS@helpsystems.com " 
   else
      echo "Please arrange to get file ${mpgdatadir}/pninfo.${pnhost}.${pnsys}.tar.gz "
      echo "for Performance Navigator to Fortra, LLC. (HelpSystems|MPG)" 
      echo "Email to support.mpginc@helpsystems.com for ftp instructions." 
   fi
fi

