#!/bin/ksh
#
# $Id: pnedcp_start.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Performance Navigator External Data Collection Process (pnedcp_start.sh)
#& This script runs at the start of the collection process.
#

invocdir=`dirname $0`

# No variable in place in config currently.
# Load the Performance Navigator External Data Collection configuration options
. ${invocdir}/pn.config

# snapshot id #
nm_nmbr=$1

cd ${mpgdatadir}

date +%Y%m%d > pnedcp_start_date_hold.hsllc
touch pnedcp_start_date.hsllc
cmp pnedcp_start_date_hold.hsllc pnedcp_start_date.hsllc > /dev/null
jtestdate=$?

# To correct for previous problem when out file was deleted instead of day file.
jgrep_date_out=`grep ,date, ${pnedcp_out} | wc -l | awk '{print $1}'`
jgrep_date_day=`grep ,date, ${pnedcp_day} | wc -l | awk '{print $1}'`
if [ "x${jgrep_date_out}x" != "xx" ] && [ "x${jgrep_date_day}x" != "xx" ] ; then
   if [ ${jgrep_date_out} -eq 1 ] && [ ${jgrep_date_day} -gt 1 ]  ; then
      # swap files pnedcp_day and pnedcp_out
      cp ${pnedcp_out} ${pnedcp_out}.hold
      mv ${pnedcp_day} ${pnedcp_out} 
      mv ${pnedcp_out}.hold ${pnedcp_day}
   fi
fi

# Was incorrectly deleting pnedcp_out instead of pnedcp_day for a while
if [ ${jtestdate} -ne 0 ]; then
   rm pnedcp_start_date.hsllc  
   rm ${pnedcp_day}  
fi

# Create the mpg file and comment with company name in pnedcp_out and pnedcp_day if pnedcp_out does not exist
if [ ! -s ${pnedcp_out} ]; then
   echo "# This file is used by Performance Navigator from Fortra, LLC. (HelpSystems|MPG)" >> ${pnedcp_out} 
   echo "# for the external data collection process (pnedcp)." >> ${pnedcp_out} 
   echo "# For questions, please call 1 800-328-1000." >> ${pnedcp_out} 
fi

# pnedcp_start_date.hsllc

# pnedcp_start_date_hold.hsllc

# Create the mpg file and comment with company name if it does not exist
if [ ! -s ${pnedcp_day} ]; then
   echo "# This file is used by Performance Navigator from Fortra, LLC. (HelpSystems|MPG)" >> ${pnedcp_day} 
   echo "# for the external data collection process (pnedcp)." >> ${pnedcp_day} 
   echo "# For questions, please call 1 800-328-1000." >> ${pnedcp_day}
   date +%Y%m%d > pnedcp_start_date.hsllc
fi

if [ "$ext_data_collect" = "T" ] ; then
   # It is assumed that the mpgdata2 file will already have logged this information so it can be placed in the mpgdata3 file.
   egrep "^AAA,(time|date|host|SerialNumber)," $nmf | sed s,AAA,MPG,g | tee -a ${pnedcp_day} >> ${pnedcp_out} 
fi

# There may be additional information that needs to be added at the start, but not at the present.

