#!/bin/ksh
#
# $Id: pnedcp_snap.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Performance Navigator External Data Collection Process (pnedcp_snap.sh)
#& This script runs at snap collection process.
#
# snapshot id #

mkdir -p /tmp/helpsystems_tmp

COLUMNS=6000
nm_nmbr=$1

rm -f /tmp/pnedcp*.hsllc # helpsystems_tmp

invocdir=`dirname $0`

# Load the configuration file for transfer_current_cmd variable
. ${invocdir}/pn.config

 set > ${invocdir}/pnedcp_snap_env.hsllc

# This will be used to create a mpgdataps.hostname file.
if [ "$ext_ps_collect" = "T" ] ; then
   # sleep may be necessary to ensure that nmon has finished writing it's date
   # sleep 10

   # It is assumed that the mpgdata2 file will already have logged this information so it can be placed in the 
   # mpgdataps file.
   # egrep "^ZZZZ,$nm_nmbr," $nmf | sed s,ZZZZ,PNZZ,g  >> ${pnedcp_ps} 
   egrep "^ZZZZ,$nm_nmbr," $nmf  | tee  /tmp/helpsystems_tmp/pnedcp_pscsv.hsllc >> ${pnedcp_ps} 

   # capture psid and uid into the nmon file at each snap.
   juname_p=`uname -p`
   if [ "x${juname_p}x" = "xpowerpcx" ] ; then
   ps -edo  pid,ppid,uname,pcpu,pmem,vsz,pagein,thcount,command \
      | sort -n \
      | tee  /tmp/helpsystems_tmp/pnedcp_ps.hsllc \
      | awk 'BEGIN { OFS="," } { print "PSN",$1,$2,$3,$4,$5,$6,$7,$8,$9}' | sed s,\ *$,,  | tee -a /tmp/helpsystems_tmp/pnedcp_pscsv.hsllc  >>  ${pnedcp_ps}
   ps -ko  pid,ppid,uname,pcpu,pmem,vsz,pagein,thcount,command \
      | sort -n \
      | tee -a /tmp/helpsystems_tmp/pnedcp_ps.hsllc \
      | awk 'BEGIN { OFS="," } { print "PSK",$1,$2,$3,$4,$5,$6,$7,$8,$9}' | sed s,\ *$,, | tee -a /tmp/helpsystems_tmp/pnedcp_pscsv.hsllc  >>  ${pnedcp_ps}
     # | awk -v trimargs=${length_args} -v vszt="${vsz_threshold}" -v pcpu="${percent_cpu}" -v pmem="${percent_mem}"  -v pgin="${page_in}" -v thrdcnt="${thread_cnt}" 'BEGIN { OFS="," } {if(( $3 != "<defunct>" && $2 ~ /^[0-9]+$/ &&  $3 != "<exiting>" && $3 != "<idle>" && $3 != "root" && $3 != "stc" && $3 != "esaadmin" && $3 != "agentca" && $3 != "cacheusr" && $3 != "daemon" && $3 != "pconsole") || ($4 > pcpu || $5 > pmem || $6 > vszt  || $7 > thrdcnt || $8 > pgin )) print "PS",$1,$2,$3,$4,$5,$6,$7,$8,substr($9" "$10" "$11" "$12" "$13" "$14" "$15,1,trimargs)}' | sed s,\ *$,,   >>  ${pnedcp_ps}
   else
      ps -edo  pid,ppid,uname,pcpu,pmem,vsz,command \
         | sort -n \
         | tee ${installdir}/ps-ef.hsllc \
         | awk 'BEGIN { OFS="," } { print "PSN",$1,$2,$3,$4,$5,$6,$7}' | sed s,\ *$,,  | tee -a /tmp/helpsystems_tmp/pnedcp_pscsv.hsllc >>  ${pnedcp_ps}
         # | awk -v trimargs=${length_args} -v vszt="${vsz_threshold}" -v pcpu="${percent_cpu}" -v pmem="${percent_mem}" 'BEGIN { OFS="," } {if(( $3 != "<defunct>" && $2 ~ /^[0-9]+$/ && $3 != "<exiting>" && $3 != "<idle>" && $3 != "root" && $3 != "stc" && $3 != "esaadmin" && $3 != "agentca" && $3 != "cacheusr" && $3 != "daemon" && $3 != "pconsole") || ($4 > pcpu || $5 > pmem || $6 > vszt )) print "PS",$1,$2,$3,$4,$5,$6,substr($7" "$8" "$9" "$10" "$11" "$12" "$13,1,trimargs)}' | sed s,\ *$,,   >>  ${pnedcp_ps}
   fi
fi

cp ${pnedcp_ps} ${pnedcp_ps_current}

if [ "$ext_data_collect" = "T" ] ; then
   # sleep may be necessary to ensure that nmon has finished writing it's date
   # sleep 10

   # It is assumed that the mpgdata2 file will already have logged this information so it can be placed in the 
   # mpgdata3 file.
   # egrep "^ZZZZ,$nm_nmbr," $nmf | sed s,ZZZZ,PNZZ,g  >> ${pnedcp_out} 
   egrep "^ZZZZ,$nm_nmbr," $nmf | tee -a ${pnedcp_day} >> ${pnedcp_out} 


   jcount_norm_ps=`egrep -v ",PPID,|ZZZZ" /tmp/helpsystems_tmp/pnedcp_pscsv.hsllc |grep -c PSN`
   jcount_kern_ps=`egrep -v ",PPID,|ZZZZ" /tmp/helpsystems_tmp/pnedcp_pscsv.hsllc |grep -c PSK`
   echo "PSC,${jcount_norm_ps},${jcount_kern_ps}" >> ${pnedcp_out}
   # capture psid and uid into the nmon file at each snap.
   juname_p=`uname -p`
   if [ "x${juname_p}x" = "xpowerpcx" ] ; then
   ps -edo  pid,ppid,uname,pcpu,pmem,vsz,pagein,thcount,args \
      | sort -n \
      | tee ${installdir}/ps-ef.hsllc \
      | awk -v trimargs=${length_args} -v vszt="${vsz_threshold}" -v pcpu="${percent_cpu}" -v pmem="${percent_mem}"  -v pgin="${page_in}" -v thrdcnt="${thread_cnt}" 'BEGIN { OFS="," } {if(( $3 != "<defunct>" && $2 ~ /^[0-9]+$/ &&  $3 != "<exiting>" && $3 != "<idle>" && $3 != "root" && $3 != "stc" && $3 != "esaadmin" && $3 != "agentca" && $3 != "cacheusr" && $3 != "daemon" && $3 != "pconsole") || ($4 > pcpu || $5 > pmem || $6 > vszt  || $7 > thrdcnt || $8 > pgin )) print "PS",$1,$2,$3,$4,$5,$6,$7,$8,substr($9" "$10" "$11" "$12" "$13" "$14" "$15,1,trimargs)}' | sed s,\ *$,,  | tee -a ${pnedcp_day} >>  ${pnedcp_out}
   else
      ps -edo  pid,ppid,uname,pcpu,pmem,vsz,args \
         | sort -n \
         | tee ${installdir}/ps-ef.hsllc \
         | awk -v trimargs=${length_args} -v vszt="${vsz_threshold}" -v pcpu="${percent_cpu}" -v pmem="${percent_mem}" 'BEGIN { OFS="," } {if(( $3 != "<defunct>" && $2 ~ /^[0-9]+$/ && $3 != "<exiting>" && $3 != "<idle>" && $3 != "root" && $3 != "stc" && $3 != "esaadmin" && $3 != "agentca" && $3 != "cacheusr" && $3 != "daemon" && $3 != "pconsole") || ($4 > pcpu || $5 > pmem || $6 > vszt )) print "PS",$1,$2,$3,$4,$5,$6,substr($7" "$8" "$9" "$10" "$11" "$12" "$13,1,trimargs)}' | sed s,\ *$,,  | tee -a ${pnedcp_day} >>  ${pnedcp_out}

   fi

   # Initially gathered only process and username (not enough details)
   # ps -ef | awk '{print $2,$1}' | sort -n | awk 'BEGIN { OFS="," } {print "PS",$1,$2}'   TNO=$nm_nmbr >>  ${pnedcp_out}

   # There may be additional information that needs to be added to the snap, but not at the present.
   # Future enhancement, each type of snapshot may be configured via a configuration file.
fi

##################################
# mpgdata2_current.hostname process follows 
##################################
# Added a cat of all mpg_yyyymmdd.nmon that are newer than 0000 the day that cend.sh was ran, or today at 0000
# which ever is older.  Data is gathered into mpgdata2_current.hostname 
# The file last_cend is created by cend.sh script or the start_nmon_now script when necessary. 
# The file mpg_today is created by the start_nmon_now script.  

cd ${installdir}
jdate=`date +%Y%m%d`
jtimetest=`find ${installdir}/last_cend -newer ${installdir}/mpg_today`
if [ "x${jtimetest}x" = "xx" ]; then
   Time_ref_file=${installdir}/last_cend
else
   Time_ref_file=${installdir}/mpg_today
fi
if [ -s /tmp/helpsystems_tmp/send_data2mpg ]; then
   jsendcompany=`cat /tmp/helpsystems_tmp/send_data2mpg`
   if [ "xx" !=  "x${jsendcompany}x" ]; then
      ./sendpninfo2mpg.sh ${jsendcompany}
      rm /tmp/helpsystems_tmp/send_data2mpg
   fi
fi

sync
# echo $Time_ref_file > jtest1
# echo ${datacur} > jtest2
cd ${nmondatadir}
# find mpg_20[0-9][0-9][0-9][0-9][0-9][0-9].nmon mpg_20[0-9][0-9][0-9][0-9][0-9][0-9].nmon.[0-9][0-9] -newer $Time_ref_file | tee ${installdir}/jtest3 \
find mpg_20[0-9][0-9][0-9][0-9][0-9][0-9].nmon mpg_20[0-9][0-9][0-9][0-9][0-9][0-9].nmon.[0-9][0-9] -newer $Time_ref_file \
   | xargs cat /tmp/helpsystems_tmp/mpgmpg 2>/dev/null  >  ${datacur}

# If there is a transfer_current_cmd variable, and it has transfer_current.sh 
# in the variable, then run the transfer_current_cmd commmand.
if [ "x${transfer_current_cmd}x" != "xx" ] ; then
   echo ${transfer_current_cmd} | grep transfer_current.sh > /dev/null
   jchk=$? 
   if [ ${jchk} -eq 0 ] ; then
      ${transfer_current_cmd}
   fi
fi

