#!/bin/ksh 
#
# $Id: pndcutils.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Performance Navigator Data Consolidation Utilities (pndcutils.sh)
#& Common utilities used by other scripts 
# 
## Jack Miller 4/18/2009
#       Updated shell to ksh, not sh compliant.
#
#
### default values:
invocdir=`dirname $0`           # invocation dir (default for temp/data files, utilities)
sysname=`uname -n | awk -F. '{print $1}'` # used in default nmon datafile names
installdir="/usr/local/mpg"        # default directory for nmon files
# The intent is that this will only be used if there is not a pn.config file.
def_datafile="${invocdir}/mpgdata2.$sysname" # default datafile
tempfile="${invocdir}/mpg.temp" # default tempfile

## daily:
dailynmonfilepattern='mpg_${checkyyyy}${checkmm}${checkdd}.nmon'

## clean:
nmondaystokeep=30               # default # of days of nmon data files to keep
cleannmonfilepattern='mpg_*.nmon'

## truncate:
daystokeep=365
maxfilelen=60000000
use_numfiledays="false"

## reduce data and compression
reduce="T"
compressdatafile="T"
compressnmonfiles="T"

### utility functions :

## date utility functions
#NOTES:
# AIX date format: DD-MON-YYYY
# linux date format: DD/MM/YY
# converted date format:  YYYYMMDD
# get first date in file (portable): cat mpgdata2 | awk '/AAA,date/ {print;exit}'
# get first date in file (linux): grep -m1 'AAA,date' mpgdata2

function setdaysinmonths {      ## arg: year
 typeset yts=$1
#ksh# set -A lastdayofmonth 99 31 28 31 30 31 30 31 31 30 31 30 31
#bash# lastdayofmonth=([0]=99 [1]=31 [2]=28 [3]=31 [4]=30 [5]=31 [6]=30 [7]=31 [8]=31 [9]=30 [10]=31 [11]=30 [12]=31)
#portable:
 lastdayofmonth[0]=99
 lastdayofmonth[1]=31
 lastdayofmonth[2]=28
 lastdayofmonth[3]=31
 lastdayofmonth[4]=30
 lastdayofmonth[5]=31
 lastdayofmonth[6]=30
 lastdayofmonth[7]=31
 lastdayofmonth[8]=31
 lastdayofmonth[9]=30
 lastdayofmonth[10]=31
 lastdayofmonth[11]=30
 lastdayofmonth[12]=31
 let lyc=yts%4
 if [ "$lyc" = 0 ] ; then
        if [ ! -z "$debug" ] ; then echo "$yts is leap year" ; fi
   lastdayofmonth[2]=29
 fi
        # unimplemented option "extra" debugging
        if [ "X$debug" = "X+" ] ; then
        for i in 1 2 3 4 5 6 7 8 9 10 11 12
        do
         echo "ldom $i = ${lastdayofmonth[$i]}"
        done
        fi
}

function get_n_days_ago {       ### returns date of N days ago in $ndaysago
 typeset rdb=$1
 typeset cy=`date +%Y`
 typeset cmm=`date +%m`
 typeset cm=${cmm##0}
 typeset cdd=`date +%d`
 typeset cd=${cdd##0}
 typeset doy=`date +%-j`

# short deltas (less than days this year)
        if [ ! -z "$debug" ] ; then echo "cy=$cy, doy=$doy, cm=$cm, cd=$cd, rdb=$rdb" ; fi
 if [ "$rdb" -lt "$doy" ] ; then
  setdaysinmonths $cy
  if [ "$rdb" -lt "$cd" ] ; then    # shorter delta (less than days this month)
    let cd=cd-rdb
    dom=${lastdayofmonth[$cm]}
    let rdb=dom-cd        # set so that "final" calc below gets correct day
        if [ ! -z "$debug" ] ; then echo "cy=$cy, cm=$cm, cd=$cd, rdb=$rdb (rdb<cd)" ; fi
  else
    let rdb=rdb-cd
    let cm=cm-1
    if [ "$cm" = 0 ] ; then let cy=cy-1; let cm=12; fi
    cd=${lastdayofmonth[$cm]}
        if [ ! -z "$debug" ] ; then echo "cy=$cy, cm=$cm, cd=$cd, rdb=$rdb (rdb<doy)" ; fi
  fi
 fi

 # subtract #days per year until less than 1 year left
 while [ $rdb -ge $doy ] ;
 do
   let rdb=rdb-doy
   let cy=cy-1
   doy=365
   let lyc=cy%4 ; if [ "$lyc" = 0 ] ; then doy=366 ; fi
   cm=12
        if [ ! -z "$debug" ] ; then echo "cy=$cy, doy=$doy, cm=$cm, rdb=$rdb" ; fi
 done

        if [ ! -z "$debug" ] ; then echo "less than 1 year left ($cy $cm $cd rdb:$rdb)" ; fi
# subtract #days per month until less than 1 month left
 setdaysinmonths $cy
 dom=${lastdayofmonth[$cm]}
        if [ ! -z "$debug" ] ; then echo "rdb=$rdb, cm=$cm, lastday=$dom" ; fi
 while [[ $rdb -gt $dom ]]
 do
   let rdb=rdb-dom
   let cm=cm-1
   dom=${lastdayofmonth[$cm]}
        if [ ! -z "$debug" ] ; then echo "cy=$cy, cm=$cm, dom=$dom, rdb=$rdb" ; fi
 done

 dom=${lastdayofmonth[$cm]}
 let cd=dom-rdb
 if [ "$cm" -lt 10 ] && [ "${#cm}" -lt 2 ] ; then cm="0$cm"; fi
 if [ "$cd" -lt 10 ] && [ "${#cd}" -lt 2 ] ; then cd="0$cd"; fi
        if [ ! -z "$debug" ] ; then echo "final: $cy $cm $cd" ; fi
 ndaysago=$cy$cm$cd
}


function get_yesterday {  ### sets $yesterday $checkyyyy $checkmm $checkdd $checkyy
 typeset yyyy=`date +%Y`
 typeset yy=`date +%y`  # temporary test
 typeset yyyyy=$yyyy
 typeset pmm=`date +%m`
 typeset mm=${pmm##0}
 typeset ymm=$mm
 typeset dd=`date +%-d`
 typeset ydd=0
 let ydd=$dd-1
        if [ ! -z "$debug" ] ; then echo "today: $yyyy$mm$dd" ; fi
 if [ "$dd" = 1 ] ; then
   let ymm=$mm-1
   if [ "$ymm" = 0 ] ; then let yyyyy=$yyyy-1 ; ymm=12 ; fi
   setdaysinmonths $yyyyy
   ydd=${lastdayofmonth[$ymm]}
 fi
 if [ "$ymm" -lt 10 ] && [ "${#ymm}" -lt 2 ] ; then ymm="0$ymm"; fi
 if [ "$ydd" -lt 10 ] && [ "${#ydd}" -lt 2 ] ; then ydd="0$ydd"; fi
 # results:
        if [ ! -z "$debug" ] ; then echo "yesterday: $yyyyy$ymm$ydd" ; fi
 yesterday=$yyyyy$ymm$ydd
 checkyyyy=$yyyyy
 checkmm=$ymm
 checkdd=$ydd
 checkyy=${checkyyyy##??}
        if [ ! -z "$debug" ] ; then echo "checkyyyy: $checkyyyy  checkyy:$checkyy" ; fi
}


function convert_mon_to_mm {
### convert MON to MM (ie: AUG to 08)
 typeset mm=0
 typeset mon=$1
 case $mon in
        JAN|jan|Jan)    mm=01 ;;
        FEB|feb|Feb)    mm=02 ;;
        MAR|mar|Mar)    mm=03 ;;
        APR|apr|Apr)    mm=04 ;;
        MAY|may|May)    mm=05 ;;
        JUN|jun|Jun)    mm=06 ;;
        JUL|jul|Jul)    mm=07 ;;
        AUG|aug|Aug)    mm=08 ;;
        SEP|sep|Sep)    mm=09 ;;
        OCT|oct|Oct)    mm=10 ;;
        NOV|nov|Nov)    mm=11 ;;
        DEC|dec|Dec)    mm=12 ;;
 esac
 mon_to_mm=$mm
}


function convert_date_dash {
### convert date from DD-MON-YYYY to YYYYMMDD format
# accepts a date "DD-MON-YYYY" or a date line "AAA,date,DD-MON-YYYY" (or any line ending ",DD-MON-YYYY")
 typeset dline=$1
        if [ ! -z "$debug" ] ; then echo "dline=$dline" ; fi
 typeset lastword=${dline##?*[,]}
        if [ ! -z "$debug" ] ; then echo "lastword=$lastword" ; fi
 typeset dd=${lastword%%-*}
 typeset lwmon=${lastword##??-}
 typeset mon=${lwmon%%-*}
 convert_mon_to_mm $mon
 typeset mm=$mon_to_mm
 typeset yyyy=${lwmon##???-}
 # result:
 cvdatadate=$yyyy$mm$dd
        if [ ! -z "$debug" ] ; then
        echo "mm=$mm, lwmon=$lwmon, mon=$mon, dd=$dd, yyyy=$yyyy, cvdatadate=$cvdatadate" ;
        fi
}


function convert_date_slash {
### convert date from DD/MM/YY to YYYYMMDD format
# accepts a date "DD/MM/YY" or a date line "AAA,date,DD/MM/YY" (or any line ending ",DD/MM/YY")
 typeset dline=$1
        if [ ! -z "$debug" ] ; then echo "dline=$dline" ; fi
 typeset lastword=${dline##?*[,]}
        if [ ! -z "$debug" ] ; then echo "lastword=$lastword" ; fi
 typeset dd=${lastword%%/*}
 typeset lwmm=${lastword##??/}
 typeset mm=${lwmm%%/*}
 typeset yy=${lwmm##??/}
 typeset yyyy="20$yy"
 # result:
 cvdatadate=$yyyy$mm$dd
        if [ ! -z "$debug" ] ; then
        echo "mm=$mm, lwmm=$lwmm, dd=$dd, yyyy=$yyyy, cvdatadate=$cvdatadate" ;
        fi
}


function convert_date {
### determine date format and call proper conversion function
# accepts a date ("DD/MM/YY" or "DD-MON-YYYY") or line ending in ",<date>"
 typeset dline=$1
        if [ ! -z "$debug" ] ; then echo "dline=$dline" ; fi
 typeset lastword=${dline##?*[,]}
        if [ ! -z "$debug" ] ; then echo "lastword=$lastword" ; fi
#
 typeset formatcheck=${lastword%%/*}
 if [ "$formatcheck" != "$lastword" ] ; then        # date includes /
   convert_date_slash $lastword
 else                                           # date does not have / (expecting -)
   convert_date_dash $lastword
 fi
}

function get_date_grep_cmd {
 typeset f=$1
 typeset fzm=`determine_file_compression $f`
 typeset cmd=""
 if [ "$fzm" != "none" ] ; then
   fzcat=`get_compression_cat $fzm`
   cmd="$fzcat $f | grep 'AAA,date'"
 else
   cmd="grep 'AAA,date' $f"
 fi
 echo $cmd
}

function get_nmon_data_date {
### get the data date from nmon data file ($1), return it in $nmondatadate
 typeset nmonfile=$1
 typeset fdline
 typeset cmd
 cmd=`get_date_grep_cmd $nmonfile`
        if [ ! -z "$debug" ] ; then echo "get_nmon_data_date nmonfile=$nmonfile" ; fi
 if [ -r "$nmonfile" ] ; then
   fdline=`eval $cmd`
        if [ ! -z "$debug" ] ; then echo "fdline=$fdline" ; fi
   convert_date $fdline ;
 else
   cvdatadate=0;
 fi
 nmondatadate=$cvdatadate ;
        if [ ! -z "$debug" ] ; then echo "nmondatadate=$nmondatadate" ; fi
}

function check_datafile_dates {
 typeset arg=$1
 typeset lastdate
 typeset datelines
 typeset dt
 if [ ! -f $datafile ] ; then
	if [ ! -z "$debug" ] ; then echo "no datafile present - OK to consolidate data"; fi
	return 0;
 fi
 # get date from nmonpath, check if already in datafile
	if [ ! -z "$debug" ] ; then echo "CDFD:nmonpath:$nmonpath,arg:$arg" ; fi
 unset nmonpath
 if [ -z "$nmonpath" ] ; then get_nmonpath $arg ; fi
	if [ ! -z "$debug" ] ; then echo "nmonpath: $nmonpath " ; fi
 unset nmondatadate
 if [ -z "$nmondatadate" ] ; then get_nmon_data_date $nmonpath ; fi
	if [ ! -z "$debug" ] ; then echo "checking $datafile for date: $nmondatadate" ; fi
 cmd=`get_date_grep_cmd $datafile`
	if [ ! -z "$debug" ] ; then echo "cmd=$cmd" ; fi
 datelines=`eval $cmd` 2>/dev/null
	if [ ! -z "$debug" ] ; then echo "datelines=$datelines" ; fi
 typeset i=0;
 for dt in  $datelines
 do
   let i=i+1 ;
#	easier to tell what is happening here if debugging is turned off for convert_date
	if [ ! -z "$debug" ] ; then debugoff=$debug ; unset debug ; fi
   convert_date $dt ;
#	turn debug back on if it was turned off
	if [ ! -z "$debugoff" ] ; then debug=$debugoff ; unset debugoff ; fi
   dates[$i]=$cvdatadate ;
   if [ "$nmondatadate" = "${dates[$i]}" ] ; then
     date_already_in_datafile="T";
	if [ ! -z "$debug" ] ; then echo "date $nmondatadate already in $datafile" ; fi
     return 3;
   fi
 done
 lastdate=${dates[$i]}
 lastdate=${lastdate:-"0"}
	if [ ! -z "$debug" ] ; then echo "last date: $lastdate (${dates[$i]})" ; fi
 if [ "$nmondatadate" -le "$lastdate" ] ; then
	echo "nmondatadate is less than or equal to the last date in $datafile" ;
	echo "nmondatadate: $nmondatadate,  last datafiledate: ${dates[$i]}" ;
	echo "$datafile will be out of order"
	return 2;
 else
	if [ ! -z "$debug" ] ; then echo "nmondatadate $nmondatadate is OK"; fi
	return 0;
 fi
}



## compression utility functions

function select_compression_method {
 typeset cm
 typeset cfile
 for cm in gzip bzip2 compress
 do
   cfile=`which $cm`
   if [ $? = 0 ] ; then
     echo $cfile
     return 0
   fi
 done
 echo "none"
 return 1
}

function get_compression_suffix {
# expects compression_method as argument
 case $1 in
   *gzip)       echo ".gz" ;;
   *bzip2)      echo ".bz2" ;;
   *compress)   echo ".Z" ;;
   none)        echo "" ;;
   *)           echo "" ;;
 esac
}

function get_uncompression_cmd {
# expects compression_method as argument
 case $1 in
   *gzip)       echo "gunzip" ;;
   *bzip2)      echo "bunzip2" ;;
   *compress)   echo "uncompress" ;;
   none)        echo "" ;;
   *)           echo "" ;;
 esac
}

function get_compression_cat {
# expects compression_method as argument
## zcat/gzcat would be nice here, but not available on all systems
 case $1 in
   *gzip)       echo "gunzip -c" ;;
   *bzip2)      echo "bunzip2 -c" ;;
   *compress)   echo "uncompress -c" ;;
   none)        echo "cat" ;;
   *)           echo "" ;;
 esac
}

function determine_file_compression {
# expects filename as argument
 case $1 in
   *.gz)	echo "gzip" ;;
   *.bz2)	echo "bzip2" ;;
   *.Z)		echo "compress" ;;
   *)		echo "none" ;;
 esac
}

function set_compression_opts {
 if [ ! -z "$compress" ] ; then compressnmonfiles="T" ; compressdatafile="T" ; fi
## set compression opts for nmon daily files
 if [ ! -z "$compressnmonfiles" ] ; then
   if [ -z "$zmethod" ] ; then
     zmethod=`select_compression_method`
     if [ $? -ne 0 ] ; then
	echo "ERROR in select_compression_method - no compression available"
	unset compressnmonfiles
     fi
     if [ "$zmethod" = "none" ] ; then
	echo "unable to find compression tool - no compression available"
	unset compressnmonfiles
     fi
   fi
   if [ -z "$zext" ] ; then
     zext=`get_compression_suffix $zmethod`
   fi
   zcat=`get_compression_cat $zmethod`
   unz=`get_uncompression_cmd $zmethod`
   if [ ! -z "$debug" ] ; then
	echo "compressnmonfiles:$compressnmonfiles, zmethod=$zmethod, zext=$zext, zcat=$zcat";
   fi
 fi

## set compression opts for datafile
 if [ ! -z "$compressdatafile" ] ; then
##### should use determine_file_compression $datafile instead ? or first, then this: ?
   if [ -z "$dzmethod" ] ; then
     dzmethod=`select_compression_method`
     if [ $? -ne 0 ] ; then
	echo "ERROR in select_compression_method - no compression available"
	unset compressdatafile
     fi
     if [ "$dzmethod" = "none" ] ; then
	echo "unable to find compression tool - no compression available"
	unset compressdatafile
     fi
   fi
   if [ -z "$dzext" ] ; then
     dzext=`get_compression_suffix $dzmethod`
   fi
   dzcat=`get_compression_cat $dzmethod`
   undz=`get_uncompression_cmd $dzmethod`
   if [ ! -z "$debug" ] ; then
     echo "compressdatafile:$compressdatafile, dzmethod=$dzmethod, dzext=$dzext, dzcat=$dzcat"
   fi
## set $datafile to the existing datafilename (compressed or not)
   bnzdf=`basename $datafile`
   bndf=`basename $datafile $dzext`
   if [ "$bnzdf" = "$bndf" ] ; then
	zdatafile=${datafile}$dzext ;
   else
	zdatafile=$datafile ;
   fi
   if [ ! -z "$debug" ] ; then
	echo "datafile=$datafile dzext=$dzext bndf=$bndf zdatafile=$zdatafile"
   fi
 fi
}

function get_nmonpath {
##### TRY: change usage of dailynmonfilepattern in get_daily:
#       change dailynmonfilepattern= to base_file_to_get or something
#       then can set base_file_to_get based on a cmdline date
#       would allow [yesterday|today|basefile] ie - basefile instead of nmonpath
 if [ "X$1" != "X" ] ; then
   typeset arg=$1
   if [ "$arg" = "yesterday" ] ; then  date_to_get=$1 ; shift
   elif [ "$arg" = "today" ] ; then  date_to_get=$1 ; shift
   else
     if [ -r "$arg" ] ; then
	nmonpath=$arg
     else
	echo "unable to access $arg - exiting";  exit 1;
     fi
   fi
 fi
## if no path and no date given, default to yesterday
 if [ "X$nmonpath" = "X" ] ; then
   if [ "X$date_to_get" = "X" ] ; then
     date_to_get="yesterday"       # default to yesterday
   fi
	if [ ! -z "$debug" ] ; then echo "date to get: $date_to_get" ; fi
   if [ "$date_to_get" = "yesterday" ] ; then
     get_yesterday      # sets $yesterday $checkyyyy $checkmm $checkdd $checkyy
     checkdate=$yesterday
   elif [ "$date_to_get" = "today" ] ; then
     checkyyyy=`date +%Y`
     checkyy=`date +%y`
     checkyy=`date +%y`
     checkmm=`date +%m`
     checkdd=`date +%d`
     checkdate=$checkyyyy$checkmm$checkdd
   else	 	## should never get here!!
	echo "unknown argument to get_nmonpath: $date_to_get - exiting";  exit
   fi
	if [ ! -z "$debug" ] ; then echo "installdir=$installdir, dailynmonfilepattern=$dailynmonfilepattern" ; fi
## need to eval dailynmonfilepattern to get variable values assigned
   dailynmonfilepattern=`eval "echo $dailynmonfilepattern"`
   nmonpath="$installdir/$dailynmonfilepattern"
 fi
}

