#!/bin/ksh
#
# $Id: pndcm.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Performance Navigator Data Consolidation Manager (pndcm.sh) 
#
#& Controls the consolidation of nmon data into the mpgdata2.hostname file
#
#&@ pndcutils.sh is also required
#&@ nmonmerge(link) is also required
#&@ reduce.patt(link) is also required
#
#&% Ran daily in crontab to clean older files
#
#####
# STILL NEEDS:
#	add "checkdate" command : pndcm.sh -c configfile checkdate nmonfile
#	TEST: use nmonmerge to concat multiple same-day files
#	TEST: reduce default on, opt -r turns off
#	TEST: compress default on, opt -Z turns off
#		also -Z <dzmethod>
#	TEST TEST TEST on AIX and linux
#
today=`date +%Y%m%d`

# debug="T"

invocdir=`dirname $0`
if [ -s $invocdir/pndcutils.sh ]; then
   . $invocdir/pndcutils.sh
fi

if [ -s $invocdir/pn.config ];  then
   . $invocdir/pn.config
fi

# Three new environmental variables
# installdir
# mpgdatadir
# nmondatadir

# installdir should be defined, but if not use invocdir
if [ -z "$installdir" ] ; then
   installdir=$invocdir
fi

# mpgdatadir should be defined, but if not use invocdir
if [ -z "$mpgdatadir" ] ; then
   mpgdatadir=$invocdir
fi

# nmondatadir should be defined, but if not use invocdir
if [ -z "$nmondatadir" ] ; then
   nmondatadir=$invocdir
fi

#### def_datafile="${mpgdatadir}/mpgdata2.$sysname"    # default datafile name


if [ ! -z "$debug" ] ; then
   echo "##$0# installdir=$installdir"
   echo "##$0# mpgdatadir=$mpgdatadir"
   echo "##$0# nmondatadir=$nmondatadir"
   echo "##$0# def_datafile=$def_datafile"
   # echo Remove stop later ; exit 1
fi

function reduce_data {
  typeset f=$1

  if [ ! -z "$reduce" ] ; then
    cat $f | awk -v pf="${invocdir}/reduce.patt" '
    # read the list of patterns to exclude from file "reduce.patt"
    BEGIN {
     pc=0
     while( getline < pf >= 1 ) {
       pc++
       rp[pc] = $0
     }
     # debug
     # for ( patt in rp ) {
     #   print "pattern["patt"]: ", rp[patt]
     # }
     }
     {
     for ( p in rp ) {
       if ( $0 ~ rp[p] ) { next ; }
     }
     print;
     }
     '  # end of awk script to reduce data
  else
     cat $f
  fi
}

function append_to_datafile {	### append daily nmon data to mpgdatafile
  typeset dailyfile=$1
  # check if nmon file is already compressed
  typeset fzm=`determine_file_compression $dailyfile`
  if [ ! -z "$debug" ] ; then echo "$dailyfile uses compression: $fzm" ; fi
  if [ "$fzm" != "none" ] ; then
    if [ ! -z "$debug" ] ; then echo "uncompressing $dailyfile" ; fi
    $unz $dailyfile
  fi
  # Added auto replacement of ^M characters at end of lines
  reduce_data $dailyfile >> $datafile
  if [ ! -z "$compressdatafile" ] ; then
    $dzmethod -c $datafile > $tempfile
    mv $tempfile $zdatafile
  fi
  ## compress the daily datafile if compress option is set
  if [ ! -z "$compressnmonfiles" ] ; then $zmethod $dailyfile ; fi
}

### main command functions :

function ndcm_get_daily {
  ###### TRY: change usage of dailynmonfilepattern in get_daily:
  ##	change dailynmonfilepattern= to base_file_to_get or something
  ##	then can set base_file_to_get based on a cmdline date
  ##	would allow [yesterday|today|basefile] ie - basefile instead of nmonpath
  # if [ "X$1" != "X" ] ; then
  #   typeset arg=$1
  #   if [ "$arg" = "yesterday" ] ; then  date_to_get=$1 ; shift
  #   elif [ "$arg" = "today" ] ; then  date_to_get=$1 ; shift
  #   else
  #     if [ -r "$arg" ] ; then
  #        nmonpath=$arg
  #     else
  #        echo "unable to access $arg - exiting";  exit
  #     fi
  #   fi
  # fi
  ### if no path and no date given, default to yesterday
  # if [ "X$nmonpath" = "X" ] ; then
  #   if [ "X$date_to_get" = "X" ] ; then
  #     date_to_get="yesterday"       # default to yesterday
  #   fi
  #   if [ ! -z "$debug" ] ; then echo "date to get: $date_to_get" ; fi
  #   if [ "$date_to_get" = "yesterday" ] ; then
  #     get_yesterday   # sets $yesterday $checkyyyy $checkmm $checkdd $checkyy
  #     checkdate=$yesterday
  #   elif [ "$date_to_get" = "today" ] ; then
  #     checkyyyy=`date +%Y`
  #     checkyy=`date +%y`
  #     checkyy=`date +%y`
  #     checkmm=`date +%m`
  #     checkdd=`date +%d`
  #     checkdate=$checkyyyy$checkmm$checkdd
  #   else		## should never get here!!
  #	echo "unknown argument to daily: $date_to_get - exiting";  exit
  #   fi
  #   if [ ! -z "$debug" ]; then 
  #     echo "nmondatadir=$nmondatadir, dailynmonfilepattern=$dailynmonfilepattern"
  #   fi
  ### need to eval dailynmonfilepattern to get variable values assigned
  #   dailynmonfilepattern=`eval "echo $dailynmonfilepattern"`
  #   nmonpath="$nmondatadir/$dailynmonfilepattern"
  # fi

  get_nmonpath $1

  ## multiple .nmon files exist for this day (restarted...)
  ## check for <file>.01 (...), if exists, mv file to file.00, cat file.?? > file
  if [ -e "$nmondatadir/${dailynmonfilepattern}.01" ] ; then
    if [ ! -z "$debug" ] ; then echo "multiple files exist for $checkdate" ; fi
    cp $nmondatadir/$dailynmonfilepattern $nmondatadir/${dailynmonfilepattern}_first
    # Determined the last file for a given datepattern, to use as date marker 
    dnfp_last=`ls -1 $nmondatadir/$dailynmonfilepattern.* |tail -1`
    # added holddate file, because file dates were incorrect.
    touch -r $dnfp_last ${dailynmonfilepattern}_holddate
    for nmftf in `ls $nmondatadir/$dailynmonfilepattern.*| grep -v ${today}`
    do
      if [ ! -z "$debug" ] ; then echo "merging $nmftf to $nmondatadir/$dailynmonfilepattern"; fi
      ${installdir}/nmonmerge -a $nmondatadir/$dailynmonfilepattern $nmftf
      ##### need to test this more...
      rm -f $nmftf
    done
    # Use original hold file date for post merged file.
    touch -r $nmondatadir/${dailynmonfilepattern}_holddate $nmondatadir/${dailynmonfilepattern}
    # Remove the hold file, no longer needed.
    rm -f $nmondatadir/${dailynmonfilepattern}_holddate
    rm -f $nmondatadir/${dailynmonfilepattern}_first
  fi

  if [ ! -z "$debug" ] ; then echo "nmonpath=$nmonpath" ; fi
  ## verify file exists and is readable
  ##### should verify actual nmon data (how?)
  if [ ! -r "$nmonpath" ] ; then
    if [ ! -z "$compressnmonfiles" ] ; then
      znmonpath=${nmonpath}$zext
      if [ ! -r "$znmonpath" ] ; then
	echo "$nmonpath missing or unreadable - unable to get nmon data - exiting"
	exit
      else
	if [ ! -z "$debug" ] ; then echo "uncompressing $nmonpath" ; fi
	$undz $znmonpath
	found_nmon_file="T"
      fi
    else
      echo "$nmonpath missing or unreadable - unable to get nmon data - exiting"
      exit
    fi
  else
    found_nmon_file="T"
  fi
  if [ "$found_nmon_file" = "T" ] ; then
    if [ ! -z "$checkdate" ] ; then
      get_nmon_data_date $nmonpath
      if [ "$checkdate" != "$nmondatadate" ] ; then
        echo "data in file $nmonpath is not from $checkdate - exiting"
        exit
      fi
    fi
  check_datafile_dates $nmonpath ;
  if [ "X$date_already_in_datafile" != "X" ] ; then
    echo "data from $nmondatadate is already in $datafile"
    echo "not appending data from $nmonpath" ;
    ## compress the datafile if compress option is set
    if [ ! -z "$compressnmonfiles" ] ; then 
      echo "compressing data from $nmonpath" ;
      $zmethod $nmonpath
    fi
  else
    if [ ! -z "$debug" ] ; then echo "appending $nmonpath to $datafile" ; fi
    append_to_datafile $nmonpath ;
    fi
  fi
}


function ndcm_truncate {
  ## truncate function - calls separate pndc_truncate.sh
  if [ ! -z "$debug" ] ; then
    echo "datafile=$datafile, daystokeep=$daystokeep, tempfile=$tempfile" ;
  fi

  option_string="";
  if [ ! -z "$debug" ] ; then option_string="$option_string -D" ; fi
  if [ ! -z "$verbose" ] ; then option_string="$option_string -v" ; fi
  if [ ! -z "$tempfile" ] ; then option_string="$option_string -t $tempfile"; fi
  if [ ! -z "$datafile" ] ; then option_string="$option_string -t $datfile"; fi
  if [ ! -z "$daystkeep" ] ; then 
    option_string="$option_string -n $daystokeep"
  fi
  if [ ! -z "$maxfilelen" ] ; then 
    option_string="$option_string -s $maxfilelen"
  fi
  if [ ! -z "$configfile" ] ; then 
    option_string="$option_string -c $configfile"
  fi
  if [ ! -z "$compressdatafile" ] ; then option_string="$option_string -Z" ; fi

  ## call pndc_truncate
  ${installdir}/pndc_truncate $option_string
}


function ndcm_clean_old_nmon_datafiles {
  typeset kd=$1
  if [ "X$kd" = "X" ] ; then
    kd="$nmondaystokeep" ;
    if [ ! -z "$debug" ] ; then 
      echo "clean: assigned kd=$kd (default/param)"
    fi
  fi
  get_n_days_ago $kd
  cutdate=$ndaysago
  if [ ! -z "$debug" ] ; then echo "cutoffdate: $cutdate" ; fi
  adf=`eval "echo $nmondatadir/$cleannmonfilepattern"`
  ls $nmondatadir/${cleannmonfilepattern}$zext > /dev/null 2>&1
  rc=$? ; if [ ! -z "$debug" ] ; then echo "eval 1 rc = $rc" ; fi
  if [ "$rc" = "0" ] ; then
    # adf="$adf "`eval "echo $nmondatadir/${cleannmonfilepattern}$zext"`
    adf="$adf "`ls -1 $nmondatadir/${cleannmonfilepattern}$zext | grep -v ${today}`
  fi
  ls $nmondatadir/${cleannmonfilepattern}.[0-9][0-9] >/dev/null 2>&1
  rc=$? ; if [ ! -z "$debug" ] ; then echo "eval 2 rc = $rc" ; fi
  if [ "$rc" = "0" ] ; then
    # adf="$adf "`eval "echo $nmondatadir/${cleannmonfilepattern}.[0-9][0-9]"`
    adf="$adf "`ls -1 $nmondatadir/${cleannmonfilepattern}.[0-9][0-9]|grep -v ${today}`
  fi
  #  if [ ! -z "$debug" ] ; then 
  #    adf="$adf "`eval "echo $nmondatadir/${cleannmonfilepattern}$zext"`
  #    adf="$adf "`eval "echo $nmondatadir/${cleannmonfilepattern}.[0-9][0-9]"`
  #  else ## suppress error message if no .01 nmon files exist
  #    adf="$adf "`eval "echo $nmondatadir/${cleannmonfilepattern}$zext" >/dev/null 2>&1` 
  #    adf="$adf "`eval "echo $nmondatadir/${cleannmonfilepattern}.[0-9][0-9]" >/dev/null 2>&1` 
  #  fi
  if [ ! -z "$debug" ] ; then echo "all nmon data files:" $adf ; fi
  ## delete by datadate in file (more accurate, but slower, esp. with many files)
  # if [ ! -z "$debug" ] ; then echo "checking by datadate in files" ; fi
  for f in $adf
  do
    if [ ! -r "$f" ] ; then
      ## can't read file, or no files found matching cleannmonfilepattern
      echo "unable to read $f" ;
    else
      ## easier to tell what is happening here if debugging is turned off for get_nmon_data_date
      if [ ! -z "$debug" ] ; then debugoff=$debug ; unset debug ; fi
      get_nmon_data_date $f
      ## turn debug back on if it was turned off
      if [ ! -z "$debugoff" ] ; then debug=$debugoff ; unset debugoff ; fi
      if [ ! -z "$debug" ] ; then printf "f:$f  datadate:$nmondatadate " ; fi
      if [ "$cutdate" -gt "$nmondatadate" ] ; then
	if [ ! -z "$debug" ] ; then
	  echo "DELETE" ;
	else
	  rm $f
	fi
      else
	if [ ! -z "$debug" ] ; then echo "KEEP" ; fi
      fi
    fi
  done
}

### utility functions and default values :
def_datafile="${mpgdatadir}/mpgdata2.$sysname"	# default datafile name

function usage {
  echo "USAGE:
pndcm.sh [options] command [args]
  where 'command' is one of: daily truncate clean
arguments and options specific to each command are:
  daily  [\"today\"|\"yesterday\"|nmonpath]      (default yesterday)
	-F dailynmonfilepattern - nmon data file pattern (def: $dailynmonfilepattern)
  truncate
	-s maxfilesize	- specify maximum datafile size (def: $maxfilelen)
	-n daystokeep	- specify maximum days of data to keep (def: $daystokeep)
  clean [days]		(default $nmondaystokeep)
	-C cleannmonfilepattern	- nmon data file pattern (def: $cleannmonfilepattern)
general options are:
	-D		- debug
	-d nmondatadir	- specify nmon data directory (def: $nmondatadir)
	-c configfile	- get settings from \"configfile\"
	-o datafile	- full path to output file (def: $def_datafile)
	-t tempfile	- full path to tempfile (def: $tempfile)
	-r		- do not reduce data (remove extraneous data)
	-z		- do not compress nmon datafiles
	-Z		- do not compress consolidated datafile
"
}


#MAIN#
while getopts "Dvo:c:d:n:s:F:C:t:rzZ" opt ; do
  case $opt in
	v)	verbose="T" ;;
	D)	debug="T" ;;
	o)	opt_datafile=$OPTARG ;;
	c)      opt_configfile=$OPTARG ;;
	t)	opt_tempfile=$OPTARG ;;
	d)	opt_nmondatadir=$OPTARG ;;
	n)	opt_daystokeep=$OPTARG ;;
	s)	opt_maxfilelen=$OPTARG ;;
	F)      opt_dailynmonfilepattern=$OPTARG ;;
	C)      opt_cleannmonfilepattern=$OPTARG ;;
	r)	opt_reduce="F" ;;
	z)	opt_compressnmonfiles="none" ;;
##	Z)	opt_compressdatafile=$OPTARG ;;	## should allow compression type as arg
	Z)	opt_compressdatafile="nocopy" ;;
	?)	usage;  exit ;;
  esac
done
shift `expr $OPTIND - 1`

if [ ! -z "$opt_configfile" ] ; then configfile=$opt_configfile; fi
##### quick+dirty configfile - unsafe!
if [ ! -z "$configfile" ] ; then
  . $configfile
fi
## this allows just setting sysname in the configfile
def_datafile="${mpgdatadir}/mpgdata2.$sysname"	# default datafile name
if [ -z "$datafile" ] ; then datafile="$def_datafile" ; fi
if [ "$reduce" != "T" ] ; then unset reduce ; fi
if [ "$compressdatafile" = "nocopy" ] ; then unset compressdatafile ; fi
if [ "$compressnmonfiles" = "none" ] ; then unset compressnmonfiles ; fi
if [ ! -z "$debug" ] ; then
  verbose="T";
  echo " -- options after configfile processing: -- ";
  echo "datafile:$datafile"
  echo "tempfile:$tempfile"
  echo "nmondatadir:$nmondatadir"
  echo "daystokeep:$daystokeep"
  echo "nmondaystokeep:$nmondaystokeep"
  echo "maxfilelen:$maxfilelen"
  echo "reduce:$reduce"
  echo "compressnmonfiles:$compressnmonfiles"
  echo "compressdatafile:$compressdatafile"
  echo "dailynmonfilepattern:$dailynmonfilepattern"
  echo "cleannmonfilepattern:$cleannmonfilepattern"
fi

# commandline options override config file
if [ ! -z "$opt_datafile" ] ; then datafile=$opt_datafile; fi
if [ ! -z "$opt_tempfile" ] ; then tempfile=$opt_tempfile; fi
if [ ! -z "$opt_nmondatadir" ] ; then nmondatadir=$opt_nmondatadir; fi
if [ ! -z "$opt_daystokeep" ] ; then daystokeep=$opt_daystokeep; fi
if [ ! -z "$opt_maxfilelen" ] ; then maxfilelen=$opt_maxfilelen; fi
#if [ ! -z "$opt_reduce" ] ; then reduce="T"; fi
if [ ! -z "$opt_reduce" ] ; then unset reduce; fi
#if [ ! -z "$opt_compressnmonfiles" ] ; then compressnmonfiles="T"; fi
if [ "$opt_compressnmonfiles" = "none" ] ; then unset compressnmonfiles ;
fi
#if [ ! -z "$opt_compressdatafile" ] ; then compressdatafile="T"; fi
if [ "$opt_compressdatafile" = "nocopy" ] ; then unset compressdatafile ;
##else  compressdatafile=$opt_compressdatafile ;
fi
if [ ! -z "$opt_cleannmonfilepattern" ] ; then cleannmonfilepattern=$opt_cleannmonfilepattern; fi
if [ ! -z "$opt_dailynmonfilepattern" ] ; then dailynmonfilepattern=$opt_dailynmonfilepattern; fi

	if [ ! -z "$debug" ] ; then
	echo " ----- options after commandline option processing:";
	echo "datafile:$datafile"
	echo "tempfile:$tempfile"
	echo "nmondatadir:$nmondatadir"
	if [ ! -z "$compressnmonfiles" ] ; then echo "compressnmonfiles:$compressnmonfiles, zmethod:$zmethod, zext:$zext" ; fi
	if [ ! -z "$compressdatafile" ] ; then echo "compressdatafile:$compressdatafile, dzmethod:$dzmethod, dzext:$dzext" ; fi
	echo "opt_daystokeep:$opt_daystokeep, daystokeep:$daystokeep"
	echo "opt_maxfilelen:$opt_maxfilelen, maxfilelen:$maxfilelen"
	echo "opt_dailynmonfilepattern:$opt_dailynmonfilepattern, dailynmonfilepattern:$dailynmonfilepattern"
	echo "opt_cleannmonfilepattern:$opt_cleannmonfilepattern, cleannmonfilepattern:$cleannmonfilepattern"
	echo "reduce:$reduce"
	echo "  -----  ";
	fi

set_compression_opts

### default bahaviors - if datafile exists, get daily
if [ "X$1" = "X" ] ; then       # if no command:
  if [ -s "$datafile" ] ; then  # if output file exists & not empty, get daily
    command="daily";
  fi
else
  command=$1 ; shift
fi

nmondaystokeep_minimum=7
nmondaystokeep_default=7
if [ "x${nmondaystokeep}x" = "xx" ]; then
   echo "nmondaystokeep not specified (${nmondaystokeep}); setting value to (${nmondaystokeep_default})."
   nmondaystokeep=${nmondaystokeep_default}
fi
if [ ${nmondaystokeep} -lt ${nmondaystokeep_minimum} ] ; then
   echo "nmondaystokeep (${nmondaystokeep}) is less than min retention of (${nmondaystokeep_minimum}); setting value to (${nmondaystokeep_minimum})."
   nmondaystokeep=${nmondaystokeep_minimum}
fi


if [ ! -z "$debug" ] ; then echo "command is: $command, args: $*" ; fi
case $command in
	checkdate)	check_datafile_dates $* ;;
	truncate)	ndcm_truncate ;;
	daily)		ndcm_get_daily $* ;;
	clean)		ndcm_clean_old_nmon_datafiles $* ;;
	*)	echo "unknown command: $command" ; usage ;;
esac

