#!/bin/ksh
#
# $Id: pndchk_fix_group.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# 
# This may be needed if the date stamps on the files are not intact. 
# Requires pndchk.sh and pndcutils.sh to work.
#
# (c) Copyright Fortra, LLC. and its group of companies.
#

#&& Runs pndchk.sh a group of mpgdata2 files in the directory.
#&
#&@ Requires files named mpgdata2.* 
#&@ 
#&@ Requires pndchk.sh pndchk_fix_group.sh pndcutils.sh

mkdir -p /tmp/helpsystems_tmp

ls -1 mpgdata2.* > /tmp/helpsystems_tmp/mpgd2_files.tmp
if [ -s /tmp/helpsystems_tmp/mpgd2_files.tmp ]; then 
   jcnt=0
   jtotal=`wc -l /tmp/helpsystems_tmp/mpgd2_files.tmp | awk '{print $1}'`
   while
   read jfile
   do
      let jcnt=${jcnt}+1
      if [ "x${jfile}x" = "xx" ]; then
         exit
      fi 
      echo "Analyzing $jfile ($jcnt of $jtotal), will correct if necessary"
      ./pndchk.sh $jfile | grep "mv mpg"  > /tmp/helpsystems_tmp/mpguseonly.tmp
      if [ -s /tmp/helpsystems_tmp/mpguseonly.tmp ]; then
         .  /tmp/helpsystems_tmp/mpguseonly.tmp
         echo "$jfile has been fixed"
      else
         echo "$jfile did not need fixing"
      fi
      rm -f *dv_rpt* *timeref /tmp/helpsystems_tmp/mpguseonly.tmp
   done < /tmp/helpsystems_tmp/mpgd2_files.tmp
else
  echo "There were no mpgdata2 files in `pwd`"
fi

