#!/bin/ksh
#
# $Id: pnd_arc_purge_top.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Performance Navigator Data archive purge top (pnd_arc_purge_top.sh) 
#& Purges any and all top data from mpgdata2.(hostname)_archive.gz
#
# Initial Created 7/22/13
#

echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "

invocdir=`dirname $0`
if [ -s $invocdir/pn.config ] ; then
  . $invocdir/pndcutils.sh
else
   echo "pndcutils.sh file does not exist at `pwd`"
fi

if [ -s $invocdir/pn.config ] ; then
   . $invocdir/pn.config 
else
   echo "pn.config file does not exist at `pwd`"
fi

# Three new environmental variables
# installdir
# mpgdatadir
# nmondatadir

# installdir should be defined, but if not use invocdir
if [ -z "$installdir" ] ; then
   installdir=$invocdir
fi

# mpgdatadir should be defined, but if not use invocdir
if [ -z "$mpgdatadir" ] ; then
   mpgdatadir=$invocdir
fi

# nmondatadir should be defined, but if not use invocdir
if [ -z "$nmondatadir" ] ; then
   nmondatadir=$invocdir
fi

###############################
###############################

function usage {
echo "USAGE:
   pnd_arc_purge_top.sh (-t) filename (I.E. mpgdata2.(hostname)_archive.gz)

   -t option does not mv new file in place, but leaves it in place for testing
"
}
   
###############################
###############################


# If -t option is specified indicate for testing only
jtestopt="F"
if [ "x${1}x" = "x-tx" ]; then
   shift
   echo ""
   echo "The -t test option was specified, a new file will be created for testing only"
   jtestopt="T"
fi


# Was a filename specified? If not Error!
if [ "x${1}x" != "xx" ]; then
   jdatafile=$1
else
   echo ""
   echo "### Error ### "
   echo ""
   echo "No gzipped archive data file was specified"
   echo ""
   usage
   exit
fi

# Does the file specified exist? If not Error!
if [ ! -s ${jdatafile} ]; then
   echo ""
   echo "### Error ### "
   echo ""
   echo "The gzipped archive data file specified does not exist."
   echo ""
   usage
   exit
fi

# Does the file end in gz? If not Error!
jtest=`ls -1 ${jdatafile} | grep gz$`
if [ "x${jdatafile}x" = "xx" ]; then
   echo ""
   echo "### Error ### "
   echo ""
   echo "The file (${jdatafile}) does not appear to be gzipped." 
   echo ""
   usage
   exit
fi

# Does the gzipped file have at least 1000 lines? If not Error!
jtest=`gunzip -c ${jdatafile} | head -1000 | wc -l | awk '{print $1}'`
if [ "x${jtest}x" != "x1000x" ]; then
   echo ""
   echo "### Error ### "
   echo ""
   echo "The file (${jdatafile}) does have at least 1000 lines." 
   echo ""
   usage
   exit
fi

# Is the gzipped file working? If so, say so, otherwise Error!
gunzip -c ${jdatafile} 2>&1 > /dev/null
jtest=$?
if [ $jtest -ne 0 ]; then
   echo ""
   echo "### Error ### "
   echo ""
   echo "The gunzip on file (${jdatafile}) appears to error, exiting " 
   echo ""
   exit
else
   echo ""
   echo "The file (${jdatafile}) appears to gunzip without an error." 
fi

# Is the gzipped file normally named? If so, say so, otherwise Warning!
jnormfilename="mpgdata2.${sysname}_archive.gz"
if [ "x${jdatafile}x" != "x${jnormfilename}x" ]; then
   echo ""
   echo "### Warning ### "
   echo ""
   echo "The file (${jdatafile}) is not named ${jnormfilename} " 
   echo ""
else
   echo "The file (${jdatafile}) is named normally" 
fi

# If there are there TOP records to remove report, if not Error! 
jtoponly=`gunzip -c ${jdatafile} | egrep  "^NPIV,|^TOP,"  | wc -c | awk '{print $1}'` 
if [ $jtoponly -eq 0 ]; then
   echo ""
   echo "### Error ### "
   echo ""
   echo "The file (${jdatafile}) does not have any (NPIV, or TOP,) records, exiting " 
   echo ""
   exit
else
   echo ""
   echo "The file (${jdatafile}) appears to have (${jtoponly}) characters"
   echo "of (NPIV, or TOP,) records" 
fi

# Report Sripping TOP records into originalfilename.tmp.gz
echo "Stripping TOP records from ${jdatafile} "
echo "into the file ${jdatafile}.tmp.gz" 

gunzip -c ${jdatafile} | grep -v "^NPIV,|^TOP,"  | gzip -c  > ${jdatafile}.tmp.gz 

# Confirm the record counts and if correct, move new file in place,
# otherwises exit.

echo "Confirming record counts" 

jmain=`gunzip -c ${jdatafile} | wc -c | awk '{print $1}'`
jnotopnew=`gunzip -c ${jdatafile}.tmp.gz | wc -c | awk '{print $1}'`

jconfirm=`echo ${jtoponly} ${jnotopnew} | awk '{print $1+$2}'`

if [ $jmain -ne $jconfirm ]; then
   echo ""
   echo "### Error ### "
   echo ""
   echo "Record count (${jnotopnew}) for new file $({jdatafile}.tmp.gz) "
   echo "to replace $({jdatafile}) appear to be incorrect, exiting."
   echo "jmain=($jmain)"
   echo "jnotopnew=($jnotopnew)"
   echo "jtoponly ($jtoponly)"
   echo "jconfirm ($jconfirm)"
   echo ""
   exit
else
   echo ""
   echo "Record counts have been verified!"
   # If testing option -t specifed, create new file, but do not replace 
   # old file. If testing option not specified, overwrite old file with 
   # new file.
   if [ "x${jtestopt}x" != "xTx" ]; then
      echo "The new file (${jdatafile}.tmp.gz) (${jnotopnew}) characters " 
      echo "is replacing (${jdatafile}) (${jmain}) characters. " 
      mv ${jdatafile}.tmp.gz ${jdatafile}
   else
      echo "The new file (${jdatafile}.tmp.gz) (${jnotopnew}) characters " 
      echo "was created for testing."
      echo "The old file (${jdatafile}) (${jmain}) characters "
      echo "was not replaced. " 
   fi
fi

