#!/bin/ksh 
#
# $Id: pnbrdf.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Performance Navigator Build Rack Data File (pnbrdf.sh) 
#&
#& This script will build a rackdata output file with out the df -k outputs 
#& It is intended to be used if existing nmon data was used to build an
#& mpgdata2.hostname file on an AIX or ppc64 Linux system.
#
#&@ Requires a file input of the data collected from an existing nmon 
#&@ installation. If nofile is specified, a syntax message will be presented.  
#&
#& If no mpgdata2.hostname file exists, to build an rackdata.hostname file a 
#& syntax message will be displayed.
#& 
# 
#
# invocation dir (default for temp/data files, utilities)
# 

invocdir=`dirname $0` 

jsyntax () {
   echo "Error: $1" 
   echo "     pnbrdf.sh filename"
   echo "     (filename must be a valid mpgdata2.hostname file)"
   exit 1 
}
if [ "x${1}x" = "xx" ] ; then
   jsyntax "No nmon file specified!"
else
   jmainfile=${1}
fi
if [ -s ${jmainfile} ] ; then
   # Confirm that the file is an nmon file.
   # Test that this is an nmon file.
   jhostname=`grep ",host,"  ${jmainfile} | head -1 | awk -F, '{print $3}'`
   # echo "hostname is $jhostname!"
   if [ "x${jhostname}x" = "xx" ] ; then
      jsyntax "File ${jmainfile} is not an nmon file!"
   fi
else
   jsyntax "File ${jmainfile} is empty or does not exist"
fi

function convert_mon_to_mm {
### convert MON to MM (ie: AUG to 08)
 typeset mm=0
 typeset mon=$1
 case $mon in
        JAN|jan|Jan)    mm=01 ;;
        FEB|feb|Feb)    mm=02 ;;
        MAR|mar|Mar)    mm=03 ;;
        APR|apr|Apr)    mm=04 ;;
        MAY|may|May)    mm=05 ;;
        JUN|jun|Jun)    mm=06 ;;
        JUL|jul|Jul)    mm=07 ;;
        AUG|aug|Aug)    mm=08 ;;
        SEP|sep|Sep)    mm=09 ;;
        OCT|oct|Oct)    mm=10 ;;
        NOV|nov|Nov)    mm=11 ;;
        DEC|dec|Dec)    mm=12 ;;
 esac
 mon_to_mm=$mm
}

function get_time_string {
   hold_time=`grep ,time, $1 \
      | tail -1 | awk -F, '{print $3}' | awk -F: '{print $1 $2}'`
   hold_date=`grep ,date, $1 | tail -1 | awk -F, '{print $3}'`
   hold_day=`echo $hold_date | cut -c1-2`
   hold_MTH=`echo $hold_date | cut -c4-6`
   hold_year=`echo $hold_date | cut -c8-12`
   convert_mon_to_mm $hold_MTH
   hold_month=$mon_to_mm
   # echo $hold_time
   # echo $hold_date
   # echo $hold_day
   # echo $hold_MTH
   # echo $hold_year
   # echo $hold_month
   jtimestamp=`echo ${hold_year}${hold_month}${hold_day}_${hold_time}`
}

function create_df_file {
   # Had to be modified to take the last bdf -m whether it is the last day or not.
   dfbeginline=`egrep -n "df-m$|df -m$"  $1 | tail -1 |awk -F: '{print $1}'`
   dfendline=`egrep -n "df-m|df -m"  $1 | tail -1 |awk -F: '{print $1}'`
   awk  -v jstart=$dfbeginline -v jlast=$dfendline ' NR >= jstart && NR <= jlast ' $1 | grep -v "\/loop[0-9]"   > df-m.hold  
   cat df-m.hold | grep -v "\-m\$" | cut -d, -f4- | sed s,\",,g | sed s/MB\ /1024-/ | sed s/Mounted\ on/Mounted_on/ | head -1 | awk '{print $1,$2,$3,$4,$5,$6,$7,$8,$9}' | sed s/\ /\,/g | sed s/,,$// > df-m.temp
   cat df-m.hold | grep -v "\-m\$" | cut -d, -f4- | sed s,\",,g | grep % | grep \/ | awk '{print $1,int($2*1024),int($3*1024),$4,$5,$6,$7,$8,$9}' | sed s/\ /\,/g | sed s/,,$// >> df-m.temp

}

# Uses last section that has progname, date, and T00001 record.
# 
# egrep -n ",progname,|Z,T0001,|,date," mpgdata2.vios1 | sed s/:/,/ | awk -F, '{{if($3 == "progname")jp = $1};{if($3 == "date")jd = $1 ; jdate = $5};{if($3 == "T0001")print jp,jd,$1,jdate}}' | tail -1
# 
# Line_of_progname Line_of_date, Line_of_T0001, date_used is the last day or not.
# 
# 673480 673492 674010 23-MAR-2015
# 
# Get the last nmon section for most current details and build a file from it. 
lastsection=`egrep -n ",progname,|Z,T0001,|,date," ${jmainfile} | sed s/:/,/ | awk -F, '{{if($3 == "progname")jp = $1};{if($3 == "date")jd = $1 ; jdate = $5};{if($3 == "T0001")print jp,jd,$1,jdate}}' | tail -1`
lastnmon=`echo $lastsection | awk '{print $1}'`
jlastdate=`echo $lastsection | awk '{print $4}'`
jfile="./nmon.$jhostname.temp" # tempfile for most nmon recent data
tail -n +${lastnmon} ${jmainfile} > ${jfile}

#
# Start analyzing the file to create rackdata.hostname_YYYYMMDD_hhmm
jdate=`date '+%Y%m%d_%H%M'`
# If rackdata.hostname exists, create rackdata.hostname_datestamp 
if [ -s  rackdata.${jhostname} ] ; then
   joutfile="rackdata.${jhostname}_${jdate}"
else
   joutfile="rackdata.${jhostname}"
fi

#######
Is_Linux (){
   echo "# Autogenerated from $jmainfile last date $jlastdate"
   grep "\$Id\:" $0 | awk '{print $1,$3,$4,$5,$6}'
   juptime=`grep uptime ${jfile} | grep : | tail -1 | awk -F\" '{print $2}' | sed s,^\ ,, | sed s,\ \ *,\ ,g`
   # Then next 4 lines create a uniq serial out of the uptime line if needed 
   echo $juptime > /tmp/helpsystems_tmp/juptime.tmp
   if [ -s  /tmp/helpsystems_tmp/juptime.tmp ] ;  then  
      juptime_serial=`sum /tmp/helpsystems_tmp/juptime.tmp | awk '{print "utsum01"$1}'`
   fi

   jlscfgnetadd=`grep "lscfg" ${jfile}  \
      | grep "Network Add" ${jfile}  \
      | sed -e "s,\.\.*,\ ,g" \
      |  sed s,\",,g \
      | awk '{print "JQBE-"$NF}' \
      | tail -1`

   jifcfgHWaddr=`grep "ifconfig" ${jfile}  \
      | grep "HWaddr" ${jfile}  \
      | sed -e "s,\.\.*,\ ,g" \
      | sed s,\",,g \
      | sed s,\:,,g \
      | awk '{print "JQIX-"$NF}' \
      | tail -1`

   echo "# uptime (${juptime})"
   echo "# rackdata for $jhostname" 
   nn=$jhostname
   nnd="Machine Node Name"
   printf "%22s = %s\n" "$nnd" "$nn"
   tempfile="${invocdir}/mpg.temp" # default tempfile

   josinfo=`grep 'AAA,OS,Linux' ${jfile} | sed -e 's/\./\,/g' | head -1`
   
   josinfo2=`grep '/proc/version,' ${jfile} | head -1 | sed s/\ \(.*\)\ /,/ | sed s/\"//g | sed s,Linux\ version\ ,, `
   
   os=`echo $josinfo | awk -F',' '{print $3}'` 
   osd="Operating System Name"
   printf "%22s = %s\n" "$osd" "$os"

   osv=`echo $josinfo2 | awk -F',' '{print $5}'` 
   osvd="OS Version"
   printf "%22s = %s\n" "$osvd" "$osv"

   osr=`echo $josinfo2 | awk -F',' '{print $4}'` 
   osrd="OS Release"
   printf "%22s = %s\n" "$osrd" "$osr"
  
   osi="Unknown"
   osid="hostid"
   if [ "x${osi}x" != "xx" ]; then
      printf "%22s = %s\n" "$osid" "$osi"
   fi

   jproctype=`echo $josinfo | awk -F',' '{print $NF}'` 
   jtitle="Processor Type"
   if [ "x${jproctype}x" != "xx" ]; then
      printf "%22s = %s\n" "$jtitle" "$jproctype"
   fi

   # If serial still empty try SerialNumber
   if [ "xx" = "x${jserial}x" ] ; then
      jserial=`egrep 'SerialNumber' ${jfile} \
         | head -1 \
         | sed -e 's/"/,/g' \
         | sed -e 's/,$//g'\
         | awk -F, '{print $NF}'`
   fi
   # If serial still empty try serial_number
   if [ "xx" = "x${jserial}x" ] ; then
      jserial=`egrep 'serial_number' ${jfile} \
         | head -1 \
         | sed -e 's/"/,/g' \
         | sed -e 's/,$//g'\
         | awk -F, '{print substr($(NF),3)}'\
         | grep -v number`
   fi

   # If serial still empty place jlscfgnetadd in serial
   if [ "xx" = "x${jserial}x" ] ; then
      jserial="${jifcfgHWaddr}" 
   fi

   # If serial still empty place jlscfgnetadd in serial
   if [ "xx" = "x${jserial}x" ] ; then
      jserial="${jlscfgnetadd}" 
   fi

   # If serial still empty place hexip 
   if [ "xx" = "x${jserial}x" ] ; then
      ifconfig_ip=`grep ifconfig ${jfile} \
         | grep inet \
         | grep Bcast \
         | head -1 \
         | sed -e "s,^.*inet\ addr:,," \
         | awk '{print $1}'| sed -e "s,\.,\ ,g"`
      ifconfig_ip_hex=`for i in $ifconfig_ip
      do
         printf '%02X' "$i"
      done`
      if [ "x${ifconfig_ip_hex}x" != "xx" ]; then
         jserial="JQBE-${ifconfig_ip_hex}"
         if [ ! -z "$debug" ] ; then echo "#13 serial=$jserial" >> /tmp/helpsystems_tmp/rackdata_debug.temp ; fi
      fi
   ### echo $jserial
   fi
   # If serial still empty place juptime_serial in serial
   if [ "xx" = "x${jserial}x" ] ; then
      jserial="${juptime_serial}" 
   fi
   # If serial still empty place pnbrdf in serial
   if [ "xx" = "x${jserial}x" ] ; then
      jserial="pnbrdf" 
   fi
   if [ "xx" != "x${jserial}x" ] ; then
      memd="Serial"
      printf "%22s = %s\n" "$memd" "$jserial"
   fi

   jmodname=`grep "model name" ${jfile}  \
      | grep cpuinfo \
      | sed s/\"//g \
      | sed s/model\ name/model_name/ \
      | sed s,\	,\ ,g \
      | sed s,\ \ *,\ ,g \
      | sed s/\ :\ /\:/g \
      | awk -F: '{print $2}'\
      | uniq `
   if [ "xx" = "x${jmodname}x" ] ; then
      jmodname="Unknown" 
   fi
   if [ "xx" != "x${jmodname}x" ] ; then
      modnamed="CPU_Model_name"
      printf "%22s = %s\n" "$modnamed" "$jmodname"
   fi

#  
 
   jcpumhz=`egrep "clock|cpu MHz"  ${jfile}  \
      | grep cpuinfo \
      | sed s/\"//g \
      | sed s/model\ name/model_name/ \
      | sed s,\	,\ ,g \
      | sed s,\ \ *,\ ,g \
      | sed s/\ :\ /\:/g \
      | awk -F: '{print $2}' \
      | awk -F\. '{print $1}' \
      | sort -n \
      | uniq \
      |tail -1`
   if [ "xx" = "x${jcpumhz}x" ] ; then
      jcpumhz="Unknown" 
   fi
   if [ "xx" != "x${jcpumhz}x" ] ; then
      cpumhzd="CPU_Mhz"
      printf "%22s = %s\n" "$cpumhzd" "$jcpumhz"
   fi
   
   tzd="TZ"
   tz="Unknown"
   if [ "x${tz}x" != "xx" ]; then
      printf "%22s = %s\n" "$tzd" "$tz"
   fi

   distinfo=`grep "release," ${jfile} | grep " Linux " | egrep -v "=|:" | awk -F, '{print $4}'  | sed s,\",,g | uniq` 
   if [ "xx" != "x${distinfo}x" ] 
   then 
      distinfod="distinfo"
      printf "%22s = %s\n" "$distinfod" "$distinfo"
   fi
   
   machmodel=`echo $josinfo | awk -F',' '{print $NF}'` 
   machmodeld="Machine model"
   if [ "x${machmodel}x" != "xx" ]; then
      printf "%22s = %s\n" "$machmodeld" "$machmodel"
   fi

   # Amount physical memory
   AmtPhysMem=`grep 'MemTotal:' ${jfile} | head -1 | sed -e 's/:\ \ */:/g' | sed -e 's/	//g' | sed -e 's/\"//g' | sed -e 's/\ kB//g' | awk -F: '{print $(NF)}'` 
   if [ "xx" != "x${AmtPhysMem}x" ] 
   then 
      AmtPhysMemd="Amount physical memory"
      printf "%22s = %s\n" "$AmtPhysMemd" "$AmtPhysMem"
   fi
   
   mt_mn=`grep 'AAA,MachineType' ${jfile} | head -1 | awk -F, '{print $3","$4}'`
   # mt_mn=`grep 'System Model:' ${jfile} | sed -e 's/"//g' | head -1 | awk -F= '{print $NF}'`
   # mt_mn=`grep 'system_type=' ${jfile} | sed -e 's/"//g' | head -1 | awk -F= '{print $NF}'`
   if [ "xx" != "x${AmtPhysMem}x" ] 
   then 
      mt_mnd="Machine Type and Model Name"
      printf "%27s = %s\n" "$mt_mnd" "$mt_mn"
   fi

   # Active Physical CPUs
   grep lparstat ${jfile} \
      | awk -F, '{print $4}' \
      | grep " : " \
      | sed s/\"//g > /tmp/helpsystems_tmp/lparstat-i.tmp

   Act_Phy_CPUs=`grep ^Active\ Phys /tmp/helpsystems_tmp/lparstat-i.tmp | awk '{print $NF}'| uniq `
   if [ ! -z "$Act_Phy_CPUs" ] ; then
      Act_Phy_CPUsd="Active Physical CPUs"
      printf "%27s = %s\n" "$Act_Phy_CPUsd" "$Act_Phy_CPUs"
   fi

   Shared_Pool_ID=`grep "^Shared\ Pool\ ID" /tmp/helpsystems_tmp/lparstat-i.tmp | awk '{print $NF}'| uniq `
   if [ ! -z "$Shared_Pool_ID" ] ; then
      Shared_Pool_IDd="Shared Pool ID"
      printf "%27s = %s\n" "$Shared_Pool_IDd" "$Shared_Pool_ID"
   fi

   Online_Virtual_CPUs=`grep "^Online\ Virtual\ CPUs" /tmp/helpsystems_tmp/lparstat-i.tmp | awk '{print $NF}'| uniq `
   if [ ! -z "$Online_Virtual_CPUs" ] ; then
      Online_Virtual_CPUsd="Online Virtual CPUs"
      printf "%27s = %s\n" "$Online_Virtual_CPUsd" "$Online_Virtual_CPUs"
   fi

   Act_CPUs_in_Pool=`grep "^Active\ CPUs\ in\ Pool" /tmp/helpsystems_tmp/lparstat-i.tmp | awk '{print $NF}'| uniq `
   if [ ! -z "$Act_CPUs_in_Pool" ] ; then
      Act_CPUs_in_Poold="Act CPUs in Pool"
      printf "%27s = %s\n" "$Act_CPUs_in_Poold" "$Act_CPUs_in_Pool"
   fi

   SMT=`grep "^Type\ " /tmp/helpsystems_tmp/lparstat-i.tmp \
      | sed -e "s,SMT$,SMT-2," \
      | sed s,\-,:,g \
      | sed s,:\ ,:, \
      | sed s,d$,d:notdisplayed:off,\
      | awk -F: '{print $(NF-2), $NF}'| uniq `
   if [ ! -z "$SMT" ] ; then
      SMTd="SMT"
      printf "%27s = %s\n" "$SMTd" "$SMT"
   fi

   ccin="Unknown"
   ccind="CCIN"
   if [ "x${ccin}x" != "xx" ]; then
      printf "%27s = %s\n" "$ccind" "$ccin"
   fi

   cuod="Unknown"
   cuodd="Proc CUOD"
   if [ "x${cuod}x" != "xx" ]; then
      printf "%27s = %s\n" "$cuodd" "$cuod"
   fi

   # Plant Code and Model ID
   PlantCodeModID=`grep 'serial_number=' ${jfile} | sed -e 's/"//g' | head -1 | awk -F= '{print $NF}'`
   if [ "xx" != "x${PlantCodeModID}x" ] 
   then 
      PlantCodeModIDd="Plant Code and Model ID"
      printf "%27s = %s\n" "$PlantCodeModIDd" "$PlantCodeModID"
   fi

   # Partition ID
   PartitionID=`grep 'partition_id=' ${jfile} | sed -e 's/"//g' | head -1 | awk -F=  '{print $NF}'`
   if [ "xx" != "x${PartitionID}x" ] 
   then 
      PartitionIDd="Partition ID"
      printf "%27s = %s\n" "$PartitionIDd" "$PartitionID"
   fi

   # Processor frequency 
   ProcFreq=`grep '/proc/cpuinfo,\"clock' ${jfile} | sed -e 's/"//g' | sort | uniq | awk '{print "@"$NF}' |  sed -e 's/\.000000/ /' |sort | uniq -c | sed s,^\ \ *,, | sed s,\ ,, `  
   if [ "xx" != "x${ProcFreq}x" ] 
   then 
      ProcFreqd="Processor frequency"
      printf "%27s = %s\n" "$ProcFreqd" "$ProcFreq"
   fi

   # CPUs
   CPUs=`grep '/proc/cpuinfo,\"clock' ${jfile} | sed -e 's/"//g' | sort | uniq | awk '{print $0}' |  wc -l | awk '{print $1}' `  
   if [ "x0x" = "x${CPUs}x" ] ; then 
      CPUs=`grep 'AAA,cpus,' ${jfile} | awk -F, '{print $3}' | uniq `
   fi
   if [ "xx" != "x${CPUs}x" ] 
   then 
      CPUsd="CPUs"
      printf "%27s = %s\n" "$CPUsd" "$CPUs"
   fi

   # Threads per core
   ThreadsPerCore=`grep "lscpu,\"Thread" ${jmainfile} | sed -e 's/"//g' | tail -1 | awk '{print $NF}'`
   if [ "xx" != "x${ThreadsPerCore}x" ] 
   then 
      ThreadsPerCored="Threads per core"
      printf "%27s = %s\n" "$ThreadsPerCored" "$ThreadsPerCore"
   fi

   # Cores per socket
   CoresPerSocket=`grep "per socket:" ${jmainfile} | sed -e 's/"//g' | tail -1 | awk '{print $NF}'`
   if [ "xx" != "x${CoresPerSocket}x" ] 
   then 
      CoresPerSocketd="Cores per socket"
      printf "%27s = %s\n" "$CoresPerSocketd" "$CoresPerSocket"
   fi

   # Sockets
   Sockets=`grep "lscpu,\"Socket" ${jmainfile} | sed -e 's/"//g' | tail -1 | awk '{print $NF}'`
   if [ "xx" != "x${Sockets}x" ] 
   then 
      Socketsd="Sockets"
      printf "%27s = %s\n" "$Socketsd" "$Sockets"
   fi

   # Total Cores
   TotalCores=`echo "$CoresPerSocket * $Sockets" | bc 2>/dev/null | awk '{print $1}'`
   if [ "xx" != "x${TotalCores}x" ] 
   then 
      TotalCoresd="Total cores"
      printf "%27s = %s\n" "$TotalCoresd" "$TotalCores"
   fi

   # SmtStatus
   SmtStatus=`grep "SMT is" ${jfile} | tail -1 | sed s,\",,g | awk -F, '{print $4}'`
   if [ "xx" != "x${SmtStatus}x" ] 
   then 
      SmtStatusd="Smt status"
      printf "%27s = %s\n" "$SmtStatusd" "$SmtStatus"
   fi


##### End of tested secion #####


grep "fdisk-l"  ${jmainfile} | egrep "Disk \/dev\/sd" | grep -v 0x00000000 |  sort | uniq -c | sed s/fdisk-l,/@/ | awk -F@ '{print $2}' | sed s/\"//g | sed s/\:/,/g | sed s,Disk\ ,,g | sed s/,\ /,/g | sort | uniq   > ${tempfile}
 
   ## get disk info (number, name, type, and sizes) 
#    grep 'BBBB' ${jfile}   \
#       | egrep -v "unknown|,cd|BBBB,0000" \
#       | sort \
#       | uniq \
#       | awk -F',' '{print "",$3,":","type:",$5,":","Size in MB:", 1000*$4}' > ${tempfile}
   jdcnt=`wc -l ${tempfile} | awk '{print $1}'`
   echo ; echo "found $jdcnt disk devices :"
   cat ${tempfile}
   get_time_string ${jfile}
   ## echo "(${jtimestamp})" # for testing only
   create_df_file  ${jmainfile}
   if [ -s df-m.temp ]; then
      echo "# df history"
      echo "# dfinfo"
      
      cat df-m.temp | awk -v jtstamp=${jtimestamp} '{print jtstamp","$0}'
      
   else
      echo "###########"
      echo "No df output available"
      echo "###########"
   fi
   if [ -s ${tempfile} ] ; then
       rm -f ${tempfile} 
       # echo ${tempfile} 
   fi
}

#######
Is_AIX (){
   echo "# Autogenerated from $jmainfile last date $jlastdate"
   echo "# rackdata for $jhostname" 
   nn=$jhostname
   nnd="Machine Node Name"
   printf "%22s = %s\n" "$nnd" "$nn"
   tempfile="${invocdir}/mpg.temp" # default tempfile

   josinfo=`grep 'AAA,AIX,' ${jfile} | sed -e 's/\./\,/g' | head -1`
   # echo $josinfo Remove later
   
   jviosinfo=`grep 'AAA,VIOS,' ${jfile} | head -1 `
   #  echo "jviosinfo ($jviosinfo)"
   
   os=`echo $josinfo | awk -F',' '{print $2}'` 
   osd="Operating System Name"
   printf "%22s = %s\n" "$osd" "$os"

   osv=`echo $josinfo | awk -F',' '{print $3}'` 
   osvd="OS Version"
   printf "%22s = %s\n" "$osvd" "$osv"

   osr=`echo $josinfo | awk -F',' '{print $4}'` 
   osrd="OS Release"
   printf "%22s = %s\n" "$osrd" "$osr"
   
   jvios=`echo $jviosinfo | awk -F',' '{print $3}'` 
   jviosd="Vios Version"
   printf "%22s = %s\n" "$jviosd" "$jvios"
 
   osid="hostid"
   osi="Unknown"
   if [ "x${osi}x" != "xx" ]; then
      printf "%22s = %s\n" "$osid" "$osi"
   fi

   jproctype=`grep  'Processor Type:' ${jfile} | sed -e 's/\"//g' | head -1 | awk '{print $NF}'`
   jtitle="Processor Type"
   if [ "x${jproctype}x" != "xx" ]; then
      printf "%22s = %s\n" "$jtitle" "$jproctype"
   fi

   if [ "xx" = "x${jserial}x" ] ; then
      jserial=`grep 'Machine Serial Number' ${jfile} |egrep -v "Not Available|Not Available" | head -1 | sed -e 's/"//g' | awk '{print $NF}'` 
   fi
   if [ "xx" = "x${jserial}x" ] ; then
      jserial=`grep 'AAA,SerialNumber,' ${jfile} | head -1 | awk -F',' '{print $3}'`
   fi
#   echo $jserial
#   echo "Remove Later"; exit 1

   if [ $jserial ] 
   then 
      memd="Serial"
      printf "%22s = %s\n" "$memd" "$jserial"
   fi
   

   # Query for AIX TL level
   joslevel=`grep oslevel ${jfile} |  grep "\-[0-9][0-9]\-" | sed -e 's/"//g' | head -1 | awk -F',' '{print $4}'`
   OSLV=`echo $joslevel | cut -c1-2`
   if [ "x${OSLV}x" = "xx" ]
   then
      OSLV="${osv}${osr}"
   fi 
   if (( OSLV >= 53 ))
   then
      tl=`echo $joslevel | cut -c9-10`
      if [ "x${tl}x" = "xx" ]
      then
         tl="Unknown"
      fi
      tld="Technology Level"
      printf "%22s = %s\n" "$tld" "$tl"
   fi
   
   isa="Unknown"
   isad="Instruction set architecture"
   printf "%40s = %s\n" "$isad" "$isa"

   mt_mn=`grep 'AAA,MachineType' ${jfile} | head -1 | awk -F, '{print $3","$4}'`
   # mt_mn=`grep 'System Model:' ${jfile} | sed -e 's/"//g' | head -1 | awk '{print $NF}'`
   mt_mnd="Machine Type and Model Name"
   printf "%40s = %s\n" "$mt_mnd" "$mt_mn"

   grep lparstat ${jfile} | awk -F, '{print $4}' | grep " : " |sed s/\"//g > /tmp/helpsystems_tmp/lparstat-i.tmp

   Act_Phy_CPUs=`grep ^Active\ Phys /tmp/helpsystems_tmp/lparstat-i.tmp | awk '{print $NF}' | uniq`
   if [ ! -z "$Act_Phy_CPUs" ] ; then
      Act_Phy_CPUsd="Active Physical CPUs"
      printf "%40s = %s\n" "$Act_Phy_CPUsd" "$Act_Phy_CPUs"
   fi

   Shared_Pool_ID=`grep "^Shared\ Pool\ ID" /tmp/helpsystems_tmp/lparstat-i.tmp | awk '{print $NF}'| uniq `
   if [ ! -z "$Shared_Pool_ID" ] ; then
      Shared_Pool_IDd="Shared Pool ID"
      printf "%40s = %s\n" "$Shared_Pool_IDd" "$Shared_Pool_ID"
   fi

   Act_CPUs_in_Pool=`grep "^Active\ CPUs\ in\ Pool" /tmp/helpsystems_tmp/lparstat-i.tmp | awk '{print $NF}'| uniq `
   if [ ! -z "$Act_CPUs_in_Pool" ] ; then
      Act_CPUs_in_Poold="Act CPUs in Pool"
      printf "%40s = %s\n" "$Act_CPUs_in_Poold" "$Act_CPUs_in_Pool"
   fi

   SMT=`grep "^Type\ " /tmp/helpsystems_tmp/lparstat-i.tmp \
      | sed -e "s,SMT$,SMT-2," \
      | sed s,\-,:,g \
      | sed s,:\ ,:, \
      | sed s,d$,d:notdisplayed:off,\
      | awk -F: '{print $(NF-2), $NF}'| uniq `
   if [ ! -z "$SMT" ] ; then
      SMTd="SMT"
      printf "%40s = %s\n" "$SMTd" "$SMT"
   fi

   pc_mi=`grep -i 'systemid' ${jfile} | awk '{print $4}' | head -1`
   pc_mid="Plant Code and Machine ID"
   printf "%40s = %s\n" "$pc_mid" "$pc_mi"

   ## Memory info
   mem=`grep -i 'realmem' ${jfile} | awk '{print $4}' | head -1`
   memd="Amount of usable physical memory in K"
   printf "%40s = %s\n" "$memd" "$mem"


   if (( OSLV >= 53 )); then
   # if [ "$osv" = "5" ] && [ "$osr" -gt "2" ] ; then
      ## LPAR specific (V5R3)

      # Next line did not work for older versions of nmon
      # lpnn=`grep -i 'LPARNumberName' ${jfile} | head -1 | awk -F',' '{print $3" "$4}'`  
      lpnn=`egrep -i "Partition N" ${jfile} | sed -e 's/"//g'  | awk '{print $NF}' | paste - - | awk '{print $2,$1}' | uniq `
      lpnnd="LPAR Number and LPAR Name"
      printf "%40s = %s\n" "$lpnnd" "$lpnn"

      lpcap=`grep -i 'Partition is capped' ${jfile} | awk '{print $4}' | head -1`
      lpcapd="Partition is capped"
      printf "%40s = %s\n" "$lpcapd" "$lpcap"

      lpded=`grep -i 'Partition is dedicated' ${jfile} | awk '{print $4}' | head -1`
      lpdedd="Partition is dedicated"
      printf "%40s = %s\n" "$lpdedd" "$lpded"

      lpentcap=`grep -i 'ent_capacity' ${jfile} | awk '{print $4}' | head -1`
      lpentcapd="Entitled processor capacity"
      printf "%40s = %s\n" "$lpentcapd" "$lpentcap"

      Online_Virtual_CPUs=`grep "^Online\ Virtual\ CPUs" /tmp/helpsystems_tmp/lparstat-i.tmp | awk '{print $NF}' | uniq `
      if [ ! -z "$Online_Virtual_CPUs" ] ; then
         Online_Virtual_CPUsd="Online Virtual CPUs"
         printf "%40s = %s\n" "$Online_Virtual_CPUsd" "$Online_Virtual_CPUs"
      fi

      lpmincap=`grep -i 'min_capacity' ${jfile} | awk '{print $4}' | head -1`
      lpmincapd="Minimum potential processor capacity"
      printf "%40s = %s\n" "$lpmincapd" "$lpmincap"

      lpmaxcap=`grep -i 'max_capacity' ${jfile} | awk '{print $4}' | head -1`
      lpmaxcapd="Maximum potential processor capacity"
      printf "%40s = %s\n" "$lpmaxcapd" "$lpmaxcap"
   fi
   
   ## get disk info (number, name, type, and sizes) 
   grep 'BBBB' ${jfile}   \
      | egrep -v "unknown|,cd|BBBB,0000" \
      | sort \
      | uniq \
      | awk -F',' '{print "",$3,":","type:",$5,":","Size in MB:", 1000*$4}' > ${tempfile}
   jdcnt=`wc -l ${tempfile} | awk '{print $1}'`
   echo ; echo "found $jdcnt disk devices :"
   cat ${tempfile}
   get_time_string  ${jfile}
   ## echo "(${jtimestamp})" # for testing only
   create_df_file ${jmainfile}
   if [ -s df-m.temp ]; then
      echo "# df history"
      echo "# dfinfo"
      cat df-m.temp | awk -v jtstamp=${jtimestamp} '{print jtstamp","$0}'
   else
      echo "###########"
      echo "No df output available"
      echo "###########"
   fi
   if [ -s ${tempfile} ] ; then
       rm -f ${tempfile} 
       # echo ${tempfile} 
   fi
   if [ -s ${tempfile} ] ; then
       rm -f ${tempfile} 
#        echo ${tempfile} 
   fi 


cp $jfile jtemp.hsllc

grep "Virtual SCSI Server Adapter" $jfile | awk '{print $2, $2, $3}' | sed s/vhost// | sort -n > /tmp/helpsystems_tmp/VScsiSrvAdp.hsllc
if [ -s /tmp/helpsystems_tmp/VScsiSrvAdp.hsllc ]; then
   echo ""
   echo "###########"
   echo "Virtual Partion Count (`wc -l /tmp/helpsystems_tmp/VScsiSrvAdp.hsllc | awk '{print $1}'`)"
   echo "###########"
   
   while 
   read jnbr jvost jvssaid
   do
   grep $jvssaid $jfile | awk '{print "#", $0 }'
   done < /tmp/helpsystems_tmp/VScsiSrvAdp.hsllc
fi


}




grep 'OS,Linux,' ${jfile} > /dev/null
jchk=$?
if [ "x${jchk}" = "x0" ] ; then
   Is_Linux > ${joutfile} 
   echo "    ${joutfile} was created from ${jmainfile}"
   # Is_Linux 
fi

grep 'AAA,AIX,' ${jfile} > /dev/null
jchk=$?
if [ "x${jchk}" = "x0" ] ; then
   Is_AIX > ${joutfile} 
   echo "    ${joutfile} was created from ${jmainfile}"
   # Is_AIX 
fi

# Remove temporary ${jfile}
if [ -s ${jfile} ] ; then
     rm -f ${jfile} 
#    echo $jfile
fi

exit

