#!/bin/ksh
##!/bin/ksh -xv
#
# $Id: pnadcp.sh,v 1.1 2023/03/27 16:07:05 root Exp $ 
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Performance Navigator Admin Data Collection Process (pnadcp_start.sh)
#& This script runs from rackdata.sh in the background.
#& .
#& Details on variable names 
#& MPG ID time/date/system_name
#& DskVars Disk Variables
#& SWSB System Wide Sticky Bits
#& DskDF ID File Systems
#& DFCnt Directory File Counts
#& DSpc Directory Space
#& BigFile Largest Files
#& .
#& admin_data_collect variable is used to turn off/on admin data collection 
#& and is entered in the pn.config file gathered when rackdata.sh runs.
#& admin_data_collect="F" off the next day.
#& admin_data_collect="T" on the next day.
#

mkdir -p /tmp/helpsystems_tmp

rm -f /tmp/sticky* /tmp/pnadcp.running /tmp/df_k.tmp # helpsystems


# Since it is running in the background, check and see if it is already running.
ps -ef | grep -v grep | grep "pnadcp.sh" > /tmp/helpsystems_tmp/pnadcp.running
jchk=`cat /tmp/helpsystems_tmp/pnadcp.running | awk '{if( $3 == 1 ) print $0}' | tee /tmp/helpsystems_tmp/jhold | wc -l | awk '{print $1}'` 
if [ $jchk -gt 1 ]; then
   echo "Running pnadcp.sh already ($jchk), exiting!"
   exit
fi

invocdir=`dirname $0`
sysname=`uname -n | awk -F. '{print $1}'`

usage () {
   echo "USAGE: $0 [options]
   where options may be any of:
   -D                  debug
   -v                  verbose
   -h                  help (this message)
   -a                  all data including directory scans (counts & space)
   -c <configfile>     specify configfile (full path)
   "
}

while getopts "Dvhac:" opt; do
   case $opt in
      D)      debug="T" ;;
      v)      verbose="T" ;;
      h)      usage;  exit ;;
      a)      opt_include_dir_scans="T" ;;
      c)      opt_configfile=$OPTARG ;;
      ?)      usage;  exit ;;
   esac
done

# Some Linuxs and others do not accept a +n option. This helps correct it.
# RedHat is known to only accept -k# option.
jsorttest=`echo "1 3" | sort +1 2>/dev/null`
## echo "${jsorttest}"
## If jsorttest is not empty, then....
if [ ! -z "${jsorttest}" ] ; then
   jsortmod="+2" 
else
   jsortmod="-k3" 
fi
## echo ${jsortmod}
## echo "Remove Later" ; exit 1

# Prior to loading config file, set include_dir_scans to False "F"
# in case it is not set in the pnadcp.config file
# It will still be overriden by command line option -a
include_dir_scans="F"

# Load the Performance Navigator Admin Data Collection configuration options
# if available
# if [ -s ${invocdir}/pnadcp.config ]; then
#    . $invocdir/pnadcp.config 
# fi

# Load the Performance Navigator configuration options if available
if [ -s ${invocdir}/pn.config ]; then
   . $invocdir/pn.config 
fi

# Three new environmental variables
# installdir
# mpgdatadir
# nmondatadir

# installdir should be defined, but if not use invocdir
if [ -z "$installdir" ] ; then
   installdir=$invocdir
fi

# mpgdatadir should be defined, but if not use invocdir
if [ -z "$mpgdatadir" ] ; then
   mpgdatadir=$invocdir
fi

# nmondatadir should be defined, but if not use invocdir
if [ -z "$nmondatadir" ] ; then
   nmondatadir=$invocdir
fi

# commandline options override config file
if [ ! -z "$opt_include_dir_scans" ] ; then include_dir_scans=$opt_include_dir_scans; fi

# Set defaults if not read from pndcutils.sh, pnadcp.config, or pn.config 
if [ "x${TopDFCnt}" = "x" ] ; then
   TopDFCnt=20
fi
if [ "x${TopDSpc}" = "x" ] ; then
   TopDSpc=20
fi
if [ "x${TopBigFile}" = "x" ] ; then
   TopBigFile=20
fi
if [ "x${MinFSz}" = "x" ] ; then
   MinFSz=50000000
fi
if [ "x${MinFCnt}" = "x" ] ; then
   MinFCnt=100
fi
if [ "x${MinDSpc}" = "x" ] ; then
   MinDSpc=10000 
fi

# If not specified externally set pnadcp output file
if [ "x${pnadcp_out}" = "x" ] ; then
   pnadcp_out="${mpgdatadir}/mpgdata4.$sysname"
fi

# Create the mpg file and comment with company name if it does not exist
if [ ! -s ${pnadcp_out} ]; then
   echo "# This file used by HelpSystems, LLC. for Performance Navigator" >> ${pnadcp_out} 
   echo "# for the admin data collection process (pnadcp)." >> ${pnadcp_out} 
   echo "# For questions, please call 1 800-328-1000." >> ${pnadcp_out} 
   echo "#" >> ${pnadcp_out} 
   echo "# Details on variable names" >> ${pnadcp_out} 
   echo "# MPG - ID time/date/system_name" >> ${pnadcp_out} 
   echo "# DskVars - Disk Variables" >> ${pnadcp_out} 
   echo "# SWSB - System Wide Sticky Bits" >> ${pnadcp_out} 
   echo "# DskDF - ID File Systems" >> ${pnadcp_out} 
   echo "# DFCnt - Directory File Counts" >> ${pnadcp_out} 
   echo "# DSpc - Directory Space" >> ${pnadcp_out} 
   echo "# BigFile - Largest Files" >> ${pnadcp_out} 
fi

if [ "x${admin_data_collect}" != "xT" ] ; then
   exit 0
fi

# Determine the system os to be used below and determine df or bdf command
# syntax
jOS=`uname -s`
if [ "x${jOS}" = "xSunOS" ] ; then
   # Tested with SunOS 8,9
   jdskcmd="df -k"
elif [ "x${jOS}" = "HP-UX" ] ; then
   jdskcmd="bdf"
else
   # Tested with AIX, SCO_SV, and severa Linux versions
   jdskcmd="df -Pk"
fi

# Use either gawk, nawk, or awk in that order for AWK.
# Use the first one found.  gawk has more options than nawk which has
# more options than awk.
for jawk in /bin/gawk /usr/bin/gawk /bin/nawk /usr/bin/nawk /bin/awk /usr/bin/awk
do
   # Added Spanish message for not found.
   jtest=`which $jawk 2>&1 | egrep -v "annot| no | not | No se puede encontrar "`
   jchk=$?
   if [ $jchk -eq 0 ]; then
      AWK="$jtest"
   break
   fi
done

if [ ! -z "$debug" ] ; then 
   jbasename=`basename $0 | sed s,\.sh$,,g`
   jbasename="${jbasename}.debug"
   rm ${jbasename}
   touch ${jbasename}
  
   echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` " | tee -a ${jbasename}
   echo $0 $@ | tee -a ${jbasename}
   echo "Screen display will also be in ${jbasename}" | tee -a ${jbasename}
fi

if [ ! -z "$debug" ] ; then echo "Start,`date +%d-%b-%Y | sed -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`,`date +%H:%M`" ; fi | tee -a ${jbasename}

if [ ! -z "$debug" ] ; then echo $AWK ; fi | tee -a ${jbasename}

### echo "(${jdskcmd}); Remove Later"
# Add in date, time, and host (Will normally be ran from rackdata if available)
echo "MPG,date,`date +%d-%b-%Y | sed -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`" >> ${pnadcp_out} 
echo "MPG,time,`date +%H:%M`" >> ${pnadcp_out} 
echo "MPG,host,${sysname}" >> ${pnadcp_out} 

# Add in Disk Variables used to adjust output
# DskVars,TopBigFile,TopDFCnt,TopDSpc,MinFSz,MinFCnt,MinDSpc
# DskVars,${TopBigFile},${TopDFCnt},${TopDSpc},${MinFSz},${MinFCnt},${MinDSpc}
# Defaults # DskVars,20,20,20,50000000,100,10000
echo "DskVars,TopBigFile,TopDFCnt,TopDSpc,MinFSz,MinFCnt,MinDSpc" >> ${pnadcp_out} 
echo "DskVars,${TopBigFile},${TopDFCnt},${TopDSpc},${MinFSz},${MinFCnt},${MinDSpc}" >> ${pnadcp_out} 

# Counts of system wide sticky bit 4000 perms, 2000 perms, 1000 perms, and
# scripts with sticky bits.
# SWSB,SB4000,SB2000,SB1000,SBScr
echo "SWSB,SB4000,SB2000,SB1000,SBScr" >> ${pnadcp_out} 
# Locate all sticky bit files that are not "directories/modules/empty/character special"
if [ ! -z "$debug" ] ; then echo "StickyBitCheck1,`date +%d-%b-%Y | sed -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`,`date +%H:%M`" ; fi | tee -a ${jbasename}
# The intent is to locate files that are scripts or command files, since this may be a problem on some unix/linux systems. 
SBScr=`find /  -perm -2000 -o -perm -1000  -o -perm -4000  2>/dev/null | xargs file /tmp/helpsystems_tmp/mpgmpg 2>/dev/null | egrep -v "statically|dynamically|directory|module|empty|character special" | tee /tmp/helpsystems_tmp/sticky_scripts.hsllc | wc -l | $AWK '{print $1}'`
# Locate all owner sticky bit files"
if [ ! -z "$debug" ] ; then echo "StickyBitCheck2,`date +%d-%b-%Y | sed -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`,`date +%H:%M`" ; fi | tee -a ${jbasename}
SB4000=`find /  -perm -4000 2>/dev/null | tee /tmp/helpsystems_tmp/sticky_owner.hsllc | wc -l | $AWK '{print $1}'` 
# Locate all group sticky bit files"
if [ ! -z "$debug" ] ; then echo "StickyBitCheck3,`date +%d-%b-%Y | sed -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`,`date +%H:%M`" ; fi | tee -a ${jbasename}
SB2000=`find /  -perm -2000 2>/dev/null | tee /tmp/helpsystems_tmp/sticky_group.hsllc | wc -l | $AWK '{print $1}'`
# Locate all everyone sticky bit files"
if [ ! -z "$debug" ] ; then echo "StickyBitCheck4,`date +%d-%b-%Y | sed -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`,`date +%H:%M`" ; fi | tee -a ${jbasename}
SB1000=`find /  -perm -1000 2>/dev/null | tee /tmp/helpsystems_tmp/sticky_everyone.hsllc | wc -l | $AWK '{print $1}'`
echo "SWSB,${SB4000},${SB2000},${SB1000},${SBScr}" >> ${pnadcp_out} 

### First identify filesystem and mountpoints using system df command ### 
if [ ! -z "$debug" ] ; then echo "DetermineDisks,`date +%d-%b-%Y | sed -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`,`date +%H:%M`" ; fi | tee -a ${jbasename}
echo "DskDF,FSName,FSDev,FSSize,FSUsed,FSMntPoint" >> ${pnadcp_out} 
${jdskcmd} \
  | grep '%' \
  | egrep "/dev/" \
  | egrep -vi "available|free|/dev/fd" \
  | $AWK '{print $1,$1,$2,$3,$NF}' \
  | sed -e 's,^/dev/dsk/,,' \
  | sed -e 's,^/dev/,,' \
  | $AWK '{print "0"$1,$0}' \
  | sed -e 's,^0[a-z][a-z]*,0,' \
  | sort -n \
  | $AWK '{print $2,$3,$4,$5,$6}' > /tmp/helpsystems_tmp/df_k.tmp 
cat /tmp/helpsystems_tmp/df_k.tmp | $AWK '{print "DskDF,"$1","$2","$3","$4","$5}' >> ${pnadcp_out} 
#----------------------------#

### ------------------------------------------------------------------###
### On systems with an uncommonly large number of files/directories   ### 
### or slower disk reads/performance this can take a while with the   ###
### Disk File Counts and Directory File Space enabled.  It should     ###
### be tested manually before turning on the (Disk File Counts) and   ###
### (Directory File Space) in each directory.                         ###
### By default, these two are not incorporated, but may be turned on  ###
### manually with "pnadcp.sh -a" or modify the variable in            ### 
### pnadcp.config (include_dir_scans="T")                             ### 
### ------------------------------------------------------------------###

if [ "x${include_dir_scans}x" = "xTx" ]; then
   ### Use filesystems and mountpoints to find directories and get count ###
   ### of files in each directory and display top 20 counts for each fs. ###
   if [ ! -z "$debug" ] ; then echo "DiskFileCounts,`date +%d-%b-%Y | sed -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`,`date +%H:%M`" ; fi | tee -a ${jbasename}
   echo "DFCnt,FSName,FCnt,DirName" >> ${pnadcp_out} 
   while
   read j_fs j_dev j_size j_used j_mp
   do
      for j_dir in `find ${j_mp} -xdev ! -fstype nfs -type d 2>/dev/null`
      do
         j_cnt=`ls -1 ${j_dir} 2>/dev/null |wc -l |$AWK '{print $1}'`
         echo "DFCnt,${j_fs},${j_cnt},${j_dir}" \
          | $AWK -F, -v minfcnt=${MinFCnt} '{if($3>=minfcnt) print $0}'
      done | sort -t, -nr ${jsortmod} | head -${TopDFCnt}
   done < /tmp/helpsystems_tmp/df_k.tmp >> ${pnadcp_out} 
   #----------------------------#

   ### Use filesystems and mountpoints to find directories and get space     ###
   ### used by files in each directory and display top 20 counts of each fs. ###
   if [ ! -z "$debug" ] ; then echo "DirectorySpace,`date +%d-%b-%Y | sed -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`,`date +%H:%M`" ; fi | tee -a ${jbasename}
   echo "DSpc,FSName,DirSpcK,DirName" >> ${pnadcp_out} 

   while
   read j_fs j_dev j_size j_used j_mp
   do
      for j_dir in `find ${j_mp} -xdev ! -fstype nfs -type d 2>/dev/null`
      do
         j_cnt=`ls -1s ${j_dir} 2>/dev/null | grep "^total" |$AWK '{print $2}'`
         echo "DSpc,${j_fs},${j_cnt},${j_dir}" \
          | $AWK -F, -v mindspc=$MinDSpc '{if($3>=mindspc) print $0}' 
      done | sort -t, -nr ${jsortmod} | head -${TopDSpc}
   done < /tmp/helpsystems_tmp/df_k.tmp >> ${pnadcp_out} 
   #----------------------------#
fi

### Use filesystems and mountpoints to find files over 50 megs in size  ###

### display top 20 files by size.                                       ###
if [ ! -z "$debug" ] ; then echo "LargeFileSize,`date +%d-%b-%Y | sed -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`,`date +%H:%M`" ; fi | tee -a ${jbasename}
echo "BigFile,FSName,KBytes,Perm,Links,Own,Grp,Bytes,M,D,Yr_Time,Path_Name" >> ${pnadcp_out} 

while
read j_fs j_dev j_size j_used j_mp
do
   # The /tmp/helpsystems_tmp/mpgmpg was required for Suse, because the xargs was activating 
   # with no data came to it.
   #
   # Added another sed for tabs and one for double commas that should not happen,
   # but did.
   #
   find ${j_mp}  -xdev -type f -size +${MinFSz}c 2>/dev/null \
    | xargs ls -als /tmp/helpsystems_tmp/mpgmpg 2>/dev/null  \
    | sort -nr  \
    | head -${TopBigFile} \
    | sed -e 's/\	\	*/\,/g' \
    | sed -e 's/\ \ */\,/g' \
    | $AWK -v jfs=$j_fs -v jdev=$j_dev -v jmp=$j_mp '{print "BigFile,"jfs","$0}'
done < /tmp/helpsystems_tmp/df_k.tmp | sed -e 's/\,\,*/\,/g' >> ${pnadcp_out} 
#----------------------------#

echo "MPG,done,`date +%d-%b-%Y | sed -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`,`date +%H:%M`" >> ${pnadcp_out} 

if [ ! -z "$debug" ] ; then echo "Finish,`date +%d-%b-%Y | sed -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`,`date +%H:%M`" ; fi | tee -a ${jbasename}
