#!/bin/ksh
#
# $Id: pn_scripts_info_hsllc.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Used to create information files about all hsllc scripts 
#
# Display the version number that is being ran
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
#
#& Special comment lines used in scripts to allow auto documentaion:
#& #&&     Purpose of script
#& #&@     Other scripts or applications required to run
#& #&      General comment
#& #&%     Special comment Emphasized, Caution or Warning
#

mkdir -p /tmp/helpsystems_tmp
rm -f /tmp/helpsystems_tmp/scripts_info_hsllc

ls -1 * | egrep -v "(^reduce|^nmon(_|m|1|9)|^dmi|^scripts|^source|^R|^N|^L|^H|\,v$|^$)" > /tmp/helpsystems_tmp/pn_scripts_ls

cat <<-jamjam > /tmp/helpsystems_tmp/scripts_info_hsllc.htm
<HTML>
<HEAD> <TITLE>Performance Navigator Scripts Information</TITLE> </HEAD>
<BODY>
<P align=LEFT>

<STRONG><font size="6" color="blue">HelpSystems, LLC.</font><BR>
<BR><font size="5">Performance Navigator Scripts Information (pn_scripts_info_hsllc.sh)</font></STRONG><BR>
<img src="https://pbs.twimg.com/media/Ctic_UuWYAAHPEr.png" width="400" alt="mpglogo">
<BR>
<BR>Select <A HREF= "http://www.fortra.com/pownavlinux.html" >FREE Performance Navigator Data Consolidator</A> to obtain the most recent copy.</A>
<BR>Select <A HREF= "ftp://anonymous@96.69.172.229/powernav.tar.gz" >ftp powernav.tar.gz file</A> to obtain the most recent copy.</A>
<BR>Select <A HREF= "ftp://anonymous@96.69.172.229" >ftp from fortra.com</A> to obtain the most recent copy of other scripts, applications or documents.</A>
<P><STRONG>Performance Navigator Support </STRONG><BR>
<A HREF= "http://www.fortra.com/" >http://www.fortra.com</A><BR>
<BR>Email: <A HREF="mailto:support.mpginc@helpsystems.com">support.mpginc@helpsystems.com</A> <BR>

<HR>
<TABLE BORDER=".1">
<TR>
<TD VALIGN="TOP">
<BR><STRONG>Go to information specifically for: </STRONG>
<BR><multicol cols=4>
jamjam

cat /tmp/helpsystems_tmp/pn_scripts_ls \
   |awk '{print "<A HREF=\"#"$0"\">"$0"</A><br>"}' >> /tmp/helpsystems_tmp/scripts_info_hsllc.htm 

echo '</multicol>' >> /tmp/helpsystems_tmp/scripts_info_hsllc.htm 


jcnt=0
while
read file
do
   print -n "."
   (( jcnt=$jcnt+1 ))
   if [ jcnt -eq 50 ]
   then
      # On each 50 scripts there will be a line break
      (( jcnt=0 ))
      print "" 
   fi
   # These provide the text file 
   echo "----File Name----"  >> /tmp/helpsystems_tmp/scripts_info_hsllc
   echo "@@ ${file}"  >> /tmp/helpsystems_tmp/scripts_info_hsllc
   echo "--Revision Info--"  >> /tmp/helpsystems_tmp/scripts_info_hsllc
   grep "\$\I\d"  $file  >> /tmp/helpsystems_tmp/scripts_info_hsllc
   echo "----Required-----"  >> /tmp/helpsystems_tmp/scripts_info_hsllc
   egrep "(::\ |^|^\ *)\#\&\@"  $file  >> /tmp/helpsystems_tmp/scripts_info_hsllc
   echo "--Mail Comments--"  >> /tmp/helpsystems_tmp/scripts_info_hsllc
   egrep "(^::\ ^|^\ *)(\#\&)"  $file  >> /tmp/helpsystems_tmp/scripts_info_hsllc
   echo ""  >> /tmp/helpsystems_tmp/scripts_info_hsllc
   echo ""  >> /tmp/helpsystems_tmp/scripts_info_hsllc
   echo ""  >> /tmp/helpsystems_tmp/scripts_info_hsllc
   
   # These provide the html doc 
   egrep "(^::\ *|^\ *)(\#\&)" $file > /tmp/helpsystems_tmp/scripts_info_hsllc_tmp
   echo "<TR>" >> /tmp/helpsystems_tmp/scripts_info_hsllc.htm
   echo "<TD VALIGN=\"TOP\">" >> /tmp/helpsystems_tmp/scripts_info_hsllc.htm
   echo "<P>" >> /tmp/helpsystems_tmp/scripts_info_hsllc.htm
   echo "<BR><STRONG><A NAME=\"${file}\"><font color=\"#009000\">${file}</font></A></STRONG>" >> /tmp/helpsystems_tmp/scripts_info_hsllc.htm

   # Add lines for script purpose or redline if missing
   egrep "(^::\ |^|^\ *)\#\&\&" /tmp/helpsystems_tmp/scripts_info_hsllc_tmp | awk '{print "<BR><STRONG>"substr($0,5)"</STRONG>"}'  > /tmp/helpsystems_tmp/scripts_info_hsllc_tmp2
   if [ -s /tmp/helpsystems_tmp/scripts_info_hsllc_tmp2 ]
   then
      cat /tmp/helpsystems_tmp/scripts_info_hsllc_tmp2 >>  /tmp/helpsystems_tmp/scripts_info_hsllc.htm
   else
      echo "<BR><STRONG><font color=\"#ff0000\">No Purpose Provided</font></STRONG>" >> /tmp/helpsystems_tmp/scripts_info_hsllc.htm
   fi

   # Add lines for special comments if necessary
   egrep "(^::\ |^|^\ *)\#\&\%" /tmp/helpsystems_tmp/scripts_info_hsllc_tmp | awk '{print "<BR><STRONG><font color=purple>"substr($0,5)"</font></STRONG>"}'  > /tmp/helpsystems_tmp/scripts_info_hsllc_tmp2
   if [ -s /tmp/helpsystems_tmp/scripts_info_hsllc_tmp2 ]
   then
      cat /tmp/helpsystems_tmp/scripts_info_hsllc_tmp2 >>  /tmp/helpsystems_tmp/scripts_info_hsllc.htm
   fi

   # Add lines for required files if necessary
   egrep "(^::\ |^|^\ *)\#\&\@" /tmp/helpsystems_tmp/scripts_info_hsllc_tmp | awk '{print "<BR><STRONG><font color=blue>"substr($0,5)"</font></STRONG>"}'  > /tmp/helpsystems_tmp/scripts_info_hsllc_tmp2
   if [ -s /tmp/helpsystems_tmp/scripts_info_hsllc_tmp2 ]
   then
      cat /tmp/helpsystems_tmp/scripts_info_hsllc_tmp2 >>  /tmp/helpsystems_tmp/scripts_info_hsllc.htm
   fi

      # Jack test
   # Add all comment lines or redline if missing
   egrep "(^::\ |^|^\ *)(\#\&|&)(\ |$)" /tmp/helpsystems_tmp/scripts_info_hsllc_tmp | awk '{print "<BR>"substr($0,3)""}'  > /tmp/helpsystems_tmp/scripts_info_hsllc_tmp2
   if [ -s /tmp/helpsystems_tmp/scripts_info_hsllc_tmp2 ]
   then
      cat /tmp/helpsystems_tmp/scripts_info_hsllc_tmp2  >>  /tmp/helpsystems_tmp/scripts_info_hsllc.htm
   else
      echo "<BR><STRONG><font color=\"#ff0000\">No Regular Comments. There must be at least one (#&) </font></STRONG>" >> /tmp/helpsystems_tmp/scripts_info_hsllc.htm
   fi

done < /tmp/helpsystems_tmp/pn_scripts_ls

print "" 

cat <<-jamjam >> /tmp/helpsystems_tmp/scripts_info_hsllc.htm
</TABLE>
<HR>
</UL> 
<P><STRONG>Performance Navigator Support </STRONG><BR>
<A HREF= "http://www.fortra.com/" >http://www.fortra.com</A><BR>
For quick support, click here or e-mail <BR>
Email: <A HREF="mailto:=support.mpginc@helpsystems.com">support.mpginc@helpsystems.com</A><BR>
Email2: <A HREF="mailto:=randy.watson@helpsystems.com">randy.watson@helpsystems.com</A><BR>
To Contact Fortra, LLC. (HelpSystems|MPG): <BR>
100 Arapahoe Ave., Suite 14, Boulder, CO 80302 <BR>
Voice 1 800-328-1000 or email jack.miller@helpsystems.com or randy.watson@helpsystems.com <BR>
--------------- <BR>
For international calls, 1 952-933-0609 <BR>
--------------- <BR>
<P><font size="-1">HelpSystems, LLC.&copy; <a
href= "http://www.mpginc.com" >Fortra, LLC.</a> All rights
reserved.<br></FONT>
</BODY>
</HTML>
jamjam

chmod 644 /tmp/helpsystems_tmp/scripts_info_hsllc /tmp/helpsystems_tmp/scripts_info_hsllc.htm

echo "All script information in text form is in /tmp/helpsystems_tmp/scripts_info_hsllc"
echo "All script information in html form is in /tmp/helpsystems_tmp/scripts_info_hsllc.htm"

#& =-=-=-=-=-=-=-=-=-=-=-=-=
#& Sample Run  
#& =-=-=-=-=-=-=-=-=-=-=-=-=
#& > pn_scripts_info_hsllc.sh
#& Running pn_scripts_info_hsllc.sh
#& ..................................................
#& ..........................
#& All script information in text form is in /tmp/helpsystems_tmp/scripts_info_hsllc
#& All script information in html form is in /tmp/helpsystems_tmp/scripts_info_hsllc.htm
