#!/bin/ksh
#!/bin/ksh -xv
#
# $Id: pn_chart_topas_files.sh,v 1.1 2023/03/27 16:07:05 root Exp $#
#
#&& Takes the current topas files from the /tmp/helpsystems_tmp/mpgdata_topas directory and 
#&& runs topaschart on each of them. (Including the most recent data.)
#&
#
#&@ topaschart required on path 
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#

echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "

mkdir -p /tmp/helpsystems_tmp

if [ -d /tmp/pn_chart_topas_files ]; then rm -rf /tmp/pn_chart_topas_files; fi # helpsystems 

if [ -s /tmp/mpgdata_topas_rocky.tar.gz ]; then rm -f /tmp/mpgdata_topas_rocky.tar.gz; fi  # helpsystems

japptest="topaschart"
okapp=""
jappavail=`$japptest 2>&1 > /dev/null`
jtest=`echo $?`
# echo $jtest
# If not on path see if available on current path.
if [ $jtest -eq 0 ]; then
   okapp=$japptest
else
   jappavail=`./$japptest 2>&1 > /dev/null`
   jtest=`echo $?`
   # echo $jtest
   if [ $jtest -eq 0 ]; then
      okapp="./$japptest"
   fi
fi
# echo $okapp
if [ "x${okapp}x" != "xx" ]; then
   echo "Using ($okapp)"
else
   echo "Unable to find ($japptest) exiting"
   exit 1
fi

dateformat=`date '+%d-%b-%C%y'`
jdate=`date +%Y%m%d_%H%M`

get_topas_data_proc () {
   # Begin of get_topas_data_proc used in get_topas_data.sh and "rackdata.sh -T"
   jscript_name=`basename $0`
   if [ "xTx" = "x${get_topas_data}x" ] ; then
      # This is a where new get_topas_data.sh to rackdata.sh starts 
      jdate=`date '+%Y%m%d_%H%M'`
      jsysname=`uname -n | awk -F. '{print $1}'`
   
      # Try to find out where the data for topasrec is currently if running.
      topasrec_dir=`ps -ef | egrep "\/topasrec" | grep -v "egrep" | sed s,^..*\-o\ ,, | awk '{print $1}'`
      # echo "Remove later 1"; topasrec_dir=""
      
      if [ "xx" == "x${topasrec_dir}x" ]; then
         # Try to find out where the data may have been if not running.
         echo "Found topasrec is NOT currently running!"
         topasrec_dir=`grep "\/topasrec" /etc/inittab | grep -v "egrep" | sed s,^..*\-o\ ,, | awk '{print $1}'`
      # echo "Remove later 2"; topasrec_dir="" 
         if [ "xx" != "x${topasrec_dir}x" ]; then
            echo "Found topasrec had been running periodically in directory "
            echo "(${topasrec_dir}) previously"
   else
      for jjdir in /var/perf/daily/  /etc/perf/daily/  /home/ios/perf/topas/
      do
	 topasrec_dir=${jjdir}
	 if [ -d ${topasrec_dir} ] ; then
            echo "topasrec is not running but may have been previously in directory"
            echo "(${topasrec_dir})"
	    break
	 else
	    topasrec_dir=""
	 fi
      done
         fi
      else
         echo "Found topasrec is running periodically in directory"
         echo "(${topasrec_dir})"
         # If rackdata.sh is running, copy rackdata.hostname to /tmp//helpsystems_tmp/pn_chart_topas_files 
         if [ "x${jscript_name}x" = "xrackdata.shx" ] || [ -s rackdata.${jsysname} ] ; then
            cp rackdata.${jsysname} /tmp/helpsystems_tmp/pn_chart_topas_files 
         fi
      fi

      # Check the status of topasrec
      rm -f /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo 'ps -ef | grep "\/topasrec"' >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      ps -ef | grep "\/topasrec" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo 'grep "\/topasrec" /etc/inittab' >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      grep "\/topasrec" /etc/inittab >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo 'crontab -l | grep "\/pmcfg"' >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      crontab -l | grep "\/pmcfg" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      echo "" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      # Keep from running if not on  AIX systems with daily topas files #
      if [ ! -d ${topasrec_dir} ] ; then
         echo "### This can only be used on AIX systems with topas!! ### " 
         echo "### This can only be used on AIX systems with topas!! ### " >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
         exit 1
      else
         echo "Identified a directory for topas"
      fi
      # cat /tmp/helpsystems_tmp/topasrec_status.${jsysname}
      # End of Check the status of topasrec
   
      echo "# Gathering topas data!"
      mkdir -p /tmp/helpsystems_tmp/mpgdata_topas
      chmod 775 /tmp/helpsystems_tmp/mpgdata_topas
      ## tar -cvf /tmp/helpsystems_tmp/mpgdata_topas/mpgTSinfo_${jsysname}.tar pn.config pnadcp.config pnedcp.config *.mpg *.hsllc *.info 2> /dev/null  > /dev/null
      cd /tmp/helpsystems_tmp/mpgdata_topas
      rm -f /tmp/helpsystems_tmp/mpgdata_topas/*.csv
      rm -f /tmp/helpsystems_tmp/mpgdata_topas.${jsysname}
      # for jfile in `ls -1tr /etc/perf/daily/${jsysname}*topas`
      # Add check for topas files in the topas directory.
      ls -1tr ${topasrec_dir}${jsysname}*topas 2>/dev/null > /tmp/helpsystems_tmp/ls-1tr_test.tmp
      if [ -s /tmp/helpsystems_tmp/ls-1tr_test.tmp ]; then
         echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
         echo 'cat /tmp/helpsystems_tmp/ls-1tr_test.tmp' >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
         echo "# ------------------------- #" >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
         cat /tmp/helpsystems_tmp/ls-1tr_test.tmp >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
         rm -f /tmp/helpsystems_tmp/ls-1tr_test.tmp
      else
         echo "# There are no topas files to process "
         echo "# There are no topas files to process " >> /tmp/helpsystems_tmp/topasrec_status.${jsysname}
         exit
      fi

      for jfile in `ls -1tr ${topasrec_dir}${jsysname}*topas`
      do
         # Option that allows nmon type output
         topasout -a ${jfile}
         touch -r ${jfile} ${jfile}.csv # Allows for original timestamp
         echo  "# mpgdata_topas ${jfile}.csv " >> /tmp/helpsystems_tmp/mpgdata2_topas.${jsysname}
         grep ^AAA,  ${jfile}.csv >> /tmp/helpsystems_tmp/mpgdata2_topas.${jsysname}
         grep -v ^AAA,  ${jfile}.csv >> /tmp/helpsystems_tmp/mpgdata2_topas.${jsysname}
      done
      mv ${topasrec_dir}${jsysname}*csv .
      cd /tmp/helpsystems_tmp
      # If proc is used in rackdata.sh use first half else get_topas_data.sh 
      # Next line is for rackdata.sh 
         ## tar cvf /tmp/helpsystems_tmp/mpgdata_topas_${jsysname}_${jdate}.tar mpgdata_topas mpgdata_topas.${jsysname} topasrec_status.${jsysname}
         tar cvf /tmp/helpsystems_tmp/mpgdata_topas_${jsysname}.tar mpgdata_topas topasrec_status.${jsysname} > /dev/null
         ## ls -al /tmp/helpsystems_tmp/mpgdata_topas_${jsysname}.tar mpgdata_topas mpgdata_topas.${jsysname} topasrec_status.${jsysname}
         gzip  -f /tmp/helpsystems_tmp/mpgdata_topas_${jsysname}.tar  > /dev/null
         ## echo "Please send  /tmp/helpsystems_tmp/mpgdata_topas_${jsysname}.tar.gz "
   
      # This is a new get_topas_data
   fi
   # End of get_topas_data_proc
}



build_html () { 
   html_file=${1}
   html_host=${2}
   rm -f ${html_file}.html
   # echo "Building html file (${html_file})"
   echo '<HTML>' > ${html_file}.html
   echo '<HEAD> <TITLE>topaschart</TITLE> </HEAD>' >> ${html_file}.html
   echo '<BODY>' >> ${html_file}.html
   echo '<P align=LEFT>' >> ${html_file}.html
   echo '<STRONG><font size="6" color="blue">HelpSystems, LLC.</font><BR>' >> ${html_file}.html
   echo "<BR><font size=\"5\">${html_host} topaschart files created by pn_chart_topas_files.sh</font></STRONG><BR>" >> ${html_file}.html
   echo '<img src="https://pbs.twimg.com/media/Ctic_UuWYAAHPEr.png" width="400" alt="HelpSystemsLogo">' >> ${html_file}.html
   echo '<BR>Select <A HREF= "http://nmon.sourceforge.net/pmwiki.php?n=Main.HomePage" >Info on nmon</A>' >> ${html_file}.html
   echo '<BR>Select <A HREF= "http://nmon.sourceforge.net/pmwiki.php?n=Site.Nmonchart" >Info on nmonchart</A>' >> ${html_file}.html
   echo '<BR>Select <A HREF= "http://nmon.sourceforge.net/pmwiki.php?n=Site.TOPASchart" >Info on topaschart</A>' >> ${html_file}.html
   echo '' >> ${html_file}.html
   echo '' >> ${html_file}.html
   echo '<BR>Select <A HREF= "http://www.fortra.com/pownavlinux.html" >FREE Performance Navigator Data Consolidator</A> to obtain the most recent copy.</A>' >> ${html_file}.html
   echo '<P><STRONG>Performance Navigator Support </STRONG><BR>' >> ${html_file}.html
   echo '<A HREF= "http://www.fortra.com/" >Performance Navigator</A><BR>' >> ${html_file}.html
   echo '<BR>Email: <A HREF="mailto:support.mpginc@helpsystems.com">support.mpginc@helpsystems.com</A> <BR><BR>' >> ${html_file}.html
   echo '' >> ${html_file}.html
   echo '' >> ${html_file}.html

   for jfile in `ls -1 *topas.csv`
   do
      echo "<A HREF= \"${jfile}.html\" >${jfile}</A><BR>" >> ${html_file}.html
   done

   echo '' >> ${html_file}.html
   echo '</BODY>' >> ${html_file}.html
   echo '</HTML>' >> ${html_file}.html
   # End of build_html 
}

chartdir="/tmp/helpsystems_tmp/pn_chart_topas_files"
. /etc/pn.conf

echo "Creating topascharts for (/tmp/helpsystems_tmp/mpgdata_topas) into (${chartdir})"

get_topas_data="T" # Required to get get_topas_data_proc to run

get_topas_data_proc

cd /tmp/helpsystems_tmp/mpgdata_topas
mkdir -p ${chartdir} 
chmod 775 ${chartdir} 
rm -f ${chartdir}/*topas.csv ${chartdir}/*tchart.html 
cp -p *topas.csv ${chartdir} 

cd ${chartdir} 
# rm -f mpg_2*nmon* *mpg_2*nmon*html 
# gunzip -f mpg_2*nmon.gz

for jfile in `ls -1 *topas.csv`
do
   jhost=`grep ,host, ${jfile} | awk -F, '{print $3}'`
   $okapp ${jfile} ${jfile}.html 
   touch -r ${jfile} ${jfile}.html # Allows for original timestamp
done

build_html helpsys_${jhost}_tchart ${jhost}
chmod 644 *html
cp /tmp/helpsystems_tmp/mpgdata_topas_${jsysname}.tar.gz .
tar -cvf - *html rackdata.${jsysname} mpgdata_topas_${jsysname}.tar.gz | gzip -c  > ${chartdir}/helpsys_${jhost}_tchart.tar.gz 
echo "All the charts are in (${chartdir}/helpsys_${jhost}_tchart.tar.gz)"
#&
#& Running pn_chart_topas_files.sh,v #.# YYYY/MM/DD hh:mm:ss
#& Creating topascharts for (/tmp/helpsystems_tmp/mpgdata_topas)into(/tmp/helpsystems_tmp/pn_chart_topas_files)
#& Found topasrec is running periodically in directory
#& (/etc/perf/daily/)
#& Identified a directory for topas
#& # Gathering topas data!
#& a hostname_160414.topas.csv.html 700 blocks.
#& a hostname_160415.topas.csv.html 700 blocks.
#& a hostname_160416.topas.csv.html 700 blocks.
#& a hostname_160417.topas.csv.html 700 blocks.
#& a hostname_160418.topas.csv.html 700 blocks.
#& a hostname_160419.topas.csv.html 700 blocks.
#& a hostname_160420.topas.csv.html 399 blocks.
#& a helpsys_hostname_tchart.html 4 blocks.
#& a mpgdata_topas_hostname.tar.gz 1263 blocks.
#& All the charts are in (/tmp/helpsystems_tmp/pn_chart_topas_files/helpsys_hostname_tchart.tar.gz)
#&
