#!/bin/ksh
#
# $Id: pn_chart_nmon_files.sh,v 1.1 2023/03/27 16:07:05 root Exp $#
#
#&& Takes the current nmon files from the mpg directory and runs nmonchart
#&& on each of them. (Including the most recent data.)
#&
#&@ nmonchart required on path
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "

mkdir -p /tmp/helpsystems_tmp

rm -f /tmp/pn_chart_files.tmp /tmp/pn_chart_nmon_files.last.hsllc /tmp/pn_chart_nmon_files.today.hsllc /tmp/pn_chart_nmon_files.diff.hsllc # helpsystems 

japptest="nmonchart"
okapp=""
jappavail=`$japptest 2>&1 > /dev/null`
jtest=`echo $?`
# echo $jtest
# If not on path see if available on current path.
if [ $jtest -eq 0 ]; then
   okapp=$japptest
else
   jappavail=`./$japptest 2>&1 > /dev/null`
   jtest=`echo $?`
   # echo $jtest
   if [ $jtest -eq 0 ]; then
      okapp="$PWD/$japptest"
   fi
fi
# echo $okapp
if [ "x${okapp}x" != "xx" ]; then
   echo "Using ($okapp)"
else
   echo "Unable to find ($japptest) exiting"
   exit 1
fi

build_html () { 
html_file=${1}
html_host=${2}
html_proc=${3}
rm -f ${html_file}.html
# echo "Building html file (${html_file})"
echo '<HTML>' > ${html_file}.html
echo '<HEAD> <TITLE>nmonchart</TITLE> </HEAD>' >> ${html_file}.html
echo '<BODY>' >> ${html_file}.html
echo '<P align=LEFT>' >> ${html_file}.html
echo '<STRONG><font size="6" color="blue">HelpSystems, LLC.</font><BR>' >> ${html_file}.html
echo "<BR><font size=\"5\">${html_host} (${html_proc}) nmonchart files created by pn_chart_nmon_files.sh</font></STRONG><BR>" >> ${html_file}.html
echo '<img src="https://pbs.twimg.com/media/Ctic_UuWYAAHPEr.png" width="400" alt="hslogo">' >> ${html_file}.html
echo '<BR>Select <A HREF= "http://nmon.sourceforge.net/pmwiki.php?n=Main.HomePage" >Info on nmon</A>' >> ${html_file}.html
echo '<BR>Select <A HREF= "http://nmon.sourceforge.net/pmwiki.php?n=Site.Nmonchart" >Info on nmonchart</A>' >> ${html_file}.html
echo '<BR>Select <A HREF= "http://nmon.sourceforge.net/pmwiki.php?n=Site.TOPASchart" >Info on topaschart</A>' >> ${html_file}.html
echo '' >> ${html_file}.html
echo '' >> ${html_file}.html
echo '<BR>Select <A HREF= "http://www.fortra.com/pownavlinux.html" >FREE Performance Navigator Data Consolidator</A> to obtain the most recent copy.</A>' >> ${html_file}.html
echo '<P><STRONG>Performance Navigator Support </STRONG><BR>' >> ${html_file}.html
echo '<A HREF= "https://www.fortra.com/products/capacity-planning-and-performance-analysis-software" >Performance Navigator</A><BR>' >> ${html_file}.html
echo '<BR>Email: <A HREF="mailto:support.mpginc@helpsystems.com">support.mpginc@helpsystems.com</A> <BR><BR>' >> ${html_file}.html
echo '' >> ${html_file}.html
echo '' >> ${html_file}.html

for jfile in `ls -1 *.nmon`
do
   echo "<A HREF= \"${html_host}_${jfile}.html\" >${jfile}</A><BR>" >> ${html_file}.html
done


##  

echo '' >> ${html_file}.html
echo '</BODY>' >> ${html_file}.html
echo '</HTML>' >> ${html_file}.html

}

chartdir="/tmp/pn_chart_nmon_files" # helpsystems
. /etc/pn.conf
echo "Creating nmoncharts for (${nminst}) into (${chartdir})"
cd ${nminst}
echo ${nminst}
jproc=`grep "Processor Type" rackdata.\`hostname\` | awk '{print $NF}'`
echo "jproc (${jproc})"
mkdir -p ${chartdir} 
chmod 775 ${chartdir} 
rm -f ${chartdir}/mpg_2*.nmon*  ${chartdir}/*nmon.html 
cp -p mpg_2*nmon* ${chartdir} 
cd ${chartdir} 

find . -name mpg_2\*nmon.gz > /tmp/helpsystems_tmp/pn_chart_nmon_files.hsllc.tmp
if [ -s /tmp/helpsystems_tmp/pn_chart_nmon_files.hsllc.tmp ]; then
   gunzip -f mpg_2*nmon.gz
else
   echo "There are no mpg_2*nmon.gz to gunzip"
fi

# echo "Remove later"
# ls -1 mpg_2*.nmon
# echo "Remove later"

find . -name mpg_2\*nmon > /tmp/helpsystems_tmp/pn_chart_nmon_files.hsllc.tmp
if [ -s /tmp/helpsystems_tmp/pn_chart_nmon_files.hsllc.tmp ]; then
   for jfile in `ls -1 mpg_2*.nmon`
   do
      jhost=`grep ,host, ${jfile} | awk -F, '{print $3}' | head -1 `
      $okapp ${jfile} ${jhost}_${jfile}.html 
   done
else
   echo "There are no mpg_2*nmon files." 
   echo "On a new install, this may be normal" 
   exit
fi
build_html helpsys_${jhost}_nchart ${jhost} ${jproc} 

chmod 644 *html

tar cf - mpg_*nmon | gzip -c > ${jhost}_orig_nm_files.tar.gz

tar -cf - *html ${jhost}_orig_nm_files.tar.gz | gzip -c  > helpsys_${jhost}_nchart.tar.gz

# These files are generated by rackdata.sh
# rm -f /tmp/pn_chart_nmon_files.last.hsllc /tmp/pn_chart_nmon_files.diff.hsllc # helpsystems

rm -f /tmp/pn_chart_nmon_files.hsllc.tmp # helpsystems 

# rm -f *mpg_2*nmon*html rm -f *mpg_2*nmon 

echo "All the charts are in (${chartdir}/helpsys_${jhost}_nchart.tar.gz)"
#
#&
#& Running pn_chart_nmon_files.sh,v #.# YYYY/MM/DD hh:mm:ss
#& Creating nmoncharts for (/usr/local/mpg) into (/tmp/pn_chart_nmon_files) # helpsystems
#& /usr/local/mpg
#& a hostname_mpg_20160413.nmon.html 786 blocks.
#& a hostname_mpg_20160414.nmon.html 786 blocks.
#& a hostname_mpg_20160415.nmon.html 786 blocks.
#& a hostname_mpg_20160416.nmon.html 784 blocks.
#& a hostname_mpg_20160417.nmon.html 786 blocks.
#& a hostname_mpg_20160418.nmon.html 786 blocks.
#& a hostname_mpg_20160419.nmon.html 786 blocks.
#& a hostname_mpg_20160420.nmon.html 462 blocks.
#& a mpg_hostname_nchart.html 4 blocks.
#& All the charts are in (/tmp/pn_chart_nmon_files/helpsys_hostname_nchart.tar.gz) # helpsystems
#&
