#!/bin/ksh
#!/bin/ksh -xv
#
# $Id: nmondetail.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& This will increase nmon detail every minute and collect top data until
#&& midnight and return to settings within ps.config 
#
#& Intended as an aid to troubleshooting a problem that is occuring now. 
#& Saves existing configuration
#& copies pn.config to pn.config_nmondetailb4
#& 
#& Stops nmon sets the timing to one minute intervals  
#&            sets nmon opts to "-t -I 0.02"
#&            sets external data collection to "T"
#& Starts nmon with new parameters.
#& Returns configuration to original_configuration and 5 minute snaps at 2400 
#
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
#
# Read nminst install directory
. /etc/pn.conf
. ${nminst}/pn.config
cd ${nminst}
cp ${nminst}/pn.config ${nminst}/pn.config_nmondetailb4
./change_pn.sh -O "-t -I 0.02" -e "T"
# at midnight return configuration pn.config_nmondetailb4 to pn.config
echo "cp ${nminst}/pn.config_nmondetailb4 ${nminst}/pn.config" | at midnight
# stop nmon
./killnmon 
# start nmon with 1 minute snaps
./start_nmon_now -m 1 -q -f 


