#!/bin/ksh
#
# $Id: nmchart_nmon_files.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Creates nmonchart html files out of nmon files in directory
#
#& All nmon files must have (.nmon) extension. 
#

mkdir -p /tmp/helpsystems_tmp

echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "

jdate=`date '+%Y%m%d_%H%M'`

rm -f /tmp/helpsystems_tmp/nmon_file_info_list.tmp

for jnmfile in *.nmon
do
   jorig_filename="$jnmfile"

   # You must specify a filename
   if [ "x" = "x${jorig_filename}" ] ; then
      echo "You must specify a mpgdata2 file to split."; exit 1
   fi

   # The filename must exist
   if [ ! -s ${jorig_filename} ] ; then
      echo "The filename (${jorig_filename}) is empty or does not exist."; exit 1
   fi

   # All split out files will go into splits

   # Create file  /tmp/helpsystems_tmp/nmon_file_info_list.tmp of details to create individual nmonfiles.
   # Change 3 chacter month on dates to 2 digit number 
   cat $jorig_filename \
      | sed s,-JAN-,-01-, \
      | sed s,-FEB-,-02-, \
      | sed s,-MAR-,-03-, \
      | sed s,-APR-,-04-, \
      | sed s,-MAY-,-05-, \
      | sed s,-JUN-,-06-, \
      | sed s,-JUL-,-07-, \
      | sed s,-AUG-,-08-, \
      | sed s,-SEP-,-09-, \
      | sed s,-OCT-,-10-, \
      | sed s,-NOV-,-11-, \
      | sed s,-DEC-,-12-, \
      | sed s,-,,g \
      | sed s,:,,g \
      | awk -v jnmf=$jnmfile -F, '{
   {if($2 == "progname" && NR != 1 ) {
      jbegin = NR;
      print jnmf, jhost, jyear, jmonth, jday, jtime, jhost "_" jyear jmonth jday "_" jtime 
   }}
   {if($2 == "progname" ) {
      jbegin = NR
   }}
   # Test
   {if($2 == "host") jhost = $3}
   {if($2 == "time") jtime = substr($3,1,4)}
   {if($2 == "date") jdate = $3;
      jyear = substr(jdate,5,8);
      jmonth = substr(jdate,3,2);
      jday = substr(jdate,1,2) ;
      jbeginlast = jbegin }
   }
END {{print jnmf, jhost, jyear, jmonth, jday, jtime, jhost "_" jyear jmonth jday "_" jtime }
}' >> /tmp/helpsystems_tmp/nmon_file_info_list.tmp

done

jfcnt=`cat /tmp/helpsystems_tmp/nmon_file_info_list.tmp | wc -l | awk '{print $1}'`
jhcnt=`cat /tmp/helpsystems_tmp/nmon_file_info_list.tmp | awk '{print $2}' | sort | uniq | wc -l | awk '{print $1}'`
echo "Processing (${jfcnt}) nmon files for (${jhcnt}) hosts."


# exit

build_html () { 
   html_file=${1}
   html_host=${2}
   rm -f ${html_file}.html
   # echo "Building html file (${html_file})"
   echo '<HTML>' > ${html_file}.html
   echo '<HEAD> <TITLE>nmonchart_files</TITLE> </HEAD>' >> ${html_file}.html
   echo '<BODY>' >> ${html_file}.html
   echo '<P align=LEFT>' >> ${html_file}.html
   echo '<STRONG><font size="6" color="blue">Fortra, LLC.</font><BR>' >> ${html_file}.html
   echo "<BR><font size=\"5\">${html_host} nmonchart files created by (nmchart_nmon_files.sh)</font></STRONG><BR>" >> ${html_file}.html
   echo '<img src="http://www.fortra.com/images/CirclesSignMar2016.jpg" width="400" alt="mpglogo">' >> ${html_file}.html
   echo '<BR>Select <A HREF= "http://nmon.sourceforge.net/pmwiki.php?n=Main.HomePage" >Info on nmon</A>' >> ${html_file}.html
   echo '<BR>Select <A HREF= "http://nmon.sourceforge.net/pmwiki.php?n=Site.Nmonchart" >Info on nmonchart</A>' >> ${html_file}.html
   echo '<BR>Select <A HREF= "http://nmon.sourceforge.net/pmwiki.php?n=Site.TOPASchart" >Info on topaschart</A>' >> ${html_file}.html
   echo '' >> ${html_file}.html
   echo '' >> ${html_file}.html
   echo '<BR>Select <A HREF= "http://www.fortra.com/pownavlinux.html" >FREE Performance Navigator Data Consolidator</A> to obtain the most recent copy.</A>' >> ${html_file}.html
   echo '<BR>Select <A HREF= "ftp://anonymous@96.69.172.229/powernav.tar.gz" >ftp powernav.tar.gz file</A> to obtain the most recent copy.</A>' >> ${html_file}.html
   echo '<BR>Select <A HREF= "ftp://anonymous@96.69.172.229" >ftp from fortra.com</A> to obtain the most recent copy of other scripts, applications or documents.</A>' >> ${html_file}.html
   echo '<P><STRONG>Performance Navigator Support </STRONG><BR>' >> ${html_file}.html
   echo '<A HREF= "http://www.fortra.com/" >http://www.fortra.com</A><BR>' >> ${html_file}.html
   echo '<BR>Email: <A HREF="mailto:support.mpginc@helpsystems.com">support.mpginc@helpsystems.com</A> <BR><BR>' >> ${html_file}.html
   echo '' >> ${html_file}.html
   echo '' >> ${html_file}.html

   # for jfile in `ls -1 *.nmon`
   # do
   #    echo "<A HREF= \"${jfile}.html\" >${jfile}</A><BR>" >> ${html_file}.html
   # done


   jhostlast="NotUsed"

   while
   read jnmfname jhostname jy jm jd jt jhostdate
   do
       nmonchart ${jnmfname} ${jnmfname}.html
       if [ "${jhostname}" != "${jhostlast}" ]; then
          echo '<A> = = = = = = = = = = = = = = = = = = = = = = = = </A><BR>' >> ${html_file}.html
       fi 
       echo "<A HREF= \"${jnmfname}.html\" >(${jnmfname}) == ${jhostdate}</A><BR>" >> ${html_file}.html
       jhostlast="${jhostname}"
   done < /tmp/helpsystems_tmp/nmon_file_info_list.tmp

   echo '' >> ${html_file}.html
   echo '</BODY>' >> ${html_file}.html
   echo '</HTML>' >> ${html_file}.html
   # End of build_html 
}

build_html mpg_nmonchart_${jdate} various

tar cvf /tmp/helpsystems_tmp/nmchart_nmon_files_${jdate}.tar *html 2>&1 > /dev/null 
gzip /tmp/helpsystems_tmp/nmchart_nmon_files_${jdate}.tar 
echo "Send /tmp/helpsystems_tmp/nmchart_nmon_files_${jdate}.tar.gz to Fortra, LLC. (HelpSystems|MPG) Support!"

#& ##############
#& Sample Run
#& ##############
#& nmchart_nmon_files.sh
#& Running nmchart_nmon_files.sh,v #.# YYYY/MM/DD hh:mm:ss
#& Processing (###) files for (##) hosts.
#& Send /tmp/helpsystems_tmp/nmchart_nmon_files_YYYYMMDD_hhmm.tar.gz to Fortra, LLC. (HelpSystems|MPG) Support!


