#!/bin/ksh
#!/bin/ksh -xv
#
# $Id: mpgd2_arcgztrim.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#& Trims mpgdata2.hostname_archive.tar.gz if it has more than 
#& remove_old_arc_data lines.
#& 
#&& mpgdata2.hostname_archive.tar.gz must exist.
#&& mpgdata2.hostname_archive.tar.gz more records than remove_old_arc_data?
#&& Is there enough space to create the new mpgdata2.hostname_archive.tar.gz?
#
#&@ gunzip
#&@ sysname needs to come from pn.config or "-s name" option 
#
#&% 
#&% Will be ran monthly when pndchk.sh runs 
#&% Trim will happen automatically without prompting. 
#
#


invocdir=`dirname $0`

if [ -s $invocdir/pn.config ] ; then
   . $invocdir/pn.config
else
   echo "pn.config file does not exist at `pwd`"
fi

function usage {
echo "usage: $0 [options]
  where options may be any of:
        -a Automatically replace new file over old file [ -a ]
        -s Specify system name (sysname=opt_sysname) [ -s name ]
        -r Specify number of days to retain of archive [ -r # ]
           (remove_old_arc_data=opt_remove_old_arc_data)
        -h Display options [ -h ]
"
}

# The colon (:) is how you indicate and option is required.
while getopts "ahs:r:" opt ; do
   case $opt in
        a)      autoreplace="T" ;;
        s)      opt_sysname=$OPTARG ;;
        r)      opt_remove_old_arc_data=$OPTARG ;;
        h)      usage;  exit ;;
        ?)      usage;  exit ;;
   esac
done

if [ ! -z "$opt_remove_old_arc_data" ] ; then remove_old_arc_data=$opt_remove_old_arc_data; fi

if [ ! -z "$opt_sysname" ] ; then sysname=$opt_sysname; fi

# echo "Remove Later ($remove_old_arc_data)($sysname)"; exit

if [ "xx" = "x${sysname}x" ]; then
   sysname=`hostname`
fi

# If remove_old_arc_data blank set to 366
if [ "x${remove_old_arc_data}x" = "xx" ]; then
   remove_old_arc_data="366"
fi

# If remove_old_arc_data blank less than 180, set to 180. 
if [ ${remove_old_arc_data} -lt 180 ]; then
   echo "(${remove_old_arc_data}) is too low setting to 180"
   remove_old_arc_data="180"
fi

# echo "sysname is (${sysname}). Trimming to (${remove_old_arc_data}) days." 
if [ -s ./mpgdata2.${sysname}_archive.gz ];then
   # ./mpgdata2.${sysname}_archive.gz exists and has space.
   echo "./mpgdata2.${sysname}_archive.gz exists, continuing"
else
   # ./mpgdata2.${sysname}_archive.gz does not exist or is zero bytes. 
   echo "./mpgdata2.${sysname}_archive.gz missing, exiting"
   exit
fi

jspaceavailk=`df -k . | tail -1 | awk '{print $3}'`
echo "Space available is (${jspaceavailk} k bytes)"
jmpgd2arch_filesize=`du -k ./mpgdata2.${sysname}_archive.gz | awk '{print $1}'`
# echo "Size of current ./mpgdata2.${sysname}_archive.gz is (${jmpgd2arch_filesize} k bytes)"
if [ ${jspaceavailk} -ge ${jmpgd2arch_filesize} ]; then
   echo "(${jspaceavailk}) is greater than or equal to (${jmpgd2arch_filesize})" 
else
   echo "(${jspaceavailk}) is smaller than (${jmpgd2arch_filesize})" 
fi

# Determine record count of current file
jmpgd2reccnt=`gunzip -c ./mpgdata2.${sysname}_archive.gz | grep -n ,progname, | tee mpgd2prognames.tmp | wc -l| awk '{print $1}'`
echo "./mpgdata2.${sysname}_archive.gz is (${jmpgd2reccnt}) days! Reducing to (${remove_old_arc_data}) days!"

# Determine first line of new file
jfirstnewline=`cat mpgd2prognames.tmp | tail -${remove_old_arc_data} |  head -1 | awk -F: '{print $1}'`
# echo "Line number of first line (${jfirstnewline}) for new mpgdata2 archive file."

# Determine size of old and new files
old_mpg2_arch_file_size=`wc -c ./mpgdata2.${sysname}_archive.gz | awk '{print $1}'`
new_mpg2_arch_file_size=`gunzip -c ./mpgdata2.${sysname}_archive.gz | awk -v jbegin=${jfirstnewline} '{if( NR >= jbegin ) print $0}' | gzip -c | wc -c | awk '{print $1}'`
echo "Old file size (${old_mpg2_arch_file_size})  New file size (${new_mpg2_arch_file_size})"

# Does the file system have enough space to build the new mpgdata2.hostname_archive.gz
jspaceavail=`echo "${jspaceavailk}" | awk '{printf "%5.0f\n", $1 * 1024}'`
# echo "(${jspaceavail}) (${new_mpg2_arch_file_size}) "  

# echo "" | awk -v javailk="${jspaceavailk}" -v jmpgd2fsize="${new_mpg2_arch_file_size}" '{print "test 1", javailk,"test 2", jmpgd2fsize/1024}'

# echo "${jspaceavailk} ${new_mpg2_arch_file_size}" 
# echo "${jspaceavailk} ${new_mpg2_arch_file_size}" | awk '{print "test 1", $1,"test 2", $2/1024}'

jokbuild=`echo "${jspaceavailk} ${new_mpg2_arch_file_size}" | awk '{if($2/1024 < $1 ) print "Ok"}'`

### jokbuild="notOk"

if [ "x${jokbuild}x" = "xOkx" ]; then
   # Build new mpgd2arch file
   gunzip -c ./mpgdata2.${sysname}_archive.gz | awk -v jbegin=${jfirstnewline} '{if( NR >= jbegin ) print $0}' | gzip -c > ./mpgdata2.${sysname}_arch_new.gz   

   if [ "x${autoreplace}x" != "xTx" ]; then
   # Size of both files.
      ls -altr ./mpgdata2.${sysname}_archive.gz ./mpgdata2.${sysname}_arch_new.gz
   else
      echo "Autoreplacing ./mpgdata2.${sysname} with ./mpgdata2.${sysname}_new"
      cp ./mpgdata2.${sysname}_arch_new.gz ./mpgdata2.${sysname}_archive.gz
      rm -f ./mpgdata2.${sysname}_arch_new.gz 
   fi

else
   # Not enough space to build new mpgd2arch file
   echo "Not enough space to build ./mpgdata2.${sysname}_arch_new.gz"
fi

#& #########################
#& Sample run
#& #########################
#& 
#&  ./mpgd2_arcgztrim.sh
#& pn.config file does not exist at /nmondata/arctrim_test
#& ./mpgdata2.AIX720_archive.gz exists, continuing
#& Space available is (194851044 k bytes)
#& (194851044) is greater than or equal to (183332)
#& ./mpgdata2.AIX720_archive.gz is (3133) days! Reducing to (366) days!
#& Old file size (187731011)  New file size (16690914)
#& -rw-rw----    1 root     system    187731011 Sep 30 10:53 ./mpgdata2.AIX720_archive.gz
#& -rw-rw----    1 root     system     16690914 Oct 08 11:04 ./mpgdata2.AIX720_arch_new.gz
#& root_PN@HelpSystems_AIX720:/nmondata/arctrim_test >


