#!/bin/sh
#
#$Id: lv_info4hp.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Used to gather logical volume information from an HP system (HP-UX).
#& Output tar file is /tmp/helpsystems_tmp/lv_info4hp.out_systemname.tar.gz

# This is NOT the usage of this script, but the usage for lsvg
# Usage: lsvg [-o] [[-L] -n PVname]
#        lsvg [-L] [-i] [-P] [-m] [-M | -l | -p] VGname...
# Lists the characteristics of a volume group.

mkdir -p /tmp/helpsystems_tmp

jhost=`uname -n | cut -d. -f1` 
jtype=`uname -s`

if [ "x${jtype}x" != "xHP-UXx" ]; then
   echo "This currently only gathers logical volume information on HP, exiting.
   "
   exit 1
fi

jdir="/tmp/helpsystems_tmp/lvinfo4hp/"

mkdir -p $jdir

cd $jdir

ioscan -funC disk  2>/dev/null > ioscan_-funC_disk_${jhost}.hsllc 
powermt display dev=all 2>/dev/null > powermt_display_dev=all_${jhost}.hsllc

awk '/rdsk/ {print $1"\n"$2"\n"$3}' ioscan_-funC_disk_${jhost}.hsllc  2>/dev/null | grep rdsk |while read vRdisk ; do
print ${vRdisk}"\t" $(diskinfo -b ${vRdisk})
done > diskinfo_${jhost}.hsllc

ioscan -F -m dsf 2>/dev/null > ioscan_-F_-m_dsf_${jhost}.hsllc

ioscan -F -m dsf 2>/dev/null | grep -v _ > ioscan_-F_-m_dsf_trimmed_${jhost}.hsllc

cat ioscan_-F_-m_dsf_trimmed_${jhost}.hsllc \
   | awk -F: '{print $1,$2}' \
   | while read jdisk vRdisk; do
        print "#========""\n"${jdisk}"\n"${vRdisk}"\n""#======= "
        diskinfo -v ${vRdisk}
     done > diskinfo2_${jhost}.hsllc

cat ioscan_-F_-m_dsf_trimmed_${jhost}.hsllc \
   | awk -F: '{print $1,$2}' \
   | while read jdisk vRdisk; do
        print "#========""\n"${jdisk}"\n"${vRdisk}"\n""#======= "
        scsimgr get_info -D ${jdisk} 2>/dev/null 
     done > scsimgr_get_info-D_diskno_${jhost}.hsllc

###   root_HP@MPG_aps39-80:/tmp/helpsystems_tmp/lvinfo4hp > grep "LUN path count" scsimgr_get_info-D_diskno_aps39-80.hsllc
###   LUN path count                                = 1

vgdisplay -v > vgdisplay_-v_${jhost}.hsllc

grep "LV Name"  vgdisplay_-v_${jhost}.hsllc | awk '{print $NF}' \
   | while read jlvname ; do
        print "#========""\n"${jlvname}"\n""#======= "
        lvdisplay -v ${jlvname} | awk '{if( $4 != "current" && $4 != "free" ) print $0}'
     done > lvdisplay_-v_lv_${jhost}.hsllc

# Because sometimes HP uses alternate links for PV Names
# Next line replaced with recommendations from Matt 
# grep "PV Name"  vgdisplay_-v_${jhost}.hsllc | awk '{print $NF}' \
awk '/PV Name/ && ! /Alternate Link/ {print $NF}' vgdisplay_-v_${jhost}.hsllc \
   | while read jpvname ; do
        print "#========""\n"${jpvname}"\n""#======= "
        pvdisplay -v ${jpvname} | awk '{if( $2 != "current" && $2 != "free" ) print $0}' | tee /tmp/helpsystems_tmp/jtmpfile.tmp 
	jpaths=`grep -c "PV Name"  /tmp/helpsystems_tmp/jtmpfile.tmp | awk '{print $1}'`
	print "PATH Count ${jpvname} ${jpaths}"
     done > pvdisplay_-v_pv_${jhost}.hsllc

# This is to identify the systems that have mirrored root disks
lvlnboot -v > lvlnboot_-v_${jhost}.hsllc

chmod 744 *

tar cvf /tmp/helpsystems_tmp/lv_info4hp_${jhost}.tar *.hsllc 2>/dev/null

chmod 744 /tmp/helpsystems_tmp/lv_info4hp_${jhost}.tar

gzip -f /tmp/helpsystems_tmp/lv_info4hp_${jhost}.tar

echo "Please send  /tmp/helpsystems_tmp/lv_info4hp_${jhost}.tar.gz to support.mpginc@helpsystems.com"
