#!/bin/ksh
#
#$Id: lv_info4aix.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
# 
#&& Used to gather logical volume information from a system.
#& Output file is /tmp/helpsystems_tmp/lv_info4aix.out_systemname

# This is NOT the usage of this script, but the usage for lsvg
# Usage: lsvg [-o] [[-L] -n PVname]
#        lsvg [-L] [-i] [-P] [-m] [-M | -l | -p] VGname...
# Lists the characteristics of a volume group.

jid=`uname -n | awk -F. '{print $1}'`
jtype=`uname -s`

if [ "x${jtype}x" != "xAIXx" ]; then
   echo "This currently only gathers logical volume information on AIX, exiting."
   exit 1
fi


rm -f /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
touch /tmp/helpsystems_tmp/lv_info4aix.out_${jid}

function cmd_all {
echo "====================="
echo "${1}"
echo "====================="
}

cmd_all "For later into rackdata.sh"  >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
echo "vgname,vgstate,vgperm,ppsize,totalpp,lvname,lvtype,lp,pp,pv,lvstate,mtpoint,mirrorp,mirror" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 

lsvg > /tmp/helpsystems_tmp/lv_info4aix.tmp
if [ -s /tmp/helpsystems_tmp/lv_info4aix.tmp ]; then
   for jvg in `lsvg`
   do
      jvginfo=`lsvg ${jvg} | egrep "STATE|GROUP|PERMISS" | awk '{print $3,$6}' | paste - - - | awk '{print $1,$3,$5,$4,$6}'`
      lsvg -l ${jvg} | tail -n +3 | sort  > /tmp/helpsystems_tmp/j1
      cat /tmp/helpsystems_tmp/j1 | awk '{print $1}'  > /tmp/helpsystems_tmp/j1a
      lsvg -m ${jvg} | tail -n +2 | sort   > /tmp/helpsystems_tmp/j2
      join -a 1 /tmp/helpsystems_tmp/j1a /tmp/helpsystems_tmp/j2 | awk '{j1=0}{if($2 != "None" && $2 != "" )j1++1}{if($3 != "None" && $3 != "" )j1++1}{if($4 != "None" && $4 != "" )j1++1}{print $1,"MP"j1}' > /tmp/helpsystems_tmp/j2a
      join -a 1 /tmp/helpsystems_tmp/j1 /tmp/helpsystems_tmp/j2a | awk -v jvgi="${jvginfo}" '{print jvgi, $0, "M"($4/$3-1)}' > /tmp/helpsystems_tmp/j2b
      cat /tmp/helpsystems_tmp/j2b | sed -e "s|\ |\,|g" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
   done
fi

echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
echo "" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 

cmd_all "lsvg" | tee -a /tmp/helpsystems_tmp/lv_info4aix.out_${jid} > /tmp/helpsystems_tmp/lv_info4aix.tmp
lsvg >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
echo "" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 


if [ -s /tmp/helpsystems_tmp/lv_info4aix.tmp ]; then
   for vg in `lsvg`
   do
      echo "## ${vg} ##" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 

      cmd_all "lsvg ${vg}"  >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      lsvg ${vg} >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      echo "" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 

      cmd_all "lsvg -L ${vg}"  >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      lsvg -L ${vg} >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      echo "" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 

      cmd_all "lsvg -P ${vg}"  >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      lsvg -P ${vg} >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      echo "" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 

      cmd_all "lsvg -m ${vg}"  >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      lsvg -m ${vg} >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      echo "" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 

      cmd_all "lsvg -M ${vg}"  >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      lsvg -M ${vg} >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      echo "" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 

      cmd_all "lsvg -l ${vg}"  >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      lsvg -l ${vg} >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      echo "" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 

      cmd_all "lsvg -p ${vg}"  >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      lsvg -p ${vg} >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
      echo "" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 


   done
fi




cmd_all "lsdev"  >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
lsdev >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 
echo "" >> /tmp/helpsystems_tmp/lv_info4aix.out_${jid} 

echo "Please send /tmp/helpsystems_tmp/lv_info4aix.out_${jid} to support.mpginc@helpsystems.com"


# vgname vgstate vgperm ppsize totalpp lvname lvtype lp pp pv lvstate mtpoint mirrorp mirror
# rootvg active read/write 32 937 hd1 jfs2 60 60 1 open/syncd /home MP0 M0
# rootvg active read/write 32 937 hd10opt jfs2 12 12 1 open/syncd /opt MP0 M0
# rootvg active read/write 32 937 hd11admin jfs2 4 4 1 open/syncd /admin MP0 M0
# rootvg active read/write 32 937 hd2 jfs2 179 179 1 open/syncd /usr MP0 M0
# rootvg active read/write 32 937 hd3 jfs2 4 4 1 open/syncd /tmp MP0 M0 # helpsystems
# rootvg active read/write 32 937 hd4 jfs2 9 9 1 open/syncd / MP0 M0
# rootvg active read/write 32 937 hd5 boot 1 1 1 closed/syncd N/A MP0 M0
# rootvg active read/write 32 937 hd6 paging 16 16 1 open/syncd N/A MP0 M0
# rootvg active read/write 32 937 hd8 jfs2log 1 1 1 open/syncd N/A MP0 M0
# rootvg active read/write 32 937 hd9var jfs2 12 12 1 open/syncd /var MP0 M0
# rootvg active read/write 32 937 livedump jfs2 8 8 1 open/syncd /var/adm/ras/livedump MP0 M0


