#!/bin/ksh
#
#$Id: lv_info.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
# 
#&& Used to gather logical volume information from a system.
#& Output file is /tmp/helpsystems_tmp/lv_info4${jtype}.out_systemname

mkdir -p /tmp/helpsystems_tmp

jhost=`uname -n | awk -F. '{print $1}'`
jtype=`uname -s`
# This case statement is not actually being used for now:
case $jtype in
   "AIX")       idcmd="id" ; whichcmd="which" ;;
   "Linux")     idcmd="id" ; whichcmd="which" ;;
   "HP-UX")     idcmd="id" ; whichcmd="fixwhich" ;;
   "SunOS")     idcmd="/usr/xpg4/bin/id" ; whichcmd="fixwhich" ;;
    *)          idcmd="id" ; whichcmd="fixwhich" ;;
esac

#
########################
#
if [ "x${jtype}x" = "xAIXx" ]; then
   echo "Gathering logical volume information on AIX."

   rm -f /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   touch /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost}
   
   function cmd_all {
   echo "====================="
   echo "${1}"
   echo "====================="
   }

   cmd_all "For later into rackdata.sh"  >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   echo "vgname,vgstate,vgperm,ppsize,totalpp,lvname,lvtype,lp,pp,pv,lvstate,mtpoint,mirrorp,mirror" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   
   lsvg > /tmp/helpsystems_tmp/lv_info4${jtype}.tmp
   if [ -s /tmp/helpsystems_tmp/lv_info4${jtype}.tmp ]; then
      for jvg in `lsvg`
      do
         jvginfo=`lsvg ${jvg} | egrep "STATE|GROUP|PERMISS" | awk '{print $3,$6}' | paste - - - | awk '{print $1,$3,$5,$4,$6}'`
         lsvg -l ${jvg} | tail -n +3 | sort  > /tmp/helpsystems_tmp/j1
         cat /tmp/helpsystems_tmp/j1 | awk '{print $1}'  > /tmp/helpsystems_tmp/j1a
         lsvg -m ${jvg} | tail -n +2 | sort   > /tmp/helpsystems_tmp/j2
         join -a 1 /tmp/helpsystems_tmp/j1a /tmp/helpsystems_tmp/j2 | awk '{j1=0}{if($2 != "None" && $2 != "" )j1++1}{if($3 != "None" && $3 != "" )j1++1}{if($4 != "None" && $4 != "" )j1++1}{print $1,"MP"j1}' > /tmp/helpsystems_tmp/j2a
         join -a 1 /tmp/helpsystems_tmp/j1 /tmp/helpsystems_tmp/j2a | awk -v jvgi="${jvginfo}" '{print jvgi, $0, "M"($4/$3-1)}' > /tmp/helpsystems_tmp/j2b
         cat /tmp/helpsystems_tmp/j2b | sed -e "s|\ |\,|g" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
      done
   fi

   echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   echo "" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   
   cmd_all "lsvg" | tee -a /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} > /tmp/helpsystems_tmp/lv_info4${jtype}.tmp
   lsvg >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   echo "" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   
   
   if [ -s /tmp/helpsystems_tmp/lv_info4${jtype}.tmp ]; then
      for vg in `lsvg`
      do
         echo "## ${vg} ##" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   
         cmd_all "lsvg ${vg}"  >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         lsvg ${vg} >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         echo "" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   
         cmd_all "lsvg -L ${vg}"  >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         lsvg -L ${vg} >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         echo "" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   
         cmd_all "lsvg -P ${vg}"  >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         lsvg -P ${vg} >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         echo "" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   
         cmd_all "lsvg -m ${vg}"  >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         lsvg -m ${vg} >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         echo "" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   
         cmd_all "lsvg -M ${vg}"  >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         lsvg -M ${vg} >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         echo "" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   
         cmd_all "lsvg -l ${vg}"  >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         lsvg -l ${vg} >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         echo "" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   
         cmd_all "lsvg -p ${vg}"  >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         lsvg -p ${vg} >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
         echo "" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 

      done
   fi

   cmd_all "lsdev"  >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   lsdev >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   echo "---------------------" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 
   echo "" >> /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} 

   echo "Please send /tmp/helpsystems_tmp/lv_info4${jtype}.out_${jhost} to support.mpginc@helpsystems.com"


   # vgname vgstate vgperm ppsize totalpp lvname lvtype lp pp pv lvstate mtpoint mirrorp mirror
   # rootvg active read/write 32 937 hd1 jfs2 60 60 1 open/syncd /home MP0 M0
   # rootvg active read/write 32 937 hd10opt jfs2 12 12 1 open/syncd /opt MP0 M0
   # rootvg active read/write 32 937 hd11admin jfs2 4 4 1 open/syncd /admin MP0 M0
   # rootvg active read/write 32 937 hd2 jfs2 179 179 1 open/syncd /usr MP0 M0
   # rootvg active read/write 32 937 hd3 jfs2 4 4 1 open/syncd /tmp MP0 M0 # helpsystems_tmp
   # rootvg active read/write 32 937 hd4 jfs2 9 9 1 open/syncd / MP0 M0
   # rootvg active read/write 32 937 hd5 boot 1 1 1 closed/syncd N/A MP0 M0
   # rootvg active read/write 32 937 hd6 paging 16 16 1 open/syncd N/A MP0 M0
   # rootvg active read/write 32 937 hd8 jfs2log 1 1 1 open/syncd N/A MP0 M0
   # rootvg active read/write 32 937 hd9var jfs2 12 12 1 open/syncd /var MP0 M0
   # rootvg active read/write 32 937 livedump jfs2 8 8 1 open/syncd /var/adm/ras/livedump MP0 M0
   exit 0
fi
#
########################
#
if [ "x${jtype}x" = "xHP-UXx" ]; then

   jdir="/tmp/helpsystems_tmp/lv_info/"

   mkdir -p $jdir

   cd $jdir
   
   ioscan -funC disk  2>/dev/null > ioscan_-funC_disk_${jhost}.hsllc 
   powermt display dev=all 2>/dev/null > powermt_display_dev=all_${jhost}.hsllc

   awk '/rdsk/ {print $1"\n"$2"\n"$3}' ioscan_-funC_disk_${jhost}.hsllc  2>/dev/null | grep rdsk |while read vRdisk ; do
   echo ${vRdisk}"\t" $(diskinfo -b ${vRdisk})
   # print ${vRdisk}"\t" $(diskinfo -b ${vRdisk})
   done > diskinfo_${jhost}.hsllc

   ioscan -F -m dsf 2>/dev/null > ioscan_-F_-m_dsf_${jhost}.hsllc

   ioscan -F -m dsf 2>/dev/null | grep -v _ > ioscan_-F_-m_dsf_trimmed_${jhost}.hsllc
   
   cat ioscan_-F_-m_dsf_trimmed_${jhost}.hsllc \
      | awk -F: '{print $1,$2}' \
      | while read jdisk vRdisk; do
           # print "#========""\n"${jdisk}"\n"${vRdisk}"\n""#======= "
           echo "#========""\n"${jdisk}"\n"${vRdisk}"\n""#======= "
           diskinfo -v ${vRdisk}
        done > diskinfo2_${jhost}.hsllc
   
   cat ioscan_-F_-m_dsf_trimmed_${jhost}.hsllc \
      | awk -F: '{print $1,$2}' \
      | while read jdisk vRdisk; do
           echo "#========""\n"${jdisk}"\n"${vRdisk}"\n""#======= "
           # print "#========""\n"${jdisk}"\n"${vRdisk}"\n""#======= "
           scsimgr get_info -D ${jdisk} 2>/dev/null 
        done > scsimgr_get_info-D_diskno_${jhost}.hsllc
   
   ###   root_HP@MPG_aps39-80:/tmp/helpsystems_tmp/lvinfo4hp > grep "LUN path count" scsimgr_get_info-D_diskno_aps39-80.hsllc
   ###   LUN path count                                = 1
   
   vgdisplay -v > vgdisplay_-v_${jhost}.hsllc
   
   grep "LV Name"  vgdisplay_-v_${jhost}.hsllc | awk '{print $NF}' \
      | while read jlvname ; do
           echo "#========""\n"${jlvname}"\n""#======= "
           # print "#========""\n"${jlvname}"\n""#======= "
           lvdisplay -v ${jlvname} | awk '{if( $4 != "current" && $4 != "free" ) print $0}'
        done > lvdisplay_-v_lv_${jhost}.hsllc

   # Because sometimes HP uses alternate links for PV Names
   # Next line replaced with recommendations from Matt 
   # grep "PV Name"  vgdisplay_-v_${jhost}.hsllc | awk '{print $NF}' \
   awk '/PV Name/ && ! /Alternate Link/ {print $NF}' vgdisplay_-v_${jhost}.hsllc \
      | while read jpvname ; do
           echo "#========""\n"${jpvname}"\n""#======= "
           # print "#========""\n"${jpvname}"\n""#======= "
           pvdisplay -v ${jpvname} | awk '{if( $2 != "current" && $2 != "free" ) print $0}' | tee /tmp/helpsystems_tmp/jtmpfile.tmp 
           jpaths=`grep -c "PV Name"  /tmp/helpsystems_tmp/jtmpfile.tmp | awk '{print $1}'`
           echo "PATH Count ${jpvname} ${jpaths}"
           # print "PATH Count ${jpvname} ${jpaths}"
        done > pvdisplay_-v_pv_${jhost}.hsllc

   # This is to identify the systems that have mirrored root disks
   lvlnboot -v > lvlnboot_-v_${jhost}.hsllc

   chmod 744 *

   tar cvf /tmp/helpsystems_tmp/lv_info4${jtype}_${jhost}.tar *.hsllc 2>/dev/null

   chmod 744 /tmp/helpsystems_tmp/lv_info4${jtype}_${jhost}.tar
   
   gzip -f /tmp/helpsystems_tmp/lv_info4${jtype}_${jhost}.tar
   
   echo "Please send  /tmp/helpsystems_tmp/lv_info4$jtype_${jhost}.tar.gz to support.mpginc@helpsystems.com" 
   
   exit 0
fi
#
##############
#
if [ "x${jtype}x" = "xLinuxx" ]; then
   
   jdir="/tmp/helpsystems_tmp/lv_info/"
   
   mkdir -p $jdir
   
   cd $jdir
   
   powermt display dev=all 2>/dev/null > powermt_display_dev=all_${jhost}.hsllc
   
   vgdisplay -v > vgdisplay_-v_${jhost}.hsllc
   
   grep "LV Name"  vgdisplay_-v_${jhost}.hsllc | awk '{print $NF}' \
      | while read jlvname ; do
           echo  "#========""\n"${jlvname}"\n""#======= "
           # print "#========""\n"${jlvname}"\n""#======= "
           lvdisplay -v ${jlvname} | awk '{if( $4 != "current" && $4 != "free" ) print $0}'
        done > lvdisplay_-v_lv_${jhost}.hsllc
   
   # Get hwinfo information if available.
   hwinfo 2>/dev/null > hwinfo_${jhost}.hsllc
   
   
   # Because sometimes HP uses alternate links for PV Names
   # Next line replaced with recommendations from Matt 
   # grep "PV Name"  vgdisplay_-v_${jhost}.hsllc | awk '{print $NF}' \
   awk '/PV Name/ && ! /Alternate Link/ {print $NF}' vgdisplay_-v_${jhost}.hsllc \
    | while read jpvname ; do
         echo "#========""\n"${jpvname}"\n""#======= "
         # print "#========""\n"${jpvname}"\n""#======= "
         pvdisplay -v ${jpvname} | awk '{if( $2 != "current" && $2 != "free" ) print $0}' | tee /tmp/helpsystems_tmp/jtmpfile.tmp 
	 jpaths=`grep -c "PV Name"  /tmp/helpsystems_tmp/jtmpfile.tmp | awk '{print $1}'`
         echo "PATH Count ${jpvname} ${jpaths}"
         # print "PATH Count ${jpvname} ${jpaths}"
      done > pvdisplay_-v_pv_${jhost}.hsllc
   
   chmod 744 *
      
   tar cvf /tmp/helpsystems_tmp/lv_info4${jtype}_${jhost}.tar *.hsllc 2>/dev/null
   
   chmod 744 /tmp/helpsystems_tmp/lv_info4${jtype}_${jhost}.tar
   
   gzip -f /tmp/helpsystems_tmp/lv_info4${jtype}_${jhost}.tar
   
   echo "Please send  /tmp/helpsystems_tmp/lv_info4${jtype}_${jhost}.tar.gz to support.mpginc@helpsystems.com"
   
   exit 0
fi

echo "Volume info for system type (${jtype}) is not provided in this script." 

exit 1
