#!/bin/ksh
#& Presented in presentation by Nigel Griffiths 
#& Nigel Griffiths, IBM Power Systems
#& Advanced Technology Support, Europe
# http://www.ibm.com/developerworks/wikis/download/attachments/53871900/VIOS_SSP2_AIXVUG.pdf?version=1
# Untested...."alert ?" many command are specific to vios servers.
# My lspool script  2011 IBM
#&& lspool list each cluster and for each list its pools and pool details
# $Id: lspool.sh,v 1.1 2023/03/27 16:07:05 root Exp $
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#


. ~/.profile
clusters=`cluster -list | sed '1d' | awk -F " " '{ printf $1 " " }'`
echo "Cluster list: " $clusters
for clust in $clusters
do
   pools=`lssp -clustername $clust | sed '1d' | awk -F " " '{ printf $1 " " }'`
   echo Pools in $clust are: $pools
   for pool in $pools
   do
      lssp -clustername $clust \
        | sed '1d' \
	| grep $pool \
	| read p size free totalLU numLUs junk
      let freepc=100*$free/$size
      let used=$size-$free
      let usedpc=100*$used/$size
      echo $pool Pool-Size: $size MB
      echo $pool Pool-Free: $free MB Percent Free $freepc
      echo $pool Pool-Used: $used MB Percent Used $usedpc
      echo $pool Allocated: $totalLU MB for $numLUs Logical Units
      alert -list -clustername $clust -spname $pool \
	| sed '1d' \
	| grep $pool \
	| read p poolid percent
      echo $pool Alert-Percent: $percent
      if [[ $totalLU > $size ]]
      then
         let over=$totalLU-$size
         echo $pool OverCommitted: yes by $over MB
      else
         echo $pool OverCommitted: no
      fi
   done
done
