#!/bin/ksh
#
# $Id: hsllc_un.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
#&& Only to use in extreme situations under direction of support.mpginc@helpsystems.com
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
#
#

mkdir -p /tmp/helpsystems_tmp

jopt=`echo $1`
jdate=`date +%Y%m%d_%H%M`
echo ${jdate}

locate_app () {
   # Identify locations of applications
   # Check normal bin sbin directories for application
   for jdirs in /bin/ /sbin/ /usr/bin/ /usr/sbin/ /usr/local/bin/ /usr/local/sbin/ /usr/contrib/bin/ /usr/contrib/sbin/ /opt/hpvm/bin/
   do
      if [ -x ${jdirs}${1} ]; then
         jloc="${jdirs}${1}"
         break
      fi
   done
   if [ "x${jloc}x" != "xx" ]; then
      export jloc
      return 0
   else
      # HP-UX  required the grep "^no "
      jloc=`which $1 2>/dev/null | grep -v "^no "`
      if [ "x${jloc}x" != "xx" ]; then
         export jloc
         return 0
      else
         return 1
      fi
   fi
}

get_ostype () {
 ostype=`$juname -s`
 case $ostype in
   "AIX")       idcmd="id" ; whichcmd="which" ;;
   "Linux")     idcmd="id" ; whichcmd="which" ;;
   "HP-UX")     idcmd="id" ; whichcmd="fixwhich" ;;
   "SunOS")     idcmd="/usr/xpg4/bin/id" ; whichcmd="fixwhich" ;;
    *)          idcmd="id" ; whichcmd="fixwhich" ;;
 esac
}

fixwhich () {
# a "which" function to replace the ones created by (sun,hpux)
# that always return 0 (success), even on a failure...
  what=$1
  ret=`which $what`
  if [ -z "$ret" ] ; then  return 1 ;
  else
    if [ -f "$ret" ] ; then return 0 ;
    else   return 1;
    fi
  fi
}

check_for_root () {
   ## check that we are running as root
   runningas=`$idcmd -u`
   runningasname=`$idcmd -u -n`
   if [ "$runningas" != "0" ] ; then
      echo "ERROR - install must be run as root - current userid is $runningas($runningasname)"
      if [ "$testplatform" = "T" ] ; then
         echo "testplatform set - continuing anyway - install may fail"
      else
         exit 1
      fi
   fi
}

locate_app uname
juname=${jloc}
get_ostype
check_for_root

jpw=`date +%Y%m%d`

ls -altr /etc/pn.conf
tail -1 /etc/pn.conf
pn_cnt=`wc -l /etc/pn.conf | awk '{print $1}'`

if [ ! -s /etc/pn.conf ]; then
# if [  -s /etc/pn.conf ]; then
   echo "#==============================================#"
   echo "There is NO /etc/pn.conf, exiting"
   echo "#==============================================#"
   exit
fi

if [ ${pn_cnt} -ne  1 ]; then
# if [ ${pn_cnt} -eq  1 ]; then
   echo "There are more than one entries (${pn_cnt}) in /etc/pn.conf"
   echo "#==============================================#"
   cat /etc/pn.conf 
   echo "#==============================================#"
   echo "# Exiting #"
   echo "#==============================================#"
   exit
else
   . /etc/pn.conf
   echo "Ready!"
fi

crontab -l > /tmp/helpsystems_tmp/crontab-l_b4.tmp
crontab -l | egrep -v "$nminst|MPG Power Navigator|MPG Performance Navigator|Performance Nav" > /tmp/helpsystems_tmp/crontab-l_no_hsllc.tmp

if [ "x${nminst}x" != "xx" ]  ; then 
   if [ "x${jpw}x" == "x${jopt}x" ] ; then  
      echo "# crontab  /tmp/helpsystems_tmp/crontab-l_no_hsllc.tmp"
      crontab  /tmp/helpsystems_tmp/crontab-l_no_hsllc.tmp

      echo "# rm /etc/pn.conf"
      rm /etc/pn.conf

      echo "# rm -r $nminst" 
      rm -r $nminst 
   elif [ "xx" != "x${jopt}x" ] ; then  
      echo "???? (${jopt})"
   fi
   if [ "xtestx" == "x${jopt}x" ] ; then  
      echo "# crontab  /tmp/helpsystems_tmp/crontab-l_no_hsllc.tmp"
      echo "# rm /etc/pn.conf"
      echo "# rm -r $nminst" 
      echo "Test is complete"
   fi
else 
   echo "nminst is not set, exiting!!"
   exit
fi

