#!/bin/ksh
#
# $Id: hsllc_admin_info.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Script to gather administrator information (hsllc_admin_info.sh)
#& Will gather assorted information for cpu and other hardware on linux or unix
#
#&@ Several other calls are made and if successful they will be gathered.
#
#&% Ran to gather assorted system information.
#

jhost=`uname -n 2>/dev/null `
jproc=`uname -p 2>/dev/null `
if [ "x" = "x${jproc}" ] || [ "xunknown" = "x${jproc}" ]; then
   jproc=`uname -m 2>/dev/null`
fi
jrev=`uname -r 2>/dev/null `
jsys=`uname -s 2>/dev/null `
joutfile="/tmp/helpsystems_tmp/hsllc_admin_info_${jhost}_${jproc}_${jsys}_${jrev}.tar" 
rm -rf /tmp/helpsystems_tmp/hsllc_admin_info.tmp /tmp/hsllc_admin_info.tmp /tmp/hsllc_admin_info 

# The next line will create 2 directories if necessary.
mkdir -p /tmp/helpsystems_tmp/hsllc_admin_info

jcpuinfo () {
for jtest in a b c d e f g h i j k l m n o p q r s t u v w x y z
do  
   uname -${jtest} 2>/dev/null > /tmp/helpsystems_tmp/hsllc_admin_info/uname.tmp
   if [ -s  /tmp/helpsystems_tmp/hsllc_admin_info/uname.tmp ] ; then
       echo "uname -${jtest} (`cat /tmp/helpsystems_tmp/hsllc_admin_info/uname.tmp`)"
   fi
done
echo ""

while 
read line
do
   $line 2>/dev/null > /tmp/helpsystems_tmp/hsllc_admin_info/hsllc_admin_info.tmp
   if [ -s /tmp/helpsystems_tmp/hsllc_admin_info/hsllc_admin_info.tmp ]; then
      echo "($line)"
      echo "#-------------------#"
      cat /tmp/helpsystems_tmp/hsllc_admin_info/hsllc_admin_info.tmp
      echo "#------- end -------#"
      echo ""
   else
      echo "($line) [no output]"
      echo ""
   fi
done <<- jamjam
cat /etc/issue
grep ^processor /proc/cpuinfo
grep ^cpu /proc/cpuinfo
grep ^model /proc/cpuinfo
grep ^platform /proc/cpuinfo 
grep ^clock /proc/cpuinfo 2>/dev/null | sed -e "s,.00*M,\\\ M,"
grep ^clock /proc/cpuinfo
hostid
machid
hw
lsattr
lsblk
lsdev
lsmod
lspath
lspci
lspnp
lsscsi
lsusb
model
jamjam
# This did not work in the script
# grep ^clock /proc/cpuinfo 2>/dev/null | sed -e "s,.00*M,\ M,"

# If new commands need to be added, place them above hsllc.
# These commmands are ran regardless of system.
# This is for testing only.
# If output is know to be extremely large, place it below on its own file.

}

# This is the series of commmands above in one file
jcpuinfo > /tmp/helpsystems_tmp/hsllc_admin_info/hsllc_multiinfo_${jhost}.hsllc

# These commmands are ran regardless, since this is for testing only.
# Since each can be large, each gets its own file or 0 byte file if it does not work
dmidecode 2>/dev/null > /tmp/helpsystems_tmp/hsllc_admin_info/hsllc_dmidecode_${jhost}.hsllc
hwinfo 2>/dev/null > /tmp/helpsystems_tmp/hsllc_admin_info/hsllc_hwinfo_${jhost}.hsllc
lscfg 2>/dev/null > /tmp/helpsystems_tmp/hsllc_admin_info/hsllc_lscfg_${jhost}.hsllc
machinfo 2>/dev/null > /tmp/helpsystems_tmp/hsllc_admin_info/hsllc_machinfo_${jhost}.hsllc
prtconf 2>/dev/null > /tmp/helpsystems_tmp/hsllc_admin_info/hsllc_prtconf_${jhost}.hsllc
sysinfo 2>/dev/null > /tmp/helpsystems_tmp/hsllc_admin_info/hsllc_sysinfo_${jhost}.hsllc

cd /tmp/helpsystems_tmp/hsllc_admin_info
tar cvf ${joutfile} hsllc_multiinfo_${jhost}.hsllc hsllc_dmidecode_${jhost}.hsllc hsllc_hwinfo_${jhost}.hsllc hsllc_lscfg_${jhost}.hsllc hsllc_machinfo_${jhost}.hsllc hsllc_prtconf_${jhost}.hsllc hsllc_sysinfo_${jhost}.hsllc
gzip -f ${joutfile}
echo "Please send ${joutfile}.gz to support.mpg@helpsystems.com!!!"



