#!/bin/ksh
#!/bin/ksh -xv
#
# $Id: gzip_nmon_continuous.sh,v 1.1 2024/04/09 18:24:31 root Exp root $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Used to continually gzip nmon files while data is being transfered until 
#&& ( rm delete2stop_gzip )
#&& Locates nmon files that are not gzipped that are over 5 minutes old.
#&& To start ( nohup ./gzip_nmon_continuous.sh & )
#
#@ nohup
#
#& Generally only needed if lots of data is being transferred and they may no be 
#& enough room on the target without gzipping the nmondata as it being transferred.
#
# 

echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
#

touch delete2stop_gzip
echo "To stop gzipping, [rm delete2stop] "
while [ -f delete2stop_gzip ];
do
    find . -cmin +5 -name nmon\* | grep -v ".gz" | xargs gzip 
    sleep 5
done
