#!/bin/ksh
# $Id: gz_2_z.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& gz_2_z.sh converts all .gz files to .Z files in the current directory
#&

mkdir -p /tmp/helpsystems_tmp

find . -name \*.gz 2>/dev/null > /tmp/helpsystems_tmp/gz_2_z.tmp

if [ "x${1}x" = "xFortra.comx" ] && [ -s /tmp/helpsystems_tmp/gz_2_z.tmp ] ; then
   echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
   if [ -s /tmp/helpsystems_tmp/gz_2_z.tmp ];
   then
      echo "Converting (`wc -l /tmp/helpsystems_tmp/gz_2_z.tmp | awk '{print $1}'`) .gz files to .Z files! "
      while
      read  jfile
      do
         #  ls -al $jfile
         gunzip $jfile
         unjfile=`echo $jfile | sed s,\.gz$,,`
         compress $unjfile
      done < /tmp/helpsystems_tmp/gz_2_z.tmp
   else
      echo "There are no .gz files to convert to .Z files! "
   fi
else
      echo "There are (` wc -l  /tmp/helpsystems_tmp/gz_2_z.tmp | awk '{print $1}'`) .gz files to convert to .Z files! "
      echo "Type "
      echo "./gz_2_z.sh Fortra.com"
fi

#& #=#=#=#=#=#=#=#=#=#=#
#& Sample runs
#& #=#=#=#=#=#=#=#=#=#=#
#& 
#& # ./gz_2_z.sh
#& There are (27) .gz files to convert to .Z files!
#& Type
#& ./gz_2_z.sh Fortra.com
#& 
#& # ./gz_2_z.sh Fortra.com
#& Running gz_2_z.sh,v #.# YYYY/MM/DD hh:mm:ss
#& Converting (27) .gz files to .Z files!
#& 
#& # ./gz_2_z.sh Fortra.com
#& Running gz_2_z.sh,v #.# YYYY/MM/DD hh:mm:ss
#& There are no .gz files to convert to .Z files!
#& 
