#!/bin/ksh
# $Id: gz_2_bz2.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& gz_2_bz2.sh converts all .gz files to .bz2 files in the current directory
#&

mkdir -p /tmp/helpsystems_tmp

find . -name \*.gz 2>/dev/null > /tmp/helpsystems_tmp/gz_2_bz2.tmp

if [ "x${1}x" = "xFortra.comx" ] && [ -s /tmp/helpsystems_tmp/gz_2_bz2.tmp ] ; then
   echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
   if [ -s /tmp/helpsystems_tmp/gz_2_bz2.tmp ];
   then
      echo "Converting (`wc -l /tmp/helpsystems_tmp/gz_2_bz2.tmp | awk '{print $1}'`) .gz files to .bz2 files! "
      while
      read  jfile
      do
         #  ls -al $jfile
         gunzip $jfile
         unjfile=`echo $jfile | sed s,\.gz$,,`
         bzip2 $unjfile
      done < /tmp/helpsystems_tmp/gz_2_bz2.tmp
   else
      echo "There are no .gz files to convert to .bz2 files! "
   fi
else
      echo "There are (` wc -l  /tmp/helpsystems_tmp/gz_2_bz2.tmp | awk '{print $1}'`) .gz files to convert to .bz2 files! "
      echo "Type "
      echo "./gz_2_bz2.sh Fortra.com"
fi

#& #=#=#=#=#=#=#=#=#=#=#
#& Sample runs
#& #=#=#=#=#=#=#=#=#=#=#
#& 
#& # ./gz_2_bz2.sh
#& There are (27) .gz files to convert to .bz2 files!
#& Type
#& ./gz_2_bz2.sh Fortra.com
#& 
#& # ./gz_2_bz2.sh Fortra.com
#& Running gz_2_bz2.sh,v #.# YYYY/MM/DD hh:mm:ss
#& Converting (27) .gz files to .bz2 files!
#& 
#& # ./gz_2_bz2.sh Fortra.com
#& Running gz_2_bz2.sh,v #.# YYYY/MM/DD hh:mm:ss
#& There are no .gz files to convert to .bz2 files!
#& 
