#!/bin/ksh
#
# $Id: group_fix_nmon_file_date.sh,v 1.1 2023/03/27 16:07:05 root Exp $
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
#
#&& Locates nmon files and runs fix_nmon_file_date.sh on every nmonfile found.
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#& This resets the date stamp to the date time stamp of the nmonfiles 
#& internally. Nmon files that are copied without the -p option can have more 
#& current datestamp. 

#@ fix_nmon_file_date.sh is required in the current directory, as well.

# grep -c "^ZZZZ" * | grep -v ":0" | awk -F: '{print $1}'

mkdir -p /tmp/helpsystems_tmp

find . -type f | xargs grep -c "^ZZZZ"  | grep -v ":0" | awk -F: '{print $1}' > /tmp/helpsystems_tmp/group_fix_nmon_file_date.filelist

jfilecnt=`wc -l /tmp/helpsystems_tmp/group_fix_nmon_file_date.filelist | awk '{print $1}'`

echo "# Processing (${jfilecnt}) files."
while 
read jfile
do
   if [ "xx" != "${jfile}" ]; then 
      echo "# Running ./fix_nmon_file_date.sh ${jfile}"
      ./fix_nmon_file_date.sh ${jfile}
   else
      echo "Finished!"
   fi
done < /tmp/helpsystems_tmp/group_fix_nmon_file_date.filelist
echo "# Processed (${jfilecnt}) files."


#& Sample run
#& Running group_fix_nmon_file_date.sh,v #.# YYYY/MM/DD hh:mm:ss
#& 
#& # Running ./fix_nmon_file_date.sh ./nmonfile.sample1
#& # Running ./fix_nmon_file_date.sh ./nmonfile.sample2


 
