#!/bin/ksh
#
# $Id: fix_nmon_file_date.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
#&& Used to change the date/time on an nmon file that is not set to its 
#&& original date/time, because of a cp (copy) command that did not 
#&& retain its original date/time stamp.
#&
#& Uses the last "ZZZZ," record to find date and time for the file.
#
#&@ Uses touch command to change the date of the files.
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#

if [ "xx" = "x${1}x" ] ; then
   echo "You need to specify an nmondata file name." 
   exit 1
fi

jtest=`ls ${1} 2>&1 >/dev/null`
jchk=$?
if [ $jchk -ne 0 ]; then
   echo "(${1}) does not appear to exist." 
   exit 1
fi

if [ ! -s ${1} ] ; then
   echo "$1 is an empty file." 
   exit 1
fi

jstamp=`grep "^ZZZZ," $1 | tail -1 | sed s/\-/,/g \
   | sed s/\-/,/g \
   | sed s/,JAN,/,01,/g \
   | sed s/,FEB,/,02,/g \
   | sed s/,MAR,/,03,/g \
   | sed s/,APR,/,04,/g \
   | sed s/,MAY,/,05,/g \
   | sed s/,JUN,/,06,/g \
   | sed s/,JUL,/,07,/g \
   | sed s/,AUG,/,08,/g \
   | sed s/,SEP,/,09,/g \
   | sed s/,OCT,/,10,/g \
   | sed s/,NOV,/,11,/g \
   | sed s/,DEC,/,12,/g \
   | sed s/://g | awk -F, '{print $6 $5 $4 substr($3,1,4) "." substr($3,5,2) }'`
if [ "xx" != "x${jstamp}x" ] ; then
   touch -t "$jstamp" $1
else
   echo "($1) does not appear to have any ZZZZ, records."  
fi

