#!/bin/ksh
#
# $Id: fix_mpgdata3_cacheusr.sh,v 1.1 2023/03/27 16:07:05 root Exp $ 
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Fix mpgdata3 file has many cacheusr lines (fix_mpgdata3_cacheusr.sh)
#&
#& Will gzip the mpgdata3 file and strip the cacheusr lines into a new 
#& mpgdata3 file.
#&
#& Holding original mpgdata3 file in mpgdata3_w_cacheusr.${jsysname}.gz 

echo "# Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "

jsysname=`uname -n | awk -F. '{print $1}'`

if [ -s  mpgdata3.${jsysname} ]; then
   echo "# (Holding original mpgdata3 file in mpgdata3_w_cacheusr.${jsysname}.gz)"
   gzip mpgdata3.${jsysname}
else
   echo  "mpgdata3.${jsysname} does not exist!!!, Exiting!!!"
   exit 1
fi

mv  mpgdata3.${jsysname}.gz  mpgdata3_w_cacheusr.${jsysname}.gz

gunzip -c mpgdata3_w_cacheusr.${jsysname}.gz | grep -v cacheusr | gzip -c > mpgdata3.${jsysname}.gz  

echo "#=================#"

ls -altr mpgdata3_w_cacheusr.${jsysname}.gz  mpgdata3.${jsysname}.gz

echo "#=================#"

gunzip mpgdata3.${jsysname}.gz 

ls -al mpgdata3.${jsysname}

echo "#=================#"

echo "# Once checked remove mpgdata3_w_cacheusr.${jsysname}.gz"
echo "# with the command:"
echo "#"
echo "# (rm mpgdata3_w_cacheusr.${jsysname}.gz)"
echo "#"

#& #========================================#
#& # Sample run of fix_mpgdata3_cacheusr.sh #
#& #========================================#
#& # Note: Files sizes of zipped files may  #
#& # be slightly different even if they are #
#& # the same in an unzipped condition.     #
#& #                                        #
#& # If mpgdata3.hostname does not exist,   # 
#& # the script will let you know and exit. #
#& #                                        #
#& # File mpgdata3_w_cacheusr.hostname.gz   #
#& # must be manually removed.              #
#& #========================================#
#& ./fix_mpgdata3_cacheusr.sh
#& # Running fix_mpgdata3_cacheusr.sh,v #.# YYYY/MM/DD hh:mm:ss
#& # (Holding original mpgdata3 file in mpgdata3_w_cacheusr.gz)
#& #=================#
#& -rw-rw---- 1 root system   351348 Jun 29 18:36 mpgdata3_w_cacheusr.hostname.gz
#& -rw-rw---- 1 root system   351332 Jun 29 18:39 mpgdata3.hostname.gz
#& #=================#
#& -rw-rw---- 1 root system 15171227 Jun 29 18:39 mpgdata3.hostname
#& #=================#
#& # Once checked remove mpgdata3_w_cacheusr.hostname.gz
#& # with the command:
#& #
#& # (rm mpgdata3_w_cacheusr.hostname.gz)
#& #
 
