#!/bin/ksh
#
# $Id: fix_mpgd3.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Used to correct problem with mpgdata3 file.
#& Removes bad lines from mpgdata3 file

echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
if [ ! -s /etc/pn.conf ] ; then
   echo "Did not fine /etc.pn.conf, exiting"
   exit 1
fi
. /etc/pn.conf
cd $nminst
if [ -s ./pn.config ]; then
   . ./pn.config
   echo "Stopping nmon"
   ./killnmon
   echo "Saving original ${nminst}/mpgdata3.${sysname} into ${nminst}/mpgdata3.${sysname}_b4.gz"
   cat ${nminst}/mpgdata3.${sysname} | gzip -c > ${nminst}/mpgdata3.${sysname}_b4.gz
   echo "Creating new ${nminst}/mpgdata3.${sysname} "
   gunzip -c ${nminst}/mpgdata3.${sysname}_b4.gz \
      | awk -F, '{if ( $2 ~ /^[0-9]+$/ || $1 == "ZZZZ" || $2 == "PID" ) print $0 }' > ${nminst}/mpgdata3.${sysname}
else
   echo "Did not find ./pn.config "
fi
